divert(-1)
  FlowchartDefs.m4
                                `Some experimental flow-chart macros.  
                                In the following, every subchart is in
                                [] brackets, with .N, .S, .E and .W
                                internally defined.  Follow this convention
                                if you define compound constructs.

                                For flowchart examples using pic only, see
                                "Creating Flowcharts in LaTeX Using the pic
                                Language," Miguel Torres-Torriti, 2008
                                http://www2.ing.puc.cl/~mtorrest/downloads
                                  /latex/flowchart.pdf'

                                `Default sizes:'
define(`fboxwid',linewid*2)
define(`fboxht',linewid*0.75)
define(`farrowht',linewid*0.5)

                                `The basic task box:
                                fbox( "contents", [wid x ht y] )
                                The first argument is the text string,
                                the second is an optional size specification.
                                To adjust the box size to the size of the
                                typeset text, see the discussion of the
                                \boxdims macro in the manual.'
define(`fbox',`[B:box ifelse(`$2',,`wid fboxwid ht fboxht',`$2') \
  fill_(fillval) `$1'
  N: B.n; S:B.s; E:B.e; W: B.w
  ]')

                                `If-then
                                ftest( "test text", [wid x ht y] )'
define(`ftest',`[B:box ifelse(`$2',,`wid fboxwid*0.8 ht fboxht*1.2',`$2') invis
  N: B.n; S: B.s; E: B.e; W: B.w 
  shade(fillval,line from 0.5 between last box.n and last box.e \
    to last box.e then to last box.s then to last box.w then to last box.n \
    then to 0.5 between last box.n and last box.e)
  ifelse(`$1',,,`$1' at B)
  ]')

                                `case statement
     fcase([wid x ht y (of tests)], "Test 1","task 1", ..., "Test n","task n")'
define(`fcase',`[ down; S: Here; xe = S.x
  fcaseloop_(1,$@)
  ifelse(`$2',,`E:S; W:S; N:S',`E:(xe+linewid/2,B1.E.y); W:T1.W; N:T1.N')
  fcasearrow_(1,$@)
  arrow from E to (E,S) then to S ]')

  define(`fcaseloop_',`ifelse(`$3',,,
   `T`$1': ftest(`$3',`$2') with .N at S
    B`$1': `$4' with .nw at T`$1'.E+(linewid/2,min(T`$1'.ht,fboxht)/2)
      arrow right linewid/4 from T`$1'.E then down T`$1'.E.y-B`$1'.W.y \
        then to B`$1'.W
    S: (T`$1'.S.x,min(T`$1'.S.y,B`$1'.S.y)-linewid/3)
      ifelse(`$5',,`line',`arrow') from T`$1'.S to S
      xe = max(xe,B`$1'.E.x)
      fcaseloop_(incr($1),`$2',shift(shift(shift(shift($@)))))')')
  define(`fcasearrow_',`ifelse(`$3',,,
   `arrow from B`$1'.E to (E,B`$1'.E)
    fcasearrow_(incr($1),`$2',shift(shift(shift(shift($@)))))')')
  
                                `while statement with explicit test
                   fwhiledo("test text", [wid x ht y], "task text", ["T"|"F"] )'
define(`fwhiledo',`[ down
  T: ftest(`$1',`$2')
    ifelse(`$4',,"T" above ljust at T.E,`$4')
    arrow right linewid/2 from T.E
  B: `$3' with .W at Here
  E: B.E; W: T.w; S: T.S
    arrow up max(linewid/4,T.n.y-B.n.y+arrowht*1.5) from B.N then left B.x-T.x
  N: Here
    arrow to T.n ]')

                                `repeat statement with explicit test
                         frepeatuntil("test", [wid x ht y], "task", ["F"|"T"] )'
define(`frepeatuntil',`[
  N: Here
  B: `$3' with .N at N
  W: B.W
    arrow down linewid/3
  T: ftest(`$1',`$2')
  E: B.E+(linewid/2+max(0,T.e.x-B.e.x),0)
    arrow from T.e to (E,T) then to E then to B.E
    ifelse(`$4',,"F" above ljust at T.e,`$4')
  S: T.S ]')

                                `if-then-else
                fifthenelse( "test", [wid x ht y], [left tasks], [right tasks],
                             ["F"|"left label"], ["T"|"right label"])'
define(`fifthenelse',`[
  T: ftest(`$1',`$2')
  N: T.N
    ifelse(`$5',,"F" below rjust at T.W,`$5')
    ifelse(`$6',,"T" below ljust at T.E,`$6')
  L: ifelse(`$3',,`T.S; W:T.W; LS:L',`$3 with .ne at ((T.W.x+T.x)/2,T.S.y)
    W: L.W; LS:L.S
    arrow from T.W to (L.N,T.W) then to L.N')
  R: ifelse(`$4',,`T.S; E:T.E; RS:R',`$4 with .nw at ((T.E.x+T.x)/2,T.S.y)
    E: R.E; RS: R.S
    arrow from T.E to (R.N,T.E) then to R.N')
  S: (T.x,min(LS.y,RS.y)-linewid/3)
    arrow from LS to (LS,S)
    arrow from RS to (RS,S)
    line to (LS,Here)
  ]')
divert(0)dnl
