% Cover+.m4
divert(-1)
define(`coveryear',2014)

% gear(rad, nteeth, initial ang, tooth ht, tooth angle, fill)
define(`gear',`[
  r = ifelse(`$1',,circlerad,`$1')
  n = ifelse(`$2',,16,`$2')
  a0 = ifelse(`$3',,0,`$3')
  h = ifelse(`$4',,r/6,`$4')
  tang = ifelse(`$5',,15,`$5')
  Point_(a0)
  d = twopi_*r/n/4-h*sind(tang)/2
  O: Here
  move to O+vec_(r+h,d)
  ifelse(`$6',,,`shade(`$6',')
  S: Here
  line to S
  for i=1 to n do {
    Point_(a0+360/n*(i-1/2))
    A: O+vec_(r,-d)
    B: O+vec_(r,d)
    Point_(a0+360/n*i)
    C: O+vec_(r+h,-d)
    D: O+vec_(r+h,d)
    continue to A then to B then to C then to D
    }
  ifelse(`$6',,,`)')
  ]')

define(`gears',`
  O: Here
  for i=1 to nshade-1 do {
    cshade = i/nshade*shadewid
    command sprintf("\newgray{linegray}{%g}",1-i/nshade)
    psset_(linecolor=linegray)
    Big:gear(r1,n1,360/n1/2,h,,1-i/nshade) with .c at O+(-cshade,cshade)
    gear(r2,n2,0,h,,1-i/nshade) with .c at Big.c+(Rect_(r1+r2+h*1.2,45)) }')
divert(0)dnl
%
\newcommand{\ABCEng}{{\sf\Large ABC Engineering Limited}}
\newcommand{\ABCAddr}{\parbox{\ddimA}{\sf%
  \small
  123 Fourth Street\\
  Anywhere ON N2L 3G1\\
  {\scriptsize \raisebox{.5ex}{\hbox{(999) 123-4567,
  \quad ABCEngineeringLimited.com}}}}}
%
{\small
.PS
gen_init
#include(book.dim,Cover)
####
define(`Gdim',`27 pc__')
sinclude(tst.dim)
s_init(Cover)
command "
  \newdimen{\xdim}
  \newcommand{\adjdim}{%
    \divide \xdim by 27 \multiply \xdim by 32} % new wid 32 pc
  \newdimen{\ddimA} \xdim=2.5in \adjdim \ddimA = \xdim
"
####

thinlines_
twidth= Gdim
S: box wid twidth ht twidth*11/8.5 fill_(0.95)

  lmarg = twidth/8.5
  rmarg = lmarg
  btwidth = twidth - lmarg - rmarg

L: S.nw+(lmarg,0)
R: S.ne+(-rmarg,0)

# Shading parameters
  shadewid = 0.10
  shadelinewid = 0.5pt__
  linethick_(shadelinewid/(1pt__))
  nshade = shadewid/shadelinewid

# Draw gears
G:[ r1 = 0.25
  n1 = 32
  h = r1/6
  r2 = r1/2
  n2 = n1/2
  gears
  thicklines_
  Big:gear(r1,n1,360/n1/2,h,,0.8) with .c at O+(-shadewid,shadewid)
  "\Large ABC" at Big
  L:gear(r2,n2,0,h,,0.95) with .c at Big.c+(Rect_(r1+r2+h*1.2,45))
  ] with .nw at S.nw+(lmarg/2,-lmarg/4)

TL: (G.Big.s,G.s) +(0,-.3)
BL: (G.e.x+0.3,S.s.y+lmarg/2)
  lw = 0.2
  psset_(linecolor=lightgray)
  line from TL down TL.y-BL.y thickness lw * 72.27
  psset_(linecolor=black)

  command "\defboxdim{CoverA}{\ABCEng}"
Head: s_box(\sf \ABCEng ) with .sw at (BL.x,G.s.y+shadewid)
Addr: s_box(\ABCAddr) with .sw at BL

  twidth = R.x-BL.x
Title: s_box(`\parbox{%gin}{\raggedright\sf
  {\Large\bfseries\sffamily Design modifications\\[-0.3ex]
  to the\\[-0.3ex]
  model 894 hydrogenator\\[-0.3ex]
  for optimized pressure\\[0.3ex]
  }(Contract 304-'coveryear` final report)}',
  R.x-BL.x) with .nw at (BL.x,TL.y-0.3)

For: s_box(`\parbox{%gin}{\raggedright\sf
  Prepared for:\\ E. Smith, Manager\\ Pillz Pharmaceuticals Ltd.}',
  R.x-BL.x) with .nw at Title.sw+(0,-.3)


Author: s_box(`\parbox{%gin}{\raggedright\sf
 15 October 'coveryear`
 \\[\baselineskip]
 Chris Cross, P.Eng.
 \\
 Contract Design Department
}',
  R.x-BL.x) with .sw at Addr.nw+(0,.3)

.PE
}%
