#include <stdio.h>
#include <string.h>

#define COMMENT_CHAR '#'
#define PBM_MAGIC "P1"
#define PBMR_MAGIC "P4"
#define PBM 1
#define PBMR 4

#define MAXCHARWID 600
#define MAXCHARHT  600

#define MAXLINELEN 80

char progname[] = "readpbm";
char buf[MAXLINELEN];
char infilename[MAXLINELEN];
char outfilename[MAXLINELEN];
FILE *infile = NULL;
FILE *outfile = NULL;
int filetype = 0;
int debug = 0;

/* global parameters */
unsigned short img_wid = 0;
unsigned short img_ht = 0;
unsigned short ch_wid = 0;
unsigned short ch_ht = 0;
unsigned short cols = 1;
unsigned short rows = 1;

char charbuf[MAXCHARHT*MAXCHARWID];

void error(char *mess)
{
  fprintf(stderr, "%s: %s\n", progname, mess);
}

void proc_char(char *cbuf,
	       const unsigned short ch_wid, const unsigned short ch_ht)
{
  unsigned short i, j;
  char *cp;

  for (j = 0; j < ch_ht; j++){
    cp = cbuf + (j * ch_wid);
    fprintf(stderr, "\n%.4d:(%d,%d)", j, ch_wid, cp);
    for (i = 0; i < ch_wid; i++){
     fprintf(stderr, "%c", ((*cp++) == 0) ? '0' :'1');
    }
  }
    fprintf(stderr, "\n" );
}

void proc_image(char *pp,
	   unsigned short width, unsigned short height,
	   unsigned short ch_wid, unsigned short ch_ht)
{
  unsigned short c, r, i, j;
  char *cp;

  for (r = 0; r < (height / ch_ht); r++){
    for (c = 0; c < (width / ch_wid); c++){

      /* process one character */
      for(j = 0; j < ch_ht; j++){
	cp = pp + ((r*ch_ht + j) * width) + (c * ch_wid);
	if(debug >1) fprintf(stderr,"PI:r%d_c%d_j%d(%d)\n", r, c, j, cp);
	for(i = 0; i < ch_wid; i++){
	  charbuf[j*ch_wid+i] = *cp++;
	}
      }
      fprintf(stderr, "\nCHAR_%d_%d::\n", r, c);
      proc_char(&charbuf[0], ch_wid, ch_ht);
    }
  }
}

char *skip_comment(FILE *fp, char *cp)
{
    do{
      if((cp = fgets(buf, MAXLINELEN, fp)) == NULL)
	error("Error reading file");
      }while (*cp == COMMENT_CHAR);
}

char *get_num(char *cp, unsigned short *n)
{
  while(isspace(*cp)){
    if(*cp == '\0') return(cp);
    cp++;
  }

  do{
    if(!isdigit(*cp)) return(cp);
    *n = (*n) * 10 + (*cp -'0');
  }while(*(++cp));

  return(cp);
}

void readpixels(FILE *fp, char *pp, unsigned long nbytes)
{
  char c;
  short n = -1;

  do{
    do{
      c = fgetc(fp);
    }while(isspace(c));

    *pp++ = c -'0';
    }while(--nbytes);
}

void readrawpixels(FILE *fp, char *pp, unsigned long nbytes)
{
    char *cp = NULL;
    int b, i;

    if(debug) fprintf(stderr, "READRAWPIXELS:nbytes=%d\n", nbytes);
    cp = pp;
    while(((b = fgetc(fp)) != EOF) && (nbytes > 0))
      { 
	for(i = 8 ; i > 0; i--){
	  *(cp++) = ((b & 0x0080) == 0) ? 0 : 1;
	  b <<= 1;
	}
	nbytes--;
      }
    if(nbytes > 0){
      if(debug) fprintf(stderr,"nbytes=%d\n", nbytes);
      error("Unexpected end of file");
    }
}

void printpbm(FILE* fp, char *pp, unsigned short width, unsigned short height)
{
  unsigned long nbytes = width * height;
  unsigned w = width;

  fprintf(fp, "%.4d:", height--); 
  while( nbytes-- > 0){
    fprintf(fp, "%c", ((*pp++) == 0) ? '0' :'1');
    if((--w) == 0){
      fprintf(fp, "\n%.4d:", height--);
      w = width;
    }
  }
}

char *readpbm(FILE *fp)
{
  char *cp = NULL;
  char *pp = NULL;
  unsigned short width = 0;
  unsigned short height = 0;
  unsigned long nbytes = 0L;

  if((cp = fgets(buf, MAXLINELEN, fp)) == NULL)
    error("Error reading file type magic number");

  if(strncmp(buf, PBMR_MAGIC, 2) == 0){
    filetype = PBMR;
  }else if(strncmp(buf, PBM_MAGIC, 2) == 0){
    filetype = PBM;
  }else{
    error("NOT a pbm file");
  }

  /* read image size: width height */
  cp = skip_comment(fp, cp);
  cp = get_num(cp, &width);
  cp = get_num(cp, &height);
  img_wid = width; img_ht = height;
  if(debug)
    fprintf(stderr, "Image size is %d x %d=%d\n", width, height, width * height);

  /* allocate space for image data */
  nbytes = width * height + 8;
  if((pp = (char *) malloc((size_t)nbytes)) == NULL)
    error("Cannot allocate memory for image data");

  if(filetype == PBMR) readrawpixels(fp, pp, nbytes/8);
  else readpixels(fp, pp, nbytes-8);
  
  if(debug > 1) printpbm(stderr, pp, width, height);

  return(pp);
}

#define isoptchar(c) (c == '-')

main(int argc, char *argv[])
{
  char *img, *cp;
  int i = 0;
  int f = 0;

  while(argc-- > 1){
    i++;
    cp = argv[i];
    if(debug > 1) fprintf(stderr,"Argv[%d]=%s\n", i, cp);
    if(isoptchar(*cp)){
      switch(*(++cp)){
	case'd':{
	  debug = 1;
	  break;
	}
	case'c':{
	  cols = 0;
	  cp = get_num(++cp, &cols);
	  break;
	}
	case'r':{
	  rows = 0;
	  cp = get_num(++cp, &rows);
	  break;
	}
	case'w':{
	  ch_wid = 0;
	  cp = get_num(++cp, &ch_wid);
	  break;
	}
	case'h':{
	  ch_ht = 0;
	  cp = get_num(++cp, &ch_ht);
	  break;
	}
      default:{
	  error("Unknown option");
	} 
      }
      }else{
	if(f == 0)
	  strcpy(infilename, cp);
	else if (f == 1)
	  strcpy(outfilename, cp);
	else 
	  error("Too many file names\nUsage: readpbm [options] infilename outfilename");
      }
    
  }

  if(debug)
    fprintf(stderr,"Args:cols=%d,rows=%d,ch_wid=%d,ch_ht=%d,in=%s,out=%s\n",
	    cols, rows, ch_wid, ch_ht, infilename, outfilename);

  if((infile = fopen(infilename, "rb")) == NULL)
    error("error opening file");

  img = readpbm(infile);

  fclose(infile);

  proc_image(img, img_wid, img_ht, 9, 8);

}
