/* strdup.c 2.9.0 92/07/06 - a coupla convenience routines */

/* - Damian Cugley <pdc@prg.ox.ac.uk> Fri.  1 Mar. 1991
-----------------------------------------------------------------------
    This software module copyright (c) 1991 Damian Cugley.  
    It is provided for free on an "as-is" basis.
    See the file COPYING for more information.
-----------------------------------------------------------------------
*/

#include "fatal.h"
#include "strmisc.h"

addr	malloc ARGS((sizeof_t));
addr	realloc ARGS((addr, sizeof_t));

#ifndef xpg2
void
xfree(a)
     addr a;
{
  int free ARGS((addr));

  if (!free(a))
    pfatalf("free(0x%lX)", (long)a);
}
#endif

addr	malloc ARGS((sizeof_t));
addr	realloc ARGS((addr, sizeof_t));

addr
xmalloc(siz)
     sizeof_t siz;
{
  register addr t;

  if (!(t = malloc(siz)))
    pfatalf("malloc(%ld)", (long)siz);
  return t;
}

addr
xrealloc(oldptr, siz)
     addr oldptr;
     sizeof_t siz;
{
  register addr t;

  if (!(t = realloc(oldptr, siz)))
    pfatalf("realloc(*,%ld)", (long)siz);
  return t;
}

char *
strdup(s)
     const char *s;
{
  int siz; char *t;

  if (!s) return (char *)0;
  siz = strlen(s) + 1;
  if (!(t = malloc(siz)))
    pfatalf("malloc(%ld)", (long)siz);
  bcopy((addr)s, t, siz);
  t[siz - 1] = 0;
  return t;
}
