/* fgetword.c 2.9.0 92/07/06 */
/* see strword(3) */

/* - Damian Cugley <pdc@prg.ox.ac.uk> Fri.  1 Mar. 1991
-----------------------------------------------------------------------
    This software module copyright (c) 1991 Damian Cugley.  
    It is provided for free on an "as-is" basis.
    See the file COPYING for more information.
-----------------------------------------------------------------------
*/

#include <ctype.h>
#include "xstdio.h"

char *
fgetword(buf, fp)
     char *buf;			/* result written here -- must be big enuf */
     FILE *fp;			/* read from this file */
{
  char *p; int ch;

  /*  Skip whitespace and '#' comments: */
  while ((ch = getc(fp)) != EOF)
    if (ch == '#')
      while ((ch = getc(fp)) != EOF && ch != '\n')
	;
    else if (!isspace(ch))
      break;
  if (ch == EOF) return (char *)0;
  p = buf;
  if (ch == '"')	
    {	
      while ((ch = getc(fp)) != EOF
	     && !(ch == '"' && (ch = getc(fp)) != '"'))
	*p++ = ch;
      if (ch != EOF && !isspace(ch)) ungetc(ch, fp);
    }
  else if (ch != EOF)
    do
      {
	*p++ = ch; 
      } while ((ch = getc(fp)) != EOF && !isspace(ch));
  *p = '\0';
  return buf;	
}
