dnl ### Determine integer type to use for bitmaps

AC_DEFUN(XDVI_C_BITMAP_TYPE,
[AC_MSG_CHECKING(for integer type to use in bitmaps)
AC_CACHE_VAL(xdvi_cv_bitmap_type,
[AC_TRY_RUN(
[#include <stdio.h>
main()
{
  FILE *f=fopen("conftestval", "w");
  if (!f) exit(1);
  if ((sizeof(unsigned long) == 4 || sizeof(unsigned long) == 2)
    && sizeof(unsigned long) != sizeof(unsigned int))
      fprintf(f, "BMTYPE=long BMBYTES=%d\n", sizeof(unsigned long));
  if (sizeof(unsigned int) == 4 || sizeof(unsigned int) == 2)
    fprintf(f, "BMTYPE=int BMBYTES=%d\n", sizeof(unsigned int));
  else if (sizeof(unsigned short) == 4 || sizeof(unsigned short) == 2)
    fprintf(f, "BMTYPE=short BMBYTES=%d\n", sizeof(unsigned short));
  else fprintf(f, "BMTYPE=char BMBYTES=%d\n", sizeof(unsigned char));
  exit(0);
}],
xdvi_cv_bitmap_type="`cat conftestval`",
AC_MSG_ERROR(could not determine integer type for bitmap))])
eval "$xdvi_cv_bitmap_type"
AC_DEFINE_UNQUOTED(BMTYPE, $BMTYPE)
AC_DEFINE_UNQUOTED(BMBYTES, $BMBYTES)
AC_MSG_RESULT([unsigned $BMTYPE, size = $BMBYTES])])


dnl ### Check for whether the C compiler does string concatenation

AC_DEFUN(XDVI_CC_CONCAT,
[AC_CACHE_CHECK([for whether the C compiler supports string concatenation],
xdvi_cc_concat,
[AC_TRY_COMPILE(
[#include <stdio.h>
], [puts("Testing" " string" " concatenation");
], xdvi_cc_concat=yes, xdvi_cc_concat=no)])
KRHEADER_H=
if test $xdvi_cc_concat = no; then
  AC_DEFINE(CC_K_AND_R)
  KRHEADER_H=krheader.h
fi
AC_SUBST(KRHEADER_H)])


dnl ### Check for at-least-pretend Streams capability

AC_DEFUN(XDVI_SYS_STREAMS,
[AC_CACHE_CHECK([for stropts.h and isastream()], xdvi_cv_sys_streams,
[AC_TRY_LINK(
[#include <stropts.h>
], [#ifndef I_SETSIG
choke me
#else
isastream(0);
#endif], xdvi_cv_sys_streams=yes, xdvi_cv_sys_streams=no)])
if test $xdvi_cv_sys_streams = yes; then
  AC_DEFINE(HAVE_STREAMS)
fi])


dnl ### Check for poll()

AC_DEFUN(XDVI_FUNC_POLL,
[AC_CACHE_CHECK([for poll.h and poll()], xdvi_cv_func_poll,
[AC_TRY_LINK(
[#include <poll.h>
], [poll((struct pollfd *) 0, 0, 0);],
xdvi_cv_func_poll=yes, xdvi_cv_func_poll=no)])
if test $xdvi_cv_func_poll = yes; then
  AC_DEFINE(HAVE_POLL)
else
  AC_CHECK_HEADERS(sys/select.h select.h)
fi])


dnl ### Check for a C99-compatible implementation of (v)snprintf()

AC_DEFUN(XDVI_FUNC_C99_VSNPRINTF,
[AC_CACHE_CHECK([for a c99-compatible implementation of (v)snprintf()],
xdvi_cv_func_good_vsnprintf,
[AC_TRY_RUN(
[#include <stdio.h>
int main()
{
  char s[2];
  return (snprintf(s, 0, "test") != 4);
}],
xdvi_cv_func_good_vsnprintf=yes,
xdvi_cv_func_good_vsnprintf=no)])
if test $xdvi_cv_func_good_vsnprintf = yes; then
  AC_DEFINE(HAVE_GOOD_VSNPRINTF)
fi])


dnl ### Check for SunOS 4

AC_DEFUN(XDVI_SYS_SUNOS_4,
[AC_CACHE_CHECK([for SunOS 4], xdvi_cv_sys_sunos_4,
[case "`(uname -sr) 2>/dev/null`" in
"SunOS 4."*)
  xdvi_cv_sys_sunos_4=yes ;;
*) xdvi_cv_sys_sunos_4=no ;;
esac])
if test $xdvi_cv_sys_sunos_4 = yes; then
  AC_DEFINE(SUNOS4)
fi])


dnl ### Check for certain broken versions of Linux

AC_DEFUN(XDVI_SYS_OLD_LINUX,
[AC_CACHE_CHECK([for certain old versions of Linux], xdvi_cv_sys_old_linux,
[case "`(uname -sr) 2>/dev/null`" in
"Linux 2."[[01]].* | "Linux 2.2."[[0-8]] | "Linux 2.2."[[0-8]]-*)
  xdvi_cv_sys_old_linux=yes ;;
*) xdvi_cv_sys_old_linux=no ;;
esac])
if test $xdvi_cv_sys_old_linux = yes; then
  AC_DEFINE(FLAKY_SIGPOLL)
fi])


dnl ### Process a string argument

dnl XDVI_ARG_STRING(PACKAGE, HELP-STRING, VARIABLE, DEFAULT_VALUE)
AC_DEFUN(XDVI_ARG_STRING,
[AC_ARG_WITH($1, [$2], [AC_DEFINE_UNQUOTED($3, "$withval")
], [AC_DEFINE($3, [$4])
])])


dnl ### Determine the path to use for GS_LIB.

AC_DEFUN(XDVI_GS_LIB_PATH,
[AC_ARG_WITH(default-gs-lib-path, [  --with-default-gs-lib-path=PATH
                          set default path for finding font aliases to PATH],
[AC_DEFINE_UNQUOTED(DEFAULT_GS_LIB_PATH, "$withval")
],
[AC_CACHE_CHECK([for the path to be used for Ghostscript searches],
xdvi_gs_lib_path,
[if gs -h >/dev/null 2>&1; then
  ac_tmp="`gs -h \
    | sed \
      -e '1,/Search path:/d' \
      -e '/For more information/,$d' \
      -e '/Initialization files are compiled/d' \
      -e 's/$/\/\/\//' \
      -e 's/^   //' \
    | tr '\n' '/'`"
  # Solaris 9 sed doesn't handle incomplete lines at eof
  xdvi_gs_lib_path=`echo "$ac_tmp" \
    | sed -e 's/\/\/\/\// /g' -e 's/ *$//' -e 's/ : /:/g'`
else
  xdvi_gs_lib_path=none
fi])
if test "$xdvi_gs_lib_path" != none; then
  AC_DEFINE_UNQUOTED(DEFAULT_GS_LIB_PATH, "$xdvi_gs_lib_path")
else
  AC_MSG_WARN(Could not determine Ghostscript search path)
  AC_DEFINE(DEFAULT_GS_LIB_PATH, NULL)
fi
])])


dnl ### Check for whether we need -lXpm

AC_DEFUN(XDVI_CHECK_XPM,
[if test -z "$imake"; then
# Cygwin needs -lXpm to be linked in explicitly; yet on older (<4.2)
# versions of XFree86, -lXpm exists, but is not needed.  So we do two checks.
AC_CACHE_CHECK([for whether -lXpm needs to be explicitly given],
xdvi_needs_explicit_xpm,
[xdvi_save_LIBS=$LIBS
LIBS="-l$1 -lXmu -lXt$X_PRE_LIBS -lXext $LIBS $X_LIBS -lX11"
AC_TRY_LINK_FUNC(XawTextReplace, xdvi_needs_explicit_xpm=no,
[LIBS="$LIBS -lXpm"
AC_TRY_LINK_FUNC(XawTextReplace, xdvi_needs_explicit_xpm=yes,
xdvi_needs_explicit_xpm=unknown)])
LIBS=$xdvi_save_LIBS])
if test "$xdvi_needs_explicit_xpm" = yes; then
  X_PRE_LIBS=" -lXpm$X_PRE_LIBS"
fi
fi])


dnl ### Check for XkbBell() functionality.  Adapted from xterm's version.
AC_DEFUN([XDVI_XKB_BELL_EXT],[
AC_CACHE_CHECK([for XKB Bell extension], xdvi_cv_xkb_bell_ext,
[xdvi_save_LIBS=$LIBS
LIBS="$X_PRE_LIBS"$1" $LIBS $X_LIBS -lX11"
AC_TRY_LINK([
#include <X11/X.h>
#include <X11/XKBlib.h>		/* has the prototype */
],[
	Atom y;
	XkbBell((Display *)0, (Window)0, 0, y);
],[xdvi_cv_xkb_bell_ext=yes],[xdvi_cv_xkb_bell_ext=no])
LIBS=$xdvi_save_LIBS])
if test "$xdvi_cv_xkb_bell_ext" = yes; then
  X_PRE_LIBS="$X_PRE_LIBS"$1
  AC_DEFINE(HAVE_XKB_BELL_EXT)
fi])


dnl ### Check for whether setsid() is allowed within vfork()
dnl (Mac OS X 10.3 (Panther, 11/2003) is one O/S which does not allow this.)

AC_DEFUN(XDVI_FUNC_SETSID_IN_VFORK,
[if test $ac_cv_func_vfork_works = yes; then
AC_CACHE_CHECK([for whether setsid() is allowed within vfork()],
xdvi_cv_setsid_in_vfork,
[AC_TRY_RUN(
[/* Test adapted from Gnu autoconf */
/* Thanks to Paul Eggert for this test.  */
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_VFORK_H
#include <vfork.h>
#endif
int
main() {
  pid_t parent = getpid ();
  pid_t child;

  child = vfork ();

  if (child == 0) {
    if (setsid () == -1)
      _exit(1);
    _exit(0);
  } else {
    int status;

    while (wait(&status) != child)
      ;
    exit(
	 /* Was there some problem with vforking?  */
	 child < 0

	 /* Did the child fail?  (This shouldn't happen.)  */
	 || status
	 );
  }
}],
xdvi_cv_setsid_in_vfork=yes,
xdvi_cv_setsid_in_vfork=no)])
if test $xdvi_cv_setsid_in_vfork = yes; then
  AC_DEFINE(HAVE_GOOD_SETSID_VFORK)
fi]
fi)


dnl ### Check if the --allow-multiple-definition linker flag is
dnl ### available (assuming that we need to use it if it is)

AC_DEFUN(XDVI_LINKER_MULTIPLE_DEFNS,
[AC_CACHE_CHECK([whether linker supports the --allow-multiple-definition flag],
xdvi_linker_multiple_defns,
xdvi_save_LDFLAGS="$LDFLAGS"
LDFLAGS="-Xlinker --allow-multiple-definition"
x_linker_options=""
[AC_TRY_LINK(
   [#include <stdio.h>
   ],
   [void foo(void);
   ],
   xdvi_linker_multiple_defns=yes, xdvi_linker_multiple_defns=no
)]
)
if test $xdvi_linker_multiple_defns = yes; then
x_linker_options="-Xlinker --allow-multiple-definition"
fi
LDFLAGS="$xdvi_save_LDFLAGS"
AC_SUBST(x_linker_options)])


dnl ### Check for XInput version 2.1 or higher

AC_DEFUN(XDVI_XINPUT_2_1,
[AC_ARG_ENABLE(xi2-scrolling,
[  --enable-xi2-scrolling  Use XInput 2.1 'smooth scrolling' if available
                          (default: enabled)],
[], [enable_xi2_scrolling=yes])
if test "x$enable_xi2_scrolling" = xyes; then
AC_CACHE_CHECK([for XInput version 2.1 or higher],
xdvi_xinput_2_1,
[AC_TRY_COMPILE(
[#include <X11/extensions/XI2.h>
], [#if (XI_2_Major < 2 || (XI_2_Major == 2 && XI_2_Minor < 1))
choke me "XInput version is < 2.1"
#endif
], xdvi_xinput_2_1=yes, xdvi_xinput_2_1=no)])
if test $xdvi_xinput_2_1 = yes; then
  AC_DEFINE(HAVE_XI21)
  X_PRE_LIBS="$X_PRE_LIBS -lXi"
fi
fi])
