/*========================================================================*\

Copyright (c) 1990-2013  Paul Vojta

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL PAUL VOJTA OR ANY OTHER AUTHOR OF OR CONTRIBUTOR TO
THIS SOFTWARE BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
IN THE SOFTWARE.

NOTE:
	xdvi is based on prior work as noted in the modification history, below.

\*========================================================================*/

/*
 * DVI previewer for X.
 *
 * Eric Cooper, CMU, September 1985.
 *
 * Code derived from dvi-imagen.c.
 *
 * Modification history:
 * 1/1986	Modified for X.10	--Bob Scheifler, MIT LCS.
 * 7/1988	Modified for X.11	--Mark Eichin, MIT
 * 12/1988	Added 'R' option, toolkit, magnifying glass
 *					--Paul Vojta, UC Berkeley.
 * 2/1989	Added tpic support	--Jeffrey Lee, U of Toronto
 * 4/1989	Modified for System V	--Donald Richardson, Clarkson Univ.
 * 3/1990	Added VMS support	--Scott Allendorf, U of Iowa
 * 7/1990	Added reflection mode	--Michael Pak, Hebrew U of Jerusalem
 * 1/1992	Added greyscale code	--Till Brychcy, Techn. Univ. Muenchen
 *					  and Lee Hetherington, MIT
 * 4/1994	Added DPS support, bounding box
 *					--Ricardo Telichevesky
 *					  and Luis Miguel Silveira, MIT RLE.
 * 1/2001	Added source specials	--including ideas from Stefan Ulrich,
 *					  U Munich
 *
 *	Compilation options:
 *	VMS	compile for VMS
 *	XAW	compile with X toolkit and Athena (Xaw) widgets
 *	XAW3D	compile with Xaw3d variant of Xaw widgets.  XAW should be
 *		defined, too.
 *	MOTIF	compile with X toolkit and Motif widgets
 *	BUTTONS	compile with buttons on the side of the window (needs toolkit)
 *	WORDS_BIGENDIAN	store bitmaps internally with most significant bit first
 *	BMTYPE	store bitmaps in unsigned BMTYPE
 *	BMBYTES	sizeof(unsigned BMTYPE)
 *	ALTFONT	default for -altfont option
 *	SHRINK	default for -s option (shrink factor)
 *	MFMODE	default for -mfmode option
 *	A4	use European size paper, and change default dimension to cm
 *	TEXXET	support reflection dvi codes (right-to-left typesetting)
 *	GREY	use grey levels to shrink fonts
 *	PS_GS	use Ghostscript to render pictures/bounding boxes
 *	PS_DPS	use display postscript to render pictures/bounding boxes
 *	PS_NEWS	use the NeWS server to render pictures/bounding boxes
 *	GS_PATH	path to call the Ghostscript interpreter by
 */

#define	EXTERN
#define	INIT(x)	=x

#include "xdvi.h"

#if !lint
static	char	copyright[] UNUSED =
"@(#) Copyright (c) 1994-2003 Paul Vojta.  All rights reserved.\n";
#endif

#include <math.h>	/* sometimes includes atof() */
#include <ctype.h>

#if NeedVarargsPrototypes		/* this is for usage() */
#include <stdarg.h>
#else
#include <varargs.h>
#endif

#ifndef	ALTFONT
#define	ALTFONT	"cmr10"
#endif

#ifndef	SHRINK
#define	SHRINK	3
#endif

#ifndef	BDPI
#define	BDPI	300
#endif

#ifndef	MFMODE
#define	MFMODE	NULL
#endif

#if	defined(PS_GS) && !defined(GS_PATH)
#define	GS_PATH	"gs"
#endif

#if A4
#define	DEFAULT_PAPER		"a4"
#else
#define	DEFAULT_PAPER		"letter"
#endif

#include "version.h"

#ifdef	X_NOT_STDC_ENV
#ifndef	atof
extern	double	atof ARGS((_Xconst char *));
#endif
#endif

/* Xlib and Xutil are already included */
#include <X11/cursorfont.h>
#include <X11/keysym.h>
#include "xdvi.icon"

#ifdef	TOOLKIT

#ifdef	OLD_X11_TOOLKIT
#include <X11/Atoms.h>
#else /* not OLD_X11_TOOLKIT */
#include <X11/Xatom.h>
#include <X11/StringDefs.h>
#endif /* not OLD_X11_TOOLKIT */

#include <X11/Shell.h>	/* needed for def. of XtNiconX */

#if	XtSpecificationRelease >= 4

#ifndef MOTIF
# if XAW3D
#  include <X11/Xaw3d/Viewport.h>
# else
#  include <X11/Xaw/Viewport.h>
# endif
#define	VPORT_WIDGET_CLASS	viewportWidgetClass
#define	DRAW_WIDGET_CLASS	drawWidgetClass
#else /* MOTIF */
#include <Xm/MainW.h>
#include <Xm/ToggleB.h>
#include <Xm/RowColumn.h>
#include <Xm/MenuShell.h>
#include <Xm/DrawingA.h>
#include <Xm/Protocols.h>
#define	VPORT_WIDGET_CLASS	xmMainWindowWidgetClass
#define	DRAW_WIDGET_CLASS	xmDrawingAreaWidgetClass
#endif /* MOTIF */

#ifdef	BUTTONS
#ifndef MOTIF
# if XAW3D
#  include <X11/Xaw3d/Command.h>
# else
#  include <X11/Xaw/Command.h>
# endif
#define	FORM_WIDGET_CLASS	formWidgetClass
#else /* MOTIF */
#include <Xm/Form.h>
#define	FORM_WIDGET_CLASS	xmFormWidgetClass
#endif /* MOTIF */
#endif /* BUTTONS */

#else	/* XtSpecificationRelease < 4 */

#if NeedFunctionPrototypes
typedef	void	*XtPointer;
#else
typedef	char	*XtPointer;
#endif

#include <X11/Viewport.h>
#define	VPORT_WIDGET_CLASS	viewportWidgetClass
#define	DRAW_WIDGET_CLASS	drawWidgetClass
#ifdef	BUTTONS
#include <X11/Command.h>
#define	FORM_WIDGET_CLASS	formWidgetClass
#endif

#endif	/* XtSpecificationRelease */

# if XtSpecificationRelease < 5
#  define XtScreenDatabase(s)	(DISP->db)
# endif

# if HAVE_X11_INTRINSICI_H
#  include <X11/IntrinsicI.h>
# else

/* Taken from <X11/TranslateI.h> in libXt-1.0.4 (Oct. 2006) */
typedef struct _LateBindings {
	unsigned int	knot:1;
	unsigned int	pair:1;
	unsigned short	ref_count;
	KeySym		keysym;
} LateBindings, *LateBindingsPtr;

# endif /* HAVE_X11_INTRINSICI_H */

#else	/* not TOOLKIT */

typedef	int		Position;

#endif	/* not TOOLKIT */

#if XlibSpecificationRelease < 5
typedef	char		*XPointer;
#define	XScreenNumberOfScreen(s)	((s) - ScreenOfDisplay(DISP, 0))
#endif

/*
 *	Cursors and masks for dragging operations.
 */

#define drag_vert_width 7
#define drag_vert_height 17
#define drag_vert_x_hot 3
#define drag_vert_y_hot 8
static _Xconst unsigned char drag_vert_bits[] = {
    0x00, 0x08, 0x1c, 0x2a, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
    0x08, 0x2a, 0x1c, 0x08, 0x00};
static _Xconst unsigned char drag_vert_mask[] = {
    0x08, 0x1c, 0x3e, 0x7f, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c,
    0x1c, 0x7f, 0x3e, 0x1c, 0x08};

#define drag_horiz_width 17
#define drag_horiz_height 7
#define drag_horiz_x_hot 8
#define drag_horiz_y_hot 3
static _Xconst unsigned char drag_horiz_bits[] = {
    0x00, 0x00, 0x00, 0x08, 0x20, 0x00, 0x04, 0x40, 0x00, 0xfe, 0xff, 0x00,
    0x04, 0x40, 0x00, 0x08, 0x20, 0x00, 0x00, 0x00, 0x00};
static _Xconst unsigned char drag_horiz_mask[] = {
    0x08, 0x20, 0x00, 0x0c, 0x60, 0x00, 0xfe, 0xff, 0x00, 0xff, 0xff, 0x01,
    0xfe, 0xff, 0x00, 0x0c, 0x60, 0x00, 0x08, 0x20, 0x00};

#define drag_omni_width 17
#define drag_omni_height 17
#define drag_omni_x_hot 8
#define drag_omni_y_hot 8
static _Xconst unsigned char drag_omni_bits[] = {
    0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x80, 0x03, 0x00, 0x40, 0x05, 0x00,
    0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x08, 0x21, 0x00, 0x04, 0x41, 0x00,
    0xfe, 0xff, 0x00, 0x04, 0x41, 0x00, 0x08, 0x21, 0x00, 0x00, 0x01, 0x00,
    0x00, 0x01, 0x00, 0x40, 0x05, 0x00, 0x80, 0x03, 0x00, 0x00, 0x01, 0x00,
    0x00, 0x00, 0x00};
static _Xconst unsigned char drag_omni_mask[] = {
    0x00, 0x01, 0x00, 0x80, 0x03, 0x00, 0xc0, 0x07, 0x00, 0xe0, 0x0f, 0x00,
    0x80, 0x03, 0x00, 0x88, 0x23, 0x00, 0x8c, 0x63, 0x00, 0xfe, 0xff, 0x00,
    0xff, 0xff, 0x01, 0xfe, 0xff, 0x00, 0x8c, 0x63, 0x00, 0x88, 0x23, 0x00,
    0x80, 0x03, 0x00, 0xe0, 0x0f, 0x00, 0xc0, 0x07, 0x00, 0x80, 0x03, 0x00,
    0x00, 0x01, 0x00};

#ifdef	VMS
/*
 * Magnifying glass cursor
 *
 * Developed by Tom Sawyer, April 1990
 * Contibuted by Hunter Goatley, January 1991
 *
 */

#define mag_glass_width 16
#define mag_glass_height 16
#define mag_glass_x_hot 6
#define mag_glass_y_hot 6
static char mag_glass_bits[] = {
	0xf8, 0x03, 0x0c, 0x06, 0xe2, 0x09, 0x13, 0x1a, 0x01, 0x14, 0x01, 0x14,
	0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x03, 0x10, 0x02, 0x18, 0x0c, 0x34,
	0xf8, 0x6f, 0x00, 0xd8, 0x00, 0xb0, 0x00, 0xe0
};
#include <decw$cursor.h>	/* Include the DECWindows cursor symbols */
static	int	DECWCursorFont;	/* Space for the DECWindows cursor font  */
static	Pixmap	MagnifyPixmap;	/* Pixmap to hold our special mag-glass  */
#include <X11/Xresource.h>      /* Motif apparently needs this one */
#endif	/* VMS */

/*
 * Command line flags.
 */

static	Dimension	bwidth	= 2;

#define	fore_Pixel	resource._fore_Pixel
#define	back_Pixel	resource._back_Pixel
#ifdef	TOOLKIT
struct _resource	resource;
#define	brdr_Pixel	resource._brdr_Pixel
#define	hl_Pixel	resource._hl_Pixel
#define	cr_Pixel	resource._cr_Pixel
#else /* not TOOLKIT */
static	_Xconst char	*brdr_color;
static	_Xconst char	*high_color;
static	_Xconst char	*curs_color;
static	Pixel		hl_Pixel, cr_Pixel;
#endif	/* not TOOLKIT */

XColor	cr_Color;

struct	mg_size_rec	mg_size[5]	= {{200, 150}, {400, 250}, {700, 500},
					   {1000, 800}, {1200, 1200}};

static	char	*curr_page;

struct WindowRec mane	= {(Window) 0, 1, 0, 0, 0, 0, MAXDIM, 0, MAXDIM, 0};
struct WindowRec alt	= {(Window) 0, 1, 0, 0, 0, 0, MAXDIM, 0, MAXDIM, 0};
/*	currwin is temporary storage except for within redraw() */
struct WindowRec currwin= {(Window) 0, 1, 0, 0, 0, 0, MAXDIM, 0, MAXDIM, 0};

#ifdef	lint
#ifdef	TOOLKIT
WidgetClass	widgetClass;
#ifndef MOTIF
WidgetClass	viewportWidgetClass;
#ifdef	BUTTONS
WidgetClass	formWidgetClass, compositeWidgetClass, commandWidgetClass;
#endif	/* BUTTONS */
#else /* MOTIF */
WidgetClass	xmMainWindowWidgetClass, xmDrawingAreaWidgetClass;
#ifdef	BUTTONS
WidgetClass	xmFormWidgetClass, xmBulletinBoardWidgetClass;
WidgetClass	xmPushButtonWidgetClass;
#endif	/* BUTTONS */
#endif /* MOTIF */
#endif	/* TOOLKIT */
#endif	/* lint */

static	char *	atom_names[]	= {"XDVI WINDOWS", "DVI NAME", "SRC GOTO",
#if TOOLKIT
				   "WM_DELETE_WINDOW",
#endif
#if XAW
				   "WM_PROTOCOLS",
#endif
				   };

/*
 *	Data for options processing
 */

static	_Xconst	char	silent[] = " ";	/* flag value for usage() */

static	_Xconst	char	subst[]	= "x";	/* another flag value */

static	_Xconst char	*subst_val[] = {
#ifdef	BUTTONS
					"-shrinkbutton[1-9] <shrink>",
#endif
					"-mgs[n] <size>"};

#ifdef	TOOLKIT

static	XrmOptionDescRec	options[] = {
{"-s",		".shrinkFactor", XrmoptionSepArg,	(XPointer) NULL},
#ifndef	VMS
{"-S",		".densityPercent", XrmoptionSepArg,	(XPointer) NULL},
#endif
{"-density",	".densityPercent", XrmoptionSepArg,	(XPointer) NULL},
#if COLOR
{"-nocolor",	".color",	XrmoptionNoArg,		(XPointer) "off"},
{"+nocolor",	".color",	XrmoptionNoArg,		(XPointer) "on"},
#endif
#ifdef	GREY
{"-nogrey",	".grey",	XrmoptionNoArg,		(XPointer) "off"},
{"+nogrey",	".grey",	XrmoptionNoArg,		(XPointer) "on"},
{"-gamma",	".gamma",	XrmoptionSepArg,	(XPointer) NULL},
{"-install",	".install",	XrmoptionNoArg,		(XPointer) "on"},
{"-noinstall",	".install",	XrmoptionNoArg,		(XPointer) "off"},
#endif
{"-p",		".pixelsPerInch", XrmoptionSepArg,	(XPointer) NULL},
{"-margins",	".Margin",	XrmoptionSepArg,	(XPointer) NULL},
{"-sidemargin",	".sideMargin",	XrmoptionSepArg,	(XPointer) NULL},
{"-topmargin",	".topMargin",	XrmoptionSepArg,	(XPointer) NULL},
{"-offsets",	".Offset",	XrmoptionSepArg,	(XPointer) NULL},
{"-xoffset",	".xOffset",	XrmoptionSepArg,	(XPointer) NULL},
{"-yoffset",	".yOffset",	XrmoptionSepArg,	(XPointer) NULL},
{"-paper",	".paper",	XrmoptionSepArg,	(XPointer) NULL},
{"-altfont",	".altFont",	XrmoptionSepArg,	(XPointer) NULL},
#ifdef MKTEXPK
{"-nomakepk",	".makePk",	XrmoptionNoArg,		(XPointer) "off"},
{"+nomakepk",	".makePk",	XrmoptionNoArg,		(XPointer) "on"},
#endif
{"-mfmode",	".mfMode",	XrmoptionSepArg,	(XPointer) NULL},
{"-editor",	".editor",	XrmoptionSepArg,	(XPointer) NULL},
{"-sourceposition",".sourcePosition", XrmoptionSepArg,	(XPointer) NULL},
{"-nofork",	".fork",	XrmoptionNoArg,		(XPointer) "off"},
{"+nofork",	".fork",	XrmoptionNoArg,		(XPointer) "on"},
{"-l",		".listFonts",	XrmoptionNoArg,		(XPointer) "on"},
{"+l",		".listFonts",	XrmoptionNoArg,		(XPointer) "off"},
#if FREETYPE
{"-nofreetypefonts", ".freetypeFonts", XrmoptionNoArg,	(XPointer) "off"},
{"+nofreetypefonts", ".freetypeFonts", XrmoptionNoArg,	(XPointer) "on"},
#endif
#ifdef	BUTTONS
{"-expert",	".expert",	XrmoptionNoArg,		(XPointer) "on"},
{"+expert",	".expert",	XrmoptionNoArg,		(XPointer) "off"},
{"-shrinkbutton1",".shrinkButton1",XrmoptionSepArg,	(XPointer) NULL},
{"-shrinkbutton2",".shrinkButton2",XrmoptionSepArg,	(XPointer) NULL},
{"-shrinkbutton3",".shrinkButton3",XrmoptionSepArg,	(XPointer) NULL},
{"-shrinkbutton4",".shrinkButton4",XrmoptionSepArg,	(XPointer) NULL},
{"-shrinkbutton5",".shrinkButton5",XrmoptionSepArg,	(XPointer) NULL},
{"-shrinkbutton6",".shrinkButton6",XrmoptionSepArg,	(XPointer) NULL},
{"-shrinkbutton7",".shrinkButton7",XrmoptionSepArg,	(XPointer) NULL},
{"-shrinkbutton8",".shrinkButton8",XrmoptionSepArg,	(XPointer) NULL},
{"-shrinkbutton9",".shrinkButton9",XrmoptionSepArg,	(XPointer) NULL},
#endif
{"-mgs",	".magnifierSize1",XrmoptionSepArg,	(XPointer) NULL},
{"-mgs1",	".magnifierSize1",XrmoptionSepArg,	(XPointer) NULL},
{"-mgs2",	".magnifierSize2",XrmoptionSepArg,	(XPointer) NULL},
{"-mgs3",	".magnifierSize3",XrmoptionSepArg,	(XPointer) NULL},
{"-mgs4",	".magnifierSize4",XrmoptionSepArg,	(XPointer) NULL},
{"-mgs5",	".magnifierSize5",XrmoptionSepArg,	(XPointer) NULL},
{"-warnspecials", ".warnSpecials", XrmoptionNoArg,	(XPointer) "on"},
{"+warnspecials", ".warnSpecials", XrmoptionNoArg,	(XPointer) "off"},
{"-hush",	".Hush",	XrmoptionNoArg,		(XPointer) "on"},
{"+hush",	".Hush",	XrmoptionNoArg,		(XPointer) "off"},
{"-hushchars",	".hushLostChars", XrmoptionNoArg,	(XPointer) "on"},
{"+hushchars",	".hushLostChars", XrmoptionNoArg,	(XPointer) "off"},
{"-hushchecksums", ".hushChecksums", XrmoptionNoArg,	(XPointer) "on"},
{"+hushchecksums", ".hushChecksums", XrmoptionNoArg,	(XPointer) "off"},
{"-safer",	".safer",	XrmoptionNoArg,		(XPointer) "on"},
{"+safer",	".safer",	XrmoptionNoArg,		(XPointer) "off"},
{"-fg",		".foreground",	XrmoptionSepArg,	(XPointer) NULL},
{"-foreground",	".foreground",	XrmoptionSepArg,	(XPointer) NULL},
{"-bg",		".background",	XrmoptionSepArg,	(XPointer) NULL},
{"-background",	".background",	XrmoptionSepArg,	(XPointer) NULL},
{"-hl",		".highlight",	XrmoptionSepArg,	(XPointer) NULL},
{"-cr",		".cursorColor",	XrmoptionSepArg,	(XPointer) NULL},
{"-icongeometry",".iconGeometry",XrmoptionSepArg,	(XPointer) NULL},
{"-keep",	".keepPosition",XrmoptionNoArg,		(XPointer) "on"},
{"+keep",	".keepPosition",XrmoptionNoArg,		(XPointer) "off"},
{"-copy",	".copy",	XrmoptionNoArg,		(XPointer) "on"},
{"+copy",	".copy",	XrmoptionNoArg,		(XPointer) "off"},
{"-thorough",	".thorough",	XrmoptionNoArg,		(XPointer) "on"},
{"+thorough",	".thorough",	XrmoptionNoArg,		(XPointer) "off"},
{"-wheelunit",	".wheelUnit",	XrmoptionSepArg,	(XPointer) NULL},
#if PS
{"-nopostscript",".postscript",	XrmoptionNoArg,		(XPointer) "off"},
{"+nopostscript",".postscript",	XrmoptionNoArg,		(XPointer) "on"},
{"-allowshell",	".allowShell",	XrmoptionNoArg,		(XPointer) "on"},
{"+allowshell",	".allowShell",	XrmoptionNoArg,		(XPointer) "off"},
#ifdef	PS_DPS
{"-nodps",	".dps",		XrmoptionNoArg,		(XPointer) "off"},
{"+nodps",	".dps",		XrmoptionNoArg,		(XPointer) "on"},
#endif
#ifdef	PS_NEWS
{"-nonews",	".news",	XrmoptionNoArg,		(XPointer) "off"},
{"+nonews",	".news",	XrmoptionNoArg,		(XPointer) "on"},
#endif
#ifdef	PS_GS
{"-noghostscript",".ghostscript", XrmoptionNoArg,	(XPointer) "off"},
{"+noghostscript",".ghostscript", XrmoptionNoArg,	(XPointer) "on"},
{"-nogssafer",	".gsSafer",	XrmoptionNoArg,		(XPointer) "off"},
{"+nogssafer",	".gsSafer",	XrmoptionNoArg,		(XPointer) "on"},
{"-gsalpha",	".gsAlpha",	XrmoptionNoArg,		(XPointer) "on"},
{"+gsalpha",	".gsAlpha",	XrmoptionNoArg,		(XPointer) "off"},
{"-interpreter",".interpreter",	XrmoptionSepArg,	(XPointer) NULL},
{"-gspalette",	".palette",	XrmoptionSepArg,	(XPointer) NULL},
#endif
#endif	/* PS */
{"-noscan",	".prescan",	XrmoptionNoArg,		(XPointer) "off"},
{"+noscan",	".prescan",	XrmoptionNoArg,		(XPointer) "on"},
{"-dvipspath",	".dvipsPath",	XrmoptionSepArg,	(XPointer) NULL},
{"-debug",	".debugLevel",	XrmoptionSepArg,	(XPointer) NULL},
{"-version",	".version",	XrmoptionNoArg,		(XPointer) "on"},
{"+version",	".version",	XrmoptionNoArg,		(XPointer) "off"},
{"--version",	".version",	XrmoptionNoArg,		(XPointer) "on"},
};

#if MAKING_HEADER
	"XDVI_KR_BEGIN1"
#endif

#if !CC_K_AND_R || MAKING_HEADER

static	_Xconst char	base_translations[] = ""
"^<Key>c:quit()\n"	/* Control keys first */
"^<Key>d:quit()\n"
"^<Key>m:forward-page()\n"
"^<Key>j:forward-page()\n"
"^<Key>l:forward-page(0)\n"
"^<Key>h:back-page()\n"
"^<Key>o:open-dvi-file()\n"
"^<Key>p:print()\n"
"a<Key>p:show-display-attributes()\n"
#ifdef VMS
"^<Key>z:quit()\n"
#endif
"\"q\":quit()\n"
"\"d\":down()\n"
"\"f\":forward-page()\n"
"\"n\":forward-page()\n"
"\" \":down-or-next()\n"
"<Key>Return:forward-page()\n"
"\"p\":back-page()\n"
"\"b\":back-page()\n"
"<Key>Delete:up-or-previous()\n"
"<Key>BackSpace:up-or-previous()\n"
#if MOTIF
"<Key>osfDelete:up-or-previous()\n"
"<Key>osfBackSpace:up-or-previous()\n"
#endif
"\"P\":declare-page-number()\n"
"\"g\":goto-page()\n"
"\"\\^\":home()\n"
"\"c\":center()\n"
"\"k\":set-keep-flag()\n"
"\"l\":left()\n"
"\"r\":right()\n"
"\"u\":up()\n"
"\"M\":set-margins()\n"
"\"s\":set-shrink-factor()\n"
"\"S\":set-density()\n"
"<Key>Home:home()\n"
"<Key>Left:left()\n"
"<Key>Up:up()\n"
"<Key>Right:right()\n"
"<Key>Down:down()\n"
"<Key>Prior:back-page()\n"
"<Key>Next:forward-page()\n"
#ifdef XK_KP_Left
"<Key>KP_Home:home()\n"
"<Key>KP_Left:left()\n"
"<Key>KP_Up:up()\n"
"<Key>KP_Right:right()\n"
"<Key>KP_Down:down()\n"
"<Key>KP_Prior:back-page()\n"
"<Key>KP_Next:forward-page()\n"
"<Key>KP_Delete:up-or-previous()\n"
"<Key>KP_Enter:forward-page()\n"
#endif
#if GREY
"\"G\":set-greyscaling()\n"
#endif
#if COLOR
"\"C\":set-color()\n"
#endif
#if PS
"\"v\":set-ps()\n"
#endif
#if PS_GS
"\"V\":set-gs-alpha()\n"
#endif
#if BUTTONS
"\"x\":set-expert-mode()\n"
#endif
"<Key>Escape:discard-number()\n"	/* Esc */
"s<Btn1Down>:drag(|)\n"
"s<Btn2Down>:drag(+)\n"
"s<Btn3Down>:drag(-)\n"
"c<Btn1Down>:source-special()\n"
"c<Btn2Down>:show-source-specials()\n"
"c<Btn3Down>:show-all-boxes()\n"
"<Btn1Down>:magnifier(*1)\n"
"<Btn2Down>:magnifier(*2)\n"
"<Btn3Down>:magnifier(*3)\n"
"\"R\":reread-dvi-file()";

#else	/* CC_K_AND_R && not MAKING_HEADER */
# include "krheader.h"
#endif

#if MAKING_HEADER
	"XDVI_KR_END1"
#endif

#define	offset(field)	XtOffsetOf(struct _resource, field)

static	char	XtRBool3[]	= "Bool3";	/* resource for Bool3 */

#if EXTRA_APP_DEFAULTS
static	XtResource	pre_app_resources[] = {
{"name", "Name", XtRString, sizeof(char *),
  offset(progname), XtRString, (XtPointer) NULL},
{"debugLevel", "DebugLevel", XtRString, sizeof(char *),
  offset(debug_arg), XtRString, (XtPointer) NULL},
};
#endif

static	XtResource	application_resources[] = {
#if CFGFILE && !EXTRA_APP_DEFAULTS
{"name", "Name", XtRString, sizeof(char *),
  offset(progname), XtRString, (XtPointer) NULL},
#endif
{"shrinkFactor", "ShrinkFactor", XtRInt, sizeof(int),
  offset(shrinkfactor), XtRImmediate, (XtPointer) SHRINK},
{"densityPercent", "DensityPercent", XtRInt, sizeof(int),
  offset(_density), XtRString, "40"},
{"mainTranslations", "MainTranslations", XtRString, sizeof(char *),
  offset(main_translations), XtRString, (XtPointer) NULL},
{"wheelTranslations", "WheelTranslations", XtRString, sizeof(char *),
  offset(wheel_translations), XtRString, (XtPointer) "<Btn4Down>:wheel(-1.)\n\
    <Btn5Down>:wheel(1.)\n<Btn6Down>:hwheel(-1.)\n<Btn7Down>:hwheel(1.)"},
{"wheelUnit", "WheelUnit", XtRInt, sizeof(int),
  offset(wheel_unit), XtRImmediate, (XtPointer) 80},
{"dvipsHangTime", "DvipsHangTime", XtRInt, sizeof(int),
  offset(dvips_hang), XtRImmediate, (XtPointer) 700},
{"dvipsFailHangTime", "DvipsFailHangTime", XtRInt, sizeof(int),
  offset(dvips_fail_hang), XtRImmediate, (XtPointer) 5000},
#ifdef	GREY
{"gamma", "Gamma", XtRFloat, sizeof(float),
  offset(_gamma), XtRString, "1"},
#endif
{"pixelsPerInch", "PixelsPerInch", XtRInt, sizeof(int),
  offset(_pixels_per_inch), XtRImmediate, (XtPointer) BDPI},
{"sideMargin", "Margin", XtRString, sizeof(char *),
  offset(sidemargin), XtRString, (XtPointer) NULL},
{"topMargin", "Margin", XtRString, sizeof(char *),
  offset(topmargin), XtRString, (XtPointer) NULL},
{"xOffset", "Offset", XtRString, sizeof(char *),
  offset(xoffset), XtRString, (XtPointer) NULL},
{"yOffset", "Offset", XtRString, sizeof(char *),
  offset(yoffset), XtRString, (XtPointer) NULL},
{"paper", "Paper", XtRString, sizeof(char *),
  offset(paper), XtRString, (XtPointer) DEFAULT_PAPER},
{"altFont", "AltFont", XtRString, sizeof(char *),
  offset(_alt_font), XtRString, (XtPointer) ALTFONT},
#ifdef MKTEXPK
{"makePk", "MakePk", XtRBoolean, sizeof(Boolean),
  offset(makepk), XtRString, "true"},
#endif
{"mfMode", "MfMode", XtRString, sizeof(char *),
  offset(mfmode), XtRString, MFMODE},
{"editor", "Editor", XtRString, sizeof(char *),
  offset(editor), XtRString, (XtPointer) NULL},
{"sourcePosition", "SourcePosition", XtRString, sizeof(char *),
  offset(src_pos), XtRString, (XtPointer) NULL},
{"fork", "Fork", XtRBoolean, sizeof(Boolean),
  offset(src_fork), XtRString, "true"},
{"listFonts", "ListFonts", XtRBoolean, sizeof(Boolean),
  offset(_list_fonts), XtRString, "false"},
#if FREETYPE
{"freetypeFonts", "FreetypeFonts", XtRBoolean, sizeof(Boolean),
  offset(freetype), XtRString, "true"},
#endif
{"reverseVideo", "ReverseVideo", XtRBoolean, sizeof(Boolean),
  offset(reverse), XtRString, "false"},
{"warnSpecials", "WarnSpecials", XtRBoolean, sizeof(Boolean),
  offset(_warn_spec), XtRString, "false"},
{"hushLostChars", "Hush", XtRBoolean, sizeof(Boolean),
  offset(_hush_chars), XtRString, "false"},
{"hushChecksums", "Hush", XtRBoolean, sizeof(Boolean),
  offset(_hush_chk), XtRString, "false"},
{"safer", "Safer", XtRBoolean, sizeof(Boolean),
  offset(safer), XtRString, "false"},
#ifdef VMS
{"foreground", "Foreground", XtRString, sizeof(char *),
  offset(fore_color), XtRString, (XtPointer) NULL},
{"background", "Background", XtRString, sizeof(char *),
  offset(back_color), XtRString, (XtPointer) NULL},
#endif
{"iconGeometry", "IconGeometry", XtRString, sizeof(char *),
  offset(icon_geometry), XtRString, (XtPointer) NULL},
{"keepPosition", "KeepPosition", XtRBoolean, sizeof(Boolean),
  offset(keep_flag), XtRString, "false"},
#if PS
{"postscript", "Postscript", XtRBoolean, sizeof(Boolean),
  offset(_postscript), XtRString, "true"},
{"allowShell", "AllowShell", XtRBoolean, sizeof(Boolean),
  offset(allow_shell), XtRString, "false"},
#ifdef	PS_DPS
{"dps", "DPS", XtRBoolean, sizeof(Boolean),
  offset(useDPS), XtRString, "true"},
#endif
#ifdef	PS_NEWS
{"news", "News", XtRBoolean, sizeof(Boolean),
  offset(useNeWS), XtRString, "true"},
#endif
#ifdef	PS_GS
{"ghostscript", "Ghostscript", XtRBoolean, sizeof(Boolean),
  offset(useGS), XtRString, "true"},
{"gsSafer", "Safer", XtRBoolean, sizeof(Boolean),
  offset(gs_safer), XtRString, "true"},
{"gsAlpha", "Alpha", XtRBoolean, sizeof(Boolean),
  offset(gs_alpha), XtRString, "false"},
{"interpreter", "Interpreter", XtRString, sizeof(char *),
  offset(gs_path), XtRString, (XtPointer) GS_PATH},
{"palette", "Palette", XtRString, sizeof(char *),
  offset(gs_palette), XtRString, (XtPointer) "Color"},
#endif
#endif	/* PS */
{"prescan", "Prescan", XtRBoolean, sizeof(Boolean),
  offset(prescan), XtRString, "true"},
{"copy", "Copy", XtRBoolean, sizeof(Boolean),
  offset(copy), XtRString, "false"},
{"thorough", "Thorough", XtRBoolean, sizeof(Boolean),
  offset(thorough), XtRString, "false"},
#if !EXTRA_APP_DEFAULTS
{"debugLevel", "DebugLevel", XtRString, sizeof(char *),
  offset(debug_arg), XtRString, (XtPointer) NULL},
#endif
{"version", "Version", XtRBoolean, sizeof(Boolean),
  offset(version_flag), XtRString, "false"},
#if BUTTONS
{"expert", "Expert", XtRBoolean, sizeof(Boolean),
  offset(expert), XtRString, "false"},
{"buttonTranslations", "ButtonTranslations", XtRString, sizeof(char *),
  offset(button_translations), XtRString, (XtPointer) default_button_config},
{"shrinkButton1", "ShrinkButton1", XtRInt, sizeof(int),
  offset(shrinkbutton[0]), XtRImmediate, (XtPointer) 0},
{"shrinkButton2", "ShrinkButton2", XtRInt, sizeof(int),
  offset(shrinkbutton[1]), XtRImmediate, (XtPointer) 0},
{"shrinkButton3", "ShrinkButton3", XtRInt, sizeof(int),
  offset(shrinkbutton[2]), XtRImmediate, (XtPointer) 0},
{"shrinkButton4", "ShrinkButton4", XtRInt, sizeof(int),
  offset(shrinkbutton[3]), XtRImmediate, (XtPointer) 0},
{"shrinkButton5", "ShrinkButton5", XtRInt, sizeof(int),
  offset(shrinkbutton[4]), XtRImmediate, (XtPointer) 0},
{"shrinkButton6", "ShrinkButton6", XtRInt, sizeof(int),
  offset(shrinkbutton[5]), XtRImmediate, (XtPointer) 0},
{"shrinkButton7", "ShrinkButton7", XtRInt, sizeof(int),
  offset(shrinkbutton[6]), XtRImmediate, (XtPointer) 0},
{"shrinkButton8", "ShrinkButton8", XtRInt, sizeof(int),
  offset(shrinkbutton[7]), XtRImmediate, (XtPointer) 0},
{"shrinkButton9", "ShrinkButton9", XtRInt, sizeof(int),
  offset(shrinkbutton[8]), XtRImmediate, (XtPointer) 0},
{"buttonSideSpacing", "ButtonSpacing", XtRDimension, sizeof(Dimension),
  offset(btn_side_spacing), XtRImmediate, (XtPointer) 6},
{"buttonTopSpacing", "ButtonSpacing", XtRDimension, sizeof(Dimension),
  offset(btn_top_spacing), XtRImmediate, (XtPointer) 50},
{"buttonBetweenSpacing", "ButtonSpacing", XtRDimension, sizeof(Dimension),
  offset(btn_between_spacing), XtRImmediate, (XtPointer) 20},
{"buttonBetweenExtra", "ButtonSpacing", XtRDimension, sizeof(Dimension),
  offset(btn_between_extra), XtRImmediate, (XtPointer) 50},
{"buttonBorderWidth", "BorderWidth", XtRDimension, sizeof(Dimension),
  offset(btn_border_width), XtRImmediate, (XtPointer) 1},
#endif
{"magnifierSize1", "MagnifierSize", XtRString, sizeof(char *),
  offset(mg_arg[0]), XtRString, (XtPointer) NULL},
{"magnifierSize2", "MagnifierSize", XtRString, sizeof(char *),
  offset(mg_arg[1]), XtRString, (XtPointer) NULL},
{"magnifierSize3", "MagnifierSize", XtRString, sizeof(char *),
  offset(mg_arg[2]), XtRString, (XtPointer) NULL},
{"magnifierSize4", "MagnifierSize", XtRString, sizeof(char *),
  offset(mg_arg[3]), XtRString, (XtPointer) NULL},
{"magnifierSize5", "MagnifierSize", XtRString, sizeof(char *),
  offset(mg_arg[4]), XtRString, (XtPointer) NULL},
#if COLOR
{"color", "Color", XtRBoolean, sizeof(Boolean),
  offset(_use_color), XtRString, "true"},
#endif
{"dvipsPath", "DvipsPath", XtRString, sizeof(char *),
  offset(dvips_path), XtRString, (XtPointer) DEFAULT_DVIPS_PATH},
#ifdef	GREY
{"grey", "Grey", XtRBoolean, sizeof(Boolean),
  offset(_use_grey), XtRString, "true"},
{"install", "Install", XtRBool3, sizeof(Bool3),
  offset(install), XtRString, "maybe"},
};

static	XtResource	app_pixel_resources[] = {	/* get these later */
#endif /* GREY */
{"foreground", "Foreground", XtRPixel, sizeof(Pixel),
  offset(_fore_Pixel), XtRString, XtDefaultForeground},
{"background", "Background", XtRPixel, sizeof(Pixel),
  offset(_back_Pixel), XtRString, XtDefaultBackground},
{"borderColor", "BorderColor", XtRPixel, sizeof(Pixel),
  offset(_brdr_Pixel), XtRPixel, (XtPointer) &resource._fore_Pixel},
{"highlight", "Highlight", XtRPixel, sizeof(Pixel),
  offset(_hl_Pixel), XtRPixel, (XtPointer) &resource._fore_Pixel},
{"cursorColor", "CursorColor", XtRPixel, sizeof(Pixel),
  offset(_cr_Pixel), XtRPixel, (XtPointer) &resource._fore_Pixel},
};
#undef	offset

static	_Xconst	char	*usagestr[] = {
	/* shrinkFactor */	"shrink",
#ifndef	VMS
	/* S */			"density",
	/* density */		silent,
#else
	/* density */		"density",
#endif
#ifdef	GREY
	/* gamma */		"g",
#endif
	/* p */			"pixels",
	/* margins */		"dimen",
	/* sidemargin */	"dimen",
	/* topmargin */		"dimen",
	/* offsets */		"dimen",
	/* xoffset */		"dimen",
	/* yoffset */		"dimen",
	/* paper */		"papertype",
	/* altfont */		"font",
	/* mfmode */		"mode-def",
	/* editor */		"editor",
	/* sourceposition */	"\"linenumber filename\"",
	/* rv */		"^-l", "-rv",
#ifdef	BUTTONS
	/* shrinkbutton1 */	subst,
	/* shrinkbutton2 */	silent,
	/* shrinkbutton3 */	silent,
	/* shrinkbutton4 */	silent,
	/* shrinkbutton5 */	silent,
	/* shrinkbutton6 */	silent,
	/* shrinkbutton7 */	silent,
	/* shrinkbutton8 */	silent,
	/* shrinkbutton9 */	silent,
#endif
	/* mgs */		subst,
	/* mgs1 */		silent,
	/* mgs2 */		silent,
	/* mgs3 */		silent,
	/* mgs4 */		silent,
	/* mgs5 */		silent,
	/* bw */		"^-safer", "-bw <width>",
	/* fg */		"color",
	/* foreground */	silent,
	/* bg */		"color",
	/* background */	silent,
	/* hl */		"color",
	/* bd */		"^-hl", "-bd <color>",
	/* cr */		"color",
#ifndef VMS
	/* display */		"^-cr", "-display <host:display>",
#else
	/* display */		"^-cr", "-display <host::display>",
#endif
	/* geometry */		"^-cr", "-geometry <geometry>",
	/* icongeometry */	"geometry",
	/* iconic */		"^-icongeometry", "-iconic",
#ifdef	BUTTONS
	/* font */		"^-icongeometry", "-font <font>",
#endif
	/* wheelunit */		"pixels",
#ifdef	PS_GS
	/* interpreter */	"path",
	/* gspalette */		"monochrome|grayscale|color",
#endif
	/* dvipspath */		"path",
	/* debug */		"bitmask",
	/* [dummy] */		"z"
};


#ifndef MOTIF

#ifdef	NOQUERY
#define	drawWidgetClass	widgetClass
#else

/* ARGSUSED */
static	XtGeometryResult
QueryGeometry(w, constraints, reply)
	Widget	w;
	XtWidgetGeometry *constraints, *reply;
{
	reply->request_mode = CWWidth | CWHeight;
	reply->width = page_w;
	reply->height = page_h;
	return XtGeometryAlmost;
}

#include <X11/IntrinsicP.h>
#include <X11/CoreP.h>

#ifdef	lint
WidgetClassRec	widgetClassRec;
#endif

	/* if the following gives you trouble, just compile with -DNOQUERY */
static	WidgetClassRec	drawingWidgetClass = {
  {
    /* superclass         */    &widgetClassRec,
    /* class_name         */    "Draw",
    /* widget_size        */    sizeof(WidgetRec),
    /* class_initialize   */    NULL,
    /* class_part_initialize*/  NULL,
    /* class_inited       */    FALSE,
    /* initialize         */    NULL,
    /* initialize_hook    */    NULL,
    /* realize            */    XtInheritRealize,
    /* actions            */    NULL,
    /* num_actions        */    0,
    /* resources          */    NULL,
    /* num_resources      */    0,
    /* xrm_class          */    NULLQUARK,
    /* compress_motion    */    FALSE,
    /* compress_exposure  */    TRUE,
    /* compress_enterleave*/    FALSE,
    /* visible_interest   */    FALSE,
    /* destroy            */    NULL,
    /* resize             */    XtInheritResize,
    /* expose             */    XtInheritExpose,
    /* set_values         */    NULL,
    /* set_values_hook    */    NULL,
    /* set_values_almost  */    XtInheritSetValuesAlmost,
    /* get_values_hook    */    NULL,
    /* accept_focus       */    XtInheritAcceptFocus,
    /* version            */    XtVersion,
    /* callback_offsets   */    NULL,
    /* tm_table           */    XtInheritTranslations,
    /* query_geometry       */  QueryGeometry,
    /* display_accelerator  */  XtInheritDisplayAccelerator,
    /* extension            */  NULL
  }
};

#define	drawWidgetClass	&drawingWidgetClass

#endif /* NOQUERY */
#endif /* MOTIF */

static	Arg	vport_args[] = {
#if ! MOTIF
#ifdef	BUTTONS
	{XtNborderWidth,	(XtArgVal) 0},
	{XtNtop,		(XtArgVal) XtChainTop},
	{XtNbottom,		(XtArgVal) XtChainBottom},
	{XtNleft,		(XtArgVal) XtChainLeft},
	{XtNright,		(XtArgVal) XtChainRight},
#endif
	{XtNallowHoriz,		(XtArgVal) True},
	{XtNallowVert,		(XtArgVal) True},
#else /* MOTIF */
	{XmNscrollingPolicy,	(XtArgVal) XmAUTOMATIC},
	{XmNborderWidth,	(XtArgVal) 0},
	{XmNleftAttachment,	(XtArgVal) XmATTACH_FORM},
	{XmNtopAttachment,	(XtArgVal) XmATTACH_FORM},
	{XmNbottomAttachment,	(XtArgVal) XmATTACH_FORM},
	{XmNrightAttachment,	(XtArgVal) XmATTACH_FORM},
#endif /* MOTIF */
};

static	Arg	draw_args[] = {
#ifndef MOTIF
	{XtNwidth,		(XtArgVal) 0},
	{XtNheight,		(XtArgVal) 0},
	{XtNx,			(XtArgVal) 0},
	{XtNy,			(XtArgVal) 0},
	{XtNlabel,		(XtArgVal) ""},
#else /* MOTIF */
	{XmNwidth,		(XtArgVal) 0},
	{XmNheight,		(XtArgVal) 0},
	{XmNbottomAttachment,	(XtArgVal) XmATTACH_WIDGET},
#endif /* MOTIF */
};

#if BUTTONS
static	Arg	form_args[] = {
#if !MOTIF
	{XtNdefaultDistance,	(XtArgVal) 0},
#else /* MOTIF */
	{XmNhorizontalSpacing,	(XtArgVal) 0},
	{XmNverticalSpacing,	(XtArgVal) 0},
#endif /* MOTIF */
};
#endif

#else	/* not TOOLKIT */

static	char	*display;
static	char	*geometry;
static	char	*margins;
static	char	*offsets;
static	Boolean	hush;
static	Boolean	iconic	= False;

#define	ADDR(x)	(XPointer) &resource.x

static	struct option {
	_Xconst	char	*name;
	_Xconst	char	*resource;
	enum {FalseArg, TrueArg, StickyArg, SepArg}
			argclass;
	enum {BooleanArg, Bool3Arg, StringArg, NumberArg, FloatArg}
			argtype;
	int		classcount;
	_Xconst	char	*usagestr;
	XPointer	address;
}	options[] = {
{"+",		NULL,		StickyArg, StringArg, 1,
  NULL,		(XPointer) &curr_page},
{"-s",		"shrinkFactor", SepArg, NumberArg, 1,
  "shrink",	(XPointer) &shrink_factor},
#ifndef VMS
{"-S",		NULL,		SepArg, NumberArg, 2,
  "density",	ADDR(_density)},
{"-density",	"densityPercent", SepArg, NumberArg, 1,
  silent,	ADDR(_density)},
#else
{"-density",	"densityPercent", SepArg, NumberArg, 1,
  "density",	ADDR(_density)},
#endif
#if COLOR
{"-nocolor",	NULL,		FalseArg, BooleanArg, 2,
  NULL,		ADDR(_use_color)},
{"+nocolor",	"color",	TrueArg, BooleanArg, 1,
  NULL,		ADDR(_use_color)},
#endif
#ifdef	GREY
{"-nogrey",	NULL,		FalseArg, BooleanArg, 2,
  NULL,		ADDR(_use_grey)},
{"+nogrey",	"grey",		TrueArg, BooleanArg, 1,
  NULL,		ADDR(_use_grey)},
{"-gamma",	"gamma",	SepArg,	FloatArg, 1,
  "g",		ADDR(_gamma)},
{"-install",	NULL,		TrueArg, Bool3Arg, 2,
  NULL,		ADDR(install)},
{"-noinstall",	"install",	FalseArg, Bool3Arg, 1,
  NULL,		ADDR(install)},
#endif
{"-p",		"pixelsPerInch", SepArg, NumberArg, 1,
  "pixels",	ADDR(_pixels_per_inch)},
{"-margins",	"Margin",	SepArg,	StringArg, 3,
  "dimen",	(XPointer) &margins},
{"-sidemargin",	"sideMargin",	SepArg,	StringArg, 1,
  "dimen",	ADDR(sidemargin)},
{"-topmargin",	"topMargin",	SepArg,	StringArg, 1,
  "dimen",	ADDR(topmargin)},
{"-offsets",	"Offset",	SepArg,	StringArg, 3,
  "dimen",	(XPointer) &offsets},
{"-xoffset",	"xOffset",	SepArg,	StringArg, 1,
  "dimen",	ADDR(xoffset)},
{"-yoffset",	"yOffset",	SepArg,	StringArg, 1,
  "dimen",	ADDR(yoffset)},
{"-paper",	"paper",	SepArg,	StringArg, 1,
  "papertype",	ADDR(paper)},
{"-altfont",	"altFont",	SepArg,	StringArg, 1,
  "font",	ADDR(_alt_font)},
#ifdef MKTEXPK
{"-nomakepk",	"makePk",	FalseArg, BooleanArg, 2,
  NULL,		ADDR(makepk)},
{"+nomakepk",	"makePk",	TrueArg, BooleanArg, 1,
  NULL,		ADDR(makepk)},
#endif
{"-mfmode",	"mfMode",	SepArg,	StringArg, 1,
  "mode-def",	ADDR(mfmode)},
{"-editor",	"editor",	SepArg,	StringArg, 1,
  "editor",	ADDR(editor)},
{"-sourceposition","sourcePosition", SepArg, StringArg, 1,
  "\"linenumber filename\"",ADDR(src_pos)},
{"-nofork",	NULL,		FalseArg, BooleanArg, 2,
  NULL,		ADDR(src_fork)},
{"+nofork",	"fork",		TrueArg, BooleanArg, 1,
  NULL,		ADDR(src_fork)},
{"-l",		NULL,		TrueArg, BooleanArg, 2,
  NULL,		ADDR(_list_fonts)},
{"+l",		"listFonts",	FalseArg, BooleanArg, 1,
  NULL,		ADDR(_list_fonts)},
#if FREETYPE
{"-nofreetypefonts", NULL,	FalseArg, BooleanArg, 2,
  NULL,		ADDR(freetype)},
{"+nofreetypefonts", "freetypeFonts", TrueArg, BooleanArg, 1,
  NULL,		ADDR(freetype)},
#endif
{"-rv",		NULL,		TrueArg, BooleanArg, 2,
  NULL,		ADDR(reverse)},
{"+rv",		"reverseVideo",	FalseArg, BooleanArg, 1,
  NULL,		ADDR(reverse)},
{"-mgs",	NULL,		SepArg, StringArg, 2,
  subst,	ADDR(mg_arg[0])},
{"-mgs1",	"magnifierSize1",SepArg, StringArg, 1,
  silent,	ADDR(mg_arg[0])},
{"-mgs2",	"magnifierSize2",SepArg, StringArg, 1,
  silent,	ADDR(mg_arg[1])},
{"-mgs3",	"magnifierSize3",SepArg, StringArg, 1,
  silent,	ADDR(mg_arg[2])},
{"-mgs4",	"magnifierSize4",SepArg, StringArg, 1,
  silent,	ADDR(mg_arg[3])},
{"-mgs5",	"magnifierSize5",SepArg, StringArg, 1,
  silent,	ADDR(mg_arg[4])},
{"-warnspecials", NULL,		TrueArg, BooleanArg, 2,
  NULL,		ADDR(_warn_spec)},
{"+warnspecials", "warnSpecials", FalseArg, BooleanArg, 1,
  NULL,		ADDR(_warn_spec)},
{"-hush",	NULL,		TrueArg, BooleanArg, 6,
  NULL,		(XPointer) &hush},
{"+hush",	"Hush",		FalseArg, BooleanArg, 5,
  NULL,		(XPointer) &hush},
{"-hushchars",	NULL,		TrueArg, BooleanArg, 2,
  NULL,		ADDR(_hush_chars)},
{"+hushchars",	"hushLostChars", FalseArg, BooleanArg, 1,
  NULL,		ADDR(_hush_chars)},
{"-hushchecksums", NULL,	TrueArg, BooleanArg, 2,
  NULL,		ADDR(_hush_chk)},
{"+hushchecksums","hushChecksums", FalseArg, BooleanArg, 1,
  NULL,		ADDR(_hush_chk)},
{"-safer",	NULL,		TrueArg, BooleanArg, 2,
  NULL,		ADDR(safer)},
{"+safer",	"safer",	FalseArg, BooleanArg, 1,
  NULL,		ADDR(safer)},
{"-bw",		NULL,		SepArg,	NumberArg, 2,
  "width",	(XPointer) &bwidth},
{"-borderwidth", "borderWidth",	SepArg,	NumberArg, 1,
  silent,	(XPointer) &bwidth},
{"-fg",		NULL,		SepArg,	StringArg, 2,
  "color",	ADDR(fore_color)},
{"-foreground",	"foreground",	SepArg,	StringArg, 1,
  silent,	ADDR(fore_color)},
{"-bg",		NULL,		SepArg,	StringArg, 2,
  "color",	ADDR(back_color)},
{"-background",	"background",	SepArg,	StringArg, 1,
  silent,	ADDR(back_color)},
{"-hl",		"highlight",	SepArg,	StringArg, 1,
  "color",	(XPointer) &high_color},
{"-bd",		NULL,		SepArg,	StringArg, 2,
  "color",	(XPointer) &brdr_color},
{"-bordercolor","borderColor",	SepArg,	StringArg, 1,
  silent,	(XPointer) &brdr_color},
{"-cr",		"cursorColor",	SepArg,	StringArg, 1,
  "color",	(XPointer) &curs_color},
#ifndef VMS
{"-display",	NULL,		SepArg,	StringArg, 1,
  "host:display", (XPointer) &display},
#else
{"-display",	NULL,		SepArg,	StringArg, 1,
  "host::display", (XPointer) &display},
#endif
{"-geometry",	"geometry",	SepArg,	StringArg, 1,
  "geometry",	(XPointer) &geometry},
{"-icongeometry","iconGeometry",StickyArg, StringArg, 1,
  "geometry",	ADDR(icon_geometry)},
{"-iconic",	NULL,		TrueArg, BooleanArg, 2,
  NULL,		(XPointer) &iconic},
{"+iconic",	"iconic",	FalseArg, BooleanArg, 1,
  NULL,		(XPointer) &iconic},
{"-keep",	NULL,		TrueArg, BooleanArg, 2,
  NULL,		ADDR(keep_flag)},
{"+keep",	"keepPosition",	FalseArg, BooleanArg, 1,
  NULL,		ADDR(keep_flag)},
{"-copy",	NULL,		TrueArg, BooleanArg, 2,
  NULL,		ADDR(copy)},
{"+copy",	"copy",		FalseArg, BooleanArg, 1,
  NULL,		ADDR(copy)},
{"-thorough",	NULL,		TrueArg, BooleanArg, 2,
  NULL,		ADDR(thorough)},
{"+thorough",	"thorough",	FalseArg, BooleanArg, 1,
  NULL,		ADDR(thorough)},
{"-wheelunit",	"wheelUnit",	SepArg,	NumberArg, 1,
  "pixels",	ADDR(wheel_unit)},
#if PS
{"-nopostscript", NULL,		FalseArg, BooleanArg, 2,
  NULL,		ADDR(_postscript)},
{"+nopostscript", "postscript",	TrueArg, BooleanArg, 1,
  NULL,		ADDR(_postscript)},
{"-allowshell",	NULL,		TrueArg, BooleanArg, 2,
  NULL,		ADDR(allow_shell)},
{"+allowshell",	"allowShell",	FalseArg, BooleanArg, 1,
  NULL,		ADDR(allow_shell)},
#ifdef	PS_DPS
{"-nodps",	NULL,		FalseArg, BooleanArg, 2,
  NULL,		ADDR(useDPS)},
{"+nodps",	"dps",		TrueArg, BooleanArg, 1,
  NULL,		ADDR(useDPS)},
#endif
#ifdef	PS_NEWS
{"-nonews",	NULL,		FalseArg, BooleanArg, 2,
  NULL,		ADDR(useNeWS)},
{"+nonews",	"news",		TrueArg, BooleanArg, 1,
  NULL,		ADDR(useNeWS)},
#endif
#ifdef	PS_GS
{"-noghostscript",NULL,		FalseArg, BooleanArg, 2,
  NULL,		ADDR(useGS)},
{"+noghostscript","ghostscript", TrueArg, BooleanArg, 1,
  NULL,		ADDR(useGS)},
{"-nogssafer",	NULL,		FalseArg, BooleanArg, 2,
  NULL,		ADDR(gs_safer)},
{"+nogssafer",	"gsSafer",	TrueArg, BooleanArg, 1,
  NULL,		ADDR(gs_safer)},
{"-gsalpha",	NULL,		TrueArg, BooleanArg, 2,
  NULL,		ADDR(gs_alpha)},
{"+gsalpha",	"gsAlpha",	FalseArg, BooleanArg, 1,
  NULL,		ADDR(gs_alpha)},
{"-interpreter", "interpreter",	SepArg,	StringArg, 1,
  "path",	ADDR(gs_path)},
{"-gspalette",	"palette",	SepArg,	StringArg, 1,
  "monochrome|grayscale|color",	ADDR(gs_palette)},
#endif
#endif	/* PS */
{"-noscan", NULL,		FalseArg, BooleanArg, 2,
  NULL,		ADDR(prescan)},
{"+noscan",	"prescan",	TrueArg, BooleanArg, 1,
  NULL,		ADDR(prescan)},
{"-debug",	"debugLevel",	SepArg,	StringArg, 1,
  "bitmask",	ADDR(debug_arg)},
{"-version",	NULL,		TrueArg, BooleanArg, 3,
  NULL,		ADDR(version_flag)},
{"+version",	"version",	FalseArg, BooleanArg, 2,
  NULL,		ADDR(version_flag)},
{"--version",	NULL,		TrueArg, BooleanArg, 1,
  NULL,		ADDR(version_flag)},
};

#endif	/* not TOOLKIT */

static	void	usage VARGS((_Xconst char *, ...)) NORETURN;

#if NeedVarargsPrototypes
static	void
usage(_Xconst char *message, ...)
#else
/* VARARGS */
void
usage(va_alist)
	va_dcl
#endif
{
#if !NeedVarargsPrototypes
	_Xconst char *message;
#endif
	va_list	args;
#if TOOLKIT
	XrmOptionDescRec *opt;
	_Xconst	char	**usageptr = usagestr;
#else
	struct option	*opt;
#endif
	_Xconst char	**sv	= subst_val;
	_Xconst char	*str1;
	_Xconst char	*str2;
	int		col	= 23;
	int		n;

	Fprintf(stderr, "%s: ", prog);

#if NeedVarargsPrototypes
	va_start(args, message);
#else
	va_start(args);
	message = va_arg(args, _Xconst char *);
#endif
	(void) vfprintf(stderr, message, args);
	va_end(args);

	Fputs("\n\nUsage: xdvi [+[<page>]]", stderr);
	for (opt = options; opt < options + XtNumber(options); ++opt) {
#if TOOLKIT
	    str1 = opt->option;
	    if (*str1 != '-') continue;
	    str2 = NULL;
	    if (opt->argKind != XrmoptionNoArg) {
		str2 = *usageptr++;
		if (str2 == silent) continue;
		if (str2 == subst) {
		    str1 = *sv++;
		    str2 = NULL;
		}
	    }
	    for (;;) {
		n = strlen(str1) + 3;
		if (str2 != NULL) n += strlen(str2) + 3;
		if (col + n < 80) Putc(' ', stderr);
		else {
		    Fputs("\n\t", stderr);
		    col = 8 - 1;
		}
		if (str2 == NULL)
		    Fprintf(stderr, "[%s]", str1);
		else
		    Fprintf(stderr, "[%s <%s>]", str1, str2);
		col += n;
		if (**usageptr != '^'
			 || strcmp(*usageptr + 1, opt->option) != 0) break;
		++usageptr;
		str1 = *usageptr++;
		str2 = NULL;
	    }
#else /* not TOOLKIT */
	    str1 = opt->name;
	    str2 = opt->usagestr;
	    if (*str1 != '-' || str2 == silent) continue;
	    if (str2 == subst) {
		str1 = *sv++;
		str2 = NULL;
	    }
	    n = strlen(str1) + 3;
	    if (str2 != NULL) n += strlen(str2) + 3;
	    if (col + n < 80) Putc(' ', stderr);
	    else {
		Fputs("\n\t", stderr);
		col = 8 - 1;
	    }
	    if (str2 == NULL)
		Fprintf(stderr, "[%s]", str1);
	    else
		Fprintf(stderr, "[%s <%s>]", str1, str2);
	    col += n;
#endif /* not TOOLKIT */
	}
	if (col + 9 < 80) Putc(' ', stderr);
	else Fputs("\n\t", stderr);
	Fputs("dvi_file\n", stderr);
	exit(1);
}

int
atopix(arg, allow_minus)
	_Xconst	char	*arg;
	Boolean		allow_minus;
{
	int		len	= strlen(arg);
	_Xconst char	*arg_end = arg;
	char		tmp[11];
	double		factor;

	if (allow_minus && *arg_end == '-') ++arg_end;
	while ((*arg_end >= '0' && *arg_end <= '9') || *arg_end == '.')
	    if (arg_end >= arg + XtNumber(tmp) - 1) return 0;
	    else ++arg_end;
	bcopy(arg, tmp, arg_end - arg);
	tmp[arg_end - arg] = '\0';

#if A4
	factor = 1.0 / 2.54;	/* cm */
#else
	factor = 1.0;		/* inches */
#endif
	if (len > 2)
	    switch (arg[len - 2] << 8 | arg[len - 1]) {
#if A4
		case 'i' << 8 | 'n':  factor = 1.0;			break;
#else
		case 'c' << 8 | 'm':  factor = 1.0 / 2.54;		break;
#endif
		case 'm' << 8 | 'm':  factor = 1.0 / 25.4;		break;
		case 'p' << 8 | 't':  factor = 1.0 / 72.27;		break;
		case 'p' << 8 | 'c':  factor = 12.0 / 72.27;		break;
		case 'b' << 8 | 'p':  factor = 1.0 / 72.0;		break;
		case 'd' << 8 | 'd':  factor = 1238.0 / 1157.0 / 72.27;	break;
		case 'c' << 8 | 'c':  factor = 12 * 1238.0 / 1157.0 / 72.27;
									break;
		case 's' << 8 | 'p':  factor = 1.0 / 72.27 / 65536;	break;
	    }

	return (int) (factor * atof(tmp) * pixels_per_inch + 0.5);
}

/**
 **	Main program starts here.
 **/

#ifdef	TOOLKIT

#ifdef GREY
static	Arg	temp_args1[] = {
	{XtNdepth,	(XtArgVal) 0},
	{XtNvisual,	(XtArgVal) 0},
	{XtNcolormap,	(XtArgVal) 0},
};
#define	temp_args1a	(temp_args1 + 2)
#endif

static	Arg	temp_args2[] = {
	{XtNiconX,	(XtArgVal) 0},
	{XtNiconY,	(XtArgVal) 0},
};

static	Arg	temp_args3 = {XtNborderWidth,	(XtArgVal) &bwidth};

static	Pixmap	icon_pm;
static	Arg	temp_args4 = {XtNiconPixmap,	(XtArgVal) &icon_pm};

static	Arg	set_wh_args[] = {
	{XtNwidth,	(XtArgVal) 0},
	{XtNheight,	(XtArgVal) 0},
};


#ifdef GREY

/*
 *	Alternate routine to convert color name to Pixel (needed to substitute
 *	"black" or "white" for BlackPixelOfScreen, etc., since a different
 *	visual and colormap are in use).
 */

#if XtSpecificationRelease >= 5

/*ARGSUSED*/
static	Boolean
XdviCvtStringToPixel(dpy, args, num_args, fromVal, toVal, closure_ret)
	Display		*dpy;
	XrmValuePtr	args;
	Cardinal	*num_args;
	XrmValuePtr	fromVal;
	XrmValuePtr	toVal;
	XtPointer	*closure_ret;
{
	XrmValue	replacement_val;
	Boolean		default_is_fg;

	if ((strcmp((String) fromVal->addr, XtDefaultForeground) == 0
	    && (default_is_fg = True))
	  || (strcmp((String) fromVal->addr, XtDefaultBackground) == 0
	    && ((default_is_fg = False), True))) {
	    replacement_val.size = sizeof(String);
	    replacement_val.addr = (default_is_fg == resource.reverse)
	      ? "white" : "black";
	    fromVal = &replacement_val;
	}

	return
	  XtCvtStringToPixel(dpy, args, num_args, fromVal, toVal, closure_ret);
}

#else /* XtSpecificationRelease < 5 */

/*
 *	Copied from the X11R4 source code.
 */

#define	done(type, value) \
	{							\
	    if (toVal->addr != NULL) {				\
		if (toVal->size < sizeof(type)) {		\
		    toVal->size = sizeof(type);			\
		    return False;				\
		}						\
		*(type*)(toVal->addr) = (value);		\
	    }							\
	    else {						\
		static type static_val;				\
		static_val = (value);				\
		toVal->addr = (XtPointer)&static_val;		\
	    }							\
	    toVal->size = sizeof(type);				\
	    return True;					\
	}

static	Boolean
XdviCvtStringToPixel(dpy, args, num_args, fromVal, toVal, closure_ret)
    Display*	dpy;
    XrmValuePtr args;
    Cardinal    *num_args;
    XrmValuePtr	fromVal;
    XrmValuePtr	toVal;
    XtPointer	*closure_ret;
{
    String	    str = (String)fromVal->addr;
    XColor	    screenColor;
    XColor	    exactColor;
    Screen	    *screen;
    Colormap	    colormap;
    Status	    status;
    String          params[1];
    Cardinal	    num_params=1;

    if (*num_args != 2)
     XtErrorMsg("wrongParameters", "cvtStringToPixel",
		   "XtToolkitError",
	"String to pixel conversion needs screen and colormap arguments",
        (String *)NULL, (Cardinal *)NULL);

    screen = *((Screen **) args[0].addr);
    colormap = *((Colormap *) args[1].addr);

    if (strcmp(str, XtDefaultBackground) == 0) {
	*closure_ret = False;
	str = (resource.reverse ? "black" : "white");
    }
    else if (strcmp(str, XtDefaultForeground) == 0) {
	*closure_ret = False;
	str = (resource.reverse ? "white" : "black");
    }

    if (*str == '#') {  /* some color rgb definition */

        status = XParseColor(DisplayOfScreen(screen), colormap,
			     (char*)str, &screenColor);

        if (status != 0)
           status = XAllocColor(DisplayOfScreen(screen), colormap,
                                &screenColor);
    } else  /* some color name */

        status = XAllocNamedColor(DisplayOfScreen(screen), colormap,
                                  (char*)str, &screenColor, &exactColor);
    if (status == 0) {
	params[0] = str;
	XtWarningMsg("noColormap", "cvtStringToPixel",
			"XtToolkitError",
                 "Cannot allocate colormap entry for \"%s\"",
                  params,&num_params);
	return False;
    } else {
	*closure_ret = (char*)True;
        done(Pixel, screenColor.pixel);
    }
}
#undef	done

#endif /* XtSpecificationRelease < 5 */

/*
 *	Convert string to yes/no/maybe.  Adapted from the X toolkit.
 */

/*ARGSUSED*/
static	Boolean
XdviCvtStringToBool3(dpy, args, num_args, fromVal, toVal, closure_ret)
	Display		*dpy;
	XrmValuePtr	args;
	Cardinal	*num_args;
	XrmValuePtr	fromVal;
	XrmValuePtr	toVal;
	XtPointer	*closure_ret;
{
	String		str	= (String)fromVal->addr;
	static Bool3	value;

	if (   memicmp(str, "true", 5) == 0
	    || memicmp(str, "yes", 4) == 0
	    || memicmp(str, "on", 3) == 0
	    || memicmp(str, "1", 2) == 0)	value = True;

	else if (memicmp(str, "false", 6) == 0
	    ||   memicmp(str, "no", 3) == 0
	    ||   memicmp(str, "off", 4) == 0
	    ||   memicmp(str, "0", 2) == 0)	value = False;

	else if (memicmp(str, "maybe", 6) == 0)	value = Maybe;

	else {
	    XtDisplayStringConversionWarning(dpy, str, XtRBoolean);
	    return False;
	}

	if (toVal->addr != NULL) {
	    if (toVal->size < sizeof(Bool3)) {
		toVal->size = sizeof(Bool3);
		return False;
	    }
	    *(Bool3 *)(toVal->addr) = value;
	}
	else toVal->addr = (XPointer) &value;

	toVal->size = sizeof(Bool3);
	return True;
}

#endif /* GREY */

#else	/* not TOOLKIT */

struct _resource	resource = {
	/* wheel_unit		*/	80,
	/* density		*/	40,
#ifdef	GREY
	/* gamma		*/	1.0,
#endif
	/* pixels_per_inch	*/	BDPI,
	/* sidemargin		*/	NULL,
	/* topmargin		*/	NULL,
	/* xoffset		*/	NULL,
	/* yoffset		*/	NULL,
	/* paper		*/	DEFAULT_PAPER,
	/* alt_font		*/	ALTFONT,
#ifdef MKTEXPK
	/* makepk		*/	True,
#endif
	/* mfmode		*/	MFMODE,
	/* editor		*/	NULL,
	/* src_pos		*/	NULL,
	/* src_fork		*/	True,
	/* list_fonts		*/	False,
#if FREETYPE
	/* freetype		*/	True,
#endif
	/* reverse		*/	False,
	/* warn_spec		*/	False,
	/* hush_chars		*/	False,
	/* hush_chk		*/	False,
	/* safer		*/	False,
	/* fore_color		*/	NULL,
	/* back_color		*/	NULL,
	/* fore_Pixel		*/	(Pixel) 0,
	/* back_Pixel		*/	(Pixel) 0,
	/* icon_geometry	*/	NULL,
	/* keep_flag		*/	False,
	/* copy			*/	False,
	/* thorough		*/	False,
#if PS
	/* postscript		*/	True,
	/* allow_shell		*/	False,
#ifdef	PS_DPS
	/* useDPS		*/	True,
#endif
#ifdef	PS_NEWS
	/* useNeWS		*/	True,
#endif
#ifdef	PS_GS
	/* useGS		*/	True,
	/* gs_safer		*/	True,
	/* gs_alpha		*/	False,
	/* gs_path		*/	GS_PATH,
	/* gs_palette		*/	"Color",
#endif
#endif	/* PS */
	/* prescan		*/	True,
	/* debug_arg		*/	NULL,
	/* version_flag		*/	False,
	/* mg_arg		*/	{NULL, NULL, NULL, NULL, NULL},
#if COLOR
	/* use_color		*/	True,
#endif
#ifdef	GREY
	/* use_grey		*/	True,
	/* install		*/	Maybe,
#endif
};

static	Pixel
string_to_pixel(strp)		/* adapted from the toolkit */
	char	**strp;
{
	char	*str = *strp;
	Status	status;
	XColor	color, junk;

	if (*str == '#') {	/* an rgb definition */
	    status = XParseColor(DISP, our_colormap, str, &color);
	    if (status != 0)
		status = XAllocColor(DISP, our_colormap, &color);
	}
	else	/* a name */
	    status = XAllocNamedColor(DISP, our_colormap, str, &color, &junk);
	if (status == 0) {
	    WARN1(XmDIALOG_WARNING,
	      "Cannot allocate colormap entry\nfor \"%s\"", str);
	    *strp = NULL;
	    return (Pixel) 0;
	}
	return color.pixel;
}

/*
 *	Process the option table.  This is not guaranteed for all possible
 *	option tables, but at least it works for this one.
 */

static	void
parse_options(argc, argv)
	int argc;
	char **argv;
{
	char		**arg;
	char		**argvend = argv + argc;
	char		*optstring;
	XPointer	addr;
	struct option	*opt, *lastopt, *candidate;
	int		len1, len2, matchlen;

	/*
	 * Step 1.  Process command line options.
	 */
	for (arg = argv + 1; arg < argvend; ++arg) {
	    len1 = strlen(*arg);
	    candidate = NULL;
	    matchlen = 0;
	    for (opt = options; opt < options + XtNumber(options); ++opt) {
		len2 = strlen(opt->name);
		if (opt->argclass == StickyArg) {
		    if (matchlen <= len2 && !strncmp(*arg, opt->name, len2)) {
			candidate = opt;
			matchlen = len2;
		    }
		}
		else if (len1 <= len2 && matchlen <= len1 &&
		    !strncmp(*arg, opt->name, len1)) {
		    if (len1 == len2) {
			candidate = opt;
			break;
		    }
		    if (matchlen < len1) candidate = opt;
		    else if (candidate && candidate->argclass != StickyArg)
			candidate = NULL;
		    matchlen = len1;
		}
	    }
	    if (candidate == NULL) {
		if (**arg == '-')
		    usage("Invalid argument \"%s\".", *arg);
		else if (dvi_name)
		    usage(
		      "More than one dvi file name given:\n\t\"%s\", \"%s\".",
		      dvi_name, *arg);
		else {
		    dvi_name = *arg;
		    continue;
		}
	    }
		/* flag it for subsequent processing */
	    candidate->resource = (char *) candidate;
		/* store the value */
	    addr = candidate->address;
	    switch (candidate->argclass) {
		case FalseArg:	*((Boolean *) addr) = False; continue;
		case TrueArg:	*((Boolean *) addr) = True; continue;
		case StickyArg:	optstring = *arg + strlen(candidate->name);
		    break;
		case SepArg:
		    ++arg;
		    if (arg >= argvend)
		      usage("Option \"%s\" appears without an argument.",
			arg[-1]);
		    optstring = *arg;
		    break;
	    }
	    switch (candidate->argtype) {
		case StringArg:	*((char **) addr) = optstring; break;
		case NumberArg:	*((int *) addr) = atoi(optstring); break;
		case FloatArg:  *((float *) addr) = atof(optstring); break;
		default:  ;
	    }
	}
	/*
	 * Step 2.  Propagate classes for command line arguments.  Backwards.
	 */
	for (opt = options + XtNumber(options) - 1; opt >= options; --opt)
	    if (opt->resource == (char *) opt) {
		addr = opt->address;
		lastopt = opt + opt->classcount;
		for (candidate = opt; candidate < lastopt; ++candidate) {
		    if (candidate->resource != NULL) {
			switch (opt->argtype) {
			    case BooleanArg:
			    case Bool3Arg:	/* same type as Boolean */
				*((Boolean *) candidate->address) =
				    *((Boolean *) addr);
				break;
			    case StringArg:
				*((char **) candidate->address) =
				    *((char **) addr);
				break;
			    case NumberArg:
				*((int *) candidate->address) = *((int *) addr);
				break;
			    case FloatArg:
				*((float *) candidate->address) =
				    *((float *) addr);
				break;
			}
			candidate->resource = NULL;
		    }
		}
	    }

	if ((DISP = XOpenDisplay(display)) == NULL)
	    oops("Can't open display");
	SCRN = DefaultScreenOfDisplay(DISP);
	/*
	 * Step 3.  Handle resources (including classes).
	 */
	for (opt = options; opt < options + XtNumber(options); ++opt)
	    if (opt->resource &&
		    ((optstring = XGetDefault(DISP, prog, opt->resource)) ||
		    (optstring = XGetDefault(DISP, "XDvi", opt->resource))))
		{
		    lastopt = opt + opt->classcount;
		    for (candidate = opt; candidate < lastopt; ++candidate)
			if (candidate->resource != NULL) switch (opt->argtype) {
			    case Bool3Arg:
				if (       memicmp(optstring, "maybe", 6) == 0)
				{
				    * (Bool3 *) candidate->address = Maybe;
				    break;
				}
				/* otherwise, fall through; the underlying */
				/* types of Bool3 and Boolean are the same. */
			    case BooleanArg:
				* (Boolean *) candidate->address =
				    (  memicmp(optstring, "true", 5) == 0
				    || memicmp(optstring, "yes", 4) == 0
				    || memicmp(optstring, "on", 3) == 0
				    || memicmp(optstring, "1", 2) == 0);
				break;
			    case StringArg:
				* (char **) candidate->address = optstring;
				break;
			    case NumberArg:
				* (int *) candidate->address = atoi(optstring);
				break;
			    case FloatArg:
				* (float *) candidate->address =
				    atof(optstring);
			}
		}
}

#endif	/* not TOOLKIT */

/*
 *	Routines for running as source-special client.
 *
 *	Resources are used as follows:
 *
 *	ATOM_XDVI_WINDOWS is attached to the root window of the default screen
 *		of the display; it contains a list of (hopefully active) xdvi
 *		windows.
 *	ATOM_DVI_FILE is attached to the main xdvi window; it tells the world
 *		what dvi file is being viewed.  It is set by that copy of xdvi
 *		and read by this routine.  The first 8 bytes are the inode
 *		number, and the rest is the file name.  We use 8 instead of
 *		sizeof(ino_t) because the latter may vary from machine to
 *		machine, and the format needs to be machine independent.
 *	ATOM_SRC_GOTO is attached to the main xdvi window; it tells that copy
 *		of xdvi to go to that position in the dvi file.  It is set by
 *		this routine and read by the displaying copy of xdvi.
 */

static	int	XdviErrorHandler P2H(Display *, XErrorEvent *);

static	unsigned long	xdvi_next_request	= 0;
static	int		xerrno;
static	int		(*XdviOldErrorHandler) ARGS((Display *, XErrorEvent *));

static	int
XdviErrorHandler(d, event)
	Display		*d;
	XErrorEvent	*event;
{
	if (event->serial != xdvi_next_request
	  || event->error_code != BadWindow)
	    return XdviOldErrorHandler(d, event);

	xerrno = 1;
	return 0;
}

static	int
XdviGetWindowProperty(display, w, property, long_offset, long_length, delete,
  req_type, actual_type_return, actual_format_return, nitems_return,
  bytes_after_return, prop_return)
	Display		*display;
	Window		w;
	Atom		property;
	long		long_offset, long_length;
	Bool		delete;
	Atom		req_type;
	Atom		*actual_type_return;
	int		*actual_format_return;
	unsigned long	*nitems_return;
	unsigned long	*bytes_after_return;
	unsigned char	**prop_return;
{
	int	retval;

	xdvi_next_request = NextRequest(display);
	xerrno = 0;

	retval = XGetWindowProperty(display, w, property, long_offset,
	  long_length, delete, req_type, actual_type_return,
	  actual_format_return, nitems_return, bytes_after_return, prop_return);

	return (xerrno != 0 ? BadWindow : retval);
}

/*
 *	src_client_check() - Check for another running copy of xdvi viewing
 *	the same file.  If one exists, return true and send that copy of xdvi
 *	the argument to -sourceposition.  If not, return false.
 */

static	Boolean
src_client_check()
{
	long		*window_list;
	size_t		window_list_len;
	long		*window_list_end;
	long		*wp;
	unsigned char	*p;
	Boolean		need_rewrite;
	Boolean		retval		= False;

	/*
	 * Get window list.  Copy it over
	 * (we'll be calling property_get_data() again).
	 */

	window_list_len = property_get_data(DefaultRootWindow(DISP),
	  ATOM_XDVI_WINDOWS, &p, XGetWindowProperty);

	if (window_list_len == 0) {
	    if (debug & DBG_CLIENT)
		puts("No \"xdvi windows\" property found");
	    return False;
	}

	if (window_list_len % sizeof(long) != 0) {
	    if (debug & DBG_CLIENT)
		puts(
		  "\"xdvi windows\" property had incorrect size; deleting it.");
	    XDeleteProperty(DISP, DefaultRootWindow(DISP), ATOM_XDVI_WINDOWS);
	    return False;
	}

	window_list = xmalloc(window_list_len);
	memcpy(window_list, p, window_list_len);

	XdviOldErrorHandler = XSetErrorHandler(XdviErrorHandler);

	/* Loop over list of windows.  */

	need_rewrite = False;
	window_list_len /= sizeof(long);
	window_list_end = window_list + window_list_len;
	for (wp = window_list; wp < window_list_end; ++wp) {
	    Window w = *wp;
	    unsigned char *buf_ret;
	    size_t len;

	    if (debug & DBG_CLIENT) {
		printf("Checking window %08lx -- ", w);
		fflush(stdout);
	    }

	    len = property_get_data(w, ATOM_DVI_FILE, &buf_ret,
	      XdviGetWindowProperty);

	    if (len == 0) {
		if (debug & DBG_CLIENT)
		    puts("(null)");
		--window_list_len;
		--window_list_end;
		memcpy(wp, wp + 1, (window_list_end - wp) * sizeof(long));
		--wp;
		need_rewrite = True;
		continue;
	    }

	    if (debug & DBG_CLIENT) {
		unsigned long ino;
		int i;

		ino = 0;
		for (i = 7; i >= 0; --i)
		    ino = (ino << 8) | buf_ret[i];
		printf("%lu `%s'\n", ino, buf_ret + 8);
	    }

	    if (len == dvi_property_length
	      && memcmp(buf_ret, dvi_property, len) == 0) {

		if (debug & DBG_CLIENT)
		    puts("Matched!");

		XChangeProperty(DISP, w,
		  ATOM_SRC_GOTO, ATOM_SRC_GOTO, 8, PropModeReplace,
		  (_Xconst unsigned char *) resource.src_pos,
		  strlen(resource.src_pos));

		retval = True;
		break;
	    }
	}

	(void) XSetErrorHandler(XdviOldErrorHandler);

	if (need_rewrite)
	    XChangeProperty(DISP, DefaultRootWindow(DISP),
	      ATOM_XDVI_WINDOWS, ATOM_XDVI_WINDOWS, 32, PropModeReplace,
	      (unsigned char *) window_list, window_list_len);

	return retval;
}


/*
 *	Translations of valid paper types to dimensions, which are used
 *	internally.
 */

static	_Xconst	char	*paper_types[] = {
	"letter",	"8.5x11in",
	"letterr",	"11x8.5in",
	"us",		"8.5x11in",
	"usr",		"11x8.5in",
	"legal",	"8.5x14in",
	"legalr",	"14x8.5in",
	"foolscap",	"13.5x17.0in",	/* ??? */
	"foolscapr",	"17x13.5in",
	NULL,		NULL,		/* hack used for formatting the list */

	/* ISO `A' formats, Portrait */
	"a1",		"594x841mm",
	"a2",		"420x594mm",
	"a3",		"297x420mm",
	"a4",		"210x297mm",
	"a5",		"148x210mm",
	"a6",		"105x148mm",
	"a7",		"74x105mm",
	NULL,		NULL,

	/* ISO `A' formats, Landscape */
	"a1r",		"840x594mm",
	"a2r",		"594x420mm",
	"a3r",		"420x297mm",
	"a4r",		"297x210mm",
	"a5r",		"210x148mm",
	"a6r",		"148x105mm",
	"a7r",		"105x74mm",
	NULL,		NULL,

	/* ISO `B' formats, Portrait */
	"b1",		"707x1000mm",
	"b2",		"500x707mm",
	"b3",		"353x500mm",
	"b4",		"250x353mm",
	"b5",		"176x250mm",
	"b6",		"125x176mm",
	"b7",		"88x125mm",
	NULL,		NULL,

	/* ISO `B' formats, Landscape */
	"b1r",		"1000x707mm",
	"b2r",		"707x500mm",
	"b3r",		"500x353mm",
	"b4r",		"353x250mm",
	"b5r",		"250x176mm",
	"b6r",		"176x125mm",
	"b7r",		"125x88mm",
	NULL,		NULL,

	/* ISO `C' formats, Portrait */
	"c1",		"648x917mm",
	"c2",		"458x648mm",
	"c3",		"324x458mm",
	"c4",		"229x324mm",
	"c5",		"162x229mm",
	"c6",		"114x162mm",
	"c7",		"81x114mm",
	NULL,		NULL,

	/* ISO `C' formats, Landscape */
	"c1r",		"917x648mm",
	"c2r",		"648x458mm",
	"c3r",		"458x324mm",
	"c4r",		"324x229mm",
	"c5r",		"229x162mm",
	"c6r",		"162x114mm",
	"c7r",		"114x81mm",
};

static	Boolean
set_paper_type() {
	_Xconst	char	*arg, *arg1;
	char	temp[21];
	_Xconst	char	**p;
	char	*q;

	arg = resource.paper;
	if (*arg == '+') {
	    ++arg;
	    ignore_papersize_specials = True;
	}
	if (strlen(arg) > sizeof(temp) - 1) return False;
	q = temp;
	for (;;) {	/* convert to lower case */
	    char c = *arg++;
	    if (c >= 'A' && c <= 'Z') c ^= ('a' ^ 'A');
	    *q++ = c;
	    if (c == '\0') break;
	}
	arg = temp;
	/* perform substitutions */
	for (p = paper_types; p < paper_types + XtNumber(paper_types); p += 2)
	    if (*p != NULL && strcmp(temp, *p) == 0) {
		arg = p[1];
		break;
	    }
	arg1 = index(arg, 'x');
	if (arg1 == NULL) return False;
	unshrunk_paper_w = atopix(arg, False);
	unshrunk_paper_h = atopix(arg1 + 1, False);
	return (unshrunk_paper_w != 0 && unshrunk_paper_h != 0);
}


#if EXTRA_APP_DEFAULTS

/*
 *	Information on how to search for miscellaneous text files.
 */

#include "filf-app.h"		/* application-related defs, etc. */
#include "filefind.h"

static	_Xconst	char	no_f_str_text[]	= "/%f";

static	struct findrec			search_text	= {
	/* path1	*/	NULL,
#if CFGFILE
	/* envptr	*/	NULL,
#endif
	/* path2	*/	".:%S",
	/* type		*/	"miscellaneous text",
	/* fF_etc	*/	"fF",
	/* x_var_char	*/	'f',
	/* n_var_opts	*/	2,
	/* no_f_str	*/	no_f_str_text,
	/* no_f_str_end	*/	no_f_str_text + sizeof(no_f_str_text) - 1,
	/* abs_str	*/	"%f",
#if USE_GF
	/* no_f_str_flags */	F_FILE_USED,
	/* abs_str_flags */	F_FILE_USED,
	/* pk_opt_char	*/	'f',
	/* pk_gf_addr	*/	NULL,
#endif
	/* pct_s_str	*/	":xdvi:web2c",
	{
	  /* v.stephead		*/	NULL,
	  /* v.pct_s_head	*/	NULL,
	  /* v.pct_s_count	*/	0,
	  /* v.pct_s_atom	*/	NULL,
	  /* v.rootp		*/	NULL,
	}
};

#endif /* EXTRA_APP_DEFAULTS */


#if TOOLKIT

struct modifierinf {
	int		len;
	_Xconst char	*name;
	Modifiers	mask;
	KeySym		keysym;
};

/* Allowed modifiers, sorted by length and then lexicographically.  */

static	struct modifierinf	modifiers[] = {
	{1,	"a",		0,		XK_Alt_L},
	{1,	"c",		ControlMask,	0},
	{1,	"h",		0,		XK_Hyper_L},
	{1,	"l",		LockMask,	0},
	{1,	"m",		0,		XK_Meta_L},
	{1,	"s",		ShiftMask,	0},
	{2,	"su",		0,		XK_Super_L},
	{3,	"Alt",		0,		XK_Alt_L},
	{4,	"Ctrl",		ControlMask,	0},
	{4,	"Lock",		LockMask,	0},
	{4,	"Meta",		0,		XK_Meta_L},
	{4,	"Mod1",		Mod1Mask,	0},
	{4,	"Mod2",		Mod2Mask,	0},
	{4,	"Mod3",		Mod3Mask,	0},
	{4,	"Mod4",		Mod4Mask,	0},
	{4,	"Mod5",		Mod5Mask,	0},
	{5,	"Hyper",	0,		XK_Hyper_L},
	{5,	"Shift",	ShiftMask,	0},
	{5,	"Super",	0,		XK_Super_L},
	{7,	"Button1",	Button1Mask,	0},
	{7,	"Button2",	Button2Mask,	0},
	{7,	"Button3",	Button3Mask,	0},
	{7,	"Button4",	Button4Mask,	0},
	{7,	"Button5",	Button5Mask,	0},
};

#define	MODSCTRLINDEX	1	/* index of "c" in the above array */
#define	MODSMETAINDEX	4	/* index of "m" */


static Bool
compile_modifiers(pp, wactp)
	_Xconst char		**pp;
	struct wheel_acts	*wactp;
{
	_Xconst char		*p = *pp;
	_Xconst char		*p1;
	Bool			exclusive = False;
	LateBindingsPtr		latep = NULL;
	int			nlate;

	while (*p == ' ' || *p == '\t') ++p;

	p1 = p;
	while ((*p1 | ('a' ^ 'A')) >= 'a' && (*p1 | ('a' ^ 'A')) <= 'z')
	    ++p1;

	if (p1 - p == 3 && memcmp(p, "Any", 3) == 0) {
	    wactp->mask = wactp->value = 0;
	    p = p1;
	    while (*p == ' ' || *p == '\t') ++p;
	    if (*p != '<')
		return False;
	}
	else if (p1 - p == 4 && memcmp(p, "None", 4) == 0) {
	    wactp->mask = ~0;
	    wactp->value = 0;
	    p = p1;
	    while (*p == ' ' || *p == '\t') ++p;
	    if (*p != '<')
		return False;
	}
	else {
	    if (*p == '!') {
		exclusive = True;
		do {
		    ++p;
		} while (*p == ' ' || *p == '\t');
	    }

	    for (;;) {
		Bool	negated = False;
		struct modifierinf *mp;

		if (*p == '<')
		    break;

		if (*p == '~') {
		    negated = True;
		    ++p;
		}

		if (*p == '^') {
		    mp = &modifiers[MODSCTRLINDEX];
		    ++p;
		}
		else if (*p == '$') {
		    mp = &modifiers[MODSMETAINDEX];
		    ++p;
		}
		else {
		    int min, max;

		    p1 = p;
		    while (((*p | ('a' ^ 'A')) >= 'a'
		      && (*p | ('a' ^ 'A')) <= 'z')
		      || (*p >= '0' && *p <= '9'))
			++p;

		    /* do binary search */
		    min = -1;
		    max = XtNumber(modifiers);
		    for (;;) {
			int i, diff;

			i = (min + max) / 2;
			if (i == min)
			    return False;	/* if not found */
			mp = &modifiers[i];

			diff = (p - p1) - mp->len;
			if (diff == 0)
			    diff = memcmp(p1, mp->name, p - p1);

			if (diff == 0)
			    break;
			if (diff > 0) min = i;
			else max = i;
		    }
		}
		if (mp->mask) {
		    wactp->mask |= mp->mask;
		    if (!negated) wactp->value |= mp->mask;
		}
		else {
		    LateBindingsPtr lp1;

		    if (latep == NULL) {
			nlate = 3;
			latep = xmalloc(3 * sizeof(LateBindings));
			latep->ref_count = 1;
		    }
		    else {
			nlate += 2;
			latep = xrealloc(latep, nlate * sizeof(LateBindings));
		    }
		    lp1 = &latep[nlate - 3];
		    lp1->knot = lp1[1].knot = negated;
		    lp1->pair = True;
		    lp1->keysym = mp->keysym;
		    ++lp1;
		    lp1->pair = False;
		    lp1->ref_count = 0;
		    lp1->keysym = mp->keysym + 1;
		    ++lp1;
		    lp1->knot = lp1->pair = False;
		    lp1->ref_count = 0;
		    lp1->keysym = 0;
		}

		while (*p == ' ' || *p == '\t') ++p;
	    }
	}

	wactp->late_bindings = latep;
	*pp = p;

	return True;
}

static Bool
compile_evtype(pp, buttonp)
	_Xconst char		**pp;
	unsigned int		*buttonp;
{
	_Xconst char		*p = *pp;
	_Xconst char		*p0;

	++p;	/* already assumed to be '<' */
	while (*p == ' ' || *p == '\t') ++p;

	p0 = p;
	while (((*p | ('a' ^ 'A')) >= 'a' && (*p | ('a' ^ 'A')) <= 'z')
	  && p - p0 < 3)
	    ++p;

	if (p - p0 != 3 || memcmp(p0, "Btn", 3) != 0)
	    return False;

	if (*p >= '1' && *p <= '9') {
	    unsigned int n = *p - '0';

	    while (*++p >= '0' && *p <= '9')
		n = n * 10 + (*p - '0');

	    *buttonp = n;
	}

	p0 = p;
	while (((*p | ('a' ^ 'A')) >= 'a' && (*p | ('a' ^ 'A')) <= 'z'))
	    ++p;

	if (p - p0 != 4 || memcmp(p0, "Down", 4) != 0)
	    return False;

	while (*p == ' ' || *p == '\t') ++p;

	if (*p++ != '>')
	    return False;

	while (*p == ' ' || *p == '\t') ++p;

	if (*p++ != ':')
	    return False;

	*pp = p;

	return True;
}

static void
compile_wheel_actions()
{
	struct wheel_acts	**wactpp;
	struct wheel_acts	*wactp;
	_Xconst char		*p = resource.wheel_translations;
	_Xconst char		*p_end = p + strlen(p);
	struct wheel_acts	wact;

	wactpp = &wheel_actions;

	for (;;) {
	    while (*p == ' ' || *p == '\t') ++p;

	    if (*p == '\n') continue;
	    if (*p == '\0') break;

	    wact.mask = wact.value = 0;
	    wact.button = 0;

	    if (!compile_modifiers(&p, &wact)
	      || !compile_evtype(&p, &wact.button))
		fprintf(stderr, "%s: syntax error in wheel translations\n",
		  prog);
	    else if (compile_action(p, &wact.action) || wact.action != NULL) {
		wactp = xmalloc(sizeof(struct wheel_acts));
		*wactp = wact;

		*wactpp = wactp;
		wactpp = &wactp->next;
	    }

	    p = memchr(p, '\n', p_end - p);
	    if (p == NULL) break;
	    ++p;
	}

	*wactpp = NULL;
}

#endif /* TOOLKIT */


/*
 *	main program
 */

int
main(argc, argv)
	int argc;
	char **argv;
{

#ifndef	TOOLKIT
	XSizeHints	size_hints;
	XWMHints	wmhints;
	int		flag;
	int		x_thick	= 0;
	int		y_thick	= 0;
#endif	/* TOOLKIT */
#ifdef MOTIF
	Widget		menubar;
	Widget		scale_menu;
#endif
	Dimension	screen_w, screen_h;
	int		i;

	/*
	 *	Step 1:  Process command-line options and resources.
	 */

#ifndef	VMS
	prog = rindex(*argv, '/');
#else
	prog = rindex(*argv, ']');
#endif
	if (prog != NULL) ++prog; else prog = *argv;

#ifdef	VMS
	if (index(prog, '.') != NULL) *index(prog, '.') = '\0';
#endif

#if SELFAUTO
	argv0 = argv[0];
#endif

#if TOOLKIT

	top_level = XtInitialize(prog, "XDvi", options, XtNumber(options),
	  &argc, argv);
	XtAddActions(Actions, num_actions);

	while (--argc > 0) {
	    char *current_arg = *++argv;

	    if (*current_arg == '+')
		if (curr_page != NULL)
		    usage("More than one page-number argument given.");
		else curr_page = current_arg + 1;
	    else if (dvi_name != NULL)
		    usage("More than one dvi file name given, \
or invalid argument:\n\t\"%s\", \"%s\".",
		      dvi_name, current_arg);
		else dvi_name = current_arg;
	}

	DISP = XtDisplay(top_level);
	SCRN = XtScreen(top_level);

#if GREY
	XtSetTypeConverter(XtRString, XtRBool3, XdviCvtStringToBool3,
	  NULL, 0, XtCacheNone, NULL);
#endif

#if XAW
	accels_cr = XtParseAcceleratorTable(
	  "<Key>Return:set()notify()unset()");
	accels_cr_click = XtParseAcceleratorTable(
	  "<Key>Return:set()notify()unset()\n\
<Btn1Down>:set()\n\
<Btn1Up>:notify()unset()");
#endif

#if EXTRA_APP_DEFAULTS
	/* get resource.progname and resource.debug_arg */
	XtGetApplicationResources(top_level, (XtPointer) &resource,
	  pre_app_resources, XtNumber(pre_app_resources), (ArgList) NULL, 0);

	if (resource.progname != NULL)
	    prog = resource.progname;
	if (resource.debug_arg != NULL)
	    debug = isdigit(*resource.debug_arg) ? atoi(resource.debug_arg)
		: DBG_ALL;

	readconfig();

	search_text.path1 = getenv("XDVIINPUTS");
	search_text.envptr = ffgetenv("XDVIINPUTS");
	/* clear it if it's a getenv() placeholder */
	if (search_text.envptr != NULL && search_text.envptr->value == NULL)
	    search_text.envptr = NULL;

	{
	    FILE *f;
	    _Xconst char *path;
	    XrmDatabase db;

	    f = filefind("XDvi", &search_text, &path);
	    if (f != NULL) {
		fclose(f);	/* too early to worry about n_files_left */
		db = XtScreenDatabase(SCRN);
		(void) XrmCombineFileDatabase(path, &db, False);
		free((char *) path);
	    }
	}
#endif /* EXTRA_APP_DEFAULTS */

	{
	    XrmDatabase db = XtScreenDatabase(SCRN);

	    /* It's easier to do this than track creations and deletions of the
	       scrollbars.  */
	    XrmPutStringResource(&db,
	      "XDvi.file.form.vport.vertical.translations",
	      "#override<Btn4Down>:file-scroll(-w)\n<Btn5Down>:file-scroll(w)");
	    XrmPutStringResource(&db,
	      "XDvi.file.form.vport.horizontal.translations",
	      "#override<Btn4Down>:file-scroll(-w)\n<Btn5Down>:file-scroll(w)");
	}

	XtGetApplicationResources(top_level, (XtPointer) &resource,
	  application_resources, XtNumber(application_resources),
	  (ArgList) NULL, 0);
	shrink_factor = resource.shrinkfactor;

#if CFGFILE && !EXTRA_APP_DEFAULTS
	if (resource.progname != NULL)
	    prog = resource.progname;
#endif

#else	/* not TOOLKIT */

	parse_options(argc, argv);

#endif /* not TOOLKIT */

	if (resource.version_flag) {
	    Printf("xdvi version %s\n", VERSION);
	    exit(0);
	}

#if !EXTRA_APP_DEFAULTS
	if (resource.debug_arg != NULL)
	    debug = isdigit(*resource.debug_arg) ? atoi(resource.debug_arg)
		: DBG_ALL;
#endif

	/* Check early for whether to pass off to a different xdvi process
	 * (-sourceposition argument for reverse source special lookup).  */

#if XlibSpecificationRelease >= 6
	if (!XInternAtoms(DISP, atom_names, XtNumber(atom_names), False, atoms))
#else
	if ((atoms[0] = XInternAtom(DISP, atom_names[0], False)) == None
	  || (atoms[1] = XInternAtom(DISP, atom_names[1], False)) == None
	  || (atoms[2] = XInternAtom(DISP, atom_names[2], False)) == None
# if TOOLKIT
	  || (atoms[3] = XInternAtom(DISP, atom_names[3], False)) == None
# endif
# if XAW
	  || (atoms[4] = XInternAtom(DISP, atom_names[4], False)) == None
# endif
	  )
#endif
	    oops("XInternAtoms failed.");

	if (debug & DBG_CLIENT) {
	    for (i = 0; i < XtNumber(atom_names); ++i)
		printf("Atom(%s) = %lu\n", atom_names[i], atoms[i]);
	}

#if GREY
	our_depth = DefaultDepthOfScreen(SCRN);
	our_visual = DefaultVisualOfScreen(SCRN);
	our_colormap = DefaultColormapOfScreen(SCRN);

	if (resource.install != False && our_visual->class == PseudoColor) {
	    /* look for a TrueColor visual with more bits */
	    XVisualInfo	template;
	    XVisualInfo	*list;
	    int		nitems_return;

	    template.screen = XScreenNumberOfScreen(SCRN);
	    template.class = TrueColor;
	    list = XGetVisualInfo(DISP, VisualScreenMask | VisualClassMask,
	      &template, &nitems_return);
	    if (list != NULL) {
		XVisualInfo	*list1;
		XVisualInfo	*best	= NULL;

		for (list1 = list; list1 < list + nitems_return; ++list1)
		    if (list1->depth > our_depth
# if PS_GS
		      /* Not all depths are supported by ghostscript; see
		       * xdev->vinfo->depth in gdevxcmp.c (ghostscript-6.51).
		       * SGI supports additional depths of 12 and 30. */
		      && (list1->depth == 1 || list1->depth == 2
			|| list1->depth == 4 || list1->depth == 8
			|| list1->depth == 15 || list1->depth == 16
			|| list1->depth == 24 || list1->depth == 32)
# endif
		      && (best == NULL || list1->depth > best->depth))
			best = list1;
		if (best != NULL) {
		    our_depth = best->depth;
		    our_visual = best->visual;
		    our_colormap = XCreateColormap(DISP,
		      RootWindowOfScreen(SCRN), our_visual, AllocNone);
		    XInstallColormap(DISP, our_colormap);
# if TOOLKIT
		    temp_args1[0].value = (XtArgVal) our_depth;
		    temp_args1[1].value = (XtArgVal) our_visual;
		    temp_args1[2].value = (XtArgVal) our_colormap;
		    XtSetValues(top_level, temp_args1, XtNumber(temp_args1));
		    XtSetTypeConverter(XtRString, XtRPixel,
		      XdviCvtStringToPixel,
		      (XtConvertArgList) colorConvertArgs, 2,
		      XtCacheByDisplay, NULL);
		    {
			/* This is needed so that popup windows have the right
			   visual and colormap.  It is unnecessary for newer
			   versions of Motif (Motif 2.1.0, Solaris 9) but
			   needed for older versions (Motif 1.2.5, Solaris 2.6).
			   It is also needed for all versions of Xaw.  */

			XrmDatabase	db = XtScreenDatabase(SCRN);
			XrmValue	val;

			val.size = sizeof our_visual;
			val.addr = (XtPointer) &our_visual;
			XrmPutResource(&db, "XDvi*visual", XtRVisual, &val);

			val.size = sizeof our_colormap;
			val.addr = (XtPointer) &our_colormap;
			XrmPutResource(&db, "XDvi*colormap", XtRColormap, &val);
		    }
# else
		    /* Can't use {Black,White}PixelOfScreen() any more */
		    if (!resource.fore_color)
			resource.fore_color =
			  (resource.reverse ? "white" : "black");
		    if (!resource.back_color)
			resource.back_color =
			  (resource.reverse ? "black" : "white");
# endif
		}
		XFree(list);
	    }
	}

	if (resource.install == True && our_visual->class == PseudoColor) {
	    XColor tmp_color;

	    /* This next bit makes sure that the standard black and white pixels
	       are allocated in the new colormap. */

	    tmp_color.pixel = BlackPixelOfScreen(SCRN);
	    XQueryColor(DISP, our_colormap, &tmp_color);
	    XAllocColor(DISP, our_colormap, &tmp_color);

	    tmp_color.pixel = WhitePixelOfScreen(SCRN);
	    XQueryColor(DISP, our_colormap, &tmp_color);
	    XAllocColor(DISP, our_colormap, &tmp_color);

	    our_colormap = XCopyColormapAndFree(DISP, our_colormap);
# if TOOLKIT
	    temp_args1a[0].value = (XtArgVal) our_colormap;
	    XtSetValues(top_level, temp_args1a, 1);
# endif
	}

#endif /* GREY */

	enable_intr();

	if (dvi_name == NULL) {
#if TOOLKIT
	    postpone_popups = False;
	    Act_open_dvi_file(NULL, NULL, NULL, 0);
	    (void) read_events(EV_GE_NEWDOC);
	    ev_flags &= ~EV_NEWDOC;
	    postpone_popups = True;
#else
	    usage("You must give a dvi file name.");
#endif
	}
	else {
	    char	*new_name;
	    size_t	n;

	    n = strlen(dvi_name);

	    /*
	     * Try foo.dvi before foo, in case there's an executable foo with
	     * documentation foo.tex.  Unless it already ends with ".dvi".
	     */

	    if (n < 4 || memcmp(dvi_name + n - 4, ".dvi", 4) != 0) {
		new_name = xmalloc(n + 5);
		memcpy(new_name, dvi_name, n);
		memcpy(new_name + n, ".dvi", 5);
		if (open_dvi_file(new_name))	/* if found */
		    dvi_name = new_name;
		else
		    free(new_name);
	    }

	    /* Then try `foo', in case the user likes DVI files without `.dvi'
	       (or if `foo' already included .dvi).  */

	    if (dvi_file == NULL) {
		if (!open_dvi_file(dvi_name)) {
		    perror(dvi_name);
		    return 1;
		}
		dvi_name = xstrdup(dvi_name);
	    }
	}

	if (resource.src_pos != NULL) {
	    if (src_client_check()) {
		XFlush(DISP);	/* necessary to get the property set */
		return 0;
	    }
	    else if (resource.src_fork) {
		/*
		 * No suitable xdvi found, so we start one by
		 * self-backgrounding.
		 */
		Fflush(stdout);	/* these avoid double buffering */
		Fflush(stderr);
		XFlush(DISP);
		if (fork())	/* if initial process (do NOT use vfork()!) */
		    return 0;
		/* Need to adjust for changed process ID */
		prep_fd(ConnectionNumber(DISP), False);
	    }
	}

	/* Needed for source specials and for calling ghostscript */
	xputenv("DISPLAY", XDisplayString(DISP));

	if (resource.mfmode != NULL) {
	    char *p;

	    p = rindex(resource.mfmode, ':');
	    if (p != NULL) {
		unsigned int	len;
		char		*p1;

		++p;
		len = p - resource.mfmode;
		p1 = xmalloc(len);
		bcopy(resource.mfmode, p1, len - 1);
		p1[len - 1] = '\0';
		resource.mfmode = p1;
		pixels_per_inch = atoi(p);
	    }
	}
	if (shrink_factor < 0)
	    usage("Invalid shrink factor: %d.", shrink_factor);
	if (density <= 0)
	    usage("Invalid shrink density: %d.", density);
	if (pixels_per_inch <= 0)
	    usage("Invalid dpi value: %d.", pixels_per_inch);

	if (shrink_factor > 1) {
	    bak_shrink = shrink_factor;
	    mane.shrinkfactor = shrink_factor;	/* otherwise it's 1 */
	}
	if (resource.sidemargin) home_x = atopix(resource.sidemargin, False);
	if (resource.topmargin) home_y = atopix(resource.topmargin, False);
	offset_x = resource.xoffset ? atopix(resource.xoffset, True)
	    : pixels_per_inch;
	offset_y = resource.yoffset ? atopix(resource.yoffset, True)
	    : pixels_per_inch;
	if (!set_paper_type()) {
	    _Xconst char **p;

	    Fprintf(stderr,
	      "%s: Unrecognized paper type \"%s\".  Legal values are:\n    ",
	      prog, resource.paper);
	    for (p = paper_types; p < paper_types + XtNumber(paper_types);
	      p += 2)
		if (*p == NULL) Fputs("\n    ", stderr);
		else Fprintf(stderr, " %s", *p);
	    Fputs("\n\
     (the names ending in `r' are `rotated' or `landscape' variants),\n\n\
or:  a specification `WIDTHxHEIGHT' followed by a dimension unit\n\
     (pt, pc, in, bp, cm, mm, dd, cc, or sp).\n\n\
Either of the above may be preceded by a plus sign (`+'); this causes the\n\
argument is to override any papersize specials in the dvi file.\n\n", stderr);
	    xdvi_exit(1);
	}
	for (i = 0; i < 5; ++i)
	    if (resource.mg_arg[i] != NULL) {
		char	*s;

		mg_size[i].w = mg_size[i].h = atoi(resource.mg_arg[i]);
		s = index(resource.mg_arg[i], 'x');
		if (s != NULL) {
		    mg_size[i].h = atoi(s + 1);
		    if (mg_size[i].h <= 0) mg_size[i].w = 0;
		}
	    }
#if	PS
	if (resource.safer) {
	    resource.allow_shell = False;
#ifdef	PS_GS
	    resource.gs_safer = True;
#endif
	}
#endif	/* PS */
#ifdef	PS_GS
	{
	    _Xconst char *CGMcgm = "CGMcgm";
	    _Xconst char *cgmp;

	    cgmp = index(CGMcgm, resource.gs_palette[0]);
	    if (cgmp == NULL)
		oops("Invalid value %s for gs palette option",
		    resource.gs_palette);
	    if (cgmp >= CGMcgm + 3) {
		static	char	gsp[]	= "x";

		gsp[0] = *(cgmp - 3);
		resource.gs_palette = gsp;
	    }
	}
#endif

#if CFGFILE && !EXTRA_APP_DEFAULTS
	readconfig();		/* read config file(s). */
#endif

	/*
	 *	Step 2:  Settle colormap issues.  This should be done before
	 *	other widgets are created, so that they get the right
	 *	pixel values.  (The top-level widget won't have the right
	 *	values, but I don't think that makes any difference.)
	 */

#if GREY && TOOLKIT
	XtGetApplicationResources(top_level, (XtPointer) &resource,
	  app_pixel_resources, XtNumber(app_pixel_resources),
	  (ArgList) NULL, 0);
#endif

#ifndef TOOLKIT
	fore_Pixel = (resource.fore_color
	  ? string_to_pixel(&resource.fore_color)
	  : (resource.reverse ? WhitePixelOfScreen(SCRN)
	    : BlackPixelOfScreen(SCRN)));
	back_Pixel = (resource.back_color
	  ? string_to_pixel(&resource.back_color)
	  : (resource.reverse ? BlackPixelOfScreen(SCRN)
	    : WhitePixelOfScreen(SCRN)));
	brdr_Pixel = (brdr_color ? string_to_pixel(&brdr_color) : fore_Pixel);
	hl_Pixel = (high_color ? string_to_pixel(&high_color) : fore_Pixel);
	cr_Pixel = (curs_color ? string_to_pixel(&curs_color) : fore_Pixel);
#endif	/* not TOOLKIT */

	copy = resource.copy;

#if GREY || COLOR
	fore_color_data.pixel = fore_Pixel;
	back_color_data.pixel = back_Pixel;
	XQueryColors(DISP, our_colormap, color_data, 2);
#endif

#if COLOR
	fg_initial.r = fore_color_data.red;
	fg_initial.g = fore_color_data.green;
	fg_initial.b = fore_color_data.blue;
	bg_initial.r = back_color_data.red;
	bg_initial.g = back_color_data.green;
	bg_initial.b = back_color_data.blue;
#endif

#if GREY
	if (our_depth == 1)
	    use_grey = False;

	if (use_grey && our_visual->class != TrueColor) {
	    init_plane_masks();
	    if (!copy) {
		/* Retain back_color_data.pixel for psgs.c.  */
		XColor	tmp_color;

		tmp_color = back_color_data;
		tmp_color.pixel = back_Pixel;
		XStoreColor(DISP, our_colormap, &tmp_color);
	    }
	}
#endif

	/*
	 *	Step 3:  Initialize the dvi file and set titles.
	 */

	init_font_open();
	init_dvi_file();
	if (curr_page) {
	    current_page = (*curr_page ? atoi(curr_page) : total_pages) - 1;
	    if (current_page < 0 || current_page >= total_pages)
		usage("Invalid initial page number: %d.", current_page + 1);
	}
	if (resource.prescan)
	    prescan();
	unshrunk_page_w = page_info[current_page].ww;
	unshrunk_page_h = page_info[current_page].wh;
	init_page();

	/*
	 *	Step 4:  Set initial window size.
	 *	This needs to be done before colors are assigned because if
	 *	-s 0 is specified, then we need to compute the shrink factor
	 *	(which in turn affects whether init_pix is called).
	 */

#if TOOLKIT

		/* The following code is lifted from Xterm */
	if (resource.icon_geometry != NULL) {
	    int junk;

	    (void) XGeometry(DISP, XScreenNumberOfScreen(SCRN),
	      resource.icon_geometry, "", 0, 0, 0, 0, 0,
	      (int *) &temp_args2[0].value, (int *) &temp_args2[1].value,
	      &junk, &junk);
	    XtSetValues(top_level, temp_args2, XtNumber(temp_args2));
	}
		/* Set icon pixmap */
	XtGetValues(top_level, &temp_args4, 1);
	if (icon_pm == (Pixmap) 0) {
	    temp_args4.value = (XtArgVal) (XCreateBitmapFromData(DISP,
		RootWindowOfScreen(SCRN), (_Xconst char *) xdvi_bits,
		xdvi_width, xdvi_height));
	    XtSetValues(top_level, &temp_args4, 1);
	}
	XtVaSetValues(top_level, XtNinput, True, NULL);

	{
	    XrmDatabase db;

#if XtSpecificationRelease < 5

	    db = DISP->db;

	    XrmPutStringResource(&db,
# if BUTTONS
	      "XDvi.form.translations",
# else
	      "XDvi.vport.translations",
# endif
	      base_translations);

#else /* XtSpecificationRelease >= 5 */

	    db = XtScreenDatabase(SCRN);

	    XrmPutStringResource(&db,
# if XAW
#  if BUTTONS
	      "XDvi.form.baseTranslations",
#  else
	      "XDvi.vport.baseTranslations",
#  endif
# else /* MOTIF */
#  if BUTTONS
	      "XDvi.form.vport.drawing.baseTranslations",
#  else
	      "XDvi.vport.drawing.baseTranslations",
#  endif
# endif /* MOTIF */
	      base_translations);

	    if (resource.main_translations != NULL)
		XrmPutStringResource(&db,
# if XAW
#  if BUTTONS
		  "XDvi.form.translations",
#  else
		  "XDvi.vport.translations",
#  endif
# else /* MOTIF */
#  if BUTTONS
		  "XDvi.form.vport.drawing.translations",
#  else
		  "XDvi.vport.drawing.translations",
#  endif
# endif /* MOTIF */
		  resource.main_translations);

#endif /* XtSpecificationRelease */

	    /* Notwithstanding the ampersand, XrmPutStringResource() does
	     * not change db (X11R6.4 source).  */
	}

#if BUTTONS

	form_widget = XtCreateManagedWidget("form", FORM_WIDGET_CLASS,
	  top_level, form_args, XtNumber(form_args));
#define	form_or_top	form_widget	/* for calls later on */
#define	form_or_vport	form_widget

#else /* not BUTTONS */

#define	form_or_top	top_level	/* for calls later on */
#define	form_or_vport	vport_widget

#endif /* not BUTTONS */

	vport_widget = XtCreateManagedWidget("vport", VPORT_WIDGET_CLASS,
	  form_or_top, vport_args, XtNumber(vport_args));

#ifndef MOTIF

	clip_widget = XtNameToWidget(vport_widget, "clip");

#else /* MOTIF */

	menubar = XmVaCreateSimpleMenuBar(vport_widget, "menubar",
	  XmNdepth, (XtArgVal) our_depth,
	  XmNvisual, (XtArgVal) our_visual,
	  XmNcolormap, (XtArgVal) our_colormap,
	  XmVaCASCADEBUTTON, XmCvtCTToXmString("File"), (KeySym) 0,
	  XmVaCASCADEBUTTON, XmCvtCTToXmString("Navigate"), (KeySym) 0,
	  XmVaCASCADEBUTTON, XmCvtCTToXmString("Scale"), (KeySym) 0,
	  NULL);
	XmVaCreateSimplePulldownMenu(menubar,
	  "file_pulldown", 0, file_pulldown_callback,
	  XmNtearOffModel, (XtArgVal) XmTEAR_OFF_ENABLED,
	  XmNdepth, (XtArgVal) our_depth,
	  XmNvisual, (XtArgVal) our_visual,
	  XmNcolormap, (XtArgVal) our_colormap,
	  XmVaPUSHBUTTON, XmCvtCTToXmString("Open file"),
	    (KeySym) 0, (String) 0, (XmString) 0,
	  XmVaPUSHBUTTON, XmCvtCTToXmString("Reload"),
	    (KeySym) 0, (String) 0, (XmString) 0,
	  XmVaPUSHBUTTON, XmCvtCTToXmString("Print"),
	    (KeySym) 0, (String) 0, (XmString) 0,
	  XmVaSEPARATOR,
	  XmVaPUSHBUTTON, XmCvtCTToXmString("Quit"),
	    (KeySym) 0, (String) 0, (XmString) 0,
	  NULL);
	XmVaCreateSimplePulldownMenu(menubar,
	  "navigate_pulldown", 1, navigate_pulldown_callback,
	  XmNtearOffModel, (XtArgVal) XmTEAR_OFF_ENABLED,
	  XmVaPUSHBUTTON, (XtArgVal) XmCvtCTToXmString("Page-10"),
	    (KeySym) 0, (String) 0, (XmString) 0,
	  XmVaPUSHBUTTON, (XtArgVal) XmCvtCTToXmString("Page-5"),
	    (KeySym) 0, (String) 0, (XmString) 0,
	  XmVaPUSHBUTTON, (XtArgVal) XmCvtCTToXmString("Prev"),
	    (KeySym) 0, (String) 0, (XmString) 0,
	  XmVaSEPARATOR,
	  XmVaPUSHBUTTON, (XtArgVal) XmCvtCTToXmString("Next"),
	    (KeySym) 0, (String) 0, (XmString) 0,
	  XmVaPUSHBUTTON, (XtArgVal) XmCvtCTToXmString("Page+5"),
	    (KeySym) 0, (String) 0, (XmString) 0,
	  XmVaPUSHBUTTON, (XtArgVal) XmCvtCTToXmString("Page+10"),
	    (KeySym) 0, (String) 0, (XmString) 0,
	  NULL);
	scale_menu = XmVaCreateSimplePulldownMenu(menubar,
	  "scale_pulldown", 2, scale_pulldown_callback,
	  XmNradioBehavior, (XtArgVal) True,
	  XmNtearOffModel, (XtArgVal) XmTEAR_OFF_ENABLED,
	  XmVaRADIOBUTTON, (XtArgVal) XmCvtCTToXmString("Shrink1"),
	    (KeySym) 0, (String) 0, (XmString) 0,
	  XmVaRADIOBUTTON, (XtArgVal) XmCvtCTToXmString("Shrink2"),
	    (KeySym) 0, (String) 0, (XmString) 0,
	  XmVaRADIOBUTTON, (XtArgVal) XmCvtCTToXmString("Shrink3"),
	    (KeySym) 0, (String) 0, (XmString) 0,
	  XmVaRADIOBUTTON, (XtArgVal) XmCvtCTToXmString("Shrink4"),
	    (KeySym) 0, (String) 0, (XmString) 0,
	  NULL);
	shrink_button[0] = XtNameToWidget(scale_menu, "button_0");
	shrink_button[1] = XtNameToWidget(scale_menu, "button_1");
	shrink_button[2] = XtNameToWidget(scale_menu, "button_2");
	shrink_button[3] = XtNameToWidget(scale_menu, "button_3");

	/* All of the pulldown menus have the same parent.  */
	XtAddCallback(XtParent(scale_menu), XtNpopdownCallback,
	  popdown_callback, (XtPointer) 0);

	x_bar = XtNameToWidget(vport_widget, "HorScrollBar");
	y_bar = XtNameToWidget(vport_widget, "VertScrollBar");

#endif /* MOTIF */

	draw_args[0].value = (XtArgVal) page_w;
	draw_args[1].value = (XtArgVal) page_h;
	draw_widget = XtCreateManagedWidget("drawing", DRAW_WIDGET_CLASS,
	  vport_widget, draw_args, XtNumber(draw_args));

#ifdef MOTIF
	XtVaSetValues(vport_widget, XmNworkWindow, draw_widget,
	  XmNmenuBar, menubar, NULL);
	XtManageChild(menubar);
	XtVaGetValues(vport_widget, XmNclipWindow, &clip_widget, NULL);
#endif /* MOTIF */

#if XtSpecificationRelease < 5
	if (resource.main_translations != NULL) {
	    XtTranslations	xlats;

	    xlats = XtParseTranslationTable(resource.main_translations);

	    for (;;) {	/* not really a loop */
		_Xconst char	*p1;
		_Xconst char	*p2;

		p1 = resource.main_translations;
		while (*p1 == ' ' || *p1 == '\t') ++p1;
		if (*p1 == '#') {
		    ++p1;
		    p2 = p1;
		    while (*p2 >= 'a' && *p2 <= 'z') ++p2;
		    if (p2 - p1 == 7 && memcmp(p1, "augment", 7) == 0) {
			XtAugmentTranslations(form_or_vport, xlats);
			break;
		    }
		    if (p2 - p1 == 8 && memcmp(p1, "override", 8) == 0) {
			XtOverrideTranslations(form_or_vport, xlats);
			break;
		    }
		}
		XtVaSetValues(form_or_vport, XtNtranslations, xlats, NULL);
		break;
	    }
	}
#endif /* XtSpecificationRelease */

	XtOverrideTranslations(
#if !MOTIF
				form_or_vport,
#else
				draw_widget,
#endif
						XtParseTranslationTable("\
\"0\":digit(0)\n\
\"1\":digit(1)\n\
\"2\":digit(2)\n\
\"3\":digit(3)\n\
\"4\":digit(4)\n\
\"5\":digit(5)\n\
\"6\":digit(6)\n\
\"7\":digit(7)\n\
\"8\":digit(8)\n\
\"9\":digit(9)\n\
\"-\":minus()\n\
<Motion>:motion()\n\
<BtnUp>:release()"));

	if (resource.wheel_unit != 0 && resource.wheel_translations != NULL) {
#if XAW
	    XtAugmentTranslations(form_or_vport,
	      XtParseTranslationTable("<BtnDown>:wheel-actions()"));
#else /* MOTIF */
#if !BUTTONS
	    XtTranslations wheel_trans_table;
#endif

	    wheel_trans_table
	      = XtParseTranslationTable("<BtnDown>:wheel-actions()");
	    XtAugmentTranslations(draw_widget, wheel_trans_table);
#endif /* MOTIF */

	    compile_wheel_actions();
	}

	/* set background colors of the drawing and clip widgets */
	{
	    static Arg back_args = {XtNbackground, (XtArgVal) 0};

	    back_args.value = back_Pixel;
	    XtSetValues(draw_widget, &back_args, 1);
	    XtSetValues(clip_widget, &back_args, 1);
	}

	/* determine default window size */
#if BUTTONS
	if (!resource.expert)
	    create_buttons();
#else
#define	xtra_wid	0
#endif
	{
	    XtWidgetGeometry constraints;
	    XtWidgetGeometry reply;

	    XtGetValues(top_level, &temp_args3, 1);	/* get border width */
	    screen_w = WidthOfScreen(SCRN) - 2 * bwidth - xtra_wid;
	    screen_h = HeightOfScreen(SCRN) - 2 * bwidth;
	    for (;;) {	/* actually, at most two passes */
		constraints.request_mode = reply.request_mode = 0;
		constraints.width = page_w;
		if (page_w > screen_w) {
		    constraints.request_mode = CWWidth;
		    constraints.width = screen_w;
		}
		constraints.height = page_h;
		if (page_h > screen_h) {
		    constraints.request_mode |= CWHeight;
		    constraints.height = screen_h;
		}
		if (constraints.request_mode != 0
			&& constraints.request_mode != (CWWidth | CWHeight))
		    (void) XtQueryGeometry(vport_widget, &constraints, &reply);
		if (!(reply.request_mode & CWWidth))
		    reply.width = constraints.width;
		if (reply.width >= screen_w)
		    reply.width = screen_w;
		if (!(reply.request_mode & CWHeight))
		    reply.height = constraints.height;
		if (reply.height >= screen_h)
		    reply.height = screen_h;

		/* now reply.{width,height} contain max. usable window size */

		if (shrink_factor != 0)
		    break;

		shrink_factor = ROUNDUP(unshrunk_page_w, reply.width - 2);
		i = ROUNDUP(unshrunk_page_h, reply.height - 2);
		if (i >= shrink_factor) shrink_factor = i;
		if (shrink_factor > 1) bak_shrink = shrink_factor;
		mane.shrinkfactor = shrink_factor;
		init_page();
		set_wh_args[0].value = (XtArgVal) page_w;
		set_wh_args[1].value = (XtArgVal) page_h;
		XtSetValues(draw_widget, set_wh_args, XtNumber(set_wh_args));
	    }
	    set_wh_args[0].value = (XtArgVal) (reply.width + xtra_wid);
	    set_wh_args[1].value = (XtArgVal) reply.height;
	    XtSetValues(top_level, set_wh_args, XtNumber(set_wh_args));
#ifdef	BUTTONS
	    set_wh_args[0].value -= xtra_wid;
	    XtSetValues(vport_widget, set_wh_args, XtNumber(set_wh_args));
#endif	/* BUTTONS */
	}
#ifdef MOTIF
	set_shrink_factor(mane.shrinkfactor);
#endif

#else	/* not TOOLKIT */

	screen_w = WidthOfScreen(SCRN) - 2*bwidth;
	screen_h = HeightOfScreen(SCRN) - 2*bwidth;

	size_hints.flags = PMinSize;
	size_hints.min_width = size_hints.min_height = 50;
	size_hints.x = size_hints.y = 0;

	/* compute largest possible window */
	flag = 0;
	if (geometry != NULL) {
	    flag = XParseGeometry(geometry, &size_hints.x, &size_hints.y,
	      &window_w, &window_h);
	    if (flag & (XValue | YValue))
		size_hints.flags |= USPosition;
	    if (flag & (WidthValue | HeightValue))
		size_hints.flags |= USSize;
	}
	if (!(flag & WidthValue)) window_w = screen_w;
	if (!(flag & HeightValue)) window_h = screen_h;

	if (shrink_factor == 0) {
	    /* compute best shrink factor based on window_w and window_h */
	    shrink_factor = ROUNDUP(unshrunk_page_w, window_w - 2);
	    i = ROUNDUP(unshrunk_page_h, window_h - 2);
	    if (i >= shrink_factor) shrink_factor = i;
	    if (shrink_factor > 1) bak_shrink = shrink_factor;
	    mane.shrinkfactor = shrink_factor;
	    init_page();
	}

	if (window_w < page_w) x_thick = BAR_THICK;
	if (window_h < page_h + x_thick) y_thick = BAR_THICK;
	if (!(flag & WidthValue)) {
	    window_w = page_w + y_thick;
	    if (window_w > screen_w) {
		x_thick = BAR_THICK;
		window_w = screen_w;
	    }
	    size_hints.flags |= PSize;
	}
	if (!(flag & HeightValue)) {
	    window_h = page_h + x_thick;
	    if (window_h > screen_h) window_h = screen_h;
	    size_hints.flags |= PSize;
	}

	if (flag & XNegative) size_hints.x += screen_w - window_w;
	if (flag & YNegative) size_hints.y += screen_h - window_h;

#endif	/* not TOOLKIT */

	/*
	 *	Step 5:  Realize the widgets (or windows).
	 */

#if TOOLKIT

#if BUTTONS && !MOTIF
	if (!resource.expert)
	    set_button_panel_height(set_wh_args[1].value);
#endif
#if MOTIF
	XtSetSensitive(draw_widget, TRUE);
#endif
	XtAddEventHandler(top_level, PropertyChangeMask, False,
	  handle_property_change, (XtPointer) NULL);
	XtAddEventHandler(vport_widget, StructureNotifyMask, False,
	  handle_resize, (XtPointer) NULL);
	XtAddEventHandler(draw_widget, ExposureMask, False, handle_expose,
	  (XtPointer) &mane);
	XtRealizeWidget(top_level);

#if XAW
	XSetWMProtocols(DISP, XtWindow(top_level), &XA_WM_DELETE_WINDOW, 1);
	XtAddEventHandler(top_level, NoEventMask, True, handle_messages, NULL);
# if BUTTONS
	if (!resource.expert)
	    XDefineCursor(DISP, XtWindow(panel_widget), panel_cursor);
# endif
#else /* MOTIF */
	XtVaSetValues(top_level, XmNdeleteResponse, XmDO_NOTHING, NULL);
	XmAddWMProtocolCallback(top_level, XA_WM_DELETE_WINDOW,
	  handle_wm_delete, NULL);
	XmProcessTraversal(draw_widget, XmTRAVERSE_CURRENT);
#endif

	currwin.win = mane.win = XtWindow(draw_widget);

	postpone_popups = False;
	if (n_init_popups != 0) {
	    for (i = 0; i < n_init_popups; ++i)
		do_popup(init_popups[i]);
	    free(init_popups);
	    init_popups = NULL;
	    n_init_popups = 0;
	}

	{
	    XWindowAttributes attrs;

	    (void) XGetWindowAttributes(DISP, mane.win, &attrs);
	    backing_store = attrs.backing_store;
	}

#else	/* not TOOLKIT */

	size_hints.width = window_w;
	size_hints.height = window_h;
#ifndef GREY
	top_level = XCreateSimpleWindow(DISP, RootWindowOfScreen(SCRN),
	  size_hints.x, size_hints.y, window_w, window_h, bwidth,
	  brdr_Pixel, back_Pixel);
#else
	{
	    XSetWindowAttributes attr;

	    attr.border_pixel = brdr_Pixel;
	    attr.background_pixel = back_Pixel;
	    attr.colormap = our_colormap;
	    top_level = XCreateWindow(DISP, RootWindowOfScreen(SCRN),
	      size_hints.x, size_hints.y, window_w, window_h, bwidth,
	      our_depth, InputOutput, our_visual,
	      CWBorderPixel | CWBackPixel | CWColormap, &attr);
	}
#endif
	{	/* See also set_titles() in dvi-init-c.  */
	    char	*title_name;
	    char	*icon_name;
	    size_t	baselen;
	    Boolean	icon_name_malloced = False;

	    icon_name = rindex(dvi_name, '/');
	    if (icon_name != NULL) ++icon_name;
	      else icon_name = dvi_name;
	    baselen = strlen(icon_name);
	    if (baselen > 4 && memcmp(icon_name + baselen - 4, ".dvi", 4) == 0)
	    {
		/* remove the .dvi */
		char *p;

		baselen -= 4;
		p = xmalloc(baselen + 1);
		memcpy(p, icon_name, baselen);
		p[baselen] = '\0';
		icon_name = p;
		icon_name_malloced = True;
	    }

	    title_name = xmalloc(baselen + 8);
	    memcpy(title_name, "Xdvi:  ", 7);
	    memcpy(title_name + 7, icon_name, baselen + 1);

	    XSetStandardProperties(DISP, top_level, title_name, icon_name,
	      (Pixmap) 0, argv, argc, &size_hints);

	    free(title_name);
	    if (icon_name_malloced)
		free(icon_name);
	}

	wmhints.flags = InputHint | StateHint | IconPixmapHint;
	wmhints.input = True;	/* window manager must direct input */
	wmhints.initial_state = iconic ? IconicState : NormalState;
	wmhints.icon_pixmap = XCreateBitmapFromData(DISP,
	    RootWindowOfScreen(SCRN), (_Xconst char *) xdvi_bits,
	    xdvi_width, xdvi_height);
	if (resource.icon_geometry != NULL) {
	    int junk;

	    wmhints.flags |= IconPositionHint;
	    (void) XGeometry(DISP, DefaultScreen(DISP), resource.icon_geometry,
		"", 0, 0, 0, 0, 0, &wmhints.icon_x, &wmhints.icon_y,
		&junk, &junk);
	}
	XSetWMHints(DISP, top_level, &wmhints);

	XSelectInput(DISP, top_level,
	  KeyPressMask | StructureNotifyMask | PropertyChangeMask);
	XMapWindow(DISP, top_level);
	XFlush(DISP);

	{
	    static KeySym list[2] = {XK_Caps_Lock, XK_Num_Lock};

#define	rebindkey(ks, str)	XRebindKeysym(DISP, (KeySym) ks, \
		  (KeySym *) NULL, 0, (_Xconst ubyte *) str, 1); \
		XRebindKeysym(DISP, (KeySym) ks, \
		  list, 1, (_Xconst ubyte *) str, 1); \
		XRebindKeysym(DISP, (KeySym) ks, \
		  list + 1, 1, (_Xconst ubyte *) str, 1); \
		XRebindKeysym(DISP, (KeySym) ks, \
		  list, 2, (_Xconst ubyte *) str, 1);

	    rebindkey(XK_Home, "^");
	    rebindkey(XK_Left, "l");
	    rebindkey(XK_Up, "u");
	    rebindkey(XK_Right, "r");
	    rebindkey(XK_Down, "d");
	    rebindkey(XK_Prior, "b");
	    rebindkey(XK_Next, "f");
#ifdef XK_KP_Left
	    rebindkey(XK_KP_Home, "^");
	    rebindkey(XK_KP_Left, "l");
	    rebindkey(XK_KP_Up, "u");
	    rebindkey(XK_KP_Right, "r");
	    rebindkey(XK_KP_Down, "d");
	    rebindkey(XK_KP_Prior, "b");
	    rebindkey(XK_KP_Next, "f");
	    rebindkey(XK_KP_Delete, "\177");
#endif /* def XK_KP_Left */
	}
#undef	rebindkey

#endif	/* not TOOLKIT */

	image = XCreateImage(DISP, our_visual, 1, XYBitmap, 0,
			     (char *) NULL, 0, 0, BMBITS, 0);
	image->bitmap_unit = BMBITS;
#ifdef	WORDS_BIGENDIAN
	image->bitmap_bit_order = MSBFirst;
#else
	image->bitmap_bit_order = LSBFirst;
#endif
	{
	    short endian = MSBFirst << 8 | LSBFirst;
	    image->byte_order = *((char *) &endian);
	}

	/* Store window id for use by src_client_check().  */

	{
	    long data = XtWindow(top_level);

	    XChangeProperty(DISP, DefaultRootWindow(DISP),
	      ATOM_XDVI_WINDOWS, ATOM_XDVI_WINDOWS, 32, PropModeAppend,
	      (unsigned char *) &data, 1);
	}
	set_dvi_property();

	/*
	 *	Step 6:  Assign colors and GCs.
	 *		 Because of the latter, this has to go after Step 5.
	 *		 In color mode, color changes affect foreGC, foreGC2,
	 *		 and ruleGC, but not copyGC or highGC.
	 */

#if GREY
	if (resource._gamma == 0.0)
	    resource._gamma = 1.0;
#endif

#define	MakeGC(fcn, fg, bg)	(values.function = fcn, \
	  values.foreground=fg, values.background=bg, \
	  XCreateGC(DISP, XtWindow(top_level), \
	    GCFunction | GCForeground | GCBackground, &values))

#if !COLOR

#if GREY
	if (use_grey)
	    init_pix();
	else
#endif
	{
	    XGCValues	values;
	    Pixel	set_bits = (Pixel) (fore_Pixel & ~back_Pixel);
	    Pixel	clr_bits = (Pixel) (back_Pixel & ~fore_Pixel);
	    Boolean	copy_tmp = resource.copy;

	    copyGC = MakeGC(GXcopy, fore_Pixel, back_Pixel);
	    if (copy_tmp || (set_bits && clr_bits)) {
		ruleGC = copyGC;
		if (!resource.thorough) copy_tmp = True;
	    }
	    if (copy_tmp) {
		foreGC = ruleGC;
		if (!resource.copy)
		    WARN(XmDIALOG_WARNING,
		      "Overstrike characters may be incorrect");
	    }
	    else {
		if (set_bits) foreGC = MakeGC(GXor, set_bits, 0);
		if (clr_bits || !set_bits)
		    *(foreGC ? &foreGC2 : &foreGC) =
			MakeGC(GXandInverted, clr_bits, 0);
		if (!ruleGC) ruleGC = foreGC;
	    }
	}

#endif /* !COLOR */

	{
	    XGCValues	values;

#if COLOR
	    /* Not affected by color changes.  */
	    copyGC = MakeGC(GXcopy, fore_Pixel, back_Pixel);
#endif
	    highGC = MakeGC(GXcopy, hl_Pixel, back_Pixel);
	}

#if XAW
	/*
	 * There's a bug in the Xaw toolkit, in which it uses the
	 * DefaultGCOfScreen to do vertical scrolling in the Text widget.
	 * This leads to a BadMatch error if our visual is not the default one.
	 * The following kludge works around this.
	 */

	DefaultGCOfScreen(SCRN) = copyGC;
#endif

#ifndef	VMS
	ready_cursor = XCreateFontCursor(DISP, XC_cross);
	redraw_cursor = XCreateFontCursor(DISP, XC_watch);
#else
	DECWCursorFont = XLoadFont(DISP, "DECW$CURSOR");
	XSetFont(DISP, highGC, DECWCursorFont);
	redraw_cursor = XCreateGlyphCursor(DISP, DECWCursorFont, DECWCursorFont,
		decw$c_wait_cursor, decw$c_wait_cursor + 1,
		&resource.fore_color, &resource.back_color);
	MagnifyPixmap = XCreateBitmapFromData(DISP, RootWindowOfScreen(SCRN),
		mag_glass_bits, mag_glass_width, mag_glass_height);
	ready_cursor = XCreatePixmapCursor(DISP, MagnifyPixmap, MagnifyPixmap,
		&resource.back_color, &resource.fore_color,
		mag_glass_x_hot, mag_glass_y_hot);
#endif	/* VMS */

	{
	    XColor bg_Color;
	    Pixmap arrow_pixmap, arrow_mask;

	    bg_Color.pixel = back_Pixel;
	    XQueryColor(DISP, our_colormap, &bg_Color);
	    cr_Color.pixel = cr_Pixel;
	    XQueryColor(DISP, our_colormap, &cr_Color);
#if !COLOR
	    XRecolorCursor(DISP, ready_cursor, &cr_Color, &bg_Color);
	    XRecolorCursor(DISP, redraw_cursor, &cr_Color, &bg_Color);
#endif

	    arrow_pixmap = XCreateBitmapFromData(DISP, RootWindowOfScreen(SCRN),
	      (_Xconst char *) drag_vert_bits,
	      drag_vert_width, drag_vert_height);
	    arrow_mask = XCreateBitmapFromData(DISP, RootWindowOfScreen(SCRN),
	      (_Xconst char *) drag_vert_mask,
	      drag_vert_width, drag_vert_height);
	    drag_cursor[0] = XCreatePixmapCursor(DISP, arrow_pixmap, arrow_mask,
	      &cr_Color, &bg_Color, drag_vert_x_hot, drag_vert_y_hot);
	    XFreePixmap(DISP, arrow_pixmap);
	    XFreePixmap(DISP, arrow_mask);

	    arrow_pixmap = XCreateBitmapFromData(DISP, RootWindowOfScreen(SCRN),
	      (_Xconst char *) drag_horiz_bits,
	      drag_horiz_width, drag_horiz_height);
	    arrow_mask = XCreateBitmapFromData(DISP, RootWindowOfScreen(SCRN),
	      (_Xconst char *) drag_horiz_mask,
	      drag_horiz_width, drag_horiz_height);
	    drag_cursor[1] = XCreatePixmapCursor(DISP, arrow_pixmap, arrow_mask,
	      &cr_Color, &bg_Color, drag_horiz_x_hot, drag_horiz_y_hot);
	    XFreePixmap(DISP, arrow_pixmap);
	    XFreePixmap(DISP, arrow_mask);

	    arrow_pixmap = XCreateBitmapFromData(DISP, RootWindowOfScreen(SCRN),
	      (_Xconst char *) drag_omni_bits,
	      drag_omni_width, drag_omni_height);
	    arrow_mask = XCreateBitmapFromData(DISP, RootWindowOfScreen(SCRN),
	      (_Xconst char *) drag_omni_mask,
	      drag_omni_width, drag_omni_height);
	    drag_cursor[2] = XCreatePixmapCursor(DISP, arrow_pixmap, arrow_mask,
	      &cr_Color, &bg_Color, drag_omni_x_hot, drag_omni_y_hot);
	    XFreePixmap(DISP, arrow_pixmap);
	    XFreePixmap(DISP, arrow_mask);
	}

	if (resource.src_pos != NULL) {
	    source_forward_string = resource.src_pos;
	    ev_flags |= EV_SRC;
	}

	do_pages();
	/* NOTREACHED */
}
