diff -ur autoconf-2.13/Makefile.in xautoconf-2.13/Makefile.in
--- autoconf-2.13/Makefile.in	Tue Jan  5 05:27:16 1999
+++ xautoconf-2.13/Makefile.in	Mon Feb  1 14:44:50 1999
@@ -49,7 +49,7 @@
 
 # Directory in which to install library files.
 datadir = @datadir@
-acdatadir = $(datadir)/autoconf
+acdatadir = $(datadir)/xautoconf
 
 # Directory in which to install documentation info files.
 infodir = @infodir@
@@ -178,7 +178,7 @@
 	if test -f standards.info || test -f $(srcdir)/standards.info; \
 	then cd $(infodir) && rm -f standards.info*; fi
 
-${srcdir}/configure: configure.in $(M4FILES)
+${srcdir}/configure: configure.in
 	cd $(srcdir) && \
 	rm -f configure configure.tmp && \
 	$(M4) autoconf.m4 configure.in > configure.tmp && \
diff -ur autoconf-2.13/acconfig.h xautoconf-2.13/acconfig.h
--- autoconf-2.13/acconfig.h	Tue Jan  5 05:27:26 1999
+++ xautoconf-2.13/acconfig.h	Mon Feb  1 14:45:36 1999
@@ -132,6 +132,9 @@
 /* Define if you have the wait3 system call.  */
 #undef HAVE_WAIT3
 
+/* Define if your installation of X has X11/Xosdefs.h.  */
+#undef HAVE_X11_XOSDEFS_H
+
 /* Define as __inline if that's what the C compiler calls it.  */
 #undef inline
 
diff -ur autoconf-2.13/acgeneral.m4 xautoconf-2.13/acgeneral.m4
--- autoconf-2.13/acgeneral.m4	Tue Jan  5 05:27:37 1999
+++ xautoconf-2.13/acgeneral.m4	Mon Feb  1 15:11:41 1999
@@ -169,10 +169,12 @@
 # Initialize some variables set by options.
 # The variables have the same names as the options, with
 # dashes changed to underlines.
+aux_top=NONE
 build=NONE
 cache_file=./config.cache
 exec_prefix=NONE
 host=NONE
+imake=
 no_create=
 nonopt=NONE
 no_recursion=
@@ -187,6 +189,7 @@
 verbose=
 x_includes=NONE
 x_libraries=NONE
+x_top=NONE
 dnl Installation directory options.
 dnl These are left unexpanded so users can "make install exec_prefix=/foo"
 dnl and all the variables that are supposed to be based on exec_prefix
@@ -234,6 +237,12 @@
 
   case "$ac_option" in
 
+  -aux-top | --aux-top | --aux-to | --aux-t | --aux- | --aux | --au | --a)
+    ac_prev=aux_top ;;
+  -aux-top=* | --aux-top=* | --aux-to=* | --aux-t=* | --aux-=* | --aux=* \
+  | --au=* | --a=*)
+    aux_top="$ac_optarg" ;;
+
   -bindir | --bindir | --bindi | --bind | --bin | --bi)
     ac_prev=bindir ;;
   -bindir=* | --bindir=* | --bindi=* | --bind=* | --bin=* | --bi=*)
@@ -306,12 +315,15 @@
 Configuration:
   --cache-file=FILE       cache test results in FILE
   --help                  print this message
+  --imake                 set flag for running from within imake
   --no-create             do not create output files
   --quiet, --silent       do not print \`checking...' messages
   --version               print the version of autoconf that created configure
 Directory and file names:
+  --x-top=XTOP            installation directory for X
+  --aux-top=AUXTOP        secondary X top directory (e.g., for toolkit)
   --prefix=PREFIX         install architecture-independent files in PREFIX
-                          [$ac_default_prefix]
+                          [XTOP or $ac_default_prefix]
   --exec-prefix=EPREFIX   install architecture-dependent files in EPREFIX
                           [same as prefix]
   --bindir=DIR            user executables in DIR [EPREFIX/bin]
@@ -344,8 +356,8 @@
   --enable-FEATURE[=ARG]  include FEATURE [ARG=yes]
   --with-PACKAGE[=ARG]    use PACKAGE [ARG=yes]
   --without-PACKAGE       do not use PACKAGE (same as --with-PACKAGE=no)
-  --x-includes=DIR        X include files are in DIR
-  --x-libraries=DIR       X library files are in DIR
+  --x-includes=DIR        X include files are in DIR [XTOP/include or guessed]
+  --x-libraries=DIR       X library files are in DIR [XTOP/lib or guessed]
 changequote([, ])dnl
 EOF
     if test -n "$ac_help"; then
@@ -358,6 +370,9 @@
   -host=* | --host=* | --hos=* | --ho=*)
     host="$ac_optarg" ;;
 
+  --imake | --imak | --ima | --im | -imake | -imak | -ima | -im)
+    imake=yes ;;
+
   -includedir | --includedir | --includedi | --included | --include \
   | --includ | --inclu | --incl | --inc)
     ac_prev=includedir ;;
@@ -529,10 +544,6 @@
     ac_package=`echo $ac_package| sed 's/-/_/g'`
     eval "with_${ac_package}=no" ;;
 
-  --x)
-    # Obsolete; use --with-x.
-    with_x=yes ;;
-
   -x-includes | --x-includes | --x-include | --x-includ | --x-inclu \
   | --x-incl | --x-inc | --x-in | --x-i)
     ac_prev=x_includes ;;
@@ -547,6 +558,11 @@
   | --x-librar=* | --x-libra=* | --x-libr=* | --x-lib=* | --x-li=* | --x-l=*)
     x_libraries="$ac_optarg" ;;
 
+  -x-top | --x-top | --x-to | --x-t)
+    ac_prev=x_top ;;
+  -x-top=* | --x-top=* | --x-to=* | --x-t=*)
+    x_top="$ac_optarg" ;;
+
   -*) AC_MSG_ERROR([$ac_option: invalid option; use --help to show usage])
     ;;
 
@@ -646,6 +662,9 @@
 if test "${LC_MESSAGES+set}" = set; then LC_MESSAGES=C; export LC_MESSAGES; fi
 if test "${LC_CTYPE+set}"    = set; then LC_CTYPE=C;    export LC_CTYPE;    fi
 
+# Set prefix to x-top if appropriate.
+test "x$prefix" = xNONE && prefix="$x_top"
+
 # confdefs.h avoids OS command line length limits that DEFS can exceed.
 rm -rf conftest* confdefs.h
 # AIX cpp loses on an empty file, so make sure it contains at least a newline.
@@ -705,6 +724,7 @@
 AC_SUBST(LDFLAGS)dnl
 AC_SUBST(LIBS)dnl
 AC_SUBST(exec_prefix)dnl
+AC_SUBST(x_top)dnl
 AC_SUBST(prefix)dnl
 AC_SUBST(program_transform_name)dnl
 dnl Installation directory options.
@@ -2072,6 +2092,9 @@
 # Let make expand exec_prefix.
 test "x$exec_prefix" = xNONE && exec_prefix='${prefix}'
 
+# A kludge necessary for CPPFLAGS to allow quoted args
+CPPFLAGS="`echo "$CPPFLAGS" | sed 's/\\\"/\\\\\\\"/g'`"
+
 # Any assignment to VPATH causes Sun make to only execute
 # the first set of double-colon rules, so remove it if not needed.
 # If there is a colon in the path, we need to keep it.
@@ -2232,9 +2255,15 @@
 fi
 EOF
 
+if test -n "$imake"; then
+  ac_noimake_makefile=
+else
+  ac_noimake_makefile='Makefile '
+fi
+
 cat >> $CONFIG_STATUS <<EOF
 
-CONFIG_FILES=\${CONFIG_FILES-"$1"}
+CONFIG_FILES=\${CONFIG_FILES-"$ac_noimake_makefile$1"}
 EOF
 cat >> $CONFIG_STATUS <<\EOF
 for ac_file in .. $CONFIG_FILES; do if test "x$ac_file" != x..; then
diff -ur autoconf-2.13/acspecific.m4 xautoconf-2.13/acspecific.m4
--- autoconf-2.13/acspecific.m4	Tue Jan  5 05:27:52 1999
+++ xautoconf-2.13/acspecific.m4	Mon Feb  1 15:07:16 1999
@@ -716,6 +716,18 @@
 fi])
 if test $ac_cv_header_stdc = yes; then
   AC_DEFINE(STDC_HEADERS)
+  AC_CACHE_CHECK([for X11/Xosdefs.h], ac_cv_x11_xosdefs_h,
+  [ac_cv_x11_xosdefs_h=no
+  if test -n "$x_includes"; then
+    if test -r "$x_includes/X11/Xosdefs.h"; then
+      ac_cv_x11_xosdefs_h=yes
+    fi
+  else
+    AC_TRY_CPP([#include <X11/Xosdefs.h>], ac_cv_x11_xosdefs_h=yes)
+  fi])
+  if test $ac_cv_x11_xosdefs_h = yes; then
+    AC_DEFINE(HAVE_X11_XOSDEFS_H)
+  fi
 fi
 ])
 
@@ -2299,7 +2311,6 @@
 # --without-x overrides everything else, but does not touch the cache.
 AC_MSG_CHECKING(for X)
 
-AC_ARG_WITH(x, [  --with-x                use the X Window System])
 # $have_x is `yes', `no', `disabled', or empty when we do not yet know.
 if test "x$with_x" = xno; then
   # The user explicitly disabled X.
@@ -2311,8 +2322,15 @@
   else
 AC_CACHE_VAL(ac_cv_have_x,
 [# One or both of the vars are not set, and there is no cached value.
-ac_x_includes=NO ac_x_libraries=NO
-AC_PATH_X_XMKMF
+if test "x$x_top" != xNONE; then
+  ac_x_includes="$x_top/include" ac_x_libraries="$x_top/lib"
+  if test ! -f "$ac_x_includes/X11/Xos.h" || test ! -d "$ac_x_libraries"; then
+    AC_MSG_ERROR($x_top does not point to a valid X install tree)
+  fi
+else
+  ac_x_includes=NO ac_x_libraries=NO
+  AC_PATH_X_XMKMF
+fi
 AC_PATH_X_DIRECT
 if test "$ac_x_includes" = NO || test "$ac_x_libraries" = NO; then
   # Didn't find X anywhere.  Cache the known absence of X.
@@ -2502,11 +2520,14 @@
 dnl Find additional X libraries, magic flags, etc.
 AC_DEFUN(AC_PATH_XTRA,
 [AC_REQUIRE([AC_PATH_X])dnl
-if test "$no_x" = yes; then
-  # Not all programs may use this symbol, but it does not hurt to define it.
-  AC_DEFINE(X_DISPLAY_MISSING)
+if test "$no_x" = yes || test -n "$imake"; then
   X_CFLAGS= X_PRE_LIBS= X_LIBS= X_EXTRA_LIBS=
 else
+  if test "x$aux_top" != xNONE; then
+    X_CFLAGS="$X_CFLAGS -I$aux_top/include"
+    X_LIBS="$X_LIBS -L$aux_top/lib"
+  fi
+
   if test -n "$x_includes"; then
     X_CFLAGS="$X_CFLAGS -I$x_includes"
   fi
@@ -2524,12 +2545,18 @@
       AC_TRY_LINK(, , ac_R_nospace=yes, ac_R_nospace=no)
       if test $ac_R_nospace = yes; then
 	AC_MSG_RESULT(no)
+	if test "x$aux_top" != xNONE; then
+	  X_LIBS="$X_LIBS -R$aux_top/lib"
+	fi
 	X_LIBS="$X_LIBS -R$x_libraries"
       else
 	LIBS="$ac_xsave_LIBS -R $x_libraries"
 	AC_TRY_LINK(, , ac_R_space=yes, ac_R_space=no)
 	if test $ac_R_space = yes; then
 	  AC_MSG_RESULT(yes)
+	  if test "x$aux_top" != xNONE; then
+	    X_LIBS="$X_LIBS -R $aux_top/lib"
+	  fi
 	  X_LIBS="$X_LIBS -R $x_libraries"
 	else
 	  AC_MSG_RESULT(neither works)
@@ -2611,6 +2638,13 @@
 AC_SUBST(X_LIBS)dnl
 AC_SUBST(X_EXTRA_LIBS)dnl
 ])
+
+dnl Require the program to be compiled with X.
+AC_DEFUN(AC_REQUIRE_X,
+[AC_REQUIRE([AC_PATH_X])dnl
+if test "x$have_x" != xyes; then
+  AC_MSG_ERROR(this program cannot be compiled without X)
+fi])
 
 dnl The old Cygwin32 macro is deprecated.
 AC_DEFUN(AC_CYGWIN32,
