/*========================================================================*\

Copyright (c) 1990-2004  Paul Vojta

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL PAUL VOJTA OR ANY OTHER AUTHOR OF OR CONTRIBUTOR TO
THIS SOFTWARE BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
IN THE SOFTWARE.

NOTE:
	xdvi is based on prior work, as noted in the modification history
	in xdvi.c.

\*========================================================================*/

#include "xdvi.h"
#include <ctype.h>

/* Xlib and Xutil are already included */

#ifdef	TOOLKIT

#ifdef	OLD_X11_TOOLKIT
#include <X11/Atoms.h>
#else /* not OLD_X11_TOOLKIT */
#include <X11/Xatom.h>
#include <X11/StringDefs.h>
#endif /* not OLD_X11_TOOLKIT */

#include <X11/Shell.h>	/* needed for def. of XtNiconX */

#if	XtSpecificationRelease >= 4

#if XAW
# if XAW3D
#  include <X11/Xaw3d/Viewport.h>
# else
#  include <X11/Xaw/Viewport.h>
# endif
# include <X11/cursorfont.h>
#else /* MOTIF */
#include <Xm/MainW.h>
#include <Xm/ToggleB.h>
#include <Xm/RowColumn.h>
#include <Xm/MenuShell.h>
#endif /* MOTIF */

#ifdef	BUTTONS
#if XAW
# if XAW3D
#  include <X11/Xaw3d/Command.h>
# else
#  include <X11/Xaw/Command.h>
# endif
#define	PANEL_WIDGET_CLASS	compositeWidgetClass
#define	BUTTON_WIDGET_CLASS	commandWidgetClass
#else /* MOTIF */
#include <Xm/Form.h>
#include <Xm/BulletinB.h>
#include <Xm/PushB.h>
#define	PANEL_WIDGET_CLASS	xmBulletinBoardWidgetClass
#define	BUTTON_WIDGET_CLASS	xmPushButtonWidgetClass
#endif /* MOTIF */
#endif /* BUTTONS */

#else	/* XtSpecificationRelease < 4 */

#if NeedFunctionPrototypes
typedef	void	*XtPointer;
#else
typedef	char	*XtPointer;
#endif

#include <X11/Viewport.h>
#ifdef	BUTTONS
#include <X11/Command.h>
#define	PANEL_WIDGET_CLASS	compositeWidgetClass
#define	BUTTON_WIDGET_CLASS	commandWidgetClass
#endif

#endif	/* XtSpecificationRelease */

#else	/* not TOOLKIT */

typedef	int		Position;
#define	XtPending()	XPending(DISP)

#endif	/* not TOOLKIT */

#if HAVE_XKB_BELL_EXT
# include <X11/XKBlib.h>
# define XBell(dpy, percent) XkbBell(dpy, mane.win, percent, (Atom) None)
#endif

#include <signal.h>
#include <sys/file.h>	/* this defines FASYNC */
#include <sys/ioctl.h>	/* this defines SIOCSPGRP and FIOASYNC */
#include <sys/wait.h>	/* ignore HAVE_SYS_WAIT_H -- we always need WNOHANG */

/* Linux prefers O_ASYNC over FASYNC; SGI IRIX does the opposite.  */
#if !defined(FASYNC) && defined(O_ASYNC)
#define	FASYNC	O_ASYNC
#endif

#if !defined(FLAKY_SIGPOLL) && !HAVE_STREAMS && !defined(FASYNC)
#if !defined(SIOCSPGRP) || !defined(FIOASYNC)
#define	FLAKY_SIGPOLL	1
#endif
#endif

#ifndef FLAKY_SIGPOLL

#ifndef SIGPOLL
#define	SIGPOLL	SIGIO
#endif

#ifndef SA_RESTART
#define SA_RESTART 0
#endif

#if HAVE_STREAMS
#include <stropts.h>

#ifndef S_RDNORM
#define	S_RDNORM S_INPUT
#endif

#ifndef S_RDBAND
#define	S_RDBAND 0
#endif

#ifndef S_HANGUP
#define	S_HANGUP 0
#endif

#ifndef S_WRNORM
#define	S_WRNORM S_OUTPUT
#endif
#endif /* HAVE_STREAMS */

#endif /* not FLAKY_SIGPOLL */

#if HAVE_SIGACTION && !defined SA_RESETHAND
# ifdef SA_ONESHOT
#  define SA_RESETHAND SA_ONESHOT
# else
#  undef HAVE_SIGACTION		/* Needed for Mac OS X < 10.2 (9/2002) */
# endif
#endif

#if HAVE_POLL
# include <poll.h>
#else
# if HAVE_SYS_SELECT_H
#  include <sys/select.h>
# else
#  if HAVE_SELECT_H
#   include <select.h>
#  endif
# endif
# define XIO_IN 1
# define XIO_OUT 2
#endif

#include <errno.h>

#ifdef X_NOT_STDC_ENV
extern	int	errno;
#endif

#ifndef	X11HEIGHT
#define	X11HEIGHT	8	/* Height of server default font */
#endif

#define	MAGBORD	1	/* border size for magnifier */

/*
 * Command line flags.
 */

#define	fore_Pixel	resource._fore_Pixel
#define	back_Pixel	resource._back_Pixel
#ifdef	TOOLKIT
extern	struct _resource	resource;
#define	brdr_Pixel	resource._brdr_Pixel
#endif	/* TOOLKIT */

#define	clip_w	mane.width
#define	clip_h	mane.height
static	Position main_x, main_y;
static	Position mag_x, mag_y, new_mag_x, new_mag_y;
#if TOOLKIT && !MOTIF
static	int	mag_conv_x, mag_conv_y;
#else
#define	mag_conv_x	0
#define	mag_conv_y	0
#endif
static	Boolean	dragcurs	= False;

static	sigset_t	all_signals;

static	void	xdvi_normal_exit();

/*
 *	The cursor shape in the magnifying glass is determined by which
 *	window received the button press event.  Under XAW, that is a parent
 *	of mane.win, so we have to define the cursor of that window instead
 *	of mane.win in that case.
 */

#if XAW
# if BUTTONS
#  define CURSORWIN	XtWindow(form_widget)
# else
#  define CURSORWIN	XtWindow(vport_widget)
# endif
#else
# define CURSORWIN	mane.win
#endif

#if COLOR
static	XColor		bg_Color;
#endif

#if TOOLKIT

#define	ACTION_DECL(name)				\
		void name ARGS((Widget, XEvent *, String *, Cardinal *))

#define	ACTION(name)					\
		void					\
		name P4C(Widget, w,			\
			XEvent *, event,		\
			String *, params,		\
			Cardinal *, num_params)

#else /* not TOOLKIT */

#define	ACTION_DECL(name)				\
		void name ARGS((XEvent *))

#define	ACTION(name)					\
		void					\
		name P1C(XEvent *, event)

#endif /* not TOOLKIT */

/* ARGSUSED */
void
null_mouse P1C(XEvent *, event)
{
}

static ACTION_DECL(Act_digit);
static ACTION_DECL(Act_minus);
static ACTION_DECL(Act_quit);
static ACTION_DECL(Act_goto_page);
static ACTION_DECL(Act_forward_page);
static ACTION_DECL(Act_back_page);
static ACTION_DECL(Act_declare_page_number);
static ACTION_DECL(Act_home);
static ACTION_DECL(Act_center);
static ACTION_DECL(Act_set_keep_flag);
static ACTION_DECL(Act_left);
static ACTION_DECL(Act_right);
static ACTION_DECL(Act_up);
static ACTION_DECL(Act_down);
static ACTION_DECL(Act_up_or_previous);
static ACTION_DECL(Act_down_or_next);
static ACTION_DECL(Act_set_margins);
static ACTION_DECL(Act_show_display_attributes);
static ACTION_DECL(Act_set_shrink_factor);
static ACTION_DECL(Act_shrink_to_dpi);
static ACTION_DECL(Act_set_density);
#if GREY
static ACTION_DECL(Act_set_greyscaling);
#endif
#if COLOR
static ACTION_DECL(Act_set_color);
#endif
#if PS
static ACTION_DECL(Act_set_ps);
#endif
#if PS_GS
static ACTION_DECL(Act_set_gs_alpha);
#endif
#if BUTTONS
static ACTION_DECL(Act_set_expert_mode);
#endif
#if !TOOLKIT
static ACTION_DECL(Act_redraw);
#endif
static ACTION_DECL(Act_reread_dvi_file);
static ACTION_DECL(Act_discard_number);

static ACTION_DECL(Act_magnifier);
static ACTION_DECL(Act_drag);
static ACTION_DECL(Act_wheel);
static ACTION_DECL(Act_hwheel);
#if TOOLKIT
static ACTION_DECL(Act_wheel_actions);
#endif
static ACTION_DECL(Act_motion);
static ACTION_DECL(Act_release);
ACTION_DECL(Act_source_special);
ACTION_DECL(Act_show_source_specials);
ACTION_DECL(Act_show_all_boxes);

#if TOOLKIT

XtActionsRec	Actions[]	= {
	{"digit",		Act_digit},
	{"minus",		Act_minus},
	{"quit",		Act_quit},
	{"goto-page",		Act_goto_page},
	{"forward-page",	Act_forward_page},
	{"back-page",		Act_back_page},
	{"declare-page-number",	Act_declare_page_number},
	{"home",		Act_home},
	{"center",		Act_center},
	{"set-keep-flag",	Act_set_keep_flag},
	{"left",		Act_left},
	{"right",		Act_right},
	{"up",			Act_up},
	{"down",		Act_down},
	{"up-or-previous",	Act_up_or_previous},
	{"down-or-next",	Act_down_or_next},
	{"set-margins",		Act_set_margins},
	{"show-display-attributes", Act_show_display_attributes},
	{"set-shrink-factor",	Act_set_shrink_factor},
	{"shrink-to-dpi",	Act_shrink_to_dpi},
	{"set-density",		Act_set_density},
	{"print",		Act_print},
	{"open-dvi-file",	Act_open_dvi_file},
#if GREY
	{"set-greyscaling",	Act_set_greyscaling},
#endif
#if COLOR
	{"set-color",		Act_set_color},
#endif
#if PS
	{"set-ps",		Act_set_ps},
#endif
#if PS_GS
	{"set-gs-alpha",	Act_set_gs_alpha},
#endif
#if BUTTONS
	{"set-expert-mode",	Act_set_expert_mode},
#endif
	{"reread-dvi-file",	Act_reread_dvi_file},
	{"discard-number",	Act_discard_number},
	{"magnifier",		Act_magnifier},
	{"drag",		Act_drag},
	{"wheel",		Act_wheel},
	{"hwheel",		Act_hwheel},
	{"wheel-actions",	Act_wheel_actions},
	{"motion",		Act_motion},
	{"release",		Act_release},
	{"source-special",	Act_source_special},
	{"show-source-specials",Act_show_source_specials},
	{"show-all-boxes",	Act_show_all_boxes},
};

Cardinal	num_actions	= XtNumber(Actions);


Bool
compile_action(str, app)
	_Xconst char	*str;
	struct xdvi_action **app;
{
	_Xconst char	*p, *p1, *p2;
	XtActionsRec	*actp;
	struct xdvi_action *ap;

	for (;;) {
	    while (*str == ' ' || *str == '\t') ++str;

	    if (*str == '\0' || *str == '\n')
		break;

	    p = str;
	    while (((*p | ('a' ^ 'A')) >= 'a' && (*p | ('a' ^ 'A')) <= 'z')
	      || (*p >= '0' && *p <= '9') || *p == '-' || *p == '_')
		++p;

	    for (actp = Actions;; ++actp) {
		if (actp >= Actions + XtNumber(Actions)) {
		    fprintf(stderr, "%s: cannot compile action %.*s\n", prog,
		      (int) (p - str), str);
		    *app = NULL;
		    return False;
		}
		if (memcmp(str, actp->string, p - str) == 0
		  && actp->string[p - str] == '\0')
		    break;
	    }

	    while (*p == ' ' || *p == '\t') ++p;
	    if (*p != '(') {
		while (*p != '\0' && *p != '\n') ++p;
		fprintf(stderr, "%s: syntax error in action %.*s\n", prog,
		  (int) (p - str), str);
		*app = NULL;
		return False;
	    }
	    ++p;
	    while (*p == ' ' || *p == '\t') ++p;
	    for (p1 = p;; ++p1) {
		if (*p1 == '\0' || *p1 == '\n') {
		    fprintf(stderr, "%s: syntax error in action %.*s\n", prog,
		      (int) (p1 - str), str);
		    *app = NULL;
		    return False;
		}
		if (*p1 == ')') break;
	    }

	    ap = xmalloc(sizeof *ap);
	    ap->proc = actp->proc;
	    for (p2 = p1;; --p2)
		if (p2 <= p) {	/* if no args */
		    ap->num_params = 0;
		    ap->param = NULL;
		    break;
		}
		else if (p2[-1] != ' ' && p2[-1] != '\t') {
		    char	*arg;

		    arg = xmalloc(p2 - p + 1);
		    bcopy(p, arg, p2 - p);
		    arg[p2 - p] = '\0';
		    ap->num_params = 1;
		    ap->param = arg;
		    break;
		}

	    *app = ap;
	    app = &ap->next;

	    str = p1 + 1;
	}

	*app = NULL;
	return True;
}


#if BUTTONS
static	Widget	line_widget;
static	int	destroy_count	= 0;
# if MOTIF
static	Widget	panel_widget;	/* otherwise it's defined in xdvi.h */
# endif
#endif /* BUTTONS */

#ifndef MOTIF
static	Widget	x_bar, y_bar;	/* horizontal and vertical scroll bars */
#endif

static	Arg	resize_args[] = {
	{XtNwidth,	(XtArgVal) 0},
	{XtNheight,	(XtArgVal) 0},
};

#define	XdviResizeWidget(widget, w, h)	\
		(width_arg.value = (XtArgVal) (w), \
		resize_args[1].value = (XtArgVal) (h), \
		XtSetValues(widget, resize_args, XtNumber(resize_args)) )

#define	width_arg	(resize_args[0])
#define	height_arg	(resize_args[1])

#if BUTTONS

#ifndef MOTIF
static	Arg	resizable_on[] = {
	{XtNresizable,	(XtArgVal) True},
};

static	Arg	resizable_off[] = {
	{XtNresizable,	(XtArgVal) False},
};
#endif

static	Arg	line_args[] = {
	{XtNbackground,		(XtArgVal) 0},
	{XtNwidth,		(XtArgVal) 1},
#if !MOTIF
	{XtNfromHoriz,		(XtArgVal) NULL},
	{XtNborderWidth,	(XtArgVal) 0},
	{XtNtop,		(XtArgVal) XtChainTop},
	{XtNbottom,		(XtArgVal) XtChainBottom},
	{XtNleft,		(XtArgVal) XtChainRight},
	{XtNright,		(XtArgVal) XtChainRight},
#else /* MOTIF */
	{XmNleftWidget,		(XtArgVal) NULL},
	{XmNleftAttachment,	(XtArgVal) XmATTACH_WIDGET},
	{XmNtopAttachment,	(XtArgVal) XmATTACH_FORM},
	{XmNbottomAttachment,	(XtArgVal) XmATTACH_FORM},
#endif /* MOTIF */
};

static	Arg	panel_args[] = {
#if !MOTIF
	{XtNborderWidth,	(XtArgVal) 0},
	{XtNfromHoriz,		(XtArgVal) NULL},
	{XtNtranslations,	(XtArgVal) NULL},
	{XtNtop,		(XtArgVal) XtChainTop},
	{XtNbottom,		(XtArgVal) XtChainBottom},
	{XtNleft,		(XtArgVal) XtChainRight},
	{XtNright,		(XtArgVal) XtChainRight},
#else /* MOTIF */
	{XmNleftAttachment,	(XtArgVal) XmATTACH_FORM},
	{XmNtopAttachment,	(XtArgVal) XmATTACH_FORM},
	{XmNbottomAttachment,	(XtArgVal) XmATTACH_FORM},
#endif /* MOTIF */
};

static	void	handle_command();

static	XtCallbackRec	command_call[] = {
	{handle_command, NULL},
	{NULL,		NULL},
};

static	Arg	command_args[] = {
#ifndef MOTIF
	{XtNlabel,	(XtArgVal) NULL},
#else
	{XmNlabelString, (XtArgVal) NULL},
#endif
	{XtNx,		(XtArgVal) 0},
	{XtNy,		(XtArgVal) 0},
	{XtNborderWidth,(XtArgVal) 0},
#ifndef MOTIF
	{XtNcallback,	(XtArgVal) command_call},
#else
	{XmNactivateCallback, (XtArgVal) command_call},
#endif
};

struct button_info {
	struct button_info	*next;
	char			*label;
	struct xdvi_action	*action;
	Widget			widget;
};

static	struct button_info	*b_head;

_Xconst char			default_button_config[] =
#if PS
  "Quit:quit()\n\
Open:open-dvi-file()\n\n\
Full size:set-shrink-factor(1)\n\
$%%:shrink-to-dpi(150)\n\
$%%:shrink-to-dpi(100)\n\
$%%:shrink-to-dpi(75)\n\n\
Page-10:back-page(10)\n\
Page-5:back-page(5)\n\
Prev:back-page(1)\n\n\
Next:forward-page(1)\n\
Page+5:forward-page(5)\n\
Page+10:forward-page(10)\n\n\
View PS:set-ps(toggle)\n\
Print:print()";
#else
  "Quit:quit()\n\
Open:open-dvi-file()\n\n\
Full size:set-shrink-factor(1)\n\
$%%:shrink-to-dpi(150)\n\
$%%:shrink-to-dpi(100)\n\
$%%:shrink-to-dpi(75)\n\n\
Page-10:back-page(10)\n\
Page-5:back-page(5)\n\
Prev:back-page(1)\n\n\
Next:forward-page(1)\n\
Page+5:forward-page(5)\n\
Page+10:forward-page(10)\n\n\
Print:print()";
#endif

void
create_buttons()
{
	Dimension		max_button_width;
	Dimension		y_pos;
	struct button_info	**bipp;
	struct button_info	*bp;
	_Xconst char		*cspos;
	int			button_number;
	int			shrink_button_number;
	int			shrink_arg;
	struct xdvi_action	*action;

	line_args[0].value = (XtArgVal) resource._fore_Pixel;
#if XAW
	line_args[2].value = (XtArgVal) vport_widget;
	line_widget = XtCreateWidget("line", widgetClass, form_widget,
	  line_args, XtNumber(line_args));
	panel_args[1].value = (XtArgVal) line_widget;
	if (panel_args[2].value == (XtArgVal) NULL)
	    panel_args[2].value =
	      (XtArgVal) XtParseTranslationTable("<ButtonPress>:");
	panel_widget = XtCreateWidget("panel", PANEL_WIDGET_CLASS,
	  form_widget, panel_args, XtNumber(panel_args));
#else
	panel_widget = XtCreateManagedWidget("panel", PANEL_WIDGET_CLASS,
	  form_widget, panel_args, XtNumber(panel_args));
	if (wheel_trans_table != NULL)
	    XtOverrideTranslations(panel_widget, wheel_trans_table);
#endif

	button_number = shrink_button_number = 0;
	b_head = NULL;
	bipp = &b_head;
	command_args[1].value = resource.btn_side_spacing;
	command_args[3].value = resource.btn_border_width;
	max_button_width = 0;
	y_pos = resource.btn_top_spacing;

	for (cspos = resource.button_translations;; ++cspos) {
	    Dimension	w, h;
	    _Xconst char *p1, *p2;
	    char	*label, *q;
	    char	name[9];
	    Widget	widget;
	    size_t	len;

	    while (*cspos == ' ' || *cspos == '\t') ++cspos;
	    if (*cspos == '\0') break;

	    if (*cspos == '\n') {
		y_pos += resource.btn_between_extra;
		continue;
	    }

	    len = 0;	/* find length of actual label string */
	    shrink_arg = 0;
	    for (p2 = p1 = cspos; *p1 != '\0' && *p1 != ':'; ) {
		if (*p1 == '\\' && p1[1] != '\0') {
		    p1 += 2;
		    p2 = p1;
		    --len;
		}
		else if (*p1 == '$'
		  && (p1[1] == '#' || p1[1] == '%' || p1[1] == '_')) {
		    shrink_arg = 1;
		    ++p1;
		    if (*p1 == '%') len += 2;
		    else if (*p1 == '_') len -= 2;
		}
		else {
		    ++p1;
		    if (p1[-1] != ' ' && p1[-1] != '\t') p2 = p1;
		}
	    }
	    len += p2 - cspos;

	    if (*p1 == '\0') break;	/* if premature end of string */

	    if (!compile_action(p1 + 1, &action)) break;

	    if (shrink_arg) {
		for (;; action = action->next) {
		    if (action == NULL) {
			fprintf(stderr, "Warning:  label on button number %d \
refers to non-existent shrink action.\n", button_number + 1);
			break;
		    }
		    if (action->proc == Act_set_shrink_factor
		      || action->proc == Act_shrink_to_dpi) {
			if (shrink_button_number < 9
			  && resource.shrinkbutton[shrink_button_number] != 0) {
			    shrink_arg
			      = resource.shrinkbutton[shrink_button_number];
			    if (shrink_arg < 1) shrink_arg = 1;
			    else if (shrink_arg > 99) shrink_arg = 99;
			    if (action->num_params > 0) free(action->param);
			    action->proc = Act_set_shrink_factor;
			    action->num_params = 1;
			    action->param = xmalloc(4);
			    sprintf(action->param, "%d", shrink_arg);
			}
			else {
			    if (action->num_params > 0) {
				shrink_arg = atoi(action->param);
				if (action->proc == Act_shrink_to_dpi)
				    shrink_arg = (double) pixels_per_inch
				      / shrink_arg + 0.5;
				if (shrink_arg < 1) shrink_arg = 1;
				else if (shrink_arg > 99) shrink_arg = 99;
			    }
			}
			break;
		    }
		}
		++shrink_button_number;
	    }

	    label = xmalloc(len + 1);
	    for (q = label; cspos < p2; ++cspos) {
		if (*cspos == '\\') {
		    if (++cspos < p2)
			*q++ = *cspos;
		}
		else if (*cspos == '$'
		  && (cspos[1] == '#' || cspos[1] == '%' || cspos[1] == '_')) {
		    ++cspos;
		    if (*cspos == '#') {
			sprintf(q, "%d", shrink_arg);
		    }
		    else if (*cspos == '%') {
			if (shrink_arg <= 15)
			    sprintf(q, "%d", (int) (100.0 / shrink_arg + .5));
			else
			    sprintf(q, "%.2f", 100.0 / shrink_arg);
		    }
		    q += strlen(q);
		}
		else
		    *q++ = *cspos;
	    }
	    *q = '\0';
	    if (q > label + len)
		oops("Internal error computing button labels");

#if !MOTIF
	    command_args[0].value = (XtArgVal) label;
#else /* MOTIF */
	    command_args[0].value = (XtArgVal) XmCvtCTToXmString(label);
#endif /* MOTIF */
	    command_args[2].value = (XtArgVal) y_pos;
	    command_call[0].closure = (XtPointer) action;
	    if (++button_number > 99) break;	/* if too many buttons */
	    sprintf(name, "button%d", button_number);
	    widget = XtCreateWidget(name, BUTTON_WIDGET_CLASS, panel_widget,
	      command_args, XtNumber(command_args));
	    resize_args[0].value = (XtArgVal) &w;
	    resize_args[1].value = (XtArgVal) &h;
	    XtGetValues(widget, resize_args, 2);
	    if (w > max_button_width) max_button_width = w;
	    y_pos += h + resource.btn_between_spacing
	      + 2 * resource.btn_border_width;

	    bp = xmalloc(sizeof *bp);
	    bp->label = label;
	    bp->action = action;
	    bp->widget = widget;
	    *bipp = bp;
	    bipp = &bp->next;

	    cspos = index(p1 + 1, '\n');
	    if (cspos == NULL)
		break;
	}
	*bipp = NULL;

	xtra_wid = max_button_width
	  + 2 * (resource.btn_side_spacing + resource.btn_border_width);

	width_arg.value = (XtArgVal) xtra_wid;
	XtSetValues(panel_widget, &width_arg, 1);

#if !MOTIF
	++xtra_wid;
#endif

	width_arg.value = (XtArgVal) max_button_width;
	for (bp = b_head; bp != NULL; bp = bp->next) {
	    XtSetValues(bp->widget, &width_arg, 1);
	    XtManageChild(bp->widget);
	}

#if MOTIF
	line_args[2].value = (XtArgVal) panel_widget;
	line_widget = XtCreateManagedWidget("line", widgetClass, form_widget,
	  line_args, XtNumber(line_args));
	XtVaSetValues(vport_widget, XmNleftAttachment, XmATTACH_WIDGET,
	  XmNleftWidget, line_widget, NULL);
#endif
}

#if XAW

void
set_button_panel_height(h)
	XtArgVal	h;
{
	height_arg.value = h;
	XtSetValues(line_widget, &height_arg, 1);
	XtManageChild(line_widget);
	XtSetValues(panel_widget, &height_arg, 1);
	XtManageChild(panel_widget);
	if (panel_cursor == (Cursor) 0)
	    panel_cursor = XCreateFontCursor(DISP, XC_left_ptr);
	if (XtIsRealized(panel_widget))
	    XDefineCursor(DISP, XtWindow(panel_widget), panel_cursor);
}

#endif /* MOTIF */

#endif /* BUTTONS */

#else /* not TOOLKIT */

static	Window	x_bar, y_bar;
static	int	x_bgn, x_end, y_bgn, y_end;	/* scrollbar positions */

static
ACTION(Act_null)
{
}

#if !GREY
#define	Act_set_greyscaling	Act_null
#endif

#if !COLOR
#define	Act_set_color		Act_null
#endif

#if !PS
#define	Act_set_ps		Act_null
#endif

#if !PS_GS
#define	Act_set_gs_alpha	Act_null
#endif

typedef	void	(*act_proc) ARGS((XEvent *));

static	act_proc	actions[128]	= {
		Act_null, Act_null, Act_null, Act_quit,		/* NUL, ^A-^C */
		Act_quit, Act_null, Act_null, Act_null,		/* ^D-^G */
		Act_up_or_previous, Act_null, Act_forward_page,
		  Act_null,					/* ^H-^K */
		Act_redraw, Act_forward_page, Act_null, Act_null, /* ^L-^O */
		Act_show_display_attributes, Act_null, Act_null,
		  Act_null,					/* ^P-^S */
		Act_null, Act_null, Act_null, Act_null,		/* ^T-^W */
		Act_null, Act_null, Act_null,
		  Act_discard_number,				/* ^X-^Z, ESC */
		Act_null, Act_null, Act_null, Act_null,		/* ^{\,],^,_} */
		Act_down_or_next, Act_null, Act_null, Act_null,	/* SP,!,",# */
		Act_null, Act_null, Act_null, Act_null,		/* $,%,&,' */
		Act_null, Act_null, Act_null, Act_null,		/* (,),*,+ */
		Act_null, Act_minus, Act_null, Act_null,	/* ,,-,.,/ */
		Act_digit, Act_digit, Act_digit, Act_digit,	/* 0,1,2,3 */
		Act_digit, Act_digit, Act_digit, Act_digit,	/* 4,5,6,7 */
		Act_digit, Act_digit, Act_null, Act_null,	/* 8,9,:,; */
		Act_null, Act_null, Act_null, Act_null,		/* <,=,>,? */
		Act_null, Act_null, Act_null, Act_set_color,	/* @,A,B,C */
		Act_null, Act_null, Act_null,
		  Act_set_greyscaling,				/* D,E,F,G */
		Act_null, Act_null, Act_null, Act_null,		/* H,I,J,K */
		Act_null, Act_set_margins, Act_null, Act_null,	/* L,M,N,O */
		Act_declare_page_number, Act_null,
		  Act_reread_dvi_file, Act_set_density,		/* P,Q,R,S */
		Act_null, Act_null, Act_set_gs_alpha, Act_null,	/* T,U,V,W */
		Act_null, Act_null, Act_null, Act_null,		/* X,Y,Z,[ */
		Act_null, Act_null, Act_home, Act_null,		/* \,],^,_ */
		Act_null, Act_null, Act_back_page, Act_center,	/* `,a,b,c */
		Act_down, Act_null, Act_forward_page,
		  Act_goto_page,				/* d,e,f,g */
		Act_null, Act_null, Act_null,
		  Act_set_keep_flag,				/* h,i,j,k */
		Act_left, Act_null, Act_forward_page, Act_null,	/* l,m,n,o */
		Act_back_page, Act_quit, Act_right,
		  Act_set_shrink_factor,			/* p,q,r,s */
		Act_null, Act_up, Act_set_ps, Act_null,		/* t,u,v,w */
		Act_null, Act_null, Act_null, Act_null,		/* x,y,z,{ */
		Act_null, Act_null, Act_null, Act_up_or_previous,/* |,},~,DEL */
};

#endif /* not TOOLKIT */

/*
 *	Mechanism to keep track of the magnifier window.  The problems are,
 *	(a) if the button is released while the window is being drawn, this
 *	could cause an X error if we continue drawing in it after it is
 *	destroyed, and
 *	(b) creating and destroying the window too quickly confuses the window
 *	manager, which is avoided by waiting for an expose event before
 *	destroying it.
 */
static	short	alt_stat;	/* 1 = wait for expose, */
				/* -1 = destroy upon expose */

/*
 *	Data for buffered events.
 */

#if !FLAKY_SIGPOLL
static	VOLATILE int	event_freq	= 70;
#else
#define	event_freq	70
#endif

static	void	can_exposures();

#if GREY

#define	gamma	resource._gamma

extern	double	pow();

static	void
mask_shifts(mask, pshift1, pshift2)
	Pixel	mask;
	int	*pshift1, *pshift2;
{
	int	k, l;

	for (k = 0; (mask & 1) == 0; ++k)
	    mask >>= 1;
	for (l = 0; (mask & 1) == 1; ++l)
	    mask >>= 1;
	*pshift1 = sizeof(short) * 8 - l;
	*pshift2 = k;
}

/*
 *	Try to allocate 4 color planes for 16 colors (for GXor drawing).
 *	Not called if the visual type is TrueColor.
 *	When color specials are active, this is called exactly once.
 *	It is used for the first foreground/background pair displayed in
 *	the document.  For other documents, we act as if this call had failed.
 */

void
init_plane_masks()
{
	Pixel	pixel;

	if (copy || plane_masks[0] != 0)
	    return;

	if (XAllocColorCells(DISP, our_colormap, False, plane_masks, 4,
	  &pixel, 1)) {
	    /* Make sure fore_Pixel and back_Pixel are a part of the palette */
	    back_Pixel = pixel;
	    fore_Pixel = pixel | plane_masks[0] | plane_masks[1]
	      | plane_masks[2] | plane_masks[3];
	    if (mane.win != (Window) 0)
		XSetWindowBackground(DISP, mane.win, back_Pixel);
	}
	else {
	    copy = True;
	    WARN(XmDIALOG_WARNING, "\
Greyscaling is running in copy mode.\n\
Your display can only display a limited number\n\
of colors at a time (typically 256), and other\n\
applications (such as netscape) are using\n\
many of them.\n\
\n\
Running in copy mode will cause overstrike\n\
characters to appear incorrectly,\n\
and may result in poor display quality.\n\
\n\
See the section ``GREYSCALING AND COLORMAPS''\n\
in the xdvi manual page for more details.");
#if !TOOLKIT
	    fflush(stdout);	/* useful if called by netscape */
#endif
	}
}

#endif /* GREY */

#if COLOR

/*
 *	Warn about overstrike characters.
 */

static	void
warn_overstrike()
{
	static	Boolean	warned_already = False;

	if (!warned_already) {
	    warned_already = True;
	    WARN(XmDIALOG_WARNING, "Overstrike characters may be incorrect");
	}
}

/*
 *	Insert into list of colors to be freed upon opening new document.
 */

static	void
color_list_insert(pixel)
	Pixel	pixel;
{
	if (color_list_len >= color_list_max) {
	    if (color_list_max == 0)
		color_list = xmalloc(
		  (color_list_max += 16) * sizeof *color_list);
	    else
		color_list = xrealloc(color_list,
		  (color_list_max += 16) * sizeof *color_list);
	}
	color_list[color_list_len++] = pixel;
}


/*
 *	Warn about colors not being correct.
 */

static	void
color_warn()
{
	if (!color_warned) {
	    color_warned = True;
	    WARN(XmDIALOG_WARNING, "\
Cannot allocate colormap entry;\n\
displayed colors are not exact.\n\
Either this document is using too many\n\
colors, or some other application is.\n\
In the latter case, close that\n\
application and re-read the dvi file.");
	}
}


/*
 *	Allocate a color and add it to our list of pixels to be returned
 *	upon opening a new document.
 */

#define	SHIFTIFY(x, shift1, shift2)	((((Pixel)(x)) >> (shift1)) << (shift2))

static	int	shift1_r, shift1_g, shift1_b;
static	int	shift2_r, shift2_g, shift2_b;
static	Boolean	shifts_good	= False;

Pixel
alloc_color(colorp, fallback_pixel)
	_Xconst struct rgb	*colorp;
	Pixel			fallback_pixel;
{
	XColor	xcol;

	if (our_visual->class == TrueColor) {
	    if (!shifts_good) {
		mask_shifts(our_visual->red_mask,   &shift1_r, &shift2_r);
		mask_shifts(our_visual->green_mask, &shift1_g, &shift2_g);
		mask_shifts(our_visual->blue_mask,  &shift1_b, &shift2_b);
		shifts_good = True;
	    }
	    return SHIFTIFY(colorp->r, shift1_r, shift2_r) |
	      SHIFTIFY(colorp->g, shift1_g, shift2_g) |
	      SHIFTIFY(colorp->b, shift1_b, shift2_b);
	}
	else {
	    xcol.red = colorp->r;
	    xcol.green = colorp->g;
	    xcol.blue = colorp->b;
	    xcol.flags = DoRed | DoGreen | DoBlue;
	    if (XAllocColor(DISP, our_colormap, &xcol)) {
		color_list_insert(xcol.pixel);
		if (debug & DBG_DVI)
		    printf("alloc_color%6d%6d%6d --> %ld\n",
		      xcol.red, xcol.green, xcol.blue, xcol.pixel);
		return xcol.pixel;
	    }
	    else {
		if (debug & DBG_DVI)
		    printf("alloc_color%6d%6d%6d --> failed\n",
		      xcol.red, xcol.green, xcol.blue);
		color_warn();
		return fallback_pixel;
	    }
	}
}

#undef SHIFTIFY


/*
 *	Switch colors of GCs, etc.  Called when we're about to use a GC.
 */

#define	SetGC(gc, fcn, fg, bg) \
	    { \
		values.function = fcn; \
		values.foreground = fg; \
		values.background = bg; \
		if (gc != NULL) \
		    XChangeGC(DISP, gc, \
		      GCFunction | GCForeground | GCBackground, &values); \
		else \
		    gc = XCreateGC(DISP, XtWindow(top_level), \
		      GCFunction | GCForeground | GCBackground, &values); \
	    }

void
do_color_change()
{
	static	int	shrink_allocated_for = 0;
	static	GC	foreGC2_bak	= NULL;
	XGCValues	values;
	Pixel		set_bits;
	Pixel		clr_bits;

#if GREY
	if (use_grey) {

	    if (our_visual->class == TrueColor) {
		if (!fg_current->pixel_good) {
		    fg_current->pixel = alloc_color(&fg_current->color,
		      fore_color_data.pixel);
		    fg_current->pixel_good = True;
		}

		set_bits = fg_current->pixel & ~bg_current->pixel;
		clr_bits = bg_current->pixel & ~fg_current->pixel;

		if (set_bits & our_visual->red_mask)
		    set_bits |= our_visual->red_mask;
		if (clr_bits & our_visual->red_mask)
		    clr_bits |= our_visual->red_mask;
		if (set_bits & our_visual->green_mask)
		    set_bits |= our_visual->green_mask;
		if (clr_bits & our_visual->green_mask)
		    clr_bits |= our_visual->green_mask;
		if (set_bits & our_visual->blue_mask)
		    set_bits |= our_visual->blue_mask;
		if (clr_bits & our_visual->blue_mask)
		    clr_bits |= our_visual->blue_mask;

		/*
		 * Make the GCs
		 */

		SetGC(ruleGC, GXcopy, fg_current->pixel, bg_current->pixel);
		foreGC2 = NULL;

		if (resource.copy
		  || (set_bits && clr_bits && !resource.thorough)) {
		    if (!resource.copy)
			warn_overstrike();
		    SetGC(foreGC, GXcopy, fg_current->pixel, bg_current->pixel);
		}
		else {
		    if (set_bits) {
			SetGC(foreGC, GXor, fg_current->pixel & set_bits, 0);
			if (clr_bits) {
			    SetGC(foreGC2_bak, GXandInverted,
			      ~fg_current->pixel & clr_bits, 0);
			    foreGC2 = foreGC2_bak;
			}
		    }
		    else
			SetGC(foreGC, GXandInverted,
			  ~fg_current->pixel & clr_bits, 0);
		}

		if (debug & DBG_DVI)
		    printf(
		      "do_color_change: fg = %lx, bg = %lx, with%s foreGC2\n",
		      fg_current->pixel, bg_current->pixel,
		      foreGC2 == NULL ? "out" : "");

		if (mane.shrinkfactor > 1) {
		    int i;
		    unsigned int sf_squared;

		    sf_squared = mane.shrinkfactor * mane.shrinkfactor;

		    if (shrink_allocated_for < mane.shrinkfactor) {
			if (pixeltbl != NULL) {
			    free((char *) pixeltbl);
			    if (pixeltbl_t != NULL) {
				free((char *) pixeltbl_t);
				pixeltbl_t = NULL;
			    }
			}
			pixeltbl = xmalloc((sf_squared + 1) * sizeof(Pixel));
			shrink_allocated_for = mane.shrinkfactor;
		    }
		    if (foreGC2 != NULL && pixeltbl_t == NULL)
			/* Can't use sf_squared (or mane.shrinkfactor) here */
			pixeltbl_t = xmalloc((shrink_allocated_for
			  * shrink_allocated_for + 1) * sizeof(Pixel));

		    /*
		     * Compute pixel values directly.
		     */

#define	SHIFTIFY(x, shift1, shift2)	((((Pixel)(x)) >> (shift1)) << (shift2))

		    for (i = 0; i <= sf_squared; ++i) {
			double		frac	= gamma > 0
			  ? pow((double) i / sf_squared, 1 / gamma)
			  : 1 - pow((double) (sf_squared - i) / sf_squared,
			  -gamma);
			unsigned int	red, green, blue;
			Pixel		pixel;

			red = frac
			  * ((double) fg_current->color.r - bg_current->color.r)
			  + bg_current->color.r;
			green = frac
			  * ((double) fg_current->color.g - bg_current->color.g)
			  + bg_current->color.g;
			blue = frac
			  * ((double) fg_current->color.b - bg_current->color.b)
			  + bg_current->color.b;

			pixel = SHIFTIFY(red,   shift1_r, shift2_r) |
				SHIFTIFY(green, shift1_g, shift2_g) |
				SHIFTIFY(blue,  shift1_b, shift2_b);

			if (foreGC2 != NULL) {	/* if thorough */
			    pixeltbl[i] = pixel & ~bg_current->pixel;
			    pixeltbl_t[i] = ~pixel & bg_current->pixel;
			}
			else if (resource.copy || (set_bits && clr_bits))
			    pixeltbl[i] = pixel;
			else
			    pixeltbl[i] = set_bits ? pixel & set_bits
				: ~pixel & clr_bits;
		    }

#undef	SHIFTIFY
		}

	    }

	    else {	/* not TrueColor */
		int	i;
		Boolean	using_planes;

		using_planes = (fg_current == bg_head->fg_head && !copy);
		if (!fg_current->palette_good) {
		    XColor color;

		    for (i = 0; i < 16; ++i) {
			double frac;

			frac = gamma > 0 ? pow((double) i / 15, 1 / gamma)
			    : 1 - pow((double) (15 - i) / 15, -gamma);
			color.red = frac
			  * ((double) fg_current->color.r - bg_current->color.r)
			  + bg_current->color.r;
			color.green = frac
			  * ((double) fg_current->color.g - bg_current->color.g)
			  + bg_current->color.g;
			color.blue = frac
			  * ((double) fg_current->color.b - bg_current->color.b)
			  + bg_current->color.b;

			color.flags = DoRed | DoGreen | DoBlue;

			if (using_planes) {
			    color.pixel = back_Pixel;	/* start of block */
			    if (i & 1) color.pixel |= plane_masks[0];
			    if (i & 2) color.pixel |= plane_masks[1];
			    if (i & 4) color.pixel |= plane_masks[2];
			    if (i & 8) color.pixel |= plane_masks[3];
			    XStoreColor(DISP, our_colormap, &color);
			    fg_current->palette[i] = color.pixel;
			}
			else {
			    if (XAllocColor(DISP, our_colormap, &color)) {
				fg_current->palette[i] = color.pixel;
				color_list_insert(color.pixel);
			    }
			    else {
				color_warn();
				fg_current->palette[i] =
				  (i * 100 >= density * 15)
				  ? fore_Pixel : bg_current->pixel;
			    }
			}
		    }

		    if (using_planes && bg_current->pixel != back_Pixel) {
			bg_current->pixel = back_Pixel;
			XSetWindowBackground(DISP, mane.win, bg_current->pixel);
			XClearWindow(DISP, mane.win);
		    }

		    fg_current->palette_good = True;
		}

		if (debug & DBG_DVI)
		    printf("do_color_change: fg = %ld, bg = %ld, using_planes = %d\n",
		      fg_current->palette[15], bg_current->pixel, using_planes);

		if (using_planes) {
		    SetGC(ruleGC, GXor, fg_current->palette[15],
		      bg_current->pixel);
		    SetGC(foreGC, GXor, fg_current->palette[15],
		      bg_current->pixel);
		}
		else {
		    SetGC(ruleGC, GXcopy, fg_current->palette[15],
		      bg_current->pixel);
		    SetGC(foreGC, GXcopy, fg_current->palette[15],
		      bg_current->pixel);
		}

		foreGC2 = NULL;

		if (mane.shrinkfactor > 1) {
		    if (shrink_allocated_for < mane.shrinkfactor) {
			if (pixeltbl != NULL) free((char *) pixeltbl);
			pixeltbl = xmalloc((unsigned)
			  (mane.shrinkfactor * mane.shrinkfactor + 1)
			  * sizeof *pixeltbl);
			shrink_allocated_for = mane.shrinkfactor;
		    }

		    for (i = 0; i <= mane.shrinkfactor * mane.shrinkfactor; ++i)
			pixeltbl[i] = fg_current->palette[
			  (i * 30 + mane.shrinkfactor * mane.shrinkfactor)
			  / (2 * mane.shrinkfactor * mane.shrinkfactor)];
		}
	    }

	}	/* end if use_grey */
	else

#endif /* GREY */

	{
	    static	GC	foreGC2_bak	= NULL;

	    if (!fg_current->pixel_good) {
		fg_current->pixel = alloc_color(&fg_current->color,
		  fore_color_data.pixel);
		fg_current->pixel_good = True;
	    }

	    if (debug & DBG_DVI)
		printf("do_color_change: fg = %lx, bg = %lx\n",
		  fg_current->pixel, bg_current->pixel);

	    SetGC(ruleGC, GXcopy, fg_current->pixel, bg_current->pixel);

	    set_bits = (Pixel) (fg_current->pixel & ~bg_current->pixel);
	    clr_bits = (Pixel) (bg_current->pixel & ~fg_current->pixel);
	    foreGC2 = NULL;

	    if (resource.copy
	      || (set_bits && clr_bits && !resource.thorough)) {
		if (!resource.copy)
		    warn_overstrike();
		SetGC(foreGC, GXcopy, fg_current->pixel, bg_current->pixel);
	    }
	    else {
		if (set_bits) {
		    SetGC(foreGC, GXor, set_bits, 0);
		    if (clr_bits) {
			SetGC(foreGC2_bak, GXandInverted, clr_bits, 0);
			foreGC2 = foreGC2_bak;
		    }
		}
		else
		    SetGC(foreGC, GXandInverted, clr_bits, 0);
	    }
	}

	fg_active = fg_current;
}

#undef SetGC

#elif GREY /* endif COLOR */

#define	MakeGC(fcn, fg, bg)	(values.function = fcn, \
	  values.foreground=fg, values.background=bg, \
	  XCreateGC(DISP, XtWindow(top_level), \
	    GCFunction | GCForeground | GCBackground, &values))

void
init_pix()
{
	static	int	shrink_allocated_for = 0;
	static	float	oldgamma	= 0.0;
	static	Pixel	palette[17];
	XGCValues	values;
	int	i;

	if (our_visual->class == TrueColor) {
	    /* This mirrors the non-grey code in xdvi.c */
	    static int		shift1_r, shift1_g, shift1_b;
	    static int		shift2_r, shift2_g, shift2_b;
	    static Pixel	set_bits;
	    static Pixel	clr_bits;
	    unsigned int	sf_squared;

	    if (oldgamma == 0.0) {
		mask_shifts(our_visual->red_mask,   &shift1_r, &shift2_r);
		mask_shifts(our_visual->green_mask, &shift1_g, &shift2_g);
		mask_shifts(our_visual->blue_mask,  &shift1_b, &shift2_b);

		set_bits = fore_color_data.pixel & ~back_color_data.pixel;
		clr_bits = back_color_data.pixel & ~fore_color_data.pixel;

		if (set_bits & our_visual->red_mask)
		    set_bits |= our_visual->red_mask;
		if (clr_bits & our_visual->red_mask)
		    clr_bits |= our_visual->red_mask;
		if (set_bits & our_visual->green_mask)
		    set_bits |= our_visual->green_mask;
		if (clr_bits & our_visual->green_mask)
		    clr_bits |= our_visual->green_mask;
		if (set_bits & our_visual->blue_mask)
		    set_bits |= our_visual->blue_mask;
		if (clr_bits & our_visual->blue_mask)
		    clr_bits |= our_visual->blue_mask;

		/*
		 * Make the GCs
		 */

		foreGC = foreGC2 = ruleGC = 0;
		copyGC = MakeGC(GXcopy, fore_Pixel, back_Pixel);
		if (copy || (set_bits && clr_bits)) {
		    ruleGC = copyGC;
		    if (!resource.thorough) copy = True;
		}
		if (copy) {
		    foreGC = ruleGC;
		    if (!resource.copy)
			WARN(XmDIALOG_WARNING,
			  "Overstrike characters may be incorrect");
		}
		else {
		    if (set_bits)
			foreGC = MakeGC(GXor,
			  set_bits & fore_color_data.pixel, 0);
		    if (clr_bits || !set_bits)
			*(foreGC ? &foreGC2 : &foreGC) = MakeGC(GXandInverted,
			  clr_bits & ~fore_color_data.pixel, 0);
		    if (!ruleGC) ruleGC = foreGC;
		}

		oldgamma = gamma;
	    }

	    if (mane.shrinkfactor == 1) return;
	    sf_squared = mane.shrinkfactor * mane.shrinkfactor;

	    if (shrink_allocated_for < mane.shrinkfactor) {
		if (pixeltbl != NULL) {
		    free((char *) pixeltbl);
		    if (pixeltbl_t != NULL)
			free((char *) pixeltbl_t);
		}
		pixeltbl = xmalloc((sf_squared + 1) * sizeof(Pixel));
		if (foreGC2 != NULL)
		    pixeltbl_t = xmalloc((sf_squared + 1) * sizeof(Pixel));
		shrink_allocated_for = mane.shrinkfactor;
	    }

	    /*
	     * Compute pixel values directly.
	     */

#define	SHIFTIFY(x, shift1, shift2)	((((Pixel)(x)) >> (shift1)) << (shift2))

	    for (i = 0; i <= sf_squared; ++i) {
		double		frac	= gamma > 0
		    ? pow((double) i / sf_squared, 1 / gamma)
		    : 1 - pow((double) (sf_squared - i) / sf_squared, -gamma);
		unsigned int	red, green, blue;
		Pixel		pixel;

		red = frac
		  * ((double) fore_color_data.red - back_color_data.red)
		  + back_color_data.red;
		green = frac
		  * ((double) fore_color_data.green - back_color_data.green)
		  + back_color_data.green;
		blue = frac
		  * ((double) fore_color_data.blue - back_color_data.blue)
		  + back_color_data.blue;

		pixel = SHIFTIFY(red,   shift1_r, shift2_r) |
			SHIFTIFY(green, shift1_g, shift2_g) |
			SHIFTIFY(blue,  shift1_b, shift2_b);

		if (copy) pixeltbl[i] = pixel;
		else if (foreGC2 != NULL) {	/* if thorough */
		    pixeltbl[i] = pixel & ~back_color_data.pixel;
		    pixeltbl_t[i] = ~pixel & back_color_data.pixel;
		}
		else
		    pixeltbl[i] = set_bits ? pixel & set_bits
			: ~pixel & clr_bits;
	    }

#undef	SHIFTIFY

	    return;
	}

	/* if not TrueColor ... */

	if (gamma != oldgamma) {
	    XColor	color;

	    for (i = 0; i < 16; ++i) {
		double	frac = gamma > 0 ? pow((double) i / 15, 1 / gamma)
		    : 1 - pow((double) (15 - i) / 15, -gamma);

		color.red = frac
		  * ((double) fore_color_data.red - back_color_data.red)
		  + back_color_data.red;
		color.green = frac
		  * ((double) fore_color_data.green - back_color_data.green)
		  + back_color_data.green;
		color.blue = frac
		  * ((double) fore_color_data.blue - back_color_data.blue)
		  + back_color_data.blue;

		color.pixel = back_Pixel;
		color.flags = DoRed | DoGreen | DoBlue;

		if (!copy) {
		    if (i & 1) color.pixel |= plane_masks[0];
		    if (i & 2) color.pixel |= plane_masks[1];
		    if (i & 4) color.pixel |= plane_masks[2];
		    if (i & 8) color.pixel |= plane_masks[3];
		    XStoreColor(DISP, our_colormap, &color);
		    palette[i] = color.pixel;
		}
		else {
		    if (XAllocColor(DISP, our_colormap, &color))
			palette[i] = color.pixel;
		    else
			palette[i] = (i * 100 >= density * 15)
			    ? fore_Pixel : back_Pixel;
		}
	    }

	    copyGC = MakeGC(GXcopy, fore_Pixel, back_Pixel);
	    foreGC = ruleGC = copy ? copyGC
	      : MakeGC(GXor, fore_Pixel, back_Pixel);
	    foreGC2 = NULL;

	    oldgamma = gamma;
	}

	if (mane.shrinkfactor == 1) return;

	if (shrink_allocated_for < mane.shrinkfactor) {
	    if (pixeltbl != NULL) free((char *) pixeltbl);
	    pixeltbl = xmalloc((unsigned)
		(mane.shrinkfactor * mane.shrinkfactor + 1) * sizeof(Pixel));
	    shrink_allocated_for = mane.shrinkfactor;
	}

	for (i = 0; i <= mane.shrinkfactor * mane.shrinkfactor; ++i)
	    pixeltbl[i] =
		palette[(i * 30 + mane.shrinkfactor * mane.shrinkfactor)
		    / (2 * mane.shrinkfactor * mane.shrinkfactor)];
}

#undef MakeGC

#endif /* GREY */

/*
 *	Event-handling routines
 */

void
expose(windowrec, x, y, w, h)
	struct WindowRec *windowrec;
	int		x, y;
	unsigned int	w, h;
{
	if (windowrec->min_x > x) windowrec->min_x = x;
	if (windowrec->max_x < x + w)
	    windowrec->max_x = x + w;
	if (windowrec->min_y > y) windowrec->min_y = y;
	if (windowrec->max_y < y + h)
	    windowrec->max_y = y + h;
	ev_flags |= EV_EXPOSE;
}

static	void
clearexpose(windowrec, x, y, w, h)
	struct WindowRec *windowrec;
	int		x, y;
	unsigned int	w, h;
{
	XClearArea(DISP, windowrec->win, x, y, w, h, False);
	expose(windowrec, x, y, w, h);
}

static	void
scrollwindow(windowrec, x0, y0)
	struct WindowRec *windowrec;
	int	x0, y0;
{
	int	x, y;
	int	x2 = 0, y2 = 0;
	int	ww, hh;

	x = x0 - windowrec->base_x;
	y = y0 - windowrec->base_y;
	ww = windowrec->width - x;
	hh = windowrec->height - y;
	windowrec->base_x = x0;
	windowrec->base_y = y0;
	if (currwin.win == windowrec->win) {
	    currwin.base_x = x0;
	    currwin.base_y = y0;
	}
	windowrec->min_x -= x;
	if (windowrec->min_x < 0) windowrec->min_x = 0;
	windowrec->max_x -= x;
	if (windowrec->max_x > windowrec->width)
	    windowrec->max_x = windowrec->width;
	windowrec->min_y -= y;
	if (windowrec->min_y < 0) windowrec->min_y = 0;
	windowrec->max_y -= y;
	if (windowrec->max_y > windowrec->height)
	    windowrec->max_y = windowrec->height;
	if (x < 0) {
	    x2 = -x;
	    x = 0;
	    ww = windowrec->width - x2;
	}
	if (y < 0) {
	    y2 = -y;
	    y = 0;
	    hh = windowrec->height - y2;
	}
	if (ww <= 0 || hh <= 0) {
	    XClearWindow(DISP, windowrec->win);
	    windowrec->min_x = windowrec->min_y = 0;
	    windowrec->max_x = windowrec->width;
	    windowrec->max_y = windowrec->height;
	}
	else {
	    XCopyArea(DISP, windowrec->win, windowrec->win, copyGC,
		x, y, (unsigned int) ww, (unsigned int) hh, x2, y2);
	    if (x > 0)
		clearexpose(windowrec, ww, 0,
		    (unsigned int) x, windowrec->height);
	    if (x2 > 0)
		clearexpose(windowrec, 0, 0,
		    (unsigned int) x2, windowrec->height);
	    if (y > 0)
		clearexpose(windowrec, 0, hh,
		    windowrec->width, (unsigned int) y);
	    if (y2 > 0)
		clearexpose(windowrec, 0, 0,
		    windowrec->width, (unsigned int) y2);
	}
}

#ifdef	TOOLKIT

/*
 *	routines for X11 toolkit
 */

static	Arg	arg_wh[] = {
	{XtNwidth,	(XtArgVal) &window_w},
	{XtNheight,	(XtArgVal) &window_h},
};

static	Position	window_x, window_y;
static	Arg	arg_xy[] = {
	{XtNx,		(XtArgVal) &window_x},
	{XtNy,		(XtArgVal) &window_y},
};

#define	get_xy()	XtGetValues(draw_widget, arg_xy, XtNumber(arg_xy))

#define	mane_base_x	0
#define	mane_base_y	0


#ifdef MOTIF

static	int
set_bar_value(bar, value, max)
	Widget	bar;
	int	value;
	int	max;
{
	XmScrollBarCallbackStruct	call_data;

	if (value > max) value = max;
	if (value < 0) value = 0;
	call_data.value = value;
	XtVaSetValues(bar, XmNvalue, value, NULL);
	XtCallCallbacks(bar, XmNvalueChangedCallback, &call_data);
	return value;
}

#endif /* MOTIF */


void
home(scrl)
	wide_bool	scrl;
{
	if (!scrl) XUnmapWindow(DISP, mane.win);
#ifndef MOTIF
	get_xy();
	if (x_bar != NULL) {
	    int coord = (page_w - clip_w) / 2;

	    if (coord > home_x / mane.shrinkfactor)
		coord = home_x / mane.shrinkfactor;
	    XtCallCallbacks(x_bar, XtNscrollProc,
		(XtPointer) (ptrdiff_t) (window_x + coord));
	}
	if (y_bar != NULL) {
	    int coord = (page_h - clip_h) / 2;

	    if (coord > home_y / mane.shrinkfactor)
		coord = home_y / mane.shrinkfactor;
	    XtCallCallbacks(y_bar, XtNscrollProc,
		(XtPointer) (ptrdiff_t) (window_y + coord));
	}
#else /* MOTIF */
	{
	    int value;

	    value = (page_w - clip_w) / 2;
	    if (value > home_x / mane.shrinkfactor)
		value = home_x / mane.shrinkfactor;
	    (void) set_bar_value(x_bar, value, (int) (page_w - clip_w));

	    value = (page_h - clip_h) / 2;
	    if (value > home_y / mane.shrinkfactor)
		value = home_y / mane.shrinkfactor;
	    (void) set_bar_value(y_bar, value, (int) (page_h - clip_h));
	}
#endif /* MOTIF */
	if (!scrl) {
	    XMapWindow(DISP, mane.win);
	    /* Wait for the server to catch up---this eliminates flicker. */
	    XSync(DISP, False);
	}
}

/*
 *	Same as home(), except move to the bottom of the page.
 */

static	void
home_bottom P1C(wide_bool, scrl)
{
	XUnmapWindow(DISP, mane.win);
#if XAW
	get_xy();
	if (x_bar != NULL) {
	    int coord = (page_w - clip_w) / 2;

	    if (coord > home_x / mane.shrinkfactor)
		coord = home_x / mane.shrinkfactor;
	    XtCallCallbacks(x_bar, XtNscrollProc,
		(XtPointer) (ptrdiff_t) (window_x + coord));
	}
	if (y_bar != NULL)
	    XtCallCallbacks(y_bar, XtNscrollProc,
		(XtPointer) (ptrdiff_t) (window_y + (page_h - clip_h)));
#else /* if MOTIF */
	{
	    int value;

	    value = (page_w - clip_w) / 2;
	    if (value > home_x / mane.shrinkfactor)
		value = home_x / mane.shrinkfactor;
	    (void) set_bar_value(x_bar, value, (int) (page_w - clip_w));

	    (void) set_bar_value(y_bar, (int) (page_h - clip_h),
	      (int) (page_h - clip_h));
	}
#endif /* MOTIF */
	XMapWindow(DISP, mane.win);
	/* Wait for the server to catch up---this eliminates flicker. */
	XSync(DISP, False);
}


#ifndef MOTIF
	/*ARGSUSED*/
static	void
handle_destroy_bar(w, client_data, call_data)
	Widget		w;
	XtPointer	client_data;
	XtPointer	call_data;
{
	* (Widget *) client_data = NULL;
}
#endif


static	Boolean	resized	= False;

static	void
get_geom()
{
	static	Dimension	new_clip_w, new_clip_h;
	static	Arg		arg_wh_clip[] = {
		{XtNwidth,	(XtArgVal) &new_clip_w},
		{XtNheight,	(XtArgVal) &new_clip_h},
	};
	int		old_clip_w;

	XtGetValues(vport_widget, arg_wh, XtNumber(arg_wh));
	XtGetValues(clip_widget, arg_wh_clip, XtNumber(arg_wh_clip));
#ifndef MOTIF
	/* Note:  widgets may be destroyed but not forgotten */
	if (x_bar == NULL) {
	    x_bar = XtNameToWidget(vport_widget, "horizontal");
	    if (x_bar != NULL)
		XtAddCallback(x_bar, XtNdestroyCallback, handle_destroy_bar,
		    (XtPointer) &x_bar);
	}
	if (y_bar == NULL) {
	    y_bar = XtNameToWidget(vport_widget, "vertical");
	    if (y_bar != NULL)
		XtAddCallback(y_bar, XtNdestroyCallback, handle_destroy_bar,
		    (XtPointer) &y_bar);
	}
#endif
	old_clip_w = clip_w;
			/* we need to do this because */
			/* sizeof(Dimension) != sizeof(int) */
	clip_w = new_clip_w;
	clip_h = new_clip_h;
	if (old_clip_w == 0) ev_flags |= EV_NEWPAGE;
	resized = False;
}

/*
 *	callback routines
 */

	/*ARGSUSED*/
void
handle_resize(widget, junk, event, cont)
	Widget	widget;
	XtPointer junk;
	XEvent	*event;
	Boolean	*cont;		/* unused */
{
	resized = True;
}

#ifdef	BUTTONS
	/*ARGSUSED*/
static	void
handle_command(widget, client_data, call_data)
	Widget	widget;
	XtPointer client_data;
	XtPointer call_data;
{
	struct xdvi_action	*actp;

	for (actp = (struct xdvi_action *) client_data;
	  actp != NULL;
	  actp = actp->next)
	    (actp->proc)(widget, NULL, &actp->param, &actp->num_params);
}

	/*ARGSUSED*/
static	void
handle_destroy_buttons(w, client_data, call_data)
	Widget		w;
	XtPointer	client_data;
	XtPointer	call_data;
{
	if (--destroy_count != 0) return;
#ifndef MOTIF
	XtSetValues(vport_widget, resizable_on, XtNumber(resizable_on));
	if (resource.expert) {
	    /* destroy buttons */
	    XtGetValues(form_widget, arg_wh, XtNumber(arg_wh));
	    XdviResizeWidget(vport_widget, window_w, window_h);
	}
	else {
	    create_buttons();	/* this determines xtra_wid */
	    XdviResizeWidget(vport_widget, window_w -= xtra_wid, window_h);
	    set_button_panel_height((XtArgVal) window_h);
	}
#else /* MOTIF */
	if (resource.expert)
	    XtVaSetValues(vport_widget,
	      XmNleftAttachment, XmATTACH_FORM,
	      XmNleftOffset, 0,
	      NULL);
	else {
	    create_buttons();
	    window_w -= xtra_wid;
	}
#endif /* MOTIF */
}
#endif	/* BUTTONS */

void
reconfig()
{
#if BUTTONS && !MOTIF
	XtSetValues(vport_widget, resizable_off, XtNumber(resizable_off));
#endif
	XdviResizeWidget(draw_widget, page_w, page_h);
	get_geom();
}

#else	/* not TOOLKIT */

/*
 *	brute force scrollbar routines
 */

static	void
paint_x_bar()
{
	int	new_x_bgn = mane.base_x * clip_w / page_w;
	int	new_x_end = (mane.base_x + clip_w) * clip_w / page_w;

	if (new_x_bgn >= x_end || x_bgn >= new_x_end) {	/* no overlap */
	    XClearArea(DISP, x_bar, x_bgn, 1, x_end - x_bgn, BAR_WID, False);
	    XFillRectangle(DISP, x_bar, copyGC,
		new_x_bgn, 1, new_x_end - new_x_bgn, BAR_WID);
	}
	else {		/* this stuff avoids flicker */
	    if (x_bgn < new_x_bgn)
		XClearArea(DISP, x_bar, x_bgn, 1, new_x_bgn - x_bgn,
		    BAR_WID, False);
	    else
		XFillRectangle(DISP, x_bar, copyGC,
		    new_x_bgn, 1, x_bgn - new_x_bgn, BAR_WID);
	    if (new_x_end < x_end)
		XClearArea(DISP, x_bar, new_x_end, 1, x_end - new_x_end,
		    BAR_WID, False);
	    else
		XFillRectangle(DISP, x_bar, copyGC,
		    x_end, 1, new_x_end - x_end, BAR_WID);
	}
	x_bgn = new_x_bgn;
	x_end = new_x_end;
}

static	void
paint_y_bar()
{
	int	new_y_bgn = mane.base_y * clip_h / page_h;
	int	new_y_end = (mane.base_y + clip_h) * clip_h / page_h;

	if (new_y_bgn >= y_end || y_bgn >= new_y_end) {	/* no overlap */
	    XClearArea(DISP, y_bar, 1, y_bgn, BAR_WID, y_end - y_bgn, False);
	    XFillRectangle(DISP, y_bar, copyGC,
		1, new_y_bgn, BAR_WID, new_y_end - new_y_bgn);
	}
	else {		/* this stuff avoids flicker */
	    if (y_bgn < new_y_bgn)
		XClearArea(DISP, y_bar, 1, y_bgn, BAR_WID, new_y_bgn - y_bgn,
		    False);
	    else
		XFillRectangle(DISP, y_bar, copyGC,
		    1, new_y_bgn, BAR_WID, y_bgn - new_y_bgn);
	    if (new_y_end < y_end)
		XClearArea(DISP, y_bar, 1, new_y_end,
		    BAR_WID, y_end - new_y_end, False);
	    else
		XFillRectangle(DISP, y_bar, copyGC,
		    1, y_end, BAR_WID, new_y_end - y_end);
	}
	y_bgn = new_y_bgn;
	y_end = new_y_end;
}

static	void
scrollmane(x, y)
	int	x, y;
{
	int	old_base_x = mane.base_x;
	int	old_base_y = mane.base_y;

	if (x > (int) (page_w - clip_w)) x = page_w - clip_w;
	if (x < 0) x = 0;
	if (y > (int) (page_h - clip_h)) y = page_h - clip_h;
	if (y < 0) y = 0;
	scrollwindow(&mane, x, y);
	if (old_base_x != mane.base_x && x_bar) paint_x_bar();
	if (old_base_y != mane.base_y && y_bar) paint_y_bar();
}

void
reconfig()
{
	int	x_thick = 0;
	int	y_thick = 0;

		/* determine existence of scrollbars */
	if (window_w < page_w) x_thick = BAR_THICK;
	if (window_h - x_thick < page_h) y_thick = BAR_THICK;
	clip_w = window_w - y_thick;
	if (clip_w < page_w) x_thick = BAR_THICK;
	clip_h = window_h - x_thick;

		/* process drawing (clip) window */
	if (mane.win == (Window) 0) {	/* initial creation */
	    XWindowAttributes attrs;

	    mane.win = XCreateSimpleWindow(DISP, top_level, y_thick, x_thick,
			(unsigned int) clip_w, (unsigned int) clip_h, 0,
			brdr_Pixel, back_Pixel);
	    XSelectInput(DISP, mane.win, ExposureMask |
			ButtonPressMask | ButtonMotionMask | ButtonReleaseMask);
	    (void) XGetWindowAttributes(DISP, mane.win, &attrs);
	    backing_store = attrs.backing_store;
	    XMapWindow(DISP, mane.win);
	}
	else
	    XMoveResizeWindow(DISP, mane.win, y_thick, x_thick, clip_w, clip_h);

		/* process scroll bars */
	if (x_thick) {
	    if (x_bar) {
		XMoveResizeWindow(DISP, x_bar,
		    y_thick - 1, -1, clip_w, BAR_THICK - 1);
		paint_x_bar();
	    }
	    else {
		x_bar = XCreateSimpleWindow(DISP, top_level, y_thick - 1, -1,
				(unsigned int) clip_w, BAR_THICK - 1, 1,
				brdr_Pixel, back_Pixel);
		XSelectInput(DISP, x_bar,
			ExposureMask | ButtonPressMask | Button2MotionMask);
		XMapWindow(DISP, x_bar);
	    }
	    x_bgn = mane.base_x * clip_w / page_w;
	    x_end = (mane.base_x + clip_w) * clip_w / page_w;
	}
	else
	    if (x_bar) {
		XDestroyWindow(DISP, x_bar);
		x_bar = (Window) 0;
	    }

	if (y_thick) {
	    if (y_bar) {
		XMoveResizeWindow(DISP, y_bar,
		    -1, x_thick - 1, BAR_THICK - 1, clip_h);
		paint_y_bar();
	    }
	    else {
		y_bar = XCreateSimpleWindow(DISP, top_level, -1, x_thick - 1,
				BAR_THICK - 1, (unsigned int) clip_h, 1,
				brdr_Pixel, back_Pixel);
		XSelectInput(DISP, y_bar,
			ExposureMask | ButtonPressMask | Button2MotionMask);
		XMapWindow(DISP, y_bar);
	    }
	    y_bgn = mane.base_y * clip_h / page_h;
	    y_end = (mane.base_y + clip_h) * clip_h / page_h;
	}
	else
	    if (y_bar) {
		XDestroyWindow(DISP, y_bar);
		y_bar = (Window) 0;
	    }
}

void
home(scrl)
	wide_bool	scrl;
{
	int	x = 0, y = 0;

	if (page_w > clip_w) {
	    x = (page_w - clip_w) / 2;
	    if (x > home_x / mane.shrinkfactor)
		x = home_x / mane.shrinkfactor;
	}
	if (page_h > clip_h) {
	    y = (page_h - clip_h) / 2;
	    if (y > home_y / mane.shrinkfactor)
		y = home_y / mane.shrinkfactor;
	}
	if (scrl)
	    scrollmane(x, y);
	else {
	    mane.base_x = x;
	    mane.base_y = y;
	    if (currwin.win == mane.win) {
		currwin.base_x = x;
		currwin.base_y = y;
	    }
	    if (x_bar) paint_x_bar();
	    if (y_bar) paint_y_bar();
	}
}

/*
 *	Same as home(), except move to the bottom of the page.
 */

static	void
home_bottom P1C(wide_bool, scrl)
{
	int	x = 0, y = 0;

	if (page_w > clip_w) {
	    x = (page_w - clip_w) / 2;
	    if (x > home_x / mane.shrinkfactor)
		x = home_x / mane.shrinkfactor;
	}
	if (page_h > clip_h)
	    y = page_h - clip_h;
	mane.base_x = x;
	mane.base_y = y;
	if (currwin.win == mane.win) {
	    currwin.base_x = x;
	    currwin.base_y = y;
	}
	if (x_bar) paint_x_bar();
	if (y_bar) paint_y_bar();
}

#define	get_xy()
#define	window_x 0
#define	window_y 0
#define	mane_base_x	mane.base_x
#define	mane_base_y	mane.base_y
#endif	/* not TOOLKIT */


/*
 *	goto_page is the only place where current_page should be set,
 *	other than when reading a new dvi file.
 */

static	home_proc	home_action	= home;

void
goto_page(n, proc)
	int		n;
	home_proc	proc;
{
	current_page = n;
	home_action = proc;
	warn_spec_now = warn_spec;
}


#if MOTIF

struct pd_act {
	XtActionProc	proc;
	Cardinal	num_params;
	String		param;
};

static void
do_pulldown_action(actp)
	struct pd_act	*actp;
{
	(actp->proc)(/* widget */ NULL, NULL, &actp->param, &actp->num_params);
}

static struct pd_act file_pulldown_actions[] = {
	{Act_open_dvi_file, 0, NULL},
	{Act_reread_dvi_file, 0, NULL},
	{Act_print, 0, NULL},
	{Act_quit, 0, NULL}};

/* ARGSUSED */
void
file_pulldown_callback(w, client_data, call_data)
	Widget		w;
	XtPointer	client_data;
	XtPointer	call_data;
{
	do_pulldown_action(file_pulldown_actions + (ptrdiff_t) client_data);
}

static struct pd_act navigate_pulldown_actions[] = {
	{Act_back_page, 1, "10"},
	{Act_back_page, 1, "5"},
	{Act_back_page, 0, NULL},
	{Act_forward_page, 0, NULL},
	{Act_forward_page, 1, "5"},
	{Act_forward_page, 1, "10"}};

/* ARGSUSED */
void
navigate_pulldown_callback(w, client_data, call_data)
	Widget		w;
	XtPointer	client_data;
	XtPointer	call_data;
{
	do_pulldown_action(navigate_pulldown_actions + (ptrdiff_t) client_data);
}


static struct pd_act scale_pulldown_actions[] = {
	{Act_set_shrink_factor, 1, "1"},
	{Act_set_shrink_factor, 1, "2"},
	{Act_set_shrink_factor, 1, "3"},
	{Act_set_shrink_factor, 1, "4"}};

/* ARGSUSED */
void
scale_pulldown_callback(w, client_data, call_data)
	Widget		w;
	XtPointer	client_data;
	XtPointer	call_data;
{
	do_pulldown_action(scale_pulldown_actions + (ptrdiff_t) client_data);
}

void
set_shrink_factor(shrink)
	int	shrink;
{
	static	Widget	active_shrink_button	= NULL;
	Widget		new_shrink_button;

	mane.shrinkfactor = shrink;
	new_shrink_button = (shrink > 0 && shrink <= XtNumber(shrink_button)
	  ? shrink_button[shrink - 1] : NULL);
	if (new_shrink_button != active_shrink_button) {
	    if (active_shrink_button != NULL)
		XmToggleButtonSetState(active_shrink_button, False, False);
	    if (new_shrink_button != NULL)
		XmToggleButtonSetState(new_shrink_button, True, False);
	    active_shrink_button = new_shrink_button;
	}
}

static	unsigned int	ungrab_serial	= 0;

/* ARGSUSED */
void
popdown_callback(w, client_data, call_data)
	Widget		w;
	XtPointer	client_data;
	XtPointer	call_data;
{
	/* Lesstif gives call_data == NULL */
	if (call_data != NULL && *((XtGrabKind *) call_data) != XtGrabNone)
	    ungrab_serial = LastKnownRequestProcessed(DISP);
}

#endif /* MOTIF */

#if !TOOLKIT

void
showmessage(message)
	_Xconst	char	*message;
{
	get_xy();
	XDrawImageString(DISP, mane.win, copyGC,
	    5 - window_x, 5 + X11HEIGHT - window_y, message, strlen(message));
}

#endif /* not TOOLKIT */


/* |||
 *	Currently the event handler does not coordinate XCopyArea requests
 *	with GraphicsExpose events.  This can lead to problems if the window
 *	is partially obscured and one, for example, drags a scrollbar.
 */

/*
 *	Actions for the translation mechanism.
 */

static	Boolean	have_arg	= False;
static	int	number		= 0;
static	int	sign		= 1;

#if TOOLKIT

#define	GET_ARG4(arg, param, param2, default)		\
		if (*num_params > 0)			\
		    {param;}				\
		else {					\
		    if (have_arg) {			\
			arg = (param2);			\
			have_arg = False;		\
			number = 0;			\
			sign = 1;			\
		    }					\
		    else				\
			{default}			\
		}

#define	GET_ARG(arg, default)				\
		GET_ARG4(arg, arg = atoi(*params), sign * number, \
		  arg = (default);)

#define	GET_ARG6(arg, param, c, param_c, param2, default)\
		if (*num_params > 0) {			\
		    if (**params == (c))		\
			{param_c;}			\
		    else				\
			{param;}			\
		}					\
		else {					\
		    if (have_arg) {			\
			arg = (param2);			\
			have_arg = False;		\
			number = 0;			\
			sign = 1;			\
		    }					\
		    else				\
			{default;}			\
		}

#define	TOGGLE(arg)							\
	if (*num_params > 0) {						\
	    if (**params != 't' && (atoi(*params) != 0) == arg)		\
		return;							\
	}								\
	else {								\
	    if (have_arg) {						\
		int	tmparg = number;				\
									\
		have_arg = False;					\
		number = 0;						\
		sign = 1;						\
									\
		if ((tmparg != 0) == arg)				\
		    return;						\
	    }								\
	}

#else /* not TOOLKIT */

static	unsigned char	keychar;

#define	GET_ARG4(arg, param, param2, default)		\
		if (have_arg) {				\
		    arg = (param2);			\
		    have_arg = False;			\
		    number = 0;				\
		    sign = 1;				\
		}					\
		else					\
		    {default}

#define	GET_ARG(arg, default)				\
		GET_ARG4(arg, NA, sign * number, arg = (default);)

#define	GET_ARG6(arg, param, c, param_c, param2, default)\
		if (have_arg) {				\
		    arg = (param2);			\
		    have_arg = False;			\
		    number = 0;				\
		    sign = 1;				\
		}					\
		else					\
		    {default;}

#define	TOGGLE(arg)					\
		if (have_arg) {				\
		    int	tmparg = number;		\
							\
		    have_arg = False;			\
		    number = 0;				\
		    sign = 1;				\
							\
		    if ((tmparg != 0) == arg)		\
			return;				\
		}

#endif /* not TOOLKIT */


static
ACTION(Act_digit)
{
	unsigned int	digit;

#if TOOLKIT
	if (*num_params != 1 || (digit = **params - '0') > 9) {
	    XBell(DISP, 0);
	    return;
	}
#else
	digit = keychar - '0';
#endif
	have_arg = True;
	number = number * 10 + digit;
}

static
ACTION(Act_minus)
{
	have_arg = True;
	sign = -sign;
}

static
ACTION(Act_quit)
{
#if !FLAKY_SIGPOLL
	if (debug & DBG_EVENT)
	    puts(event_freq < 0
	      ? "SIGPOLL is working"
	      : "no SIGPOLL signals received");
#endif
	xdvi_normal_exit();
}

static
ACTION(Act_goto_page)
{
	int	arg;

	GET_ARG6(arg, arg = atoi(*params) - pageno_correct,
	  'e', arg = total_pages - 1,
	  sign * number - pageno_correct, arg = total_pages - 1);

	if (arg < 0 || arg >= total_pages) {
	    XBell(DISP, 0);
	    return;
	}

	if (current_page != arg)
	    goto_page(arg, home);

	ev_flags |= EV_NEWPAGE;
	XFlush(DISP);
	return;		/* Don't use longjmp here:  it might be called from
			 * within the toolkit, and we don't want to longjmp out
			 * of Xt routines. */
}

static
ACTION(Act_forward_page)
{
	int	arg;

	GET_ARG(arg, 1);
	arg += current_page;

	if (arg >= 0 && arg < total_pages) {
	    if (current_page != arg)
		goto_page(arg, home);
	    /* Control-L (and changing the page) clears this box */
	    source_fwd_box_page = -1;
	    ev_flags |= EV_NEWPAGE;
	    XFlush(DISP);
	    return;	/* Don't use longjmp here:  it might be called from
			 * within the toolkit, and we don't want to longjmp out
			 * of Xt routines. */
	}
	XBell(DISP, 0);
}

static
ACTION(Act_back_page)
{
	int	arg;

	GET_ARG(arg, 1);
	arg = current_page - arg;

	if (arg >= 0 && arg < total_pages) {
	    if (current_page != arg)
		goto_page(arg, home);
	    ev_flags |= EV_NEWPAGE;
	    XFlush(DISP);
	    return;	/* Don't use longjmp here:  it might be called from
			 * within the toolkit, and we don't want to longjmp out
			 * of Xt routines. */
	}
	XBell(DISP, 0);
}

static
ACTION(Act_declare_page_number)
{
	int	arg;

	GET_ARG(arg, 0);
	pageno_correct = arg - current_page;
}

static
ACTION(Act_home)
{
	home(True);
}

static
ACTION(Act_center)
{
	int	x, y;

#if BUTTONS
	if (event == NULL)
	    return;		/* button actions do not provide events */
#endif

#if TOOLKIT
#if !MOTIF

	x = event->xkey.x - clip_w / 2;
	y = event->xkey.y - clip_h / 2;
	/* The clip widget gives a more exact value. */
	if (x_bar != NULL)
	    XtCallCallbacks(x_bar, XtNscrollProc, (XtPointer) (ptrdiff_t) x);
	if (y_bar != NULL)
	    XtCallCallbacks(y_bar, XtNscrollProc, (XtPointer) (ptrdiff_t) y);
	XWarpPointer(DISP, None, None, 0, 0, 0, 0, -x, -y);

#else /* MOTIF */

	get_xy();
	/* The clip widget gives a more exact value. */
	x = event->xkey.x - clip_w / 2;
	y = event->xkey.y - clip_h / 2;

	x = set_bar_value(x_bar, x, (int) (page_w - clip_w));
	y = set_bar_value(y_bar, y, (int) (page_h - clip_h));
	XWarpPointer(DISP, None, None, 0, 0, 0, 0,
	  -x - window_x, -y - window_y);

#endif /* MOTIF */
#else /* not TOOLKIT */

	x = clip_w / 2 - event->xkey.x;
	if (x > mane.base_x) x = mane.base_x;
	y = clip_h / 2 - event->xkey.y;
	if (y > mane.base_y) y = mane.base_y;
	scrollwindow(&mane, mane.base_x - x, mane.base_y - y);
	if (x_bar) paint_x_bar();
	if (y_bar) paint_y_bar();
	XWarpPointer(DISP, None, None, 0, 0, 0, 0, x, y);

#endif /* not TOOLKIT */

}

static
ACTION(Act_set_keep_flag)
{

#if TOOLKIT
	if (*num_params == 0) {
#endif
	    if (have_arg) {
		resource.keep_flag = (number != 0);
		have_arg = False;
		number = 0;
		sign = 1;
	    }
	    else
		resource.keep_flag = !resource.keep_flag;
#if TOOLKIT
	}
	else
	    resource.keep_flag = (**params == 't'
	      ? !resource.keep_flag
	      : atoi(*params));
#endif
}

static
ACTION(Act_left)
{
#if TOOLKIT
#if !MOTIF
	if (x_bar != NULL)
	    XtCallCallbacks(x_bar, XtNscrollProc,
	      (XtPointer) (*num_params == 0 ? (-2 * (ptrdiff_t) clip_w / 3)
	      : (ptrdiff_t) (-atof(*params) * clip_w)));
	else
	    XBell(DISP, 0);
#else /* MOTIF */
	get_xy();
	(void) set_bar_value(x_bar, (*num_params == 0 ? (-2 * (int) clip_w / 3)
	  : (int) (-atof(*params) * clip_w)) - window_x,
	  (int) (page_w - clip_w));
#endif /* MOTIF */
#else /* not TOOLKIT */
	if (mane.base_x > 0)
	    scrollmane(mane.base_x - 2 * (int) clip_w / 3, mane.base_y);
	else
	    XBell(DISP, 0);
#endif /* not TOOLKIT */
}

static
ACTION(Act_right)
{
#if TOOLKIT
#if !MOTIF
	if (x_bar != NULL)
	    XtCallCallbacks(x_bar, XtNscrollProc,
	      (XtPointer) (*num_params == 0 ? (2 * (ptrdiff_t) clip_w / 3)
	      : (ptrdiff_t) (atof(*params) * clip_w)));
	else
	    XBell(DISP, 0);
#else /* MOTIF */
	get_xy();
	(void) set_bar_value(x_bar, (*num_params == 0 ? (2 * (int) clip_w / 3)
	  : (int) (atof(*params) * clip_w)) - window_x,
	  (int) (page_w - clip_w));
#endif /* MOTIF */
#else /* not TOOLKIT */
	if (mane.base_x < (int) page_w - (int) clip_w)
	    scrollmane(mane.base_x + 2 * (int) clip_w / 3, mane.base_y);
	else
	    XBell(DISP, 0);
#endif /* not TOOLKIT */
}

static
ACTION(Act_up)
{
#if TOOLKIT
#if !MOTIF
	if (y_bar != NULL)
	    XtCallCallbacks(y_bar, XtNscrollProc,
	      (XtPointer) (*num_params == 0 ? (-2 * (ptrdiff_t) clip_h / 3)
	      : (ptrdiff_t) (-atof(*params) * clip_h)));
	else
	    XBell(DISP, 0);
#else /* MOTIF */
	get_xy();
	(void) set_bar_value(y_bar, (*num_params == 0 ? (-2 * (int) clip_h / 3)
	  : (int) (-atof(*params) * clip_h)) - window_y,
	  (int) (page_h - clip_h));
#endif /* MOTIF */
#else /* not TOOLKIT */
	if (mane.base_y > 0)
	    scrollmane(mane.base_x, mane.base_y - 2 * (int) clip_h / 3);
	else
	    XBell(DISP, 0);
#endif /* not TOOLKIT */
}

static
ACTION(Act_down)
{
#if TOOLKIT
#if !MOTIF
	if (y_bar != NULL)
	    XtCallCallbacks(y_bar, XtNscrollProc,
	      (XtPointer) (*num_params == 0 ? (2 * (ptrdiff_t) clip_h / 3)
	      : (ptrdiff_t) (atof(*params) * clip_h)));
	else
	    XBell(DISP, 0);
#else /* MOTIF */
	get_xy();
	(void) set_bar_value(y_bar, (*num_params == 0 ? (2 * (int) clip_h / 3)
	  : (int) (atof(*params) * clip_h)) - window_y,
	  (int) (page_h - clip_h));
#endif /* MOTIF */
#else /* not TOOLKIT */
	if (mane.base_y < (int) page_h - (int) clip_h)
	    scrollmane(mane.base_x, mane.base_y + 2 * (int) clip_h / 3);
	else
	    XBell(DISP, 0);
#endif /* not TOOLKIT */
}

static
ACTION(Act_down_or_next)
{
	if (!resource.keep_flag) {
#if TOOLKIT
#if !MOTIF
	    if (y_bar != NULL) {
		get_xy();
		if (window_y > (int) clip_h - (int) page_h) {
		    XtCallCallbacks(y_bar, XtNscrollProc,
		      (XtPointer) (*num_params == 0
		      ? (2 * (ptrdiff_t) clip_h / 3)
		      : (ptrdiff_t) (atof(*params) * clip_h)));
		    return;
		}
	    }
#else /* MOTIF */
	    get_xy();
	    if (window_y > (int) clip_h - (int) page_h) {
		(void) set_bar_value(y_bar,
		  (*num_params == 0 ? (2 * (int) clip_h / 3)
		  : (int) (atof(*params) * clip_h)) - window_y,
		  (int) (page_h - clip_h));
		return;
	    }
#endif /* MOTIF */
#else /* not TOOLKIT */
	    if (mane.base_y < (int) page_h - (int) clip_h) {
		scrollmane(mane.base_x, mane.base_y + 2 * (int) clip_h / 3);
		return;
	    }
#endif /* not TOOLKIT */
	} /* !keep_flag */

	if (current_page < total_pages - 1) {
	    goto_page(current_page + 1, home);
	    ev_flags |= EV_NEWPAGE;
	    XFlush(DISP);
	    return;	/* Don't use longjmp here:  it might be called from
			 * within the toolkit, and we don't want to longjmp out
			 * of Xt routines. */
	}
	else
	    XBell(DISP, 0);
}

static
ACTION(Act_up_or_previous)
{
	if (!resource.keep_flag) {
#if TOOLKIT
#if !MOTIF
	    if (y_bar != NULL) {
		get_xy();
		if (window_y < 0) {
		    XtCallCallbacks(y_bar, XtNscrollProc,
		      (XtPointer) (*num_params == 0
		      ? (-2 * (ptrdiff_t) clip_h / 3)
		      : (ptrdiff_t) (-atof(*params) * clip_h)));
		    return;
		}
	    }
#else /* MOTIF */
	    get_xy();
	    if (window_y < 0) {
		(void) set_bar_value(y_bar,
		  (*num_params == 0 ? (-2 * (int) clip_h / 3)
		  : (int) (-atof(*params) * clip_h)) - window_y,
		  (int) (page_h - clip_h));
		return;
	    }
#endif /* MOTIF */
#else /* not TOOLKIT */
	    if (mane.base_y > 0) {
		scrollmane(mane.base_x, mane.base_y - 2 * (int) clip_h / 3);
		return;
	    }
#endif /* not TOOLKIT */
	} /* !keep_flag */

	if (current_page > 0) {
	    goto_page(current_page - 1, home_bottom);
	    ev_flags |= EV_NEWPAGE;
	    XFlush(DISP);
	    return;	/* Don't use longjmp here:  it might be called from
			 * within the toolkit, and we don't want to longjmp out
			 * of Xt routines. */
	}
	else
	    XBell(DISP, 0);
}

static
ACTION(Act_set_margins)
{
	Window	ww;

#if BUTTONS
	if (event == NULL)
	    return;		/* button actions do not provide events */
#endif

	(void) XTranslateCoordinates(DISP, event->xkey.window, mane.win,
	  event->xkey.x, event->xkey.y, &home_x, &home_y,
	  &ww);		/* throw away last argument */
	home_x *= mane.shrinkfactor;
	home_y *= mane.shrinkfactor;
}

static
ACTION(Act_show_display_attributes)
{
	Printf("Unit = %d, bitord = %d, byteord = %d\n",
	    BitmapUnit(DISP), BitmapBitOrder(DISP), ImageByteOrder(DISP));
}

static	int
shrink_to_fit()
{
	int	value1;
	int	value2;

	value1 = ROUNDUP(unshrunk_page_w, window_w - 2);

#if !MOTIF
	value2 = ROUNDUP(unshrunk_page_h, window_h - 2);
#else /* MOTIF */
	{	/* account for menubar */
	    static	Dimension	new_h;

	    /* get rid of scrollbar */
	    XdviResizeWidget(draw_widget, 1, 1);
	    XtVaGetValues(clip_widget, XtNheight, &new_h, NULL);
	    value2 = ROUNDUP(unshrunk_page_h, new_h - 2);
	}
#endif /* MOTIF */

	return value1 > value2 ? value1 : value2;
}

static
ACTION(Act_set_shrink_factor)
{
	int	arg;

	GET_ARG6(arg, arg = atoi(*params), 'a', arg = shrink_to_fit(),
	  number, arg = shrink_to_fit());

	if (arg <= 0) {
	    XBell(DISP, 0);
	    return;
	}

	if (arg == mane.shrinkfactor)
	    return;
#if !MOTIF
	mane.shrinkfactor = arg;
#else
	set_shrink_factor(arg);
#endif
	if (arg != 1 && arg != bak_shrink) {
	    bak_shrink = arg;
#if GREY
#if COLOR
	    if (use_grey) fg_active = NULL;
#else
	    if (use_grey) init_pix();
#endif
#endif /* GREY */
	    reset_fonts();
	}

	if (dvi_file == NULL) {
	    unshrunk_page_w = unshrunk_page_h = 0;
	    return;
	}

	init_page();
	reconfig();
	home(False);
	ev_flags |= EV_NEWPAGE;
	XFlush(DISP);
}

static
ACTION(Act_shrink_to_dpi)
{
	int	arg;

	GET_ARG(arg, 0);

	if (arg > 0)
	    arg = (double) pixels_per_inch / arg + 0.5;

	if (arg <= 0) {
	    XBell(DISP, 0);
	    return;
	}

	if (arg == mane.shrinkfactor)
	    return;
#if !MOTIF
	mane.shrinkfactor = arg;
#else
	set_shrink_factor(arg);
#endif
	if (arg != 1 && arg != bak_shrink) {
	    bak_shrink = arg;
#if GREY
#if COLOR
	    if (use_grey) fg_active = NULL;
#else
	    if (use_grey) init_pix();
#endif
#endif /* GREY */
	    reset_fonts();
	}

	if (dvi_file == NULL) {
	    unshrunk_page_w = unshrunk_page_h = 0;
	    return;
	}

	init_page();
	reconfig();
	home(False);
	ev_flags |= EV_NEWPAGE;
	XFlush(DISP);
}

static
ACTION(Act_set_density)
{
	int	arg;

	GET_ARG4(arg, arg = atoi(*params), sign * number,
	  {XBell(DISP, 0); return;});

#if GREY
	if (use_grey) {
	    float newgamma = arg != 0 ? arg / 100.0 : 1.0;

	    if (newgamma == gamma)
		return;
	    gamma = newgamma;
#if COLOR
	    fg_active = NULL;
	    reset_colors();
#else
	    init_pix();
	    if (our_visual->class != TrueColor)
		return;
	    reset_fonts();
#endif /* COLOR */
	}
	else
#endif /* GREY */
	{
	    if (arg < 0) {
		XBell(DISP, 0);
		return;
	    }
	    if (arg == density)
		return;
	    density = arg;
	    reset_fonts();
	    if (mane.shrinkfactor == 1)
		return;
	}
	ev_flags |= EV_NEWPAGE;
	XFlush(DISP);
}

#if GREY

static
ACTION(Act_set_greyscaling)
{
	TOGGLE(use_grey);
	use_grey = !use_grey;

	if (use_grey) {
	    if (our_visual->class != TrueColor)
		init_plane_masks();
#if COLOR
	    fg_active = NULL;
#else
	    init_pix();
#endif
	}
	reset_fonts();
	ev_flags |= EV_NEWPAGE;
	XFlush(DISP);
}

#endif /* GREY */

#if COLOR

static
ACTION(Act_set_color)
{
	TOGGLE(use_color)

	if (use_color) {
	    use_color = False;
	    full_reset_colors();
	    scanned_page_color = total_pages;
#if PS
	    if (ignore_papersize_specials || scanned_page_ps <= total_pages)
		scanned_page = scanned_page_ps;
#endif
	}
	else {
	    use_color = True;
	    scanned_page = scanned_page_color = scanned_page_reset;
	}
	ev_flags |= EV_NEWPAGE;
}

#endif /* COLOR */

#if PS

static
ACTION(Act_set_ps)
{
	TOGGLE(resource._postscript)

	if (resource._postscript) {
	    resource._postscript = False;
	    scanned_page_ps_bak = scanned_page_ps;
	    scanned_page_ps = total_pages;
#if COLOR
	    if (ignore_papersize_specials || scanned_page_color <= total_pages)
		scanned_page = scanned_page_color;
#endif
	}
	else {
	    resource._postscript = True;
	    scanned_page_ps = scanned_page_ps_bak;
	    if (scanned_page > scanned_page_ps)
		scanned_page = scanned_page_ps;
	}

	psp.toggle();
	ev_flags |= EV_PS_TOGGLE;
	XFlush(DISP);
}

#endif /* PS */

#if PS_GS

static
ACTION(Act_set_gs_alpha)
{
	TOGGLE(resource.gs_alpha)
	resource.gs_alpha = !resource.gs_alpha;

	ev_flags |= EV_PS_TOGGLE;
	XFlush(DISP);
}

#endif /* PS_GS */

#if BUTTONS

static
ACTION(Act_set_expert_mode)
{
	TOGGLE(resource.expert)

	if (resource.expert) {	/* create buttons */
	    resource.expert = False;
	    if (destroy_count != 0) return;
#if !MOTIF
	    create_buttons();	/* this determines xtra_wid */
	    XtSetValues(vport_widget, resizable_on, XtNumber(resizable_on));
	    XdviResizeWidget(vport_widget, window_w -= xtra_wid, window_h);
	    set_button_panel_height((XtArgVal) window_h);
#else /* MOTIF */
	    create_buttons();
	    window_w -= xtra_wid;
#endif /* MOTIF */
	}
	else {		/* destroy buttons */
	    resource.expert = True;
	    if (destroy_count != 0) return;
	    destroy_count = 2;
	    XtAddCallback(panel_widget, XtNdestroyCallback,
		handle_destroy_buttons, (XtPointer) 0);
	    XtAddCallback(line_widget, XtNdestroyCallback,
		handle_destroy_buttons, (XtPointer) 0);
	    XtDestroyWidget(panel_widget);
	    XtDestroyWidget(line_widget);
	    window_w += xtra_wid;
	    while (b_head != NULL) {
		struct button_info *bp = b_head;
		struct xdvi_action *action;

		b_head = bp->next;
		free(bp->label);
		/* free bp->action */
		for (action = bp->action; action != NULL; ) {
		    struct xdvi_action *act2 = action;

		    action = act2->next;
		    if (act2->num_params > 0) free(act2->param);
		    free(act2);
		}
		free(bp);
	    }
	}
}

#endif /* BUTTONS */

#if !TOOLKIT

static
ACTION(Act_redraw)
{
	ev_flags |= EV_NEWPAGE;
	XFlush(DISP);
}

#endif /* not TOOLKIT */

static
ACTION(Act_reread_dvi_file)
{
#if PS
	ps_clear_cache();
#endif
	if (dvi_file != NULL) {
	    Fclose(dvi_file);
	    dvi_file = NULL;
	    dvi_file_ready = False;
	}
	ev_flags |= EV_NEWDOC;
}

static
ACTION(Act_discard_number)
{
	have_arg = False;
	number = 0;
	sign = 1;
}


/* Actions to support the magnifying glass.  */

static	void	mag_motion ARGS((XEvent *));
static	void	mag_release ARGS((XEvent *));

static	void
compute_mag_pos(xp, yp)
	int	*xp, *yp;
{
	int	t;

	t = mag_x + main_x - alt.width/2;
	if (t > WidthOfScreen(SCRN) - (int) alt.width - 2*MAGBORD)
	    t = WidthOfScreen(SCRN) - (int) alt.width - 2*MAGBORD;
	if (t < 0) t = 0;
	*xp = t;
	t = mag_y + main_y - alt.height/2;
	if (t > HeightOfScreen(SCRN) - (int) alt.height - 2*MAGBORD)
	    t = HeightOfScreen(SCRN) - (int) alt.height - 2*MAGBORD;
	if (t < 0) t = 0;
	*yp = t;
}

static
ACTION(Act_magnifier)
{
	_Xconst char		*p;
	int			x, y;
	XSetWindowAttributes	attr;
#if XAW
	Window			throwaway;
#elif !TOOLKIT
	struct mg_size_rec	*size_ptr = mg_size + event->xbutton.button - 1;
#endif


	/*
	 * Don't pop up a magnifying glass if we're still generating fonts or
	 * prescanning (e.g., bg_current might be NULL).
	 */

	if (!check_dvi_file() || !dvi_file_ready)
	    return;

#if MOTIF
	/*
	 * There's an apparent bug in Motif related to the interaction between
	 * the menubar menus and the magnifier.
	 *
	 * If you click on a menu on the menubar and then click on the drawing
	 * widget to pop up a magnifier, the keyboard and pointer are still
	 * grabbed, leading to a weird situation in which the magnifier stays
	 * around even after you release the pointer.  The following statement
	 * works around this bug by ignoring such pointer events.
	 *
	 * This bug occurs in Motif 1.2 and OpenMotif 2.2.2 (at least).  It
	 * does not occur in Lesstif.
	 */

	if (event->xany.serial < ungrab_serial)
	    return;
#endif

#if TOOLKIT

	if (event->type != ButtonPress || mouse_release != null_mouse
	  || alt.win != (Window) 0 || mane.shrinkfactor == 1
	  || *num_params != 1) {
	    XBell(DISP, 0);
	    return;
	}

	p = *params;
	if (*p == '*') {
	    int n = atoi(p + 1) - 1;

	    if (n < 0 || n >= 5 || mg_size[n].w <= 0) {
		XBell(DISP, 0);
		return;
	    }
	    alt.width = mg_size[n].w;
	    alt.height = mg_size[n].h;
	}
	else {
	    alt.width = alt.height = atoi(p);
	    p = index(p, 'x');
	    if (p != NULL) {
		alt.height = atoi(p + 1);
		if (alt.height == 0) alt.width = 0;
	    }
	    if (alt.width == 0) {
		XBell(DISP, 0);
		return;
	    }
	}
#if !MOTIF
	(void) XTranslateCoordinates(DISP, event->xbutton.window, mane.win,
	  0, 0, &mag_conv_x, &mag_conv_y, &throwaway);
#endif

#else /* not TOOLKIT */

	if (mouse_release != null_mouse || alt.win != (Window) 0
	  || mane.shrinkfactor == 1 || size_ptr->w <= 0) {
	    XBell(DISP, 0);
	    return;
	}

	alt.width = size_ptr->w;
	alt.height = size_ptr->h;

#endif /* not TOOLKIT */

	mag_x = event->xbutton.x + mag_conv_x;
	mag_y = event->xbutton.y + mag_conv_y;
	main_x = event->xbutton.x_root - mag_x;
	main_y = event->xbutton.y_root - mag_y;
	compute_mag_pos(&x, &y);
	alt.base_x = (mag_x + mane_base_x) * mane.shrinkfactor - alt.width/2;
	alt.base_y = (mag_y + mane_base_y) * mane.shrinkfactor - alt.height/2;
	attr.save_under = True;
	attr.border_pixel = brdr_Pixel;
#if COLOR
	attr.background_pixel = bg_current->pixel;
#else
	attr.background_pixel = back_Pixel;
#endif
	attr.override_redirect = True;
#ifdef GREY
	attr.colormap = our_colormap;
#endif
	alt.win = XCreateWindow(DISP, RootWindowOfScreen(SCRN),
		    x, y, alt.width, alt.height, MAGBORD,
		    our_depth, InputOutput, our_visual,
		    CWSaveUnder | CWBorderPixel | CWBackPixel |
#ifdef GREY
		    CWColormap |
#endif
		    CWOverrideRedirect, &attr);
	XSelectInput(DISP, alt.win, ExposureMask);
	XMapWindow(DISP, alt.win);
	alt_stat = 1;	/* waiting for exposure */
	mouse_motion = mag_motion;
	mouse_release = mag_release;
}

static	void
mag_motion P1C(XEvent *, event)
{
	new_mag_x = event->xmotion.x + mag_conv_x;
	main_x = event->xmotion.x_root - new_mag_x;
	new_mag_y = event->xmotion.y + mag_conv_y;
	main_y = event->xmotion.y_root - new_mag_y;

	if (new_mag_x != mag_x || new_mag_y != mag_y)
	    ev_flags |= EV_MAG_MOVE;
	else
	    ev_flags &= ~EV_MAG_MOVE;
}

/* ARGSUSED */
static	void
mag_release P1C(XEvent *, event)
{
	if (alt.win != (Window) 0) {
	    if (alt_stat)
		alt_stat = -1;	/* destroy upon expose */
	    else {
		XDestroyWindow(DISP, alt.win);
		if (drawing_mag) ev_flags |= EV_MAG_GONE;
		alt.win = (Window) 0;
		mouse_motion = mouse_release = null_mouse;
		ev_flags &= ~EV_MAG_MOVE;
		can_exposures(&alt);
	    }
	}
}

static	void
movemag(x, y)
	int	x, y;
{
	int	xx, yy;

	mag_x = x;
	mag_y = y;
	if (mag_x == new_mag_x && mag_y == new_mag_y) ev_flags &= ~EV_MAG_MOVE;
	compute_mag_pos(&xx, &yy);
	XMoveWindow(DISP, alt.win, xx, yy);
	scrollwindow(&alt,
	    (x + mane_base_x) * mane.shrinkfactor - (int) alt.width/2,
	    (y + mane_base_y) * mane.shrinkfactor - (int) alt.height/2);
}


/* Actions to support dragging the image.  */

static	int	drag_last_x, drag_last_y;	/* last position of cursor */
static	int	drag_flags;			/* 1 = vert, 2 = horiz */

static	void	drag_motion ARGS((XEvent *));
static	void	drag_release ARGS((XEvent *));

static
ACTION(Act_drag)
{
	if (mouse_release != null_mouse && mouse_release != drag_release)
	    return;

#if TOOLKIT

	if (*num_params != 1) return;
	switch (**params) {
	    case '|':  drag_flags = 1; break;
	    case '-':  drag_flags = 2; break;
	    case '+':  drag_flags = 3; break;
	    default:   return;
	}

#else /* not TOOLKIT */

	drag_flags = event->xbutton.button;
	if (drag_flags <= 0 || drag_flags > 3)
	    return;
	drag_flags = drag_flags ^ (drag_flags >> 1);

#endif /* not TOOLKIT */

	if (mouse_release == null_mouse) {
	    mouse_motion = drag_motion;
	    mouse_release = drag_release;
	    drag_last_x = event->xbutton.x_root;
	    drag_last_y = event->xbutton.y_root;
	}
	else
	    drag_motion(event);

#if COLOR
	{
	    static Boolean	curs_pix_set[3]	= {False, False, False};
	    static Pixel	cursor_pix[3];

	    if (bg_current != NULL && (!curs_pix_set[drag_flags - 1]
	      || cursor_pix[drag_flags - 1] != bg_current->pixel)) {
		XRecolorCursor(DISP, drag_cursor[drag_flags - 1], &cr_Color,
		  &bg_Color);
		cursor_pix[drag_flags - 1] = bg_current->pixel;
		curs_pix_set[drag_flags - 1] = True;
	    }
	}
#endif

	XDefineCursor(DISP, CURSORWIN, drag_cursor[drag_flags - 1]);
	XFlush(DISP);
	dragcurs = True;
}


static	void
drag_motion P1C(XEvent *, event)
{
#if MOTIF
	get_xy();
#endif

	if (drag_flags & 2) {	/* if horizontal motion */
#if TOOLKIT
#if !MOTIF
	    if (x_bar != NULL)
		XtCallCallbacks(x_bar, XtNscrollProc,
		  (XtPointer) (ptrdiff_t)
		  (drag_last_x - event->xbutton.x_root));
#else /* MOTIF */
	    (void) set_bar_value(x_bar,
	      drag_last_x - event->xbutton.x_root - window_x,
	      (int) (page_w - clip_w));
#endif /* MOTIF */
#else /* not TOOLKIT */
	    scrollmane(mane.base_x + drag_last_x - event->xbutton.x_root,
	      mane.base_y);
#endif /* not TOOLKIT */
	    drag_last_x = event->xbutton.x_root;
	}

	if (drag_flags & 1) {	/* if vertical motion */
#if TOOLKIT
#if !MOTIF
	    if (y_bar != NULL)
		XtCallCallbacks(y_bar, XtNscrollProc,
		  (XtPointer) (ptrdiff_t)
		  (drag_last_y - event->xbutton.y_root));
#else /* MOTIF */
	    (void) set_bar_value(y_bar,
	      drag_last_y - event->xbutton.y_root - window_y,
	      (int) (page_h - clip_h));
#endif /* MOTIF */
#else /* not TOOLKIT */
	    scrollmane(mane.base_x,
	      mane.base_y + drag_last_y - event->xbutton.y_root);
#endif /* not TOOLKIT */
	    drag_last_y = event->xbutton.y_root;
	}
}


static	void
drag_release P1C(XEvent *, event)
{
	drag_motion(event);
	mouse_motion = mouse_release = null_mouse;

	XDefineCursor(DISP, CURSORWIN,
	  ev_flags & EV_CURSOR ? redraw_cursor : ready_cursor);
	XFlush(DISP);
	dragcurs = False;
}



/* Wheel support.  */

static	int	wheel_button	= -1;

static
ACTION(Act_wheel)
{
#if TOOLKIT
	int	dist;

	if (*num_params == 0) {
	    XBell(DISP, 0);
	    return;
	}
	dist = (index(*params, '.') == NULL) ? atoi(*params)
	  : (int) (atof(*params) * resource.wheel_unit);
#if !MOTIF
	if (y_bar != NULL)
	    XtCallCallbacks(y_bar, XtNscrollProc, (XtPointer) (ptrdiff_t) dist);
#else /* MOTIF */
	get_xy();
	(void) set_bar_value(y_bar, dist - window_y, (int) (page_h - clip_h));
#endif /* MOTIF */
#else /* not TOOLKIT */
	scrollmane(mane.base_x,
	  mane.base_y + (event->xbutton.button == 5
	  ? resource.wheel_unit : -resource.wheel_unit));
#endif /* not TOOLKIT */

#if TOOLKIT
	if (event != NULL)
#endif
	    wheel_button = event->xbutton.button;
}

static	int	wheel_h_button	= -1;

static
ACTION(Act_hwheel)
{
#if TOOLKIT
	int	dist;

	if (*num_params == 0) {
	    XBell(DISP, 0);
	    return;
	}
	dist = (index(*params, '.') == NULL) ? atoi(*params)
	  : (int) (atof(*params) * resource.wheel_unit);
#if !MOTIF
	if (x_bar != NULL)
	    XtCallCallbacks(x_bar, XtNscrollProc, (XtPointer) (ptrdiff_t) dist);
#else /* MOTIF */
	get_xy();
	(void) set_bar_value(x_bar, dist - window_x, (int) (page_w - clip_w));
#endif /* MOTIF */
#else /* not TOOLKIT */
	scrollmane(mane.base_x + (event->xbutton.button == 7
	  ? resource.wheel_unit : -resource.wheel_unit),
	  mane.base_y);
#endif /* not TOOLKIT */

#if TOOLKIT
	if (event != NULL)
#endif
	    wheel_h_button = event->xbutton.button;
}

#if TOOLKIT
static
ACTION(Act_wheel_actions)
{
	struct wheel_acts *wactp;
	struct xdvi_action *actp;

	for (wactp = wheel_actions; wactp != NULL; wactp = wactp->next)
	    if (event->xbutton.button == wactp->button || wactp->button == 0) {
		Modifiers mask = 0;
		Modifiers value = 0;

		if (wactp->late_bindings == NULL
		  || _XtComputeLateBindings(DISP, wactp->late_bindings,
		  &value, &mask)) {
		    mask |= wactp->mask;
		    value |= wactp->value;
		    if (((value ^ event->xbutton.state) & mask) == 0) {
			for (actp = wactp->action; actp != NULL;
			  actp = actp->next)
			    (actp->proc)(w, event,
			      &actp->param, &actp->num_params);
			return;
		    }
		}
	    }
}
#endif /* TOOLKIT */


/* Internal mouse actions.  */

#if TOOLKIT

static
ACTION(Act_motion)
{
	if (event->xbutton.button != wheel_button
	   && event->xbutton.button != wheel_h_button)
	    mouse_motion(event);
}


static
ACTION(Act_release)
{
	if (event->xbutton.button == wheel_button) {
	    wheel_button = -1;
	    return;
	}

	if (event->xbutton.button == wheel_h_button) {
	    wheel_h_button = -1;
	    return;
	}

	mouse_release(event);
}

#endif /* TOOLKIT */


/* Actions for source specials.  */

ACTION(Act_source_special)
{
	Window	ww;

	if ((event->type == ButtonPress && mouse_release != null_mouse)
	  || alt.win != (Window) 0) {
	    XBell(DISP, 0);
	    return;
	}

	source_reverse_x = event->xbutton.x;
	source_reverse_y = event->xbutton.y;
	if (event->xbutton.window != mane.win)
	    (void) XTranslateCoordinates(DISP,
	      RootWindowOfScreen(SCRN), mane.win,
	      event->xbutton.x_root, event->xbutton.y_root,
	      &source_reverse_x, &source_reverse_y,
	      &ww);	/* throw away last argument */

	source_reverse_x = (source_reverse_x + mane_base_x) * mane.shrinkfactor;
	source_reverse_y = (source_reverse_y + mane_base_y) * mane.shrinkfactor;

	ev_flags |= EV_SRC;
}

ACTION(Act_show_source_specials)
{
	if ((event->type == ButtonPress && mouse_release != null_mouse)
	  || alt.win != (Window) 0) {
	    XBell(DISP, 0);
	    return;
	}

	if (!(ev_flags & EV_SRC)) {
	    source_reverse_x = -1;
	    source_show_all = False;
	    ev_flags |= EV_SRC;
	}
}

ACTION(Act_show_all_boxes)
{
	if ((event->type == ButtonPress && mouse_release != null_mouse)
	  || alt.win != (Window) 0) {
	    XBell(DISP, 0);
	    return;
	}

	if (!(ev_flags & EV_SRC)) {
	    source_reverse_x = -1;
	    source_show_all = True;
	    ev_flags |= EV_SRC;
	}
}


#undef	ACTION
#undef	GET_ARG4
#undef	GET_ARG
#undef	TOGGLE


#if TOOLKIT

	/*ARGSUSED*/
void
handle_expose(widget, closure, ev, cont)
	Widget	widget;
	XtPointer closure;
	XEvent	*ev;
#define	event	(&(ev->xexpose))
	Boolean	*cont;		/* unused */
{
	struct WindowRec *windowrec = (struct WindowRec *) closure;

	if (windowrec == &alt) {
	    if (alt_stat < 0) {	/* destroy upon exposure */
		alt_stat = 0;
		mag_release(ev);
		return;
	    }
	    else
		alt_stat = 0;
	}

	expose(windowrec, event->x, event->y,
	    (unsigned int) event->width, (unsigned int) event->height);
}

#undef	event
#endif	/* TOOLKIT */


void
#if TOOLKIT
/* ARGSUSED */
handle_property_change(widget, junk, ev, cont)
	Widget	widget;
	XtPointer junk;
	XEvent	*ev;
	Boolean	*cont;		/* unused */
#else /* !TOOLKIT */
handle_property_change(ev)
	XEvent *ev;
#endif
#define	event	(&(ev->xproperty))
{
	char	*src_goto_property;
	size_t	src_goto_len;

	if (event->window != XtWindow(top_level)
	  || event->atom != ATOM_SRC_GOTO)	/* if spurious event */
	    return;

	/*
	 * Retrieve the data from our window property.
	 */

	src_goto_len = property_get_data(XtWindow(top_level), ATOM_SRC_GOTO,
	  (unsigned char **) &src_goto_property, XGetWindowProperty);

	if (src_goto_len == 0) {
	    if (debug & DBG_CLIENT)
		puts("SRC_GOTO gave us nothing");
	    return;
	}

	source_forward_string = src_goto_property;
	ev_flags |= EV_SRC;
}

#undef	event


#if XAW

void
handle_messages(widget, closure, event, cont)
	Widget	widget;
	XtPointer closure;
	XEvent	*event;
	Boolean	*cont;		/* unused */
{
	if (event->type == ClientMessage
	  && event->xclient.message_type == XA_WM_PROTOCOLS
	  && event->xclient.data.l[0] == XA_WM_DELETE_WINDOW) {
	    if (closure != 0)
		((XtCallbackProc) closure) (widget, NULL, NULL);
	    else
		Act_quit(widget, event, NULL, 0);
	}
}

#elif MOTIF

void
handle_wm_delete(w, client_data, call_data)
	Widget		w;
	XtPointer	client_data;
	XtPointer	call_data;
{
	Act_quit(w, NULL, NULL, 0);
}

#endif /* MOTIF */


/*
 *	Interrupt system for receiving events.  The program sets a flag
 *	whenever an event comes in, so that at the proper time (i.e., when
 *	reading a new dvi item), we can check incoming events to see if we
 *	still want to go on printing this page.  This way, one can stop
 *	displaying a page if it is about to be erased anyway.  We try to read
 *	as many events as possible before doing anything and base the next
 *	action on all events read.
 *	Note that the Xlib and Xt routines are not reentrant, so the most we
 *	can do is set a flag in the interrupt routine and check it later.
 *	Also, sometimes the interrupts are not generated (some systems only
 *	guarantee that SIGIO is generated for terminal files, and on the system
 *	I use, the interrupts are not generated if I use "(xdvi foo &)" instead
 *	of "xdvi foo").  Therefore, there is also a mechanism to check the
 *	event queue every 70 drawing operations or so.  This mechanism is
 *	disabled if it turns out that the interrupts do work.
 *	For a fuller discussion of some of the above, see xlife in
 *	comp.sources.x.
 */

/*
 *	Signal flags
 */

/* This could be static volatile, but we want to avoid any optimizer bugs.  */
VOLATILE unsigned int	sig_flags	= 0;

#define	SF_USR	1
#define	SF_ALRM	2
#define	SF_POLL	4
#define	SF_CHLD	8
#define	SF_TERM	16

static	void	do_sigterm ARGS((void));
static	void	do_sigchld ARGS((void));
static	void	do_sigpoll ARGS((void));
static	void	do_sigalrm ARGS((void));
static	void	do_sigusr ARGS((void));

#define	SP0	do_sigusr	/* these must be in the same order as SF_* */
#define	SP1	do_sigalrm
#define	SP2	do_sigpoll
#define	SP3	do_sigchld
#define	SP4	do_sigterm	/* highest priority */

typedef	void	(*signalproc) ARGS((void));

static	_Xconst signalproc	flags_to_sigproc[32]
		= {NULL, SP0, SP1, SP1, SP2, SP2, SP2, SP2,
		   SP3, SP3, SP3, SP3, SP3, SP3, SP3, SP3,
		   SP4, SP4, SP4, SP4, SP4, SP4, SP4, SP4,
		   SP4, SP4, SP4, SP4, SP4, SP4, SP4, SP4};

#undef	SP0
#undef	SP1
#undef	SP2
#undef	SP3
#undef	SP4


/*
 *	Signal routines.  At the signal level, all we do is set flags.
 */

#if !FLAKY_SIGPOLL
/* ARGSUSED */
static	RETSIGTYPE
handle_sigpoll(signo)
	int	signo;
{
	event_counter = 1;
	event_freq = -1;	/* forget Plan B */
	sig_flags |= SF_POLL;
#if !HAVE_SIGACTION
	(void) signal(SIGPOLL, handle_sigpoll);	/* reset the signal */
#endif
}
#endif	/* not FLAKY_SIGPOLL */

/* ARGSUSED */
static	RETSIGTYPE
handle_sigterm(signo)
	int	signo;
{
	sig_flags |= SF_TERM;
}

/* ARGSUSED */
static	RETSIGTYPE
handle_sigchld(signo)
	int	signo;
{
	sig_flags |= SF_CHLD;
}

/* ARGSUSED */
static	RETSIGTYPE
handle_sigalrm(signo)
	int	signo;
{
	sig_flags |= SF_ALRM;
}

/* ARGSUSED */
static	RETSIGTYPE
handle_sigusr(signo)
	int	signo;
{
	event_counter = 1;
	sig_flags |= SF_USR;
}


/*
 *	enable_intr() - Called from main to set up the signal handlers.
 */

void
enable_intr() {
#ifndef FLAKY_SIGPOLL
	int	sock_fd	= ConnectionNumber(DISP);
#endif
#if HAVE_SIGACTION
	struct sigaction a;
#endif

#ifndef FLAKY_SIGPOLL
#if HAVE_SIGACTION
	/* Subprocess handling, e.g., MakeTeXPK, fails on the Alpha without
	   this, because SIGPOLL interrupts the call of system(3), since OSF/1
	   doesn't retry interrupted wait calls by default.  From code by
	   maj@cl.cam.ac.uk.  */
	a.sa_handler = handle_sigpoll;
	(void) sigemptyset(&a.sa_mask);
	(void) sigaddset(&a.sa_mask, SIGPOLL);
	a.sa_flags = SA_RESTART;
	sigaction(SIGPOLL, &a, NULL);
#else /* not HAVE_SIGACTION */
	(void) signal(SIGPOLL, handle_sigpoll);
#endif /* not HAVE_SIGACTION */

	prep_fd(sock_fd, False);
#endif	/* not FLAKY_SIGPOLL */

#if HAVE_SIGACTION
	a.sa_handler = handle_sigterm;
	(void) sigemptyset(&a.sa_mask);
	(void) sigaddset(&a.sa_mask, SIGINT);
	(void) sigaddset(&a.sa_mask, SIGQUIT);
	(void) sigaddset(&a.sa_mask, SIGTERM);
	(void) sigaddset(&a.sa_mask, SIGHUP);
	a.sa_flags = SA_RESETHAND;
	sigaction(SIGINT, &a, NULL);
	sigaction(SIGQUIT, &a, NULL);
	sigaction(SIGTERM, &a, NULL);
	sigaction(SIGHUP, &a, NULL);
#else /* not HAVE_SIGACTION */
	(void) signal(SIGINT, handle_sigterm);
	(void) signal(SIGQUIT, handle_sigterm);
	(void) signal(SIGTERM, handle_sigterm);
	(void) signal(SIGHUP, handle_sigterm);
#endif /* not HAVE_SIGACTION */

#if HAVE_SIGACTION
	a.sa_handler = handle_sigchld;
	(void) sigemptyset(&a.sa_mask);
	(void) sigaddset(&a.sa_mask, SIGCHLD);
	a.sa_flags = 0;
	sigaction(SIGCHLD, &a, NULL);
#else /* not HAVE_SIGACTION */
	(void) signal(SIGCHLD, handle_sigchld);
#endif /* not HAVE_SIGACTION */

#if HAVE_SIGACTION
	a.sa_handler = handle_sigalrm;
	(void) sigemptyset(&a.sa_mask);
	(void) sigaddset(&a.sa_mask, SIGALRM);
	a.sa_flags = 0;
	sigaction(SIGALRM, &a, NULL);
#else /* not HAVE_SIGACTION */
	(void) signal(SIGALRM, handle_sigalrm);
#endif /* not HAVE_SIGACTION */

#if HAVE_SIGACTION
	a.sa_handler = handle_sigusr;
	(void) sigemptyset(&a.sa_mask);
	(void) sigaddset(&a.sa_mask, SIGUSR1);
	a.sa_flags = 0;
	sigaction(SIGUSR1, &a, NULL);
#else /* not HAVE_SIGACTION */
	(void) signal(SIGUSR1, handle_sigusr);
#endif /* not HAVE_SIGACTION */

	(void) sigemptyset(&all_signals);
	(void) sigaddset(&all_signals, SIGPOLL);
	(void) sigaddset(&all_signals, SIGINT);
	(void) sigaddset(&all_signals, SIGQUIT);
	(void) sigaddset(&all_signals, SIGTERM);
	(void) sigaddset(&all_signals, SIGHUP);
	(void) sigaddset(&all_signals, SIGCHLD);
	(void) sigaddset(&all_signals, SIGALRM);
	(void) sigaddset(&all_signals, SIGUSR1);

}


/*
 *	Mid-level signal handlers.  These are called from within read_events(),
 *	and do the actual work appropriate for the given signal.
 */

/*
 *	Process-related routines.  Call set_chld() to indicate that a given
 *	child process should be watched for when it terminates.  Call
 *	clear_chld() to remove the process from the list.  When the child
 *	terminates, the record is removed from the list and the indicated
 *	process is called.
 */

static	struct xchild	*child_recs	= NULL;	/* head of child process list */

void
set_chld(cp)
	struct xchild	*cp;
{
	cp->next = child_recs;
	child_recs = cp;
}

void
clear_chld(cp)
	struct xchild	*cp;
{
	struct xchild	**cpp;

	for (cpp = &child_recs;;) {
	    struct xchild *cp2;

	    cp2 = *cpp;
	    if (cp2 == cp) break;
	    cpp = &cp2->next;
	}
	*cpp = cp->next;
}

static	void
do_sigchld()
{
	pid_t	pid;
	int	status;

	sig_flags &= ~SF_CHLD;

#if ! HAVE_SIGACTION
	(void) signal(SIGCHLD, handle_sigchld);	/* reset the signal */
#endif
	for (;;) {
#if HAVE_WAITPID
	    pid = waitpid(-1, &status, WNOHANG);
#else
	    pid = wait3(&status, WNOHANG, NULL);
#endif
	    if (pid == 0) break;

	    if (pid != -1) {
		struct xchild	**cpp;
		struct xchild	*cp;

		for (cpp = &child_recs;;) {
		    cp = *cpp;
		    if (cp == NULL)
			break;
		    if (cp->pid == pid) {
			*cpp = cp->next;	/* unlink it */
			(cp->proc)(status);
			break;
		    }
		    cpp = &cp->next;
		}
		break;
	    }

	    if (errno == EINTR) continue;
	    if (errno == ECHILD) break;
#if HAVE_WAITPID
	    perror("xdvi: waitpid");
#else
	    perror("xdvi: wait3");
#endif
	    break;
	}
}


/*
 *	File-related routines.  Call set_io() to indicate that a given fd
 *	should be watched for ability to input or output data.  Call clear_io()
 *	to remove it from the list.  When poll()/select() indicates that the fd
 *	is available for the indicated type of i/o, the corresponding routine
 *	is called.  Call clear_io() to remove an fd from the list.
 *	Both set_io() and clear_io() can be called from within read_proc or
 *	write_proc (although turning an io descriptor on or off is better
 *	accomplished by setting the events flag in the xio structure, and
 *	in the corresponding pollfd structure if the pfd pointer is not NULL
 *	(it is always non-NULL when read_proc and write_proc are called)).
 *	We allocate space for one additional record in the pollfd array, to
 *	accommodate the fd for the X connection; this is done by initializing
 *	num_fds to 1 instead of zero.
 */

static	struct xio	*iorecs	= NULL;	/* head of xio list */

#if HAVE_POLL
static	struct pollfd	*fds	= NULL;
static	int		num_fds	= 1;	/* current number of fds */
static	int		max_fds	= 0;	/* max allocated number of fds */
static	Boolean		io_dirty= True;	/* need to recompute fds[] array */
#else
static	int		numfds	= 0;
static	fd_set		readfds;
static	fd_set		writefds;
#endif

void
set_io(ip)
	struct xio	*ip;
{
	ip->next = iorecs;
	iorecs = ip;

#if HAVE_POLL
	++num_fds;
	if (!io_dirty && num_fds <= max_fds) {
	    fds[num_fds - 1].fd = ip->fd;
	    fds[num_fds - 1].events = ip->xio_events;
	    ip->pfd = &fds[num_fds - 1];
	}
	else {
	    ip->pfd = NULL;
	    io_dirty = True;
	}
#else
	if (numfds <= ip->fd) numfds = ip->fd + 1;
#endif
}

void
clear_io(ip)
	struct xio	*ip;
{
	struct xio	**ipp;

	for (ipp = &iorecs;;) {
	    struct xio *ip2;

	    ip2 = *ipp;
	    if (ip2 == ip) break;
	    ipp = &ip2->next;
	}
	*ipp = ip->next;

#if HAVE_POLL
	--num_fds;
	io_dirty = True;
#else
# if FLAKY_SIGPOLL
	numfds = ConnectionNumber(DISP);
# else
	numfds = (event_freq < 0 ? -1 : ConnectionNumber(DISP));
# endif
	for (ip = iorecs; ip != NULL; ip = ip->next)
	    if (ip->fd > numfds)
		numfds = ip->fd;
	++numfds;
#endif /* !HAVE_POLL */
}

static void
do_sigpoll()
{
#if FLAKY_SIGPOLL
	sig_flags &= ~SF_POLL;
#else
	struct xio	*ip;

	sig_flags &= ~SF_POLL;

#if HAVE_POLL

	if (io_dirty) {
	    struct pollfd *fp;

	    if (num_fds > max_fds) {
		if (fds != NULL) free(fds);
		fds = xmalloc(num_fds * sizeof *fds);
		max_fds = num_fds;
		fds->fd = ConnectionNumber(DISP);
		fds->events = POLLIN;
	    }
	    fp = fds + 1;
	    for (ip = iorecs; ip != NULL; ip = ip->next) {
		fp->fd = ip->fd;
		fp->events = ip->xio_events;
		ip->pfd = fp;
		++fp;
	    }
	    io_dirty = False;
	}

	for (;;) {
	    if (poll(fds + 1, num_fds - 1, 0) >= 0)
		break;

	    if (errno != EAGAIN && errno != EINTR) {
		perror("xdvi: poll");
		return;
	    }
	}

	for (ip = iorecs; ip != NULL; ip = ip->next) {
	    int revents = ip->pfd->revents;

	    if (revents & POLLIN) (ip->read_proc)();
	    if (revents & POLLOUT) (ip->write_proc)();
	}

#else

	FD_ZERO(&readfds);
	FD_ZERO(&writefds);
	for (ip = iorecs; ip != NULL; ip = ip->next) {
	    if (ip->xio_events & XIO_IN)
		FD_SET(ip->fd, &readfds);
	    if (ip->xio_events & XIO_OUT)
		FD_SET(ip->fd, &writefds);
	}

	for (;;) {
	    struct timeval tv;

	    tv.tv_sec = tv.tv_usec = 0;
	    if (select(numfds, &readfds, &writefds, (fd_set *) NULL, &tv) >= 0)
		break;

	    if (errno != EAGAIN && errno != EINTR) {
		perror("select (xdvi read_events)");
		return;
	    }
	}

	for (ip = iorecs; ip != NULL; ip = ip->next) {
	    if (FD_ISSET(ip->fd, &readfds))
		(ip->read_proc)();
	    if (FD_ISSET(ip->fd, &writefds))
		(ip->write_proc)();
	}

#endif

#endif /* not FLAKY_SIGPOLL */
}


/*
 *	Timer-related routines.  Call set_timer() to set a timer a given number
 *	of milliseconds in the future.  At that time, the timer will be cleared
 *	and the given procedure will be called with argument set to the struct
 *	passed to set_timer().  The timer routine may call set_timer() or
 *	cancel_timer().
 */


static	struct xtimer		*timers	= NULL;	/* head of timer list */

static	struct itimerval	itv	= {{0, 0}, {0, 0}};

#ifndef	timercmp
#define	timercmp(a, b, cmp)	((a)->tv_sec cmp (b)->tv_sec || \
		((a)->tv_sec == (b)->tv_sec && (a)->tv_usec cmp (b)->tv_usec))
#endif	/* timercmp */

void
set_timer(tp, ms)
	struct xtimer	*tp;
	int		ms;
{
	struct xtimer	**tpp;
	struct xtimer	*tp2;

	gettimeofday(&tp->when, NULL);
	itv.it_value.tv_sec = ms / 1000;
	itv.it_value.tv_usec = (ms % 1000) * 1000;
	tp->when.tv_sec += itv.it_value.tv_sec;
	tp->when.tv_usec += itv.it_value.tv_usec;
	if (tp->when.tv_usec >= 1000000) {
	    tp->when.tv_usec -= 1000000;
	    ++tp->when.tv_sec;
	}

	for (tpp = &timers;;) {		/* add timer to list */
	    tp2 = *tpp;
	    if (tp2 == NULL || timercmp(&tp->when, &tp2->when, <))
		break;
	    tpp = &tp2->next;
	}
	tp->next = tp2;
	*tpp = tp;

	if (tpp == &timers) {
	    setitimer(ITIMER_REAL, &itv, NULL);
	    if (ms == 0)
		sig_flags |= SF_ALRM;
	}
}

void
cancel_timer(tp)
	struct xtimer	*tp;
{
	struct xtimer	**tpp;

	for (tpp = &timers;;) {		/* remove from list */
	    if (*tpp == tp)
		break;
	    tpp = &(*tpp)->next;
	}

	*tpp = (*tpp)->next;	/* unlink it */

	if (timers == NULL) {	/* cancel SIGALRM */
	    itv.it_value.tv_sec = itv.it_value.tv_usec = 0;
	    setitimer(ITIMER_REAL, &itv, NULL);
	}
}

static	void
do_sigalrm()
{
	struct timeval	now;

	sig_flags &= ~SF_ALRM;
#if !HAVE_SIGACTION
	(void) signal(SIGALRM, handle_sigalrm);	/* reset the signal */
#endif

	gettimeofday(&now, NULL);

	while (timers != NULL && timercmp(&timers->when, &now, <=)) {
	    struct xtimer	*tp;

	    tp = timers;
	    timers = timers->next;	/* unlink it _first_ */
	    (tp->proc)(tp);
	}

	if (timers != NULL) {		/* set next timer */
	    int i;

	    itv.it_value.tv_sec = timers->when.tv_sec - now.tv_sec;
	    i = timers->when.tv_usec - now.tv_usec;
	    if (i < 0) {
		--itv.it_value.tv_sec;
		i += 1000000;
	    }
	    itv.it_value.tv_usec = i;

	    setitimer(ITIMER_REAL, &itv, NULL);
	}
}


/*
 *	Handle SIGUSR1 signal.  Pretty straightforward.
 */

static	void
do_sigusr()
{
	sig_flags &= ~SF_USR;
#if !HAVE_SIGACTION
	(void) signal(SIGUSR1, handle_sigusr);	/* reset the signal */
#endif
	if (dvi_file != NULL) {
	    Fclose(dvi_file);
	    dvi_file = NULL;
	    dvi_file_ready = False;
	}
	ev_flags |= EV_NEWDOC;
}


/*
 *	Handle termination signals.  Kill child processes, if permitted.
 *	Otherwise, leave it up to the caller.  This is the only place where
 *	the EV_TERM event flag is set, and it can only happen if there's an
 *	active non-killable process.  This should only happen if read_events()
 *	is called from one of a very few select locations.
 */

static	void
do_sigterm()
{
	struct xchild	*cp;
	Boolean		all_killed	= True;

	sig_flags &= ~SF_TERM;

	/* loop through child processes */
	for (cp = child_recs; cp != NULL; cp = cp->next)
	    if (cp->killable)
		kill(cp->pid, SIGKILL);
	    else
		all_killed = False;

	if (all_killed)		/* if all processes killed */
	    xdvi_exit(0);

	ev_flags |= EV_TERM;	/* otherwise, let the caller handle it */
}

/*
 *	Set the flag so that termination occurs, via the above routine.
 *	This should be used in place of xdvi_exit() when there may be a
 *	non-killable process running (e.g., anytime within read_events()).
 */

static	void
xdvi_normal_exit()
{
	sig_flags |= SF_TERM;
}


/*
 *	Since redrawing the screen is (potentially) a slow task, xdvi checks
 *	for incoming events while this is occurring.  It does not register
 *	a work proc that draws and returns every so often, as the toolkit
 *	documentation suggests.  Instead, it checks for events periodically
 *	(or not, if SIGPOLL can be used instead) and processes them in
 *	a subroutine called by the page drawing routine.  This routine (below)
 *	checks to see if anything has happened and processes those events and
 *	signals.  (Or, if it is called when there is no redrawing that needs
 *	to be done, it blocks until something happens.)
 *
 *	Ultimately, the goal is to have this be the only place in xdvi where
 *	blocking occurs.
 *
 *	The argument to this function should be a mask of event types (EV_*)
 *	indicating which event types should cause read_events to return instead
 *	of waiting for more events.  This function will always process all
 *	pending events and signals before returning.
 *	The return value is the value of ev_flags.
 */

unsigned int
read_events(ret_mask)
	unsigned int	ret_mask;
{
	XEvent	event;

#if !HAVE_POLL
	if (numfds == 0) numfds = ConnectionNumber(DISP) + 1;
#endif

	for (;;) {
	    event_counter = event_freq;
	    /*
	     * The above line clears the flag indicating that an event is
	     * pending.  So if an event comes in right now, the flag will be
	     * set again needlessly, but we just end up making an extra call.
	     * Also, be careful about destroying the magnifying glass while
	     * drawing on it.
	     */

#if !FLAKY_SIGPOLL

	    if (event_freq < 0) {	/* if SIGPOLL works */

		if (!XtPending()) {
		    sigset_t oldsig;

		    (void) sigprocmask(SIG_BLOCK, &all_signals, &oldsig);
		    for (;;) {
			while (sig_flags)
			    flags_to_sigproc[sig_flags]();

			if (XtPending())
			    break;

			if (ev_flags & ret_mask) {
			    (void) sigprocmask(SIG_SETMASK, &oldsig,
				(sigset_t *) NULL);
			    return ev_flags;
			}
			(void) sigsuspend(&oldsig);
		    }
		    (void) sigprocmask(SIG_SETMASK, &oldsig, (sigset_t *) NULL);
		}
	    }
	    else

#endif /* not FLAKY_SIGPOLL */

	    {
		for (;;) {
		    struct xio	*ip;

		    while (sig_flags) {
			sigset_t oldsig;

			(void) sigprocmask(SIG_BLOCK, &all_signals, &oldsig);

			while (sig_flags)
			    flags_to_sigproc[sig_flags]();

			(void) sigprocmask(SIG_SETMASK, &oldsig,
			  (sigset_t *) NULL);
		    }

		    if (XtPending())
			break;

		    if (ev_flags & ret_mask)
			return ev_flags;

		    /* If a SIGUSR1 signal comes right now, then it will wait
		       until an X event or another SIGUSR1 signal arrives. */

#if HAVE_POLL
		    if (io_dirty) {
			struct pollfd *fp;

			if (num_fds > max_fds) {
			    if (fds != NULL) free(fds);
			    fds = xmalloc(num_fds * sizeof *fds);
			    max_fds = num_fds;
			    fds->fd = ConnectionNumber(DISP);
			    fds->events = POLLIN;
			}
			fp = fds + 1;
			for (ip = iorecs; ip != NULL; ip = ip->next) {
			    fp->fd = ip->fd;
			    fp->events = ip->xio_events;
			    ip->pfd = fp;
			    ++fp;
			}
			io_dirty = False;
		    }

		    for (;;) {
			if (poll(fds, num_fds, -1) >= 0) {
			    for (ip = iorecs; ip != NULL; ip = ip->next) {
				int revents = ip->pfd->revents;

				if (revents & POLLIN) (ip->read_proc)();
				if (revents & POLLOUT) (ip->write_proc)();
			    }
			    break;
			}

			if (errno == EINTR)
			    break;

			if (errno != EAGAIN) {
			    perror("xdvi: poll");
			    break;
			}
		    }
#else
		    FD_ZERO(&readfds);
		    FD_ZERO(&writefds);
		    FD_SET(ConnectionNumber(DISP), &readfds);
		    for (ip = iorecs; ip != NULL; ip = ip->next) {
			if (ip->xio_events & XIO_IN)
			    FD_SET(ip->fd, &readfds);
			if (ip->xio_events & XIO_OUT)
			    FD_SET(ip->fd, &writefds);
		    }

		    for (;;) {
			if (select(numfds, &readfds, &writefds, (fd_set *) NULL,
			  (struct timeval *) NULL) >= 0) {
			    for (ip = iorecs; ip != NULL; ip = ip->next) {
				if (FD_ISSET(ip->fd, &readfds))
				    (ip->read_proc)();
				if (FD_ISSET(ip->fd, &writefds))
				    (ip->write_proc)();
			    }
			    break;
			}

			if (errno == EINTR)
			    break;

			if (errno != EAGAIN) {
			    perror("xdvi: select");
			    break;
			}
		    }
#endif
		}
	    }

#if TOOLKIT

	    XtNextEvent(&event);
	    if (resized) get_geom();
	    if (event.xany.window == alt.win && event.type == Expose) {
		handle_expose((Widget) NULL, (XtPointer) &alt, &event,
		    (Boolean *) NULL);
		continue;
	    }
	    (void) XtDispatchEvent(&event);

#else /* not TOOLKIT */

	    XNextEvent(DISP, &event);
	    if (event.xany.window == mane.win || event.xany.window == alt.win) {
		struct WindowRec *wr = &mane;

		if (event.xany.window == alt.win) {
		    wr = &alt;
		    /* check in case we already destroyed the window */
		    if (alt_stat < 0) { /* destroy upon exposure */
			alt_stat = 0;
			mag_release(&event);
			continue;
		    }
		    else
			alt_stat = 0;
		}
		switch (event.type) {
		case GraphicsExpose:
		case Expose:
		    expose(wr, event.xexpose.x, event.xexpose.y,
			event.xexpose.width, event.xexpose.height);
		    break;

		case ButtonPress:
		    if (resource.wheel_unit != 0 && (event.xbutton.button == 4
		      || event.xbutton.button == 5))
			Act_wheel(&event);
		    else if (resource.wheel_unit != 0
		      && (event.xbutton.button == 6
		      || event.xbutton.button == 7))
			Act_hwheel(&event);
		    else if (event.xbutton.state & ControlMask) {
			switch (event.xbutton.button) {
			    case 1:  Act_source_special(&event); break;
			    case 2:  Act_show_source_specials(&event); break;
			    case 3:  Act_show_all_boxes(&event); break;
			}
		    }
		    else if (event.xbutton.state & ShiftMask)
			Act_drag(&event);
		    else
			Act_magnifier(&event);
		    break;

		case MotionNotify:
		    mouse_motion(&event);
		    break;

		case ButtonRelease:
		    if (event.xbutton.button == wheel_button)
			wheel_button = -1;
		    else if (event.xbutton.button == wheel_h_button)
			wheel_h_button = -1;
		    else
			mouse_release(&event);
		    break;
		}	/* end switch */
	    }	/* end if window == {mane,alt}.win */

	    else if (event.xany.window == x_bar) {
		if (event.type == Expose)
		    XFillRectangle(DISP, x_bar, copyGC,
			x_bgn, 1, x_end - x_bgn, BAR_WID);
		else if (event.type == MotionNotify)
		    scrollmane(event.xmotion.x * page_w / clip_w,
			mane.base_y);
		else switch (event.xbutton.button)
		{
		    case 1:
			scrollmane(mane.base_x + event.xbutton.x, mane.base_y);
			break;
		    case 2:
			scrollmane(event.xbutton.x * page_w / clip_w,
			    mane.base_y);
			break;
		    case 3:
			scrollmane(mane.base_x - event.xbutton.x, mane.base_y);
		}
	    }

	    else if (event.xany.window == y_bar) {
		if (event.type == Expose)
		    XFillRectangle(DISP, y_bar, copyGC,
			1, y_bgn, BAR_WID, y_end - y_bgn);
		else if (event.type == MotionNotify)
		    scrollmane(mane.base_x,
			event.xmotion.y * page_h / clip_h);
		else switch (event.xbutton.button)
		{
		    case 1:
			scrollmane(mane.base_x, mane.base_y + event.xbutton.y);
			break;
		    case 2:
			scrollmane(mane.base_x,
			    event.xbutton.y * page_h / clip_h);
			break;
		    case 3:
			scrollmane(mane.base_x, mane.base_y - event.xbutton.y);
		}
	    }

	    else if (event.xany.window == top_level)
		switch (event.type) {
		case ConfigureNotify:
		    if (event.xany.window == top_level &&
			(event.xconfigure.width != window_w ||
			event.xconfigure.height != window_h)) {
			    Window old_mane_win = mane.win;

			    window_w = event.xconfigure.width;
			    window_h = event.xconfigure.height;
			    reconfig();
			    if (old_mane_win == (Window) 0) {
				ev_flags |= EV_NEWPAGE;
				home_action = home;
			    }
		    }
		    break;

		case MapNotify:		/* if running w/o WM */
		    if (mane.win == (Window) 0) {
			reconfig();
			ev_flags |= EV_NEWPAGE;
			home_action = home;
		    }
		    break;

		case KeyPress:
		    {
#define			TRSIZE	4

			char	trbuf[TRSIZE];

			if (XLookupString(&event.xkey, trbuf, TRSIZE,
			  (KeySym *) NULL, (XComposeStatus *) NULL) == 1
			  && (keychar = *trbuf) < 128)
			    (actions[keychar])(&event);
		    }
		    break;

		case PropertyNotify:
		    handle_property_change(&event);
		    break;
		}

#endif	/* not TOOLKIT */

	}
}


/*
 *	Higher-level routines for managing events.
 */

static	void
can_exposures(windowrec)
	struct WindowRec *windowrec;
{
	windowrec->min_x = windowrec->min_y = MAXDIM;
	windowrec->max_x = windowrec->max_y = 0;
}

static	void
redraw(windowrec)
	struct WindowRec *windowrec;
{

	currwin = *windowrec;
	min_x = currwin.min_x + currwin.base_x;
	min_y = currwin.min_y + currwin.base_y;
	max_x = currwin.max_x + currwin.base_x;
	max_y = currwin.max_y + currwin.base_y;
	can_exposures(windowrec);

	if (debug & DBG_EVENT)
	    Printf("Redraw %d x %d at (%d, %d) (base=%d,%d)\n", max_x - min_x,
		max_y - min_y, min_x, min_y, currwin.base_x, currwin.base_y);

	if (!(ev_flags & EV_CURSOR)) {
	    if (!dragcurs) {
		XDefineCursor(DISP, CURSORWIN, redraw_cursor);
		XFlush(DISP);
	    }
	    ev_flags |= EV_CURSOR;
	}

	draw_page();
	warn_spec_now = False;
}

static	void
redraw_page()
{
#if COLOR
	_Xconst struct rgb *rgbp;
#endif

	if (debug & DBG_EVENT) Fputs("Redraw page:  ", stdout);

	if (scanned_page < current_page) {
	    if (!check_dvi_file())
		return;
	    prescan();
	    if (ev_flags & EV_GE_NEWPAGE)	/* if we need to re-prescan */
		return;
	}

	if (page_info[current_page].ww != unshrunk_page_w
	  || page_info[current_page].wh != unshrunk_page_h) {
	    init_page();
	    reconfig();
	}

	/* We can't call home() without proper unshrunk_page_*, which requires
	 * prescan(), which can't be done from within read_events() */

	if (home_action != NULL) {
	    if (!resource.keep_flag)
		home_action(False);
	    home_action = NULL;
#if PS_GS
	    if (gs_postpone_prescan) {
		if (!setjmp(canit_env))
		    gs_resume_prescan();
		else
		    return;
	    }
#endif
#if TOOLKIT
	    /* This discards the expose event generated by home() */
	    if (read_events(EV_NOWAIT) & EV_GE_NEWPAGE)
		return;
	    can_exposures(&mane);
#endif
	}

#if COLOR
	rgbp = &bg_initial;
	if (page_colors != NULL)
	    rgbp = &page_colors[current_page].bg;

	/* Set background color */
	if (bg_current == NULL
	  || rgbp->r != bg_current->color.r
	  || rgbp->g != bg_current->color.g
	  || rgbp->b != bg_current->color.b) {
	    struct bgrec **bgpp;

	    for (bgpp = &bg_head;;) {
		bg_current = *bgpp;
		if (bg_current == NULL) {	/* if bg is not in list */
		    bg_current = *bgpp = xmalloc(sizeof *bg_current);
		    bg_current->next = NULL;
		    bg_current->color = *rgbp;
		    bg_current->fg_head = NULL;
		    bg_current->pixel_good = False;
		    break;
		}
		if (bg_current->color.r == rgbp->r
		  && bg_current->color.g == rgbp->g
		  && bg_current->color.b == rgbp->b)
		    break;
		bgpp = &bg_current->next;
	    }
	    fg_current = NULL;	/* force change of foreground color */
	    /* highGC is only used in XDrawRectangle, so its background color
	       doesn't need to be changed.  */
	    if (debug & DBG_DVI)
		printf("Changing background color to %5d %5d %5d\n",
		  bg_current->color.r, bg_current->color.g,
		  bg_current->color.b);

	    if (!bg_current->pixel_good) {
		bg_current->pixel = alloc_color(&bg_current->color,
		  back_color_data.pixel);
		bg_current->pixel_good = True;
	    }
	    XSetWindowBackground(DISP, mane.win, bg_current->pixel);

	    bg_Color.pixel = bg_current->pixel;
	    XQueryColor(DISP, our_colormap, &bg_Color);
	    XRecolorCursor(DISP, ready_cursor, &cr_Color, &bg_Color);
	    XRecolorCursor(DISP, redraw_cursor, &cr_Color, &bg_Color);
	}
#endif /* COLOR */

	dvi_file_ready = True;

	XClearWindow(DISP, mane.win);
	if (backing_store != NotUseful) {
	    mane.min_x = mane.min_y = 0;
	    mane.max_x = page_w;
	    mane.max_y = page_h;
	}
	else {
	    get_xy();
	    mane.min_x = -window_x;
	    mane.max_x = -window_x + clip_w;
	    mane.min_y = -window_y;
	    mane.max_y = -window_y + clip_h;
	}
	redraw(&mane);
}

void
do_pages()
{
	if (debug & DBG_BATCH) {
	    int i;

	    (void) read_events(EV_GT_IDLE);

	    for (i = 0; i < total_pages; ++i) {
		goto_page(i, home);
#if PS_GS
		for (;;) {
		    redraw_page();
		    (void) read_events(EV_NOWAIT);
		    if (!(ev_flags & (EV_NEWPAGE | EV_NEWDOC))) break;
		    ev_flags = EV_IDLE;
		}
#else
		redraw_page();
#endif
	    }

	    xdvi_exit(0);
	}
	else
	    for (;;) {	/* normal operation */

		(void) read_events(EV_GT_IDLE);

		if (ev_flags & (EV_NEWPAGE | EV_NEWDOC | EV_PS_TOGGLE)) {
		    ev_flags &= ~(EV_NEWPAGE | EV_EXPOSE | EV_PS_TOGGLE);
		    if (ev_flags & EV_NEWDOC) {
			ev_flags &= ~EV_NEWDOC;
			reload_dvi_file();
		    }
		    can_exposures(&mane);
		    can_exposures(&alt);

		    if (dvi_file != NULL)
			redraw_page();
		    else
			(void) check_dvi_file();
		}

		else if (ev_flags & EV_SRC) {
		    /* Source special operations are deferred to here because
		     * they call geom_scan(), which may call define_font(),
		     * which may call makefont(), which may call read_events()
		     * recursively.
		     */
		    if (!check_dvi_file())
			/* if dvi file is corrupted or has changed */
			continue;

		    ev_flags &= ~EV_SRC;
		    if (source_forward_string != NULL) {
			_Xconst char *s = source_forward_string;

			source_forward_string = NULL;
			source_forward_search(s);
		    }
		    else if (source_reverse_x != -1)
			source_reverse_search(source_reverse_x,
			  source_reverse_y);
		    else source_special_show(source_show_all);
		}

		else if (ev_flags & EV_MAG_MOVE) {
		    if (alt.win == (Window) 0) ev_flags &= ~EV_MAG_MOVE;
		    else if (abs(new_mag_x - mag_x) >
			2 * abs(new_mag_y - mag_y))
			    movemag(new_mag_x, mag_y);
		    else if (abs(new_mag_y - mag_y) >
			2 * abs(new_mag_x - mag_x))
			    movemag(mag_x, new_mag_y);
		    else movemag(new_mag_x, new_mag_y);
		}

		else if (ev_flags & EV_EXPOSE) {
		    if (alt.min_x < MAXDIM) {
			if (mane.min_x >= MAXDIM) ev_flags &= ~EV_EXPOSE;
			redraw(&alt);
		    }
		    else {
			ev_flags &= ~EV_EXPOSE;
			if (mane.min_x < MAXDIM)
			    redraw(&mane);
		    }
		}

		else if (ev_flags & EV_CURSOR) {
		    /*
		     * This code eliminates unnecessary calls to XDefineCursor,
		     * since this is a slow operation on some hardware
		     * (e.g., S3 chips).
		     */
		    XSync(DISP, False);
		    if (!XtPending()) {
			ev_flags &= ~EV_CURSOR;
			if (!dragcurs)
			    XDefineCursor(DISP, CURSORWIN, ready_cursor);
		    }
		}

		XFlush(DISP);
	    }
}


#if MOTIF_TIMERS

/*
 *	Newer versions of the Motif toolkit use the timer facility
 *	(XtAppAddTimeOut(), etc.) in the X Toolkit.  Proper functioning of
 *	this mechanism, however, requires that the X Toolkit be in charge of
 *	blocking.  Since xdvi does its own blocking, this means that we need
 *	to provide working alternatives to these X Toolkit routines.
 *	One symptom of the above-mentioned bug is that the printlog window
 *	eventually stops showing dvips progress until you move the mouse.
 */

static	void	xt_alarm ARGS((struct xtimer *));

static	struct xtimer	*xt_free_timers	= NULL;


XtIntervalId
XtAppAddTimeOut(app, interval, proc, closure)
	XtAppContext	app;
	unsigned long	interval;
	XtTimerCallbackProc proc;
	XtPointer	closure;
{
	struct xtimer	*tp;

	if (xt_free_timers == NULL)
	    tp = xmalloc(sizeof *tp);
	else {
	    tp = xt_free_timers;
	    xt_free_timers = xt_free_timers->next;
	}

	tp->proc = xt_alarm;
	tp->xt_proc = proc;
	tp->closure = closure;

	set_timer(tp, interval);

	return (XtIntervalId) tp;
}

void
XtRemoveTimeOut(id)
	XtIntervalId	id;
{
	struct xtimer	*tp;

	tp = (struct xtimer *) id;

	/* Motif (Solaris 9, 2003) sometimes calls XtRemoveTimeOut() after
	   the timer event has occurred, so we need to be sure not to remove
	   the timer record twice.  */
	if (tp->proc == NULL)
	    return;

	cancel_timer(tp);

	tp->next = xt_free_timers;
	xt_free_timers = tp;
}

void
xt_alarm(tp)
	struct xtimer	*tp;
{
	XtIntervalId	id;

	tp->proc = NULL;	/* flag timer as used-up */
	id = (XtIntervalId) tp;
	(tp->xt_proc)(tp->closure, &id);

	tp->next = xt_free_timers;
	xt_free_timers = tp;
}

#endif /* MOTIF_TIMERS */
