.\" Copyright (c) 1990-2014  Paul Vojta
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a copy
.\" of this software and associated documentation files (the "Software"), to
.\" deal in the Software without restriction, including without limitation the
.\" rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
.\" sell copies of the Software, and to permit persons to whom the Software is
.\" furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included in
.\" all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
.\" EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL PAUL VOJTA OR ANY OTHER AUTHOR OF OR CONTRIBUTOR TO
.\" THIS SOFTWARE BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
.\" WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
.\" OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
.\" IN THE SOFTWARE.
.\"
.if t .ds Te T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.if n .ds Te TeX
'	# small and boldface (not all -man's provide it)
.de SB
\&\fB\s-1\&\\$1 \\$2\s0\fR
..
.TH XDVI 1 "21 April 2014" "X Version 11"
.SH NAME
xdvi \- DVI Previewer for the X Window System
.SH SYNOPSIS
.B xdvi
.nh
[\fB+\fP[\fIpage\fP]] [\fB\-s\fP \fIshrink\fP] [\fB\-S\fP \fIdensity\fP]
#ifcolor
[\fB\-nocolor\fP]
#endif
#ifgrey
[\fB\-nogrey\fP] [\fB\-gamma\fP \fIg\fP] [\fB\-install\fP] [\fB\-noinstall\fP]
#endif
[\fB\-p\fP \fIpixels\fP]
[\fB\-margins\fP \fIdimen\fP]
[\fB\-sidemargin\fP \fIdimen\fP] [\fB\-topmargin\fP \fIdimen\fP]
[\fB\-offsets\fP \fIdimen\fP]
[\fB\-xoffset\fP \fIdimen\fP] [\fB\-yoffset\fP \fIdimen\fP]
[\fB\-paper\fP \fIpapertype\fP] [\fB\-altfont\fP \fIfont\fP]
#ifmakepk
[\fB\-nomakepk\fP]
#endif
[\fB\-mfmode\fP \fImode-def\fP[\fB:\fP\fIdpi\fP]]
#ifft
[\fB\-nofreetypefonts\fP]
#endif
[\fB\-editor\fP \fIeditor\fP]
[\fB\-sourceposition\fP \fIline\fP[\fB:\fP\fIcol\fP][\ ]\fIfilename\fP]
[\fB\-nofork\fP]
[\fB\-l\fP]
[\fB\-rv\fP]
#ifbuttons
[\fB\-expert\fP]
[\fB\-shrinkbutton\fP\fIn\fP \fIshrink\fP]
#endif
[\fB\-mgs\fP[\fIn\fP] \fIsize\fP] [\fB\-warnspecials\fP]
[\fB\-hush\fP]
[\fB\-hushchars\fP] [\fB\-hushchecksums\fP]
[\fB\-safer\fP]
[\fB\-fg\fP \fIcolor\fP] [\fB\-bg\fP \fIcolor\fP] [\fB\-hl\fP \fIcolor\fP]
[\fB\-bd\fP \fIcolor\fP] [\fB\-cr\fP \fIcolor\fP]
[\fB\-bw\fP \fIwidth\fP]
[\fB\-display\fP \fIhost:display\fP] [\fB\-geometry\fP \fIgeometry\fP]
[\fB\-icongeometry\fP \fIgeometry\fP] [\fB\-iconic\fP]
#ifbuttons
[\fB\-font\fP \fIfont\fP]
#endif
[\fB\-keep\fP] [\fB\-copy\fP] [\fB\-thorough\fP]
#ifxi21
[\fB\-noxi2scrolling\fP]
#endif
[\fB\-wheelunit\fP \fIpixels\fP]
[\fB\-noscan\fP]
#ifps
[\fB\-nopostscript\fP]
[\fB\-allowshell\fP]
#endif
#ifdps
[\fB\-nodps\fP]
#endif
#ifnews
[\fB\-nonews\fP]
#endif
#ifghost
[\fB\-noghostscript\fP]
[\fB\-nogssafer\fP]
[\fB\-gsalpha\fP]
[\fB\-interpreter\fP \fIpath\fP]
[\fB\-gspalette\fP \fIpalette\fP]
#endif
#iftool
[\fB\-dvipspath\fP \fIpath\fP]
#endif
[\fB\-debug\fP \fIbitmask\fP] [\fB\-version\fP]
.I dvi_file
.hy
.SH DESCRIPTION
.B xdvi
is a program which runs under the X window system. It is used to preview
.I dvi
files, such as are produced by
.BR tex (1).
.PP
This program has the capability of showing the file shrunken by various
(integer) factors, and also has a ``magnifying glass'' which allows one
to see a small part of the unshrunk image momentarily.
.PP
Before displaying any page or part thereof, it checks to see if the
.I dvi
file has changed since the last time it was displayed.  If this is the case,
then
.B xdvi
will reinitialize itself for the new
.I dvi
file.  For this reason, exposing parts of the
.B xdvi
window while \*(Te\& is running should be avoided.  This feature allows you
to preview many versions of the same file while running
.B xdvi
only once.
#iftool
.PP
If
.B xdvi
is run without the
.I dvi-file
argument, then it pops up a window asking for a
.I dvi
file.
#endif
#ifbuttons
.PP
In addition to using keystrokes to move within the file,
.B xdvi
provides buttons on the right side of the window, which are synonymous
with various sequences of keystrokes.
#endif
#ifps
.PP
.B xdvi
can show PostScript<tm> specials by any of three methods.
It will try first to use Display PostScript<tm>, then NeWS, then it
will try to use Ghostscript to render the images.  All of these options
depend on additional software to work properly; moreover, some of them
may not be compiled into this copy of
.BR xdvi .
.PP
For performance reasons,
.B xdvi
does not render PostScript specials in the magnifying glass.
#endif
.SH OPTIONS
In addition to specifying the
.I dvi
file (with or without the
.B .dvi
extension),
.B xdvi
supports the following command line options.  If the option begins with a
.RB ` + '
instead of a
.RB ` \- ',
the option is restored to its default value.  By default, these options can
be set via the resource names given in parentheses in the description of
each option.
.TP
.BI + page
Specifies the first page to show.  If
.B +
is given without a number, the last page is assumed; the first page is
the default.
#ifps
.TP
.B \-allowshell
.RB ( .allowShell )
This option enables the shell escape in PostScript specials.
(For security reasons, shell escapes are disabled by default.)
This option should be rarely used; in particular it should not be used just
to uncompress files: that function is done automatically if the file name
ends in
.BR .Z ,
.BR .gz ,
or
.BR .bz2 .
Shell escapes are always turned off if the
.B \-safer
option is used.
#endif
.TP
.BI \-altfont " font"
.RB ( .altFont )
Declares a default font to use when the font in the
.I dvi
file cannot be found.  This is useful, for example, with PostScript <tm> fonts.
.TP
.BI \-background " color"
.RB ( .background )
Determines the color of the background.  Same as
.BR -bg .
.TP
.BI \-bd " color"
.RB ( .borderColor )
Determines the color of the window border.
.TP
.BI \-bg " color"
.RB ( .background )
Determines the color of the background.
.TP
.BI \-bordercolor " color"
Same as
.BR -bd .
.TP
.BI \-borderwidth " width"
.RB ( .borderWidth )
Specifies the width of the border of the window.  Same as
.BR -bw .
.TP
.BI \-bw " width"
.RB ( .borderWidth )
Specifies the width of the border of the window.
.TP
.B \-copy
.RB ( .copy )
Always use the
.I copy
operation when writing characters to the display.
This option may be necessary for correct operation on a color display, but
overstrike characters will be incorrect.
#ifgrey
If greyscale anti-aliasing is in use, the
.B \-copy
operation will disable the use of colorplanes and make overstrikes come
out incorrectly.
#endif
See also
.BR \-thorough .
.TP
.BI \-cr " color"
.RB ( .cursorColor )
Determines the color of the cursor.  The default is the color of the page
border.
.TP
.BI \-debug " bitmask"
.RB ( .debugLevel )
If nonzero, prints additional debugging information on standard output.
The bitmask should be given as a decimal number.  The values of the bits
are defined in the source file
.BR xdvi.h .
.TP
.BI \-density " density"
.RB ( .densityPercent )
Determines the density used when shrinking bitmaps for fonts.
A higher value produces a lighter font.  The default value is 40.
#ifgrey
If greyscaling is in use, this argument does not apply; use
.B \-gamma
instead.
#endif
See also the
.RB ` S '
keystroke.
Same as
.BR \-S .
.TP
.BI \-display " host" : display
Specifies the host and screen to be used for displaying the
.I dvi
file.  By default this is obtained from the environment variable
.SB DISPLAY.
#iftool
.TP
.BI \-dvipspath " path"
.RB ( .dvipsPath )
Use
.I path
as the
.B dvips
program to use when printing.  By default it uses
.BR dvips .
#endif
.TP
.BI \-editor " editor"
.RB ( .editor )
Specifies the editor to be invoked for reading the source file corresponding to
the
.I dvi
file.  For details on how to do this, see the section on SOURCE SPECIALS.
#ifbuttons
.TP
.B \-expert
.RB ( .expert )
Prevent the buttons from appearing.  See also the
.RB ` x '
keystroke.
#endif
.TP
.BI \-fg " color"
.RB ( .foreground )
Determines the color of the text (foreground).
.TP
.BI \-foreground " color"
Same as
.BR -fg .
#ifbuttons
.TP
.BI \-font " font"
.RB ( *font )
Sets the font for use in the buttons.
#endif
#ifgrey
.TP
.BI \-gamma " gamma"
.RB ( .gamma )
Controls the interpolation of colors in the greyscale anti-aliasing color
palette.  Default value is 1.0.  For 0 <
.I gamma
< 1, the fonts will be lighter (more like the background), and for
.I gamma
> 1, the fonts will be darker (more like the foreground).  Negative
values behave the same way, but use a slightly different algorithm.
For color and grayscale displays; for monochrome, see
.BR \-density .
See also the
.RB ` S '
keystroke.
#endif
.TP
.BI \-geometry " geometry"
.RB ( *geometry )
Specifies the initial geometry of the window.
#ifghost
.TP
.BI \-gspalette " palette"
.RB ( .palette )
Specifies the palette to be used when using Ghostscript for rendering
PostScript specials.  Possible values are
.BR Color ,
.BR Greyscale ,
and
.BR Monochrome .
The default is
.BR Color .
.TP
.B \-gsalpha
.RB ( .gsAlpha )
Causes
.B Ghostscript
to be called with the
.B x11alpha
driver instead of the
.B x11
driver.  The
.B x11alpha
driver enables anti-aliasing in PostScript figures, for a nicer appearance.
It is available on newer versions of
.BR Ghostscript .
This option can also be toggled with the
.RB ` V '
keystroke.
#endif
.TP
.BI \-hl " color"
.RB ( .highlight )
Determines the color of the page border.  The default is the foreground color.
.TP
.B \-hush
.RB ( .Hush )
Causes
.B xdvi
to suppress all suppressible warnings.
.TP
.B \-hushchars
.RB ( .hushLostChars )
Causes
.B xdvi
to suppress warnings about references to characters which are not defined
in the font.
.TP
.B \-hushchecksums
.RB ( .hushChecksums )
Causes
.B xdvi
to suppress warnings about checksum mismatches between the
.I dvi
file and the font file.
.TP
.BI \-icongeometry " geometry"
.RB ( .iconGeometry )
Specifies the initial position for the icon.
.TP
.B \-iconic
.RB ( .iconic )
Causes the
.B xdvi
window to start in the iconic state.  The default is to start with the
window open.
#ifgrey
.TP
.B \-install
.RB ( .install )
If
.B xdvi
is running under a
.B PseudoColor
visual, then (by default) it will check for
.B TrueColor
visuals with more bits per pixel, and switch to such a visual if one exists.
If no such visual exists, it will use the current visual and colormap.  If
.B \-install
is selected, however, it will still use a
.B TrueColor
visual with a greater depth, if one is available; otherwise, it will
install its own colormap on the current visual.  If the current visual is not
.BR PseudoColor ,
then
.B xdvi
will not switch the visual or colormap, regardless of its options.
The default value of the
.B install
resource is the special value,
.BR maybe .
There is no
.B +install
option.  See also
.BR \-noinstall ,
and the GREYSCALING AND COLORMAPS section.
#endif
#ifghost
.TP
.BI \-interpreter " filename"
.RB ( .interpreter )
Use
.I filename
as the Ghostscript interpreter.  By default it uses
.BR @GS_PATH@ .
#endif
.TP
.B \-keep
.RB ( .keepPosition )
Sets a flag to indicate that
.B xdvi
should not move to the home position when moving to a new page.  See also the
.RB ` k '
keystroke.
.TP
.B \-l
.RB ( .listFonts )
Causes the names of the fonts used to be listed.
.TP
.BI \-margins " dimen"
.RB ( .Margin )
Specifies the size of both the top margin and side margin.
This determines the ``home'' position of the page within the window as
follows.  If the entire page fits in the window, then the margin settings
are ignored.  If, even after removing the margins from the left, right,
top, and bottom, the page still cannot fit in the window, then the page
is put in the window such that the top and left margins are hidden, and
presumably the upper left-hand corner of the text on the page will be
in the upper left-hand corner of the window.
Otherwise, the text is centered in the window.
The dimension should be a decimal number optionally followed by
any of the two-letter abbreviations for units accepted by \*(Te\&
.RB ( pt ,
.BR pc ,
.BR in ,
.BR bp ,
.BR cm ,
.BR mm ,
.BR dd ,
.BR cc ,
or
.BR sp ).
By default, the unit will be
.BR @DEFAULT_UNIT@.
See also
.BR \-sidemargin ", " \-topmargin ,
and the keystroke
.RB ` M .'
.TP
.BI \-mfmode " mode-def\fR[\fP\fB:\fPdpi\fR]\fP"
.RB ( .mfMode )
Specifies a
.I mode-def
string, which can be used in searching for fonts (see ENVIRONMENT, below).
Generally, when changing the
.IR mode-def ,
it is also necessary to change the font size to the appropriate value
for that mode.  This is done by adding a colon and the value in dots per inch;
for example,
.BR "\-mfmode ljfour:600" .
This method overrides any value given by the
.B pixelsPerInch
resource or the
.B \-p
command-line argument.
#ifmakepk
The metafont mode is also passed to
.B metafont
during automatic creation of fonts.
#endif
By default, it is
.BR "@MFMODE@" .
.TP
.BI \-mgs " size"
Same as
.BR \-mgs1 .
.TP
.BI "\-mgs\fR[\fIn\fR]" " size"
.RB ( .magnifierSize\fR[\fIn\fR] )
Specifies the size of the window to be used for the ``magnifying glass''
for Button
.IR n .
The size may be given as an integer (indicating that the magnifying glass
is to be square), or it may be given in the form
.IR width x height .
See the MOUSE ACTIONS section.  Defaults are 200x150, 400x250, 700x500,
1000x800, and 1200x1200.
#ifcolor
.TP
.B \-nocolor
.RB ( .color )
Turns off the use of color specials.  This option can be toggled with the
.RB ` C '
keystroke.
(For this option, the logic of the corresponding resource is reversed:
.B \-nocolor
corresponds to
.BR color:off ;
.B +nocolor
to
.BR color:on .)
#endif
#ifdps
.TP
.B \-nodps
.RB ( .dps )
Inhibits the use of Display PostScript<tm> for displaying PostScript<tm>
specials.  Other forms of PostScript emulation, if installed, will be used
instead.
(For this option, the logic of the corresponding resource is reversed:
.B \-nodps
corresponds to
.BR dps:off ;
.B +nodps
to
.BR dps:on .)
#endif
.TP
.B \-nofork
.RB ( .fork )
When the
.B \-sourceposition
argument is used and there is no appropriate instance of
.B xdvi
already running, then the default behavior is for
.B xdvi
to run itself in the background (as if it were a daemon).  This argument
makes it run in the foreground instead.  This is useful for debugging,
or if
.B xdvi
is run from a broken set of
.B emacs
macros.  If no
.B \-sourceposition
argument is given, then this option has no effect.
(For this option, the logic of the corresponding resource is reversed:
.B \-nofork
corresponds to
.BR fork:off ;
.B +nofork
to
.BR fork:on .)
#ifft
.TP
.B \-nofreetypefonts
.RB ( .freetypeFonts )
This will disable the use of the FreeType library to display PostScript<tm>
Type 1 fonts.  Use this option as a workaround when you encounter problems
with the display of Type 1 fonts (but please don't forget to send a bug report
in this case, to the URL mentioned in the section AUTHORS below).
.br
(Note:
.B \-nofreetypefonts
corresponds to
.BR freetypeFonts:off ;
.B +nofreetypefonts
to
.BR freetypeFonts:on .)
#endif
#ifghost
.TP
.B \-noghostscript
.RB ( .ghostscript )
Inhibits the use of Ghostscript for displaying PostScript<tm> specials.
(For this option, the logic of the corresponding resource is reversed:
.B \-noghostscript
corresponds to
.BR ghostscript:off ;
.B +noghostscript
to
.BR ghostscript:on .)
#endif
#ifgrey
.TP
.B \-nogrey
.RB ( .grey )
Turns off the use of greyscale anti-aliasing when printing shrunken bitmaps.
(For this option, the logic of the corresponding resource is reversed:
.B \-nogrey
corresponds to
.BR grey:off ;
.B +nogrey
to
.BR grey:on .)
See also the
.RB ` G '
keystroke.
#endif
#ifghost
.TP
.B \-nogssafer
.RB ( .gsSafer )
Normally, if Ghostscript is used to render PostScript specials, the Ghostscript
interpreter is run with the option
.BR \-dSAFER .
The
.B \-nogssafer
option runs Ghostscript without
.BR \-dSAFER .
The
.B \-dSAFER
option in Ghostscript disables PostScript operators such as
.BR deletefile ,
to prevent possibly malicious PostScript programs from having any effect.
It also prevents access to files whose paths reference the parent directory
of the current directory (i.e., files whose paths contain the characters
.RB `` ../ '');
this is a feature of Ghostscript that cannot be overridden.  If the
.B \-safer
option is specified, then this option has no effect; in that case Ghostscript
is always run with
.BR \-dSAFER .
(For the
.B \-nogssafer
option, the logic of the corresponding resource is reversed:
.B \-nogssafer
corresponds to
.BR gsSafer:off ;
.B +nogssafer
to
.BR gsSafer:on .)
#endif
#ifgrey
.TP
.B \-noinstall
.RB ( .install )
Inhibit the default behavior of switching to a
.B TrueColor
visual if one is available with more bits per pixel than the current visual.
This option corresponds to a resource of
.BR install:off .
There is no
.B +noinstall
option.  See also
.BR \-install ,
and the GREYSCALING AND COLORMAPS section.
#endif
#ifmakepk
.TP
.B \-nomakepk
.RB ( .makePk )
Turns off automatic generation of font files that cannot be found by other
means.
(For this option, the logic of the corresponding resource is reversed:
.B \-nomakepk
corresponds to
.BR makePk:off ;
.B +nomakepk
to
.BR makePK:on .)
#endif
#ifnews
.TP
.B \-nonews
.RB ( .news )
Inhibits the use of NeWS<tm> for displaying PostScript<tm> specials.
Ghostscript, if enabled by the installation, will be used instead.
(For this option, the logic of the corresponding resource is reversed:
.B \-nonews
corresponds to
.BR news:off ;
.B +news
to
.BR news:on .)
#endif
#ifps
.TP
.B \-nopostscript
.RB ( .postscript )
Turns off rendering of PostScript<tm> specials.  Bounding boxes, if known,
will be displayed instead.  This option can also be toggled with the
.RB ` v '
keystroke.
(For this option, the logic of the corresponding resource is reversed:
.B \-nopostscript
corresponds to
.BR postscript:off ;
.B +postscript
to
.BR postscript:on .)
#endif
.TP
.B \-noscan
.RB ( .prescan )
By default,
.B xdvi
does a preliminary scan of the
.I dvi
file, in order to process any
.B papersize
specials; this is especially important at startup since the paper size may be
needed to determine the window size.
#ifps
If PostScript<tm> is in use, then prescanning is also necessary in order to
properly process header files.
#fi
#ifcolor
In addition, prescanning is needed to correctly determine the background color
of a page.
#fi
This option turns off such prescanning.
(Prescanning will be automatically be turned back on if
.B xdvi
detects any of the specials mentioned above.)  (For the
.B \-noscan
option, the logic of the corresponding resource is reversed:
.B \-noscan
corresponds to
.BR prescan:off ;
.B +noscan
to
.BR prescan:on .)
#ifxi21
.TP
.B \-noxi2scrolling
.RB ( .xi2Scrolling )
This will disable the use of high-resolution scrolling using the XInput 2.1
features of the X Server.  When enabled, horizontal and vertical scrolling is
done in smaller increments than would correspond to a single click of a
mouse wheel.  This is only available for hardware that supports the feature,
generally touchpads.  It is not available for traditional wheel mice.
If suitable hardware is not present or if the X server does not support
XInput 2.1 or higher, then the high-resolution scrolling feature
is turned off and has no effect.
.br
(Note:
.B \-noxi2scrolling
corresponds to
.BR xi2Scrolling:off ;
.B +noxi2scrolling
to
.BR xi2Scrolling:on .)
#endif
.TP
.BI \-offsets " dimen"
.RB ( .Offset )
Specifies the size of both the horizontal and vertical offsets of the
output on the page.  By decree of the Stanford \*(Te\& Project,
the default \*(Te\& page origin is always 1 inch over and down from
the top-left page corner, even when non-American paper sizes are used.
Therefore, the default offsets are 1.0 inch.
The argument
.I dimen
should be a decimal number optionally followed by any of the two-letter
abbreviations for units accepted by \*(Te\&
.RB ( pt ,
.BR pc ,
.BR in ,
.BR bp ,
.BR cm ,
.BR mm ,
.BR dd ,
.BR cc ,
or
.BR sp ).
By default, the unit will be
.BR @DEFAULT_UNIT@.
See also
.B \-xoffset
and
.BR \-yoffset .
.TP
.BI \-p " pixels"
.RB ( .pixelsPerInch )
Defines the size of the fonts to use, in pixels per inch.  The
default value is @BDPI@.  This option is provided only for backwards
compatibility; the preferred way of setting the font size is by setting the
Metafont mode at the same time; see the
.B \-mfmode
option.
.TP
.BI \-paper " papertype"
.RB ( .paper )
Specifies the size of the printed page.  This may be of the form
\fIwidth\fBx\fIheight\fR optionally followed by a unit, where
.I width
and
.I height
are decimal numbers giving the width and height of the paper, respectively,
and the unit is any of the two-letter abbreviations for units accepted
by \*(Te\&
.RB ( pt ,
.BR pc ,
.BR in ,
.BR bp ,
.BR cm ,
.BR mm ,
.BR dd ,
.BR cc ,
or
.BR sp ).
By default, the unit will be
.BR @DEFAULT_UNIT@.
There are also synonyms which may be used:
.B letter
(8.5x11in),
.B us
(8.5x11in, same as
.BR letter ),
.B legal
(8.5x14in),
.B foolscap
(13.5x17in),
as well as the ISO sizes
.BR a1 - a7 ,
.BR b1 - b7 ,
.BR c1 - c7 .
Each of these also has a landscape or `rotated' variant:
.B letterr
(11x8.5in),
.BR a1r - a7r ,
etc.  Any of the above sizes may be preceded by a plus sign
.RB (` + ');
this causes the paper size given here to override any paper size given in the
.I dvi
file.  The default paper size is @DEFAULT_PAGE_SIZE@.
.TP
.B \-rv
.RB ( .reverseVideo )
Causes the page to be displayed with white characters on a black background,
instead of vice versa.
.TP
.BI \-s " shrink"
.RB ( .shrinkFactor )
Defines the initial shrink factor.  The default value is @SHRINK@.  If
.I shrink
is given as 0, then the initial shrink factor is computed so that the
page fits within the window (as if the `s' keystroke were given without
a number).
.TP
.BI \-S " density"
.RB ( .densityPercent )
Same as
.BR \-density ,
.I q.v.
.TP
.B \-safer
.RB ( .safer )
This option turns on all available security options; it is designed for use when
.B xdvi
is called by a browser that obtains a
.I dvi
or \*(Te\& file from another site.
#ifps
In the present case, this option selects
#endif
#ifghost
.B +nogssafer
and
#endif
#ifps
.BR +allowshell .
#endif
#ifnops
In the present case, this option is accepted but has no effect, since
.B xdvi
has been compiled without support for PostScript specials.
#endif
#ifbuttons
.TP
.BI \-shrinkbutton "n shrink"
.RB ( .shrinkButton\fIn\fP )
Specifies that the
.IR n th
button changing shrink factors shall change to shrink factor
.IR factor .
This is useful, e.g., when using 600 dpi fonts, since in that case shrinking
by a factor of 4 is still not enough.  Here
.I n
may be a number from 1 to 3 (in the default button layout, the ``Full Size''
button is unaffected by these options).  If the buttons are customized,
higher values of
.I n
(up to 9) may be used.
#endif
.TP
.BI \-sidemargin " dimen"
.RB ( .sideMargin )
Specifies the side margin (see
.BR \-margins ).
.TP
.BI \-sourceposition " line\fR[\fP\fB:\fPcol\fR][ ]\fPfilename"
.RB ( .sourcePosition )
This option makes
.B xdvi
search in the
.I dvi
file for the place corresponding to the indicated line (and, optionally,
column) in the .tex source file, and highlight the place found by drawing a
rectangle in the
.I highlight
color (see the
.B \-hl
option) around the corresponding text.  In addition, when run with this
argument (and the
.B \-nofork
option is not given; q.v.),
.B xdvi
will always return immediately:  if it finds another instance of
.B xdvi
already showing
.I dvi_file,
then it will cause that instance to raise its window and move to the given
place in the
.I dvi
file; otherwise it will start up its own instance in the background.
This option requires that
.I dvi_file
be prepared with source special information.  See the section on SOURCE SPECIALS
for more details.
.TP
.B \-thorough
.RB ( .thorough )
.B xdvi
will usually try to ensure that overstrike characters
.RI ( e.g. ,
.BR \enotin )
are printed correctly.  On monochrome displays, this is always possible
with one logical operation, either
.I and
or
.IR or .
On color displays, however, this may take two operations, one to set the
appropriate bits and one to clear other bits.  If this is the case, then
by default
.B xdvi
will instead use the
.I copy
operation, which does not handle overstriking correctly.  The
.B \-thorough
option chooses the slower but more correct choice.  See also
.BR \-copy .
.TP
.BI \-topmargin " dimen"
.RB ( .topMargin )
Specifies the top and bottom margins (see
.BR \-margins ).
.TP
.BI \-version
Print information on the version of
.BR xdvi .
.TP
.B \-warnspecials
.RB ( .warnSpecials )
Causes
.B xdvi
to issue warnings about
.B \especial
strings that it cannot process.
.TP
.BI \-wheelunit " pixels"
.RB ( .wheelUnit )
Sets the number of pixels that a motion of a wheel mouse will move the
image up, down, left, or right.  If set to zero, the wheel mouse
functionality is (essentially) disabled.  The default value is 80.
.TP
.BI \-xoffset " dimen"
.RB ( .xOffset )
Specifies the size of the horizontal offset of the output on the page.  See
.BR \-offsets .
.TP
.BI \-yoffset " dimen"
.RB ( .yOffset )
Specifies the size of the vertical offset of the output on the page.  See
.BR -offsets .
.SH KEYSTROKES
.B xdvi
recognizes the following keystrokes when typed in its window.
Each may optionally be preceded by a (positive or negative) number, whose
interpretation will depend on the particular keystroke.
Also, the ``Home'', ``Prior'', ``Next'', and arrow cursor keys are synonyms for
.RB ` ^ ',
.RB ` b ',
.RB ` f ',
.RB ` l ',
.RB ` r ',
.RB ` u ',
and
.RB ` d '
keys, respectively.
#iftool
.PP
The key assignments given here are those that
.B xdvi
assigns by default.  They can be changed--see CUSTOMIZATION, below.
The names appearing in brackets at the beginning of each of the following
keystroke definitions is the name assigned to the action associated with
that key, for use when customizing.  Users who do not customize their
keystrokes may ignore these labels.
#
.TP
.B q
#tool.RB [ quit() ]
Quits the program.  Control-C and control-D will do this, too.
.TP
.B n
#tool.RB [ forward-page() ]
Moves to the next page (or to the
.IR n th
next page if a number is given).  Synonyms are
.RB ` f ',
Return, and Line Feed.
.TP
.I Space
#tool.RB [ down-or-next() ]
Moves down two-thirds of a window-full, or to the next page if already at
the bottom of the page.
.TP
.B p
#tool.RB [ back-page() ]
Moves to the previous page (or back
.I n
pages).  Synonyms are
.RB ` b '
and control-H.
.TP
.I Delete
#tool.RB [ up-or-previous() ]
Moves up two-thirds of a window-full, or to the bottom of the previous page
if already at the top of the page.  The BackSpace key will also do this.
.TP
.B g
#tool.RB [ goto-page() ]
Moves to the page with the given number.  Initially, the first page is assumed
to be page number 1, but this can be changed with the
.RB ` P '
keystroke, below.  If no page number is given, then it goes to the last page.
.TP
.B P
#tool.RB [ declare-page-number() ]
``This is page number
.IR n .''
This can be used to make the
.RB ` g '
keystroke refer to actual page numbers instead of absolute page numbers.
.TP
.IB Control\- L
#tool.RB [ forward-page(0) ]
Redisplays the current page.
.TP
.B ^
#tool.RB [ home() ]
Move to the ``home'' position of the page.  This is normally the upper
left-hand corner of the page, depending on the margins as described in the
.B \-margins
option, above.
.TP
.B u
#tool.RB [ up() ]
Moves up two thirds of a window-full.
.TP
.B d
#tool.RB [ down() ]
Moves down two thirds of a window-full.
.TP
.B l
#tool.RB [ left() ]
Moves left two thirds of a window-full.
.TP
.B r
#tool.RB [ right() ]
Moves right two thirds of a window-full.
.TP
.B c
#tool.RB [ center() ]
Moves the page so that the point currently beneath the cursor is moved to
the middle of the window.  It also (gasp!) warps the cursor to the same place.
.TP
.B M
#tool.RB [ set-margins() ]
Sets the margins so that the point currently under the cursor is the upper
left-hand corner of the text in the page.  Note that this command itself does
not move the image at all.  For details on how the margins are used, see
the
.B \-margins
option.
#iftool
.TP
.IB Control\- O
.RB [ open-dvi-file() ]
Pop up a window asking for a new
.I dvi
file.
.TP
.IB Control\- P
.RB [ print() ]
Pop up a window to allow
.B xdvi
to print the
.I dvi
file or a range of pages from it.  The popup window is mostly self-explanatory,
but the window showing
.B dvips
progress accepts some keystrokes that are not obvious.  In that second window,
.IB Control\- C
is equivalent to clicking on the
.B Cancel
button,
.I Return
is equivalent to clicking on the
.B Close window
button, and
.IB Control\- S
and
.IB Control\- Q
select and deselect, respectively, the option of keeping the window open after
.B dvips
finishes.
#endif
.TP
.B s
#tool.RB [ set-shrink-factor() ]
Changes the shrink factor to the given number.  If no number is given, the
smallest factor that makes the entire page fit in the window will be used.
(Margins are ignored in this computation.)
.TP
.B S
#tool.RB [ set-density() ]
Sets the density factor to be used when shrinking bitmaps.  This should
be a number between 0 and 100; higher numbers produce lighter characters.
#ifgrey
If greyscaling mode is in effect, this changes the value of gamma instead.
The new value of gamma is the given number divided by 100; negative values
are allowed.
#endif
.TP
.B R
#tool.RB [ reread-dvi-file() ]
Forces the
.I dvi
file to be reread.  This allows you to preview many versions of the same
file while running
.B xdvi
only once.
.TP
.B k
#tool.RB [ set-keep-flag() ]
Normally when
.B xdvi
switches pages, it moves to the home position as well.  The
.RB ` k '
keystroke toggles a `keep-position' flag which, when set, will keep
the same position when moving between pages.  Also
.RB ` 0k '
and
.RB ` 1k '
clear and set this flag, respectively.  See also the
.B \-keep
option.
#ifbuttons
.TP
.B x
#tool.RB [ set-expert-mode() ]
Toggles expert mode (in which the buttons do not appear).  Also
.RB ` 0x '
and
.RB ` 1x '
clear and reset this mode, respectively.  See also the
.B \-expert
option.
#endif
#ifgrey
.TP
.B G
#tool.RB [ set-greyscaling() ]
This key toggles the use of greyscale anti-aliasing for displaying shrunken
bitmaps.  In addition, the key sequences
.RB ` 0G '
and
.RB ` 1G '
clear and set this flag, respectively.  See also the
.B \-nogrey
option.
#endif
#ifcolor
.TP
.B C
#tool.RB [ set-color() ]
This key toggles the use of color specials.  The key sequences
.RB ` 0C '
and
.RB ` 1C '
turn interpretation of color specials off and on, respectively.
See also the
.B \-nocolor
option.
#endif
#ifps
.TP
.B v
#tool.RB [ set-ps() ]
This key toggles the rendering of PostScript<tm> specials.  If rendering
is turned off, then bounding boxes are displayed when available.
In addition the key sequences
.RB ` 0v '
and
.RB ` 1v '
clear and set this flag, respectively.  See also the
.B \-nopostscript
option.
#endif
#ifghost
.TP
.B V
#tool.RB [ set-gs-alpha() ]
This key toggles the anti-aliasing of PostScript<tm> specials when
.B Ghostscript
is used as renderer.  In addition the key sequences
.RB ` 0V '
and
.RB ` 1V '
clear and set this flag, respectively.  See also the
.B \-gsalpha
option.
#endif
.SH MOUSE ACTIONS
If the shrink factor is set to any number other than one, then clicking
any mouse button will pop up a ``magnifying glass'' which shows the unshrunk
image in the vicinity of the mouse click.  This subwindow disappears when
the mouse button is released.  Different mouse buttons produce different sized
windows, as indicated by the
.B \-mgs
option.  Moving the cursor while holding the button down will move the
magnifying glass.  To access this feature via customization, use the
.B magnifier
action.  Its argument is either a string of the form
.IR width x height ,
as in the
.BI \-mgs n
command-line option, or one of the strings
.B *1
through
.BR *5 ,
referring to the value specified by the corresponding
.BI \-mgs n
option.
.PP
The scrollbars (if present) behave in the standard way:  pushing Button 2
in a scrollbar moves the top or left edge of the scrollbar to that point
and optionally drags it;
pushing Button 1 moves the image up or right by an amount equal to the distance
from the button press to the upper left-hand corner of the window; pushing
Button 3 moves the image down or left by the same amount.
.PP
The image can also be dragged around, by holding down the shift key
and a mouse button.  Shift-button 1 will allow vertical dragging only;
Shift-button 3, horizontal dragging; and Shift-button 2 allows dragging
in either direction.  To access these actions via customization, use the
.B drag
action.  This action should have one parameter, the character
.RB `` | '',
.RB `` - '',
or
.RB `` + '',
indicating vertical dragging, horizontal dragging, or dragging in both
directions.
.PP
Wheel mice are supported:  motion of the wheel on such a mouse moves the
image up, down, left, or right by the number of pixels indicated by the
.B \-wheelunit
option.  To access this option via customization, use the
.B wheel
and
.B hwheel
action for vertical and horizontal scrolling, respectively.  These actions
take one parameter, giving the distance to scroll
the image.  If the parameter contains a decimal point, the distance is given
in wheel units; otherwise, pixels.  Not all wheel mice support horizontal
scrolling.
#iftool
.SH UNBOUND ACTIONS
The following actions have not been assigned any keystroke, but are available
if customization is used.
.TP
.B shrink-to-dpi()
This action takes one (required) argument.  It sets the shrink factor to
an integer so as to approximate the use of fonts with the corresponding
number of dots per inch.  If
.B xdvi
is using fonts scaled for
.I p
dots per inch, and the argument to
.B shrink-to-dpi
is
.IR n ,
then the corresponding shrink factor is the ratio
.IR p / n ,
rounded to the nearest integer.
.SH CUSTOMIZATION
Key and mouse button assignments can be changed by setting the
.B mainTranslations
resource to a string of translations as defined in the documentation for the
X toolkit.  The actions should take the form of action names as given in the
KEYSTROKES and MOUSE ACTIONS sections.
.PP
Key actions will usually be without arguments, or they may give an argument
to replace an optional number typed immediately prior to the action.  The keys
.BR 0 \- 9
and hyphen cannot be reassigned, since they are used for inputting numbers.
.PP
Some key actions may take special arguments, as follows.
The argument of
.B goto-page
may be the letter
.RB ` e ',
indicating the action of going to the end of the document.
The argument of
.B set-shrink-factor
may be the letter
.RB ` a ',
indicating that the shrink factor should be set to the smallest value such that
the page will fit in the window.
The actions
.BR up ,
.BR down ,
.BR left ,
.BR right ,
.BR up-or-previous ,
and
.BR down-or-next
may give a decimal number, indicating what fraction of a window-full to move
(in place of two thirds).
Finally, for actions that would perform a toggle, such as
.BR set-keep-flag ,
the argument may be the letter
.RB ` t ',
indicating that the action should toggle regardless of what number may have
been typed recently.
.PP
Mouse actions should refer only to
.B ButtonPress
events (e.g.,
.BR "<Btn1Down>:magnifier(*1)" ).
The corresponding motion and release events will then be handled internally.
A key action may be bound to a mouse event, but not vice versa.
.PP
Usually the string of translations should begin with
.RB `` #override '',
indicating that the default key and mouse button assignments should not
be discarded.
.PP
When keys or mouse buttons involving modifiers (such as Ctrl or Shift)
are customized together with their non-modified equivalents, the modified
keys should come first, for example:
.RS 5
.nf
.ft 3
.sp 1n
XDvi.mainTranslations: #override \\
    Ctrl<Btn1Down>: magnifier(*3)\\n\\
    Shift<Btn1Down>: magnifier(*2)\\n\\
    <Btn1Down>: magnifier(*1)
.sp 1n
.ft
.fi
.RE
.PP
Because
.B xdvi
needs to capture pointer motion events, and because the X Toolkit
translations mechanism cannot accommodate both motion events and double-click
events at the same time, it is not possible to specify double-click
actions in
.B xdvi
customizations.  For information on this and other aspects of translations,
see the X Toolkit Intrinsics documentation.
.PP
There is no command-line option to set the
.B mainTranslations
resource, since changing this resource on the command line would be cumbersome.
However, see the section on CUSTOMIZATION EXAMPLES for information on how
to set the resource for testing purposes using the
.B \-xrm
command-line option.
.PP
Support of wheel mice is controlled by the
.B wheelTranslations
resource.  Generally the only action routines called by this resource should be
.B wheel
and
.BR hwheel .
Its default value is
.RS 5
.nf
.ft 3
.sp 1n
<Btn4Down>:wheel(-1.)\\n\\
<Btn5Down>:wheel(1.)\\n\\
<Btn6Down>:hwheel(-1.)\\n\\
<Btn7Down>:hwheel(1.)
.sp 1n
.ft
.fi
.RE
.PP
When specifying a value for this resource, all wheel actions should be
included.
.PP
The X Toolkit routines that implement translations do not support event
types of
.B Btn6Down
or
.BR Btn7Down .
Because of this,
.B xdvi
implements its own parser for translations given in
.BR wheelTranslations .
This parser is more limited than the parser built in to the X Toolkit.
It should not begin with
.RB `` #replace '',
.RB `` #augment '',
or
.RB `` #override ''.
Modifiers of the form
.BI @ keysym
are not supported, and the event type must be of the form
.B BtnDown
or
.BI Btn n Down\fR,\fP
where
.I n
is a positive integer without leading zeroes.  Also, some limitations apply
to the action field.
#
#ifbuttons
.PP
The button labels and actions may also be customized, in a similar manner.
In this case the resource
.B buttonTranslations
should consist of a string describing the button labels and the associated
actions.  The string consists of substrings, separated by the newline
character
(`\fB\\n\fP'),
each describing one button.  Each substring consists of a string (to be
used as the button's label), a colon, and a sequence of actions to be
performed when the button is pushed.  Unlike the situation with key actions,
an action associated to a button should provide an argument (if applicable).
.PP
The label string may contain a colon if it is escaped by a backslash
(`\fB\\\fP').  It also may contain some special sequences tied to the
.BI \-shrinkbutton n
command-line options.  If the characters
.RB ` $# '
occur, then they are replaced by the argument of the corresponding
.B \-shrinkbutton
command-line option (if present).  If no corresponding
.B \-shrinkbutton
option was given, then the value is taken from the list of actions, which
is expected to contain at least one
.B set-shrink-factor
or
.B shrink-to-dpi
action.  Likewise, the character sequence
.RB ` $% '
will be replaced by the percentage corresponding to the shrink factor,
determined as above.  In order for the
.B \-shrinkbutton
option to affect a given button, the label string must contain one of the
character sequences
.RB ` $# ',
.RB ` $% ',
or
.RB ' $_ '.
This last string flags a button to be affected by a
.B \-shrinkbutton
option, without making any numbers appear in the label text (the
.RB ` $_ '
will not appear in the label text).
.PP
Some resources are provided to allow customization of the geometry of
the command buttons and the timing of the window that appears when
.B dvips
is processing a print request.  Again, they are not changeable via
command-line options, other than via the
.B \-xrm
option.  All of these resources take integer values.
.TP
.B buttonSideSpacing
The number of pixels to be placed on either side of the buttons.
The default value is 6.
.TP
.B buttonTopSpacing
The number of pixels between the top button and the top of the window.
The default value is 50.
.TP
.B buttonBetweenSpacing
The number of pixels between most buttons.
The default value is 20.
.TP
.B buttonBetweenExtra
The number of pixels of additional space to be inserted if the
.B buttonTranslations
resource string contains an extra newline character.
The default value is 50.
.TP
.B buttonBorderWidth
The border width of the button windows.  The default value is 1.
.TP
.B dvipsHangTime
The time, measured in milliseconds, that the ``Xdvi print process'' window will
remain showing after
.B dvips
has successfully processed a print request.  The default value is 700
(0.7 seconds).  If it is zero or negative, then the window will stay up until
closed by the user.
.TP
.B dvipsFailHangTime
This is the same as
.BR dvipsHangTime ,
except that it applies if
.B dvips
returns a status indicating failure.  The default value is 3000 (3 seconds).
#
#iftool
.SH CUSTOMIZATION EXAMPLES
.PP
Some users prefer that the window scroll smoothly when they hold down the
arrow keys, instead of giving a large motion each time they type the keys.
To get this scrolling behavior, the following resource can be used.
.RS 5
.nf
.ft 3
.sp 1n
XDvi.mainTranslations: #override \\
    <Key>Up:up(.01)\\n\\
    <Key>Down:down(.01)\\n\\
    <Key>Left:left(.01)\\n\\
    <Key>Right:right(.01)
.sp 1n
.ft
.fi
.RE
.PP
To set the
.B mainTranslations
resource for testing purposes, use the
.B \-xrm
command-line option provided by the X toolkit.  For example,
.RS 5
.nf
.ft 3
.sp 1n
xdvi \-xrm 'XDvi.mainTranslations: #override "z":quit()' ...
.sp 1n
.ft
.fi
.RE
or
.RS 5
.nf
.ft 3
.sp 1n
xdvi \-xrm 'XDvi.mainTranslations: #override <Key>z:quit()' ...
.sp 1n
.ft
.fi
.RE
will cause the key
.RB ` z '
to quit
.BR xdvi .
This method also works with the other translation resources.
#
.SH SPECIALS (GENERALLY)
Any of the specials used by
.B xdvi
may be preceded by the characters
.RB `` xdvi: ''.
Doing so does not change the behavior of the special under
.BR xdvi ,
but it causes other
.I dvi
viewers to ignore the special.
.SH SOURCE SPECIALS
With properly prepared
.I dvi
files,
.B xdvi
is capable of calling up an editor at the point in the file corresponding to
any given point in the typeset output
.RB (`` "reverse search" '').
It can also be invoked so as to move to the place in the
.I dvi
file corresponding to a given line (and, optionally, column) in a given source
file
.RB (`` "forward search" '').
Both of these capabilities require that the version of \*(Te\& used to
produce the
.I dvi
file be compiled to support ``source specials,'' and that the
.B \-src\-specials
argument be used on the command line when running \*(Te\&.
(Or, some special-purpose macro packages will also suffice for the above
capabilities.  In fact, column number information is not provided by any
version of \*(Te\&; it must be provided by a macro package.  This is because
column information would make the
.I dvi
file too large; only special-purpose applications would benefit from it.)
.P
.B Reverse Search.
Reverse search is done by moving the mouse to the desired position on the
page displayed by
.BR xdvi ,
and pressing Button 1 while holding the Control button down.
.P
Each time this feature is used, a new copy of the editor is invoked.
(The editor command can be a program such as
.BR emacsclient ,
however, which passes the information on to a running instance of an editor
if possible.)  The editor is specified by the
.B \-editor
command-line option, the
.B .editor
resource, or the
.SB XEDITOR,
.SB VISUAL,
or
.SB EDITOR
environment variables; the first of these to specify a value determines the
editor to call.  If none of these are set, then the Unix editor
.B vi
is used.  The value is a string called as a shell command, in which
occurrences of the designator
.RB `` %f ''
are replaced by the file name, occurrences of
.RB `` %l ''
are replaced by the line number within the file, and (if supported)
occurrences of
.RB `` %c ''
are replaced by the column number within the line.  If no designator
.RB `` %f ''
occurs in the string, then
.RB `` "+%l %f" ''
is appended to the end of the string.  If the string was found as the value
of the
.SB VISUAL
or
.SB EDITOR
environment variables, then
.RB `` "xterm -e "''
is prepended to the string; if the editor is specified by other means, then
it must be in the form of a shell command to pop up an X window with an
editor in it.
.P
For debugging purposes, Ctrl-Button 2 will draw boxes around the first glyph
or rule in a file occurring on source lines identified by source specials.
In addition, Ctrl-Button 3 will draw similar boxes around all glyphs and rules
in the file.  These boxes are drawn in the color specified by the highlight
color (the
.B \-hl
command-line option or the
.B .highColor
resource).  In addition to glyphs and rules, certain PostScript specials also
may be boxed (those providing a bounding box).
.P
The file to be edited is searched for first in the directory containing the
.I dvi
file, then in the path specified by the
.SB XDVISOURCES
or
.SB TEXINPUTS
environment variables.
.P
.B Forward search.
Forward search is invoked on the command line (typically by a text editor),
by specifying the
.B \-sourceposition
argument.
.B xdvi
The main dvi file
.I dvi_file
is specified as usual.  ``Forward search'' means that xdvi will try to open
the page in
.I dvi_file
corresponding to the given line number (and, optionally, column number)
of the .tex source file
.IR filename ,
and highlight the place found by drawing a rectangle in the
.I highlight
color (see the
.B \-hl
option) around the corresponding text.
.P
In addition, the
.B \-sourceposition
option causes
.B xdvi
to run in client mode.  ``Client mode'' means that if there is already
another instance of
.B xdvi
running on this X display and displaying the same
.IR dvi_file ,
a new instance started with the
.B -sourceposition
option will only notify that running instance to perform the forward
search, and exit after that.  If no such instance of
.B xdvi
is found, then
.B xdvi
will start up a new instance in the background.  Either way, when running
in client mode,
.B xdvi
will always return immediately.  This is set up so that other programs
such as text editors may invoke
.B xdvi
in ``client mode'' to jump to a specific
place in the
.I dvi
file corresponding to the current cursor position in the .tex file,
and the user can continue editing without having to close the
.B xdvi
window first.  (Note, however, that if the
.B \-nofork
argument is given on the command line, or the corresponding resource is
set, then operation in client mode is a bit different in that
.B xdvi
will not run itself in the background if there is no instance already running.)
.P
The argument for
.I filename
should match the file name used for the source specials in the
.I dvi
file. The space before the
.I filename
is optional; it is only needed to avoid ambiguity if
.I filename
starts with a digit or a colon. Note that the argument needs to be enclosed
in quotes if a space is used, to prevent the shell from
misinterpreting the space as argument separator.
.P
Source specials in the
.I dvi
file must have one of the following formats:
.RS 5
.nf
.sp 1n
    \fBsrc:\fP\fIline\fP[ ]\fIfilename\fP
    \fBsrc:\fP\fIline\fP\fB:\fP\fIcol\fP[ ]\fIfilename\fP
    \fBsrc:\fP\fIline\fP
    \fBsrc:\fP\fIline\fP\fB:\fP\fIcol\fP
    \fBsrc::\fP\fIcol\fP
.sp 1n
.fi
.RE
.PP
If
.I filename
or
.I line
are omitted, the most recent values are used.  The first source special on
each page must be in one of the first two forms, so that defaults are not
inherited across pages.
.SH PAPERSIZE SPECIALS
.B xdvi
accepts specials to set the paper size for the document.  These specials
should be of the form
.RS 5
.nf
.sp 1n
    \fBpapersize=\fP[\fB*\fP]\fIwidth\fP,\fIheight\fP
.sp 1n
.fi
.RE
.PP
where
.I width
and
.I height
give the width and height of the paper, respectively.  Each of these should
appear in the form of a decimal number followed by any of the two-letter
abbreviations for units accepted by \*(Te\&
.RB ( pt ,
.BR pc ,
.BR in ,
.BR bp ,
.BR cm ,
.BR mm ,
.BR dd ,
.BR cc ,
or
.BR sp ).
If an asterisk
.RB ( * )
appears just before the width, then the measurements refer to the document
dimensions (e.g.,
.B pt
as opposed to
.BR truept ).
This allows a macro package to vary the page size according to elements
of the document; e.g.,
.RS 5
.nf
.ft 3
.sp 1n
\\special{xdvi: papersize=*\\number\\wd\\mybox sp,\\number\\ht\\mybox sp}
.sp 1n
.ft
.fi
.RE
.PP
Except for the asterisk, this format is compatible with
.BR dvips .
.P
The last
.B papersize
special on a page determines the size of that page.  If there is no such
special on a given page, the most recent
.B papersize
is used, or, if there are no
.B papersize
specials on any preceding page, then the value of the
.B paper
resource (or
.B \-paper
option on the command line) is used.  Thus the paper size may vary for
different pages of the
.I dvi
file.
.P
If the
.B paper
resource (or
.B \-paper
command-line option) begins with a plus sign
.RB (` + '),
then all
.B papersize
specials in the
.I dvi
file are ignored.
#ifcolor
.SH COLOR SPECIALS
The color specials supported by
.B xdvi
are the same as those supported by
.BR dvips ,
except that the literal PostScript color specification (as in the
.B AggiePattern
example in the
.B dvips
documentation) is not supported.  In particular, the LaTeX
.B color
package will work with
.BR xdvi .
See the documentation of the LaTeX
.B color
package for details on its use, and also see the
.B dvips
documentation file
.B dvips.tex
for details on the syntax and semantics of the color specials.
.P
Support for color specials includes the same list of named colors as
.BR dvips ,
namely:
.BR Apricot ,
.BR Aquamarine ,
.BR Bittersweet ,
.BR Black ,
.BR Blue ,
.BR BlueGreen ,
.BR BlueViolet ,
.BR BrickRed ,
.BR Brown ,
.BR BurntOrange ,
.BR CadetBlue ,
.BR CarnationPink ,
.BR Cerulean ,
.BR CornflowerBlue ,
.BR Cyan ,
.BR Dandelion ,
.BR DarkOrchid ,
.BR Emerald ,
.BR ForestGreen ,
.BR Fuchsia ,
.BR Goldenrod ,
.BR Gray ,
.BR Green ,
.BR GreenYellow ,
.BR JungleGreen ,
.BR Lavender ,
.BR LimeGreen ,
.BR Magenta ,
.BR Mahogany ,
.BR Maroon ,
.BR Melon ,
.BR MidnightBlue ,
.BR Mulberry ,
.BR NavyBlue ,
.BR OliveGreen ,
.BR Orange ,
.BR OrangeRed ,
.BR Orchid ,
.BR Peach ,
.BR Periwinkle ,
.BR PineGreen ,
.BR Plum ,
.BR ProcessBlue ,
.BR Purple ,
.BR RawSienna ,
.BR Red ,
.BR RedOrange ,
.BR RedViolet ,
.BR Rhodamine ,
.BR RoyalBlue ,
.BR RoyalPurple ,
.BR RubineRed ,
.BR Salmon ,
.BR SeaGreen ,
.BR Sepia ,
.BR SkyBlue ,
.BR SpringGreen ,
.BR Tan ,
.BR TealBlue ,
.BR Thistle ,
.BR Turquoise ,
.BR Violet ,
.BR VioletRed ,
.BR White ,
.BR WildStrawberry ,
.BR Yellow ,
.BR YellowGreen ,
.BR YellowOrange .
Note that these names are case sensitive.
.P
At present, the
.B \ecolorbox
and
.B \efcolorbox
macros are not supported.  This includes use of the
.B columncolor
macro in the
.B colortbl
package, and the
.B shaded
environment in the
.B framed
La\*(Te\&2e package.
#endif
#ifgrey
.SH GREYSCALING AND COLORMAPS
The greyscale anti-aliasing feature in
.B xdvi
will not work at its best if the display does not have enough colors available.
This can happen if other applications are using most of the colormap
(even if they are iconified).  If this occurs, then
.B xdvi
will print an error message and turn on the
.B -copy
option.  This will result in overstrike characters appearing wrong;
it may also result in poor display quality if the number of available
colors is very small.
.PP
Typically this problem occurs on displays that allocate eight bits
of video memory per pixel.  To see how many bits per pixel your display
uses, type
.B xwininfo
in an
.B xterm
window, and then click the mouse on the root window when asked.  The
``Depth:'' entry will tell you how many bits are allocated per pixel.
.PP
Displays using at least 15 bits per pixel are typically
.B TrueColor
visuals, which do not have this problem, since their colormap is
permanently allocated and available to all applications.  (The visual
class is also displayed by
.BR xwininfo .)
For more information on visual classes see the documentation for the
X Window System.
.PP
To alleviate this problem, therefore, one may (a) run with more bits
per pixel (this may require adding more video memory or replacing the video
card), (b) shut down other applications that may be using much of the colormap
and then restart
.BR xdvi ,
or (c) run
.B xdvi
with the
.B \-install
option.
.PP
One application which is often the cause of this problem is
.BR Netscape .
In this case there are two more alternatives to remedying the situation.
One can run
.RB `` "netscape -install" ''
to cause
.B Netscape
to install a private colormap.  This can cause colors to change in
bizarre ways when the mouse is moved to a different window.
Or, one can run
.RB `` "netscape -ncols 220" ''
to limit
.B Netscape
to a smaller number of colors.  A smaller number will ensure that
other applications have more colors available, but will degrade the
color quality in the
.B Netscape
window.
#endif
.SH SIGNALS
When
.B xdvi
receives a
.SB SIGUSR1
signal, it rereads the
.I dvi
file.
.SH ENVIRONMENT
.TP
.SB DISPLAY
Specifies which graphics display terminal to use.
#ifconfig
.TP
.SB TEXMFCNF
Indicates a (colon-separated) list of directories to search for files named
.BR texmf.cnf ,
which are to be interpreted as configuration files.  An extra colon anywhere
in the list incorporates the compiled-in default value at that point.
See the section CONFIGURATION FILES for more details on configuration files,
how
.B xdvi
searches for them, and what they should contain.
#endif
.TP
.SB TEXMF
Indicates the top directory of \*(Te\& Directory Structure (TDS) trees to use
when searching for files.  It should be a list of directories, separated by
colons.  An extra colon anywhere in the variable incorporates the compiled-in
default value at that point.
See the section on FILE SEARCHING for more details.
.TP
.SB XDVISIZES
A list of font resolutions separated by colons.  If a font cannot be found
or made at its stated size, then these sizes are tried as a fallback.
.B xdvi
tries the actual size of the font before trying any of the given sizes.
Each font resolution should be a positive integer, specifying the number
of dots per inch, or a string of the form
.BR magstep\fIn\fP ,
where
.I n
is a number -9.5, -9, -8.5, ..., 8, 8.5, 9, or 9.5.  The string
.B magstep
may be shortened to any non-empty initial substring (so that
.B magstep0.5
may be shortened to
.B mag0.5
or
.B m0.5
(but not
.BR mag.5 )).
The entries
.BI magstep n
signify the current pixels-per-inch value, multiplied by 1.2 raised to the
.IR n th
power, and rounded to the nearest integer.
If the list begins with a colon, the system default sizes are used, as well.
Sizes are expressed in dots per inch and must be integers.
The current default set of sizes is @DEFAULT_FONT_SIZES@.
.B xdvi
will also try the actual size of the font before trying any of the given sizes.
.TP
.SB XDVIFONTS
Determines the path(s) searched for
.I pk
and
.I gf
font pixel files.  See the section on FILE SEARCHING for more details.
#iftexfonts
.TP
.SB PKFONTS
Determines the path(s) searched for
.I pk
and
.I gf
font pixel files if
.SB XDVIFONTS
is not set.
.TP
.SB TEXPKS
Determines the path(s) searched for
.I pk
and
.I gf
font pixel files if neither
.SB XDVIFONTS
nor
.SB PKFONTS
is set.
.TP
.SB TEXFONTS
Determines the path(s) searched for
.I pk
and
.I gf
font pixel files if none of
.SB XDVIFONTS,
.SB PKFONTS,
and
.SB TEXPKS
are set.  It may also be used for searching for fontmap files, encoding files,
and Type 1 font files, if
.B xdvi
has been compiled with support for the FreeType library.
If
.SB TEXFONTS
is used, it should not contain any
.RB ` % '
signs, since
.B xdvi
interprets this as a special character, but other applications do not.
#endif
.TP
.SB XDVIVFS
Determines the path(s) searched for virtual fonts
.RI ( vf
files).  See the section on FILE SEARCHING for more details.
#iftexfonts
.TP
.SB VFFONTS
Determines the path(s) searched for
.I vf
fonts if
.SB XDVIVFS
is not set.  If this is used, it should not contain any
.RB ` % '
signs, since
.B xdvi
interprets this as a special character, but other applications do not.
#endif
#ifps
.TP
.SB XDVIPICTS
Determines the path(s) searched for PostScript figure files.
See the section on FILE SEARCHING for more details.
.TP
.SB TEXPICTS
Determines the path(s) searched for PostScript figure files if
.SB XDVIPICTS
is not set.
.TP
.SB TEXINPUTS
Determines the path(s) searched for PostScript figure files if neither
.SB TEXPICTS
nor
.SB XDVIPICTS
is set.  Also determines the path(s) searched for source files if
.SB XDVISOURCES
is not set.
.TP
.SB XDVIHEADERS
Determines the path(s) searched for PostScript header files.
See the section on FILE SEARCHING for more details.
.TP
.SB TEXPSHEADERS
Determines the path(s) searched for PostScript header files if
.SB XDVIHEADERS
is not set.
.TP
.SB PSHEADERS
Determines the path(s) searched for PostScript header files if neither
.SB XDVIHEADERS
nor
.SB TEXPSHEADERS
is set.
#endif
.TP
.SB XDVISOURCES
Determines the path(s) searched for source files when invoking the
``source specials'' feature of
.BR xdvi .
#ifft
.TP
.SB XDVIT1FONTS
Determines the path(s) searched for PostScript Type 1 fonts.
See the section on FILE SEARCHING for more details.
.TP
.SB T1FONTS
Determines the path(s) searched for PostScript Type 1 fonts if
.SB XDVIT1FONTS
is not set.
.TP
.SB T1INPUTS
Determines the path(s) searched for PostScript Type 1 fonts if neither
.SB XDVIT1FONTS
nor
.SB T1FONTS
is set.  If none of these three variables is set, then
.SB TEXFONTS,
.SB XDVIHEADERS,
.SB TEXPSHEADERS,
and
.SB PSHEADERS
are checked (in that order) before using the compiled-in default value.
.TP
.SB XDVITYPE1CONFIG
Determines the path(s) searched for dvips-style configuration files (such as
.B config.ps
and
.BR config.xdvi )
to determine which fontmap files to read when mapping TeX font names to
Type 1 font names, Type 1 font files, encodings, etc.
See the section on FILE SEARCHING for more details.
.TP
.SB TEXCONFIG
Determines the path(s) searched for dvips-style configuration files if
.SB XDVITYPE1CONFIG
is not set.
.TP
.SB XDVIFONTMAPS
Determines the path(s) searched for fontmap files.
See the section on FILE SEARCHING for more details.
.TP
.SB TEXFONTMAPS
Determines the path(s) searched for fontmap files if
.SB XDVIFONTMAPS
is not set.  If neither of these variables is set, then
.SB TEXFONTS
is also checked before using the compiled-in default value.
.TP
.SB XDVIENCS
Determines the path(s) searched for encoding files.
See the section on FILE SEARCHING for more details.
.TP
.SB ENCFONTS
Determines the path(s) searched for encoding files if
.SB XDVIENCS
is not set.  If neither of these variables is set, then
.SB TEXFONTS
is also checked before using the compiled-in default value.
.TP
.SB XDVI_GS_LIB
Determines the path(s) searched for Ghostscript-style Fontmap files.
See the Ghostscript documentation for more details.
.TP
.SB GS_LIB
Determines the path(s) searched for Ghostscript-style Fontmap files if
.SB XDVI_GS_LIB
is not set.
#endif
.TP
.SB XEDITOR
Determines the command to be executed to pop up the editor, if neither the
.B \-editor
command-line option nor the
.B .editor
resource are specified.  See the section on SOURCE SPECIALS for details on
the format.
.TP
.SB VISUAL
Determines an editor to be popped up in an
.B xterm
window if neither
.BR \-editor ,
.BR .editor ,
nor
.SB XEDITOR
is given.
.TP
.SB EDITOR
Determines an editor to be popped up in an
.B xterm
window if neither
.BR \-editor ,
.BR .editor ,
.SB XEDITOR,
nor
.SB VISUAL
is given.
#ifmakepk
.TP
.SB XDVIMAKEPK
Address of the program (and, optionally, the order of its arguments) to
be called when
.B xdvi
attempts to create a
.I gf
or
.I pk
font file.  See the section on CREATING FONT FILES for more details.
#endif
#ifps
.TP
.SB TMPDIR
The directory to use for storing temporary files created when uncompressing
PostScript files.
#endif
#ifextraappdef
.TP
.SB XDVIINPUTS
Colon-separated list of paths to search for an extra
.I app-defaults
file.
#endif
.SH FILE SEARCHING
In order to accommodate the wide variety of ways in which fonts are stored
on various sites,
.B xdvi
has a fairly elaborate mechanism for indicating where to look for font files.
For other types of files, the mechanism is similar, but simpler.  The method
for looking for font pixel files will be described first; other file types will
then be described.  This section is quite technical; on first reading, it
would probably be better to skip to the section on EXAMPLES OF FONT SEARCHING.
.PP
The environment variable
.SB XDVIFONTS
(or
.SB PKFONTS,
etc., if
.SB XDVIFONTS
is not set) contains a list of specifiers, separated by colons.  An extra
colon anywhere in that list causes the compiled-in default value to be
substituted at that point.  Or, if no such environment variable is used,
the compiled-in default is also used instead.
#ifconfig
(However, see the section on CONFIGURATION FILES to see how they change the
situation concerning defaults.)
#endif
.PP
In each specifier, the following substitutions are first made:
.TP
.B %f
Replaced by the font name.
.TP
.B %F
Replaced by the font name (but without side effects; see below).
.TP
.B %d
Replaced by the size of the font (in dots per inch).
.TP
.B %b
Replaced by the base resolution; i.e., the value of the
.B \-p
parameter or the
.B .pixelsPerInch
resource.
.TP
.B %p
Replaced by the font file format
.RB (`` pk ''
or
.RB `` gf '').
.TP
.B %m
Replaced by the
.IR mode-def ,
as given in the
.B \-mfmode
argument or the
.B .mfMode
resource.
.TP
.B %t
Replaced, sequentially, by the directories given by the
.B TEXMF
environment variable (or its compiled-in default).  This may only be used
at the beginning of a specifier.
.TP
.B %s
Replaced by
.RB `` %qfonts/%p/{%m,modeless}// ''.
This is compatible with the \*(Te\& Directory Structure (TDS) standard.
This string may only be used at the end of a specifier.
.TP
.B %S
Replaced by
.RB `` %t/%s ''.
.TP
.B %q
Replaced by the empty string.  This has the side effect of enabling the
``quick find'' feature, which is described below.
.TP
.B %Q
Replaced by the empty string.  Like
.BR %q ,
this enables the ``quick find'' feature.  It also inhibits searching for the
file by normal means if ``quick find'' is not available.
.TP
.B %%
Replaced by a single percent sign.  Likewise,
.BR %: ,
.BR %* ,
etc. can be used to insert those special characters into the destination
string.
.PP
If no
.RB `` %f ''
appears in the specifier, then the string
.RB `` /%f.%d%p ''
is added on the end.
.PP
The characters
.BR * ,
.BR ? ,
.BR [ ,
.BR ] ,
.BR { ,
and
.B }
are interpreted as wild cards, as in the C-shell
.RB ( csh ).
(This is here to pave the way for
.I fli
files, which have not been implemented yet.)
In addition, a double slash
.RB (`` // '')
in the specifier indicates that any number of subdirectories may be inserted
at that point.
.PP
There is an exception to the above procedure.  If the font name begins
with a slash
.RB ( / ),
then the font name is treated as an absolute path:  the single specifier
.RB `` %f.%d%p ''
is used instead of the specifier(s) given by
.SB XDVIFONTS.
.PP
The recursive search over subdirectories triggered by a double slash often
causes a severe performance penalty; therefore,
.B xdvi
implements a speedup called ``quick find.''  This is triggered by the presence
of a
.RB `` %q ''
or
.RB `` %Q ''
in the specifier.  The location of such a string indicates that a file named
.B ls-R
should exist in that directory; that file should be the output of a
.B ls -R
or
.B ls -LR
command executed while in that directory.  If such a file exists, then
.B xdvi
will search that file instead of searching through the directory tree.
If such a file does not exist, and if
.RB `` %Q ''
was used, then
.B xdvi
will skip the specifier entirely.
.PP
In order for ``quick find'' to work,
a few conditions must be met.  First of all, the
.RB `` %q ''
or
.RB `` %Q ''
must occur immediately after a slash, and no later than immediately following
the double slash.  Secondly, there must be exactly one double slash in the
specifier (having more than one double slash requires more complicated
code in
.BR xdvi ;
if there are no double slashes then there is no need for ``quick find'').
Third, there may be no wild cards other than
.B {
and
.B }
in the specifier.  Finally,
.BR %f ,
.BR %F ,
and
.B %d
may not occur in the specifier prior to the double slash.  These conditions
are all satisfied in the case of the \*(Te\& Directory Structure (TDS) standard.
.PP
An additional exception is that if a specifier or one of the alternatives in the
.SB TEXMF
environment variable begins with two exclamation points
.RB (`` !! ''),
then those characters are stripped off, and any subordinate search that
could use an
.B ls-R
file, will be skipped if the
.B ls-R
file does not exist.  In other words, any
.RB `` %q ''
strings are treated as
.RB `` %Q ''.
This feature has been included for compatibility with the
.B Kpathsea
library.
.PP
Finally, if a specifier or one of the alternatives in the
.SB TEXMF
environment variable begins with a tilde
.RB ( ~ )
(after the
.RB `` !! '',
if any), then
.B xdvi
will attempt to replace a string of the form
.BI ~ username
with the home directory of
.IR username .
The
.I username
is taken to be everything up through the next slash or the end of the string;
if it is empty, then the current user's home directory is substituted instead.
If the username does not exist, then the string is left unchanged.
.SH SEARCHING FOR FONTS
When
.B xdvi
searches for a font, the first thing it does is to look for a
#ifft
PostScript Type 1 font (unless Type 1 fonts have been turned off by the
.B \-nofreetypefonts
command-line argument or
.B .freetypeFonts
X resource).  It does so by the following method.

.PP
First, it compiles a list of dvips-style map files, using the same procedure as
.B dvips
would use for a hypothetical printer named
.BR xdvi .
In other words, it searches the files
.BR config.ps ,
.B $HOME/.dvipsrc
(where
.B $HOME
refers to the user's home directory), and
.B config.xdvi
to determine a list of map files to search for the font.  It then searches
those map files for an entry pertaining to the font in question.  If an entry
for the font is found, then that entry must give the PostScript name for
the font, and may also give additional information such as the file name
of a Type 1 font file containing the font, an encoding file to use for
the font, or information on transformations to apply to the font
(expansion/contraction and slanting).  If the map files contain more than
one entry for a given font, then the first entry encountered will be used.
See the
.B dvips
documentation for details on this procedure.
.PP
If the map entry for the font gives a file name, then the named file is
searched for and used (if found) to provide the font.  Otherwise (if the
map entry does not give a file name), then
.B xdvi
uses the PostScript name given in the map entry to search for the font in
.B Fontmap
files, using the same method as Ghostscript uses to search for PostScript
fonts.
.PP
If an entry for the font is not found in one of the dvips map files, then
it is assumed not to be available in Type 1 format, and
.B xdvi
will then search for a
#endif
.I pk
or
.I gf
file, at the size required for the
.I dvi
file, using the strategy mentioned in the above subheading.
#ifdosnames
If that fails, it will try again, but for specifiers lacking a string
.RB `` %f '',
it will add the string
.RB `` /dpi%d/%f.%p ''
at the end (instead of
.RB `` /%f.%d%p '').
#endif
It will also try a slightly different size, in case of rounding errors.
.PP
If no such bitmap file is found, it then searches for a virtual font.
(A virtual font is a recipe for creating a font from characters in other fonts
and from rectangles.)  This uses the procedure described under FILE SEARCHING,
except that:  (1) the environment variable
.SB XDVIVFS
or its associated defaults is used in place of the environment variable
.SB XDVIFONTS
or its associated defaults;
(2)
.RB `` %d '',
.RB `` %b '',
.RB `` %p '',
and
.RB `` %m ''
are not substituted;
(3)
.RB `` %s ''
is replaced by
.RB `` %qfonts/vf// '';
(4) if no
.RB `` %f ''
appears in a specifier, then
.RB `` /%f.vf ''
is added at the end; and finally
(5) if the file name begins with a slash, then
.RB `` %f.vf ''
replaces all the specifiers.
.PP
If no virtual font is found, then
.B xdvi
will
#ifmakepk
invoke Metafont to create the font in the correct size.  Failing that, it will
#endif
try to find the nearest size.
If the font cannot be found at all, then
.B xdvi
will try to vary the point size of the font (within a certain range),
and if this fails, then it will use the font specified as the alternate
font (see
.BR \-altfont ).
.SH EXAMPLE OF FONT SEARCHING
This example describes how
.B xdvi
would search for the font
.B cmr10
at 300 dots per inch.  First,
#ifft
.B xdvi
searches the map files for an entry describing a font with TeX name
.BR cmr10 .
It will likely find a line
.RS 5
.nf
.ft 3
.sp 1n
cmr10 CMR10 <cmr10.pfb
.sp 1n
.ft
.fi
.RE
The (space-separated) entries in this line mean (in order) that the TeX name
of the font is
.BR cmr10 ,
the PostScript name is
.BR CMR10 ,
and the font is located in the file
.BR cmr10.pfb .
This file is searched for using the methods listed in the section on
FILE SEARCHING.  This is done using the same procedure as for font files,
except that:
(1)
.RB `` %f ''
and
.RB `` %F ''
refer to the file name, not the font name;
(2)
.RB `` %d '',
.RB `` %b '',
.RB `` %p '',
and
.RB `` %m ''
are not substituted;
(3)
.RB `` %s ''
is replaced by
.RB `` %qfonts/type1// '';
(4) if no
.RB `` %f ''
appears in a specifier, then
.RB `` /%f ''
is added at the end; and finally
(5) if the file name begins with a slash, then
.RB `` %f ''
replaces all the specifiers.
.PP
If no such map file entry is found, if the file
.B cmr10.pfb
cannot be found, or if Type 1 fonts have been turned off, then
#endif
.B xdvi
searches for the font in raster format at 300 dpi.  For example, if the
specifier is
.RB `` /usr/local/tex/fonts '',
then
.B xdvi
looks for
.B /usr/local/tex/fonts/cmr10.300pk
and
.BR /usr/local/tex/fonts/cmr10.300gf ,
in that order (provided that
.B xdvi
is compiled to accept both
.I pk
and
.I gf
files, which is not necessarily the case).
.PP
For sites using the \*(Te\& Directory Structure (TDS) standard,
.SB XDVIFONTS
(or, better yet, its compiled-in default) should be set to
.RB `` .:%S '';
in that case, if
.SB TEXMF
(or, again, its compiled-in default) is set to
.RB `` /usr/local/texmf '',
then
.B xdvi
will look within that directory for the font file, in accordance with the
TDS standard.
.PP
There may be several such TDS trees.
.PP
A common situation is one in which a user wishes to augment the set of fonts
provided by the system.  It is possible to do this without having to know
or remember what the defaults are.  For example, if the user has a small
number of fonts, and keeps them all in one directory, say
.BR /home/user/fonts ,
then setting
.SB XDVIFONTS
to
.RB `` /home/user/fonts: ''
will cause
.B xdvi
to check that directory for font files before checking its default list.
Similarly, setting
.SB XDVIFONTS
to
.RB `` :/home/user/fonts ''
will cause
.B xdvi
to check that directory
.I after
checking its default locations.  This is true even if the system uses a TDS
tree.
#iftexfonts
.PP
If that directory also contains
.I tfm
files, then it is possible to set
.SB TEXFONTS
instead of
.SB XDVIFONTS;
in that case, \*(Te\& will also look for the
.I tfm
files in that directory.  This feature depends on which implementation
of \*(Te\& is in use.  The
.SB XDVIFONTS
variable overrides the
.SB TEXFONTS
variable, so that on those sites where
.SB TEXFONTS
must be set explicitly, and therefore this feature is not useful, the
.SB XDVIFONTS
variable may be set to an empty string (i.e.,
.RB  `` "setenv XDVIFONTS" '')
to cause
.B xdvi
to ignore
.SB TEXFONTS.
#endif
.PP
If the user has a large number of fonts and wishes to keep them in a TDS
tree, then that is also possible with
.BR xdvi :
if, for example, the TDS tree is
.BR /home/user/texmf ,
then setting
.SB TEXMF
to
.RB `` /home/user/texmf: ''
will cause
.B xdvi
to check that TDS tree before its default actions.  This assumes, however,
that the site uses a TDS tree also (since
.SB TEXMF
is not used unless
.RB `` %t ''
or
.RB `` %S ''
occurs in a specifier somewhere).  If the site does not use a TDS tree,
then it would be best to set
.SB XDVIFONTS
to
.RB `` /home/user/texmf/%s: '',
instead.
#ifmakepk
.SH CREATING FONT FILES
.PP
When
.B xdvi
reaches a point where it cannot find a font in the correct size, it calls
a program to create such a font file.  The name of this program (usually
a shell script) may be controlled by the environment variable
.SB XDVIMAKEPK.
Usually this variable would be set to the name of the script.
In that case the script is called with options giving the font name,
the requested resolution in dots per inch, the base resolution in dots
per inch, a (possibly more accurate) indication of the magnification
using magsteps (if possible), and the
.I mode-def
that Metafont is to use when creating the font file.
.PP
The
.I mode-def
used is the one given by the
.B \-mfmode
argument on the command line, the
.B mfMode
resource, or the compiled-in default (if any).  If none of these are given,
the string
.RB `` @MKTEXPK_DEFAULT_MODE@ ''
is used.
.PP
Optionally, the
.SB XDVIMAKEPK
variable may include the following designators:
.TP
.B %n
Replaced by the font name.
.TP
.B %d
Replaced by the resolution (in dots per inch) of the desired pixel file.
.TP
.B %b
Replaced by the base resolution of the Metafont mode.
.TP
.B %m
Replaced by an indication of the magnification to be applied.
.TP
.B %o
Replaced by the Metafont
.IR mode-def.
.TP
.B %r
Replaced by a string of the form
.BI ``>& digit '',
enclosed in single quotes, where
.I digit
indicates a file number on which the program is to write the full path of the
font file that it has created.
.PP
If the
.SB XDVIMAKEPK
string uses designators, if a
.I mode-def
is known to
.BR xdvi ,
but if no
.RB `` %o ''
designator was used, then the mode will be appended to the end of the string.
Also, if no
.RB `` %r ''
was used, then
.B xdvi
expects the program to write the full path of the font file on its standard
output.
.PP
By default,
.SB XDVIMAKEPK
equals
.BR @MKTEXPK_PATH@ .
If no designator
.RB `` %n ''
appears in the
.SB XDVIMAKEPK
string, then the string
.B @MKTEXPK_TAIL@
will be appended.
.PP
This mechanism is compatible with the font creation mechanism used in
.BR dvips (1)
and the
.B Kpathsea
library.
#endif
#ifps
.SH SEARCHING FOR POSTSCRIPT FILES
PostScript figure files and header files are searched for using a modification
of the procedure used for font files.
First, if the file name does not begin with a slash, then
.B xdvi
will look in the directory containing the
.I dvi
file.  If it is not found there, then the
.SB XDVIPICTS
and
.SB XDVIHEADERS
environment variables determine the search strategy for PostScript
figure files and header files, respectively.  This is the same procedure as
for font files, except that:
(1)
.RB `` %f ''
and
.RB `` %F ''
refer to the file name, not the font name;
(2)
.RB `` %d '',
.RB `` %b '',
.RB `` %p '',
and
.RB `` %m ''
are not substituted;
(3)
.RB `` %s ''
is replaced by
.RB `` {%qdvips//,%qtex//} ''
for figure files or
.RB `` %qdvips// ''
for header files;
(4) if no
.RB `` %f ''
appears in a specifier, then
.RB `` /%f ''
is added at the end; and finally
(5) if the file name begins with a slash, then
.RB `` %f ''
replaces all the specifiers.
Customarily,
.SB XDVIPICTS
will be the same as the \*(Te\& input directory.
.PP
There is an additional exception to the above strategy.
If the file name begins with a backtick
.RB ( ` ),
then the remaining characters in the file name give a shell command (often
.BR zcat )
which is executed; its standard output is then sent to be interpreted as
PostScript.  Note that there is some potential for security problems here;
see the
.B \-allowshell
command-line option.  It is better to use compressed files directly (see below).
.PP
If a file name is given (as opposed to a shell command),
if that file name ends in
.RB `` .Z '',
.RB `` .gz '',
or
.RB `` .bz2 '',
and if the initial bytes of the file indicate that it was compressed with
.BR compress (1),
.BR gzip (1),
or
.BR bzip2 (1),
respectively, then the file is first uncompressed with
.BR "uncompress \-c" ,
.BR "gunzip \-c" ,
or
.BR "bunzip2 \-c" ,
respectively.  This is preferred over using a backtick to call the command
directly, since you do not have to specify
.B \-allowshell
and since it allows for path searching.
#endif
#ifextraappdef
.SH X RESOURCES
It is often desirable to set X Window System resources from a file within the
.B texmf
tree instead of within the X Window System directory hierarchy.
For this reason,
.B xdvi
searches for a file named
.RB `` XDvi ''
in the main directory of all
.B texmf
trees, or in its subdirectories
.B xdvi
or
.BR web2c .
The search path for this file can be overridden by using the
.SB XDVIINPUTS
environment variable.
#endif
#ifconfig
.SH CONFIGURATION FILES
.B xdvi
allows for any number of configuration files; these provide additional levels
of defaults for file paths.  For example, when searching for font pixel files,
the hierarchy of defaults is as follows:
.TP
First
The value of the
.SB XDVIFONTS,
.SB PKFONTS,
.SB TEXPKS,
or
.SB TEXFONTS
environment variable (if any).
.TP
 .
The value of
.SB PKFONTS
given in the first config file searched.
.TP
 .
 ...
.TP
 .
The value of
.SB PKFONTS
given in the last config file searched.
.TP
Last
The compiled-in default value.
.PP
The first of these in the list that is given is used; if an extra colon is
present in that string, then the next in the list is used.  Additional extra
colons are ignored; if no extra colon is present, then the remainder of the
list is ignored.  Note that, unlike the situation with environment variables,
only one name may be used in the config file.  Additionally, if a config file
defines a variable such as
.SB PKFONTS
more than once, only the first value is used.
.PP
Other special config file variables are:
.TP 12
.SB TEXMF
Directories to substitute for
.BR %t .
But, see the caution below.
.TP
.SB VFFONTS
Search specifiers for virtual fonts.
#endif
#ifconfigps
.TP
.SB TEXPICTS
Search specifiers for PostScript figure files.
.TP
.SB PSHEADERS
Search specifiers for PostScript header files.
#endif
#ifconfig
.PP
The configuration file may also define other variables; these (as well as
.SB PKFONTS
and the other variables listed above) will be substituted whenever they are
referred to, using either the syntax
.BI $ variable\fR,\fP
in which
.I variable
consists of the longest string consisting of letters, digits, and underscores
following the dollar sign, or the syntax
.BI ${ variable }\fR,\fP
which is interpreted without matching the braces.  These substitutions occur
before brace expansions, which in turn occur before tilde expansions.
Substitutions of this sort are global:  only the first definition of a
variable is used, even if there are multiple configuration files.
This holds also when variables such as
.SB PKFONTS
are substituted via
.B $PKFONTS
instead of the hierarchy of defaults mentioned earlier.
Also, an environment variable will override a corresponding configuration
file variable.  Undefined variables are replaced with the empty string.
.PP
.B Note:
Some configuration files define a variable
.SB TEXMF
and access it via
.BR $TEXMF .
When using such files with
.BR xdvi ,
it may be necessary to avoid using
.B %t
and
.B $S
if the definition is incompatible with how that special symbol is used by
.BR xdvi .
For example,
.B xdvi
does not support brace expansion within
.SB TEXMF
when it is used in the context of
.BR %t ,
so if a configuration file defines
.SB TEXMF
as a string involving braces, then
.B $TEXMF/%s
should be used instead of
.BR %S .
#endif
#ifselfauto
.PP
When starting up,
.B xdvi
will determine where its executable file is located, and will define three
special configuration file variables based on that information.
It defines
.SB SELFAUTOLOC
to be the directory containing the binary,
.SB SELFAUTODIR
to be the parent of that directory, and
.SB SELFAUTOPARENT
to be the parent of that directory.  For example, if
.B xdvi
is in the executable file
.BR /usr/local/tex/texmf/bin/sunos4/xdvi ,
then the value of
.SB SELFAUTOLOC
will be
.BR /usr/local/tex/texmf/bin/sunos4 ,
.SB SELFAUTODIR
will be
.BR /usr/local/tex/texmf/bin ,
and
.SB SELFAUTOPARENT
will be
.BR /usr/local/tex/texmf .
These three variables are special:  they cannot be defined in a configuration
file or in the environment.
#endif
#ifconfig
.PP
The syntax of configuration files is as follows.  Blank lines, and lines
in which the first non-white character is
.B #
or
.BR % ,
are assumed to be comment lines, and are ignored.
All other lines must be of the form
.IB variable = value\fR,\fP
in which
.I variable
is either a variable name or a qualified variable name (discussed below), and
.I value
is the value to be assigned to the variable.  A qualified variable name
is a variable name, followed by a period and a string.
A definition using a qualified variable name will be ignored, unless
the string matches either of (a) the argument of the
.B \-name
command-line argument (or the filename part of the path of the executable
file for
.B xdvi
(usually ``xdvi''), if no
.B \-name
option was used); or (b) the string ``XDvi'' (the
.I class
of
.BR xdvi ).
Since only the first definition of a variable will have any effect, an
unqualified definition should be placed after all qualified definitions
of that same variable.
.PP
There may be several configuration files.  They are located as follows.
Initially, an environment variable
.SB TEXMFCNF
is used; it should contain a colon-separated list of directories.
All of those directories will be searched for files named
.BR texmf.cnf ,
and those files will all be read.  Those files may also define variables
.SB TEXMFCNF;
if so, then those variables are taken to be colon-separated lists of
directories.  This defines the data structure of a tree; this tree is
read in the obvious depth-first order.  Duplicate directories are skipped
in order to avoid infinite loops.  Finally, an extra colon anywhere in any
of these lists causes the compiled-in default to be substituted at that
point.  In addition, if
.SB TEXMFCNF
is not defined in the environment, then the search starts with the compiled-in
default (it is expected that this will usually be the case).
.PP
If there are more than one
.B texmf
tree, then it is expected that each of them will have its own configuration
file; the easiest way to combine them is to link them together in a chain
(a vertical tree).  The last file in the chain can be set up as if it were
the only configuration file, and all others could contain a definition of
.SB TEXMFCNF
pointing to the directory of the next configuration file in the chain,
and definitions for
.SB TEXMF
or
.SB PKFONTS,
etc., with extra colons at the end so that the values from configuration
files lower in the chain are also used.
#endif
#ifps
.SH LIMITATIONS
.B xdvi
accepts many but not all types of PostScript specials accepted by
.BR dvips .
For example, it accepts most specials generated by
.B epsf
and
.BR psfig .
It does not, however, support
.B bop\-hook
or
.BR eop\-hook ,
nor does it allow PostScript commands to affect the rendering of things that
are not PostScript (for example, the ``NEAT'' and rotated ``A'' examples in the
.B dvips
manual, and the
.B PSfrag
package).  These restrictions are due to the design of
.BR xdvi ;
in all likelihood they will always remain.
.PP
La\*(Te\&2e rotation specials are not currently supported.
.PP
.B MetaPost
files containing included text are not supported.
#endif
.SH FILES
.PD 0
#ifconfig
@DEFAULT_CONFIG_PATH@   Directories to be searched for configuration files.
#endif
@DEFAULT_TEXMF_PATH@   \*(Te\& Directory Structure (TDS) directories.
.TP 40
@DEFAULT_FONT_PATH@   Font pixel files.
@DEFAULT_VF_PATH@   Virtual font files.
#ifps
.TP
@DEFAULT_FIG_PATH@   Directories containing PostScript figures.
.TP
@DEFAULT_HEADER_PATH@   Directories containing PostScript header files.
#endif
#ifft
.TP
@DEFAULT_DVIPS_CF_PATH@   Directories containing dvips configuration files.
.TP
@DEFAULT_FONTMAP_PATH@   Directories containing dvips-style fontmap files.
.TP
@DEFAULT_ENC_PATH@   Directories containing encoding files.
.TP
@DEFAULT_TYPE1_PATH@   Directories containing PostScript Type 1 font files.
.TP
@DEFAULT_GS_LIB_PATH@   Directories containing Ghostscript Fontmap files.
#endif
.PD
.SH SEE ALSO
.BR X (1),
.BR dvips (1).
.SH AUTHORS
Eric Cooper, CMU, did a version for direct output to a QVSS.
Modified for X by Bob Scheifler, MIT Laboratory for Computer Science.
Modified for X11 by Mark Eichin, MIT SIPB.
Additional enhancements by many others.
The current maintainer is Paul Vojta, U.C. Berkeley.
.PP
Please report bugs to the SourceForge bug tracker:
.PP
.nf
.B http://sourceforge.net/tracker/?func=add&group_id=23164&atid=377580
.PP
