/*
 *  TEX Device Driver  ver 2.26
 *  copyright(c) 1988, 1989 by TSG.
 *
 *  buffer.h : macro routines for buffer access
 *  Apr. 15, 1989 : first edition
 *  Jul.  1, 1989 : 2nd edition
 */

#if DEBUG & MEM_CHK
int _get_int(BUFFER **);
long _get_mid(BUFFER **);
long _get_long(BUFFER **);
static void (*_ptrchk) (BUFFER *);

#define get_ubyte(p) ((*_ptrchk)(p),(uchar)*(p)++ )
#define get_byte(p) ((*_ptrchk)(p),(signed char)*(p)++ )
#define get_int(p)  ((*_ptrchk)(p),_get_int(&(p)))
#define get_mid(p)  ((*_ptrchk)(p),_get_mid(&(p)))
#define get_long(p) ((*_ptrchk)(p),_get_long(&(p)))
#define move_ptr(p,n) ((*_ptrchk)(p),(p)+=(n))
#else
int _get_int(BUFFER **);
long _get_mid(BUFFER **);
long _get_long(BUFFER **);

#define get_ubyte(p)    ((uchar)*(p)++ )
#define get_byte(p) ((signed char)*(p)++ )
#define get_int(p)  (_get_int(&(p)))
#define get_mid(p)  (_get_mid(&(p)))
#define get_long(p) (_get_long(&(p)))
#define move_ptr(p,n)   ((p)+=(n))
#endif

#define is_end_of(p) ((HUGE_BUF*)p->current >= (HUGE_BUF*)p->end)

/* end of file : buffer.h */
