/*
** Datei: DVINECP6.C
** Autor: Ingo Eichenseher
*/

#include <stdio.h>
#include <stdarg.h>
#include "dvi.h"
#include "dviframe.h"
#include "dvihdcp.h"

/*
** ------------------------ NEC P6 high (360x360) -------------------
*/

static void skpl_p6high(int skip)
{
    if (skip&1) prbyte(10);
    skip>>=1;
    if (skip)
    {
	while(skip>255)
	{
	    prbyte(13); prbyte(27); prbyte('J'); prbyte(255);
	    skip -= 255;
	}
	prbyte(13); prbyte(27); prbyte('J'); prbyte(skip);
    }
}

static int send_p6high(long addr, int words, int frame_width, int pos)
{
    unsigned int lines, columns, pattern;
    for (lines=0; lines<2; lines++, addr+=frame_width)
    {
	if (op.separate) { pattern=0xAAAA; columns=0; }
	else { pattern=0xFFFF; columns=1; }
	for (; columns<2; columns++, pattern>>=1)
	{
	    prbyte(27); prbyte('\\');
	    prbyte( (pos/2)&255 );
	    prbyte( (pos/2)>>8  );

	    prbyte(27); prbyte('*'); prbyte(40);
	    if (pos&1)
	    {
		prbyte( (words*16+1)&255 );
		prbyte( (words*16+1)>>8  );
		prbyte(0); prbyte(0); prbyte(0);
	    }
	    else
	    {
		prbyte( (words*16)&255 );
		prbyte( (words*16)>>8  );
	    }
	    send24(frame_ptr(addr),words,frame_width*2,pattern);

	    prbyte(13);
	}
	prbyte(10);
    }
    return 2;
}

static void init_p6high(void)
{
    prbyte(27); prbyte('x'); prbyte(1);
    prbyte(28); prbyte('3'); prbyte(1);
}

static void exit_p6high(void)
{
    if (op.formfeed) prbyte(12);
    prbyte(27); prbyte('2');
}

/*
** ------------------------ NEC P6 low (180x180) --------------------
*/

/* also for FX80 */
void skpl_p6low(int skip)
{
    if (skip)
    {
	while(skip>255)
	{
	    prbyte(13); prbyte(27); prbyte('J'); prbyte(255);
	    skip -= 255;
	}
	prbyte(13); prbyte(27); prbyte('J'); prbyte(skip);
    }
}

static int send_p6low(long addr, int words, int frame_width, int pos)
{
    prbyte(27); prbyte('\\');
    prbyte( pos&255 );
    prbyte( pos>>8  );

    prbyte(27); prbyte('*'); prbyte(39);
    prbyte( (words*16)&255 );
    prbyte( (words*16)>>8  );
    send24(frame_ptr(addr),words,frame_width,0xFFFF);

    prbyte(13);
    return 0;
}

static void init_p6low(void)
{
    prbyte(27); prbyte('x'); prbyte(1);
}

static void exit_p6low(void)
{
    if (op.formfeed) prbyte(12);
    prbyte(27); prbyte('2');
}

/*
** ------------------------ NEC P6 mid (360x180) --------------------
*/

static int send_p6mid(long addr, int words, int frame_width, int pos)
{
    int columns, pattern;
    if (op.separate) { pattern=0xAAAA; columns=0; }
    else {pattern=0xFFFF; columns=1; }
    for (; columns<2; columns++, pattern>>=1)
    {
	prbyte(27); prbyte('\\');
	prbyte( (pos/2)&255 );
	prbyte( (pos/2)>>8  );

	prbyte(27); prbyte('*'); prbyte(40);
	if (pos&1)
	{
	    prbyte( (words*16+1)&255 );
	    prbyte( (words*16+1)>>8  );
	    prbyte(0); prbyte(0); prbyte(0);
	}
	else
	{
	    prbyte( (words*16)&255 );
	    prbyte( (words*16)>>8  );
	}
	send24(frame_ptr(addr),words,frame_width,pattern);

	prbyte(13);
    }
    return 0;
}

int p6low(void)
{
    return print_page(24,skpl_p6low,send_p6low,init_p6low,exit_p6low);
}

int p6high(void)
{
    return print_page(48,skpl_p6high,send_p6high,init_p6high,exit_p6high);
}

int p6mid(void)
{
    return print_page(24,skpl_p6low,send_p6mid,init_p6low,exit_p6low);
}

