/*
** Datei: DVIATARI.C
** Autor: Ingo Eichenseher
*/

#include <stdio.h>
#include <stdlib.h>
#ifdef __ATARIGNU__
#include <stdarg.h>
#endif
#include "dvi.h"
#include "dvihdcp.h"

/*
** -----------------------------------------------------------------
** Atari spezifische Unterprogramme, Variablen, includes und defines
** -----------------------------------------------------------------
*/

#ifdef __TURBOC__
#include <ext.h>
#include <tos.h>
#endif

#ifdef __ATARIGNU__
#include <osbind.h>
#include <aesbind.h>
#include <vdibind.h>
#endif

/*
** Die folgende Funktion stellt fest, ob die Tasten
** Control+Shift+Alternate gedrueckt wurden (in diesem Fall ist
** das Funktionsergebnis ungleich 0).
*/

int stop_key(void)
{
    return (Kbshift(-1)&14)==14;
}

/* 
** Die folgende Funktion gibt ein Zeichen auf dem Drucker
** aus. 
*/

void prbyte(int c)
{
    extern int dviprn(int c);
    if (red_fp == NULL)
    {
	int err;

#if defined(__ATARIGNU__)
	err = 0;
	if ( op.biosprint )
	    Cprnout( c );
	else
	    err = dviprn( c );
#else
	if (op.biosprint) err = !Cprnout(c);
	else err = dviprn(c);
#endif

	if (err) halt("Printer time out");
    }
    else putc(c,red_fp);
}

