#include <stdio.h>
#include <stdarg.h>
#include "dvi.h"
#include "dvilw.h"

int read_img(char *name, int x, int y, double density)
{
    IMG_FILE *img;
    unsigned char *p;
    int w,h,bytes,pw,ph;

    img = img_open(name,&w,&h,&bytes,&pw,&ph,op.img_path);
    if (img==NULL) return 1;

    density = density;
    psprint("gsave\n");
    psprint("%d %d translate %g %g scale\n",x,y,
	    (double)op.hres*(double)(bytes*8)*(double)pw/25400.0,
	    (double)op.vres*(double)h*(double)ph/25400.0);
    psprint("%d %d %d [ %d 0 0 %d 0 %d ]\n",
	    bytes*8,h,1,bytes*8,-h,h);
    psprint("{ currentfile %d string readhexstring pop } image\n",
	    bytes);
    while(h--)
    {
	int i;
	p=(unsigned char*)img_read((char *)NULL,img);
	for (i=0; i<bytes; i++) psprint("%02x",0xff^*p++);
	pschar('\n');
    }
    psprint("grestore\n");

    img_close(img);
    return 0;
}

