/* dvireader.h - 21:21 GMT +10:00 Sat 12 Jun 1993 - modifier Geoffrey Tobin. */

#ifndef DVIREADER_H
#define DVIREADER_H

/* Include file ../include/dvireader.h from dvitovdu.c */

/* DVIReader */

#define ruletablesize   300   /* maximum number of rules in a ruletable    */
#define chartablesize   3000   /* maximum number of chars in a chartable    */
#define maxfontspec     maxstring
    /* max length of a font file specification   */
#define maxspeciallen   maxstring
    /* maximum length of \special string         */
#define maxTeXchar      255   /* ignore character codes > 255              */

typedef struct _REC_ruletable
{
  int hp, vp;   /* pixel coords of rule's ref point */
  int wd, ht;   /* dimensions of rule in pixels     */
} _REC_ruletable;

typedef struct _REC_chartable
{
  int hp, vp;   /* pixel coords of char's ref point */
  unsigned char code;   /* char's code and pixeltable index */
} _REC_chartable;

typedef struct _REC_pixeltable
{
  int wd, ht;
  /* glyph width and height in pixels; they
                             define the size of the smallest box
                             containing all the black pixels           */
  int xo, yo;
  /* x and y offsets from top left corner
                             of glyph to character's reference point   */
  int dwidth;
  /* advance width in DVI units computed from
                             fix width stored in font file             */
  int pwidth;
  /* advance width in pixels computed from
                             fix width stored in font file             */
  int mapadr;   /* byte offset of bitmap info in font file   */
  int_or_mptr bitmap;   /* SYSDEP: starting address of bitmap        */
} _REC_pixeltable;

/* Information about the rules and characters appearing on a page is stored
   in dynamic one-way lists to avoid imposing any limit on their numbers.
   To reduce pointer overheads, the nodes in these lists contain large
   tables (the values of ruletablesize and chartablesize have been chosen
   so that the vast majority of DVI pages will only require one-node lists).
   When interpreting a DVI page, DVIReader adds a new rule or character node
   to the TAIL of the relevant list.  This is done so that when DVItoVDU
   accesses such lists (starting at the head), rules and characters will be
   processed in somewhat the same sequence as seen in the DVI file; i.e.,
   top-to-bottom and left-to-right across the page.
   Since a character list is part of the information stored for a font,
   the precise sequence in which DVI characters are seen is not remembered.
   Font information is also linked together in a one-way list, but the
   ordering is more or less random (see, however, the SortFonts routine).
*/

typedef struct ruleinfo
{
  int rulecount;   /* number of rules in ruletable     */
  _REC_ruletable ruletable[ruletablesize];
  struct ruleinfo *nextrule;   /* next node in rule list           */
} ruleinfo;   /* a node in a list of ruletables   */

typedef struct charinfo
{
  int charcount;   /* number of chars in chartable     */
  _REC_chartable chartable[chartablesize];
  struct charinfo *nextchar;   /* next node in char list           */
} charinfo;   /* a node in list of chartables     */

/* DVIReader uses wd, ht, xo and yo to calculate minhp, minvp, maxhp and
   maxvp.  dwidth and pwidth are used to advance horizontally.
   The mapadr and bitmap fields are not used by DVIReader; they are used
   by FontReader and the main program to load character bitmaps.
*/
typedef _REC_pixeltable pixeltable[maxTeXchar + 1];

typedef struct fontinfo
{
  boolean pkfont;    /* is this a PK bitmap font?          */
  boolean psfont;    /* is this a PS or pure TFM font?     */
  boolean fontused;  /* is font used on current page?      */
  int fontnum;       /* DVI font number: -2^31 .. 2^30 - 1 */
  int scaledsize;    /* scaled font size in DVI units      */
  int designsize;    /* design size in DVI units           */
  string fontarea;   /* explicit font directory            */
  int fontarealen;   /* length of fontarea                 */
  string fontname;   /* font name; e.g., "cmr10"           */
  int fontnamelen;   /* length of font name                */
  string fontspec;   /* complete font file pathname        */
  int fontspeclen;   /* length of fontspec                 */
  boolean fontexists;   /* can fontspec be opened?         */
  boolean honest;     /* true (and not substitute) font    */
  int totalchars;    /* number of chars from font on page  */
  charinfo * charlist;   /* head of char information list  */
  charinfo * chartail;   /* tail of char information list  */
  _REC_pixeltable * pixelptr;   /* allocated once: 1st time font used */
  struct fontinfo * nextfont;   /* next node in font list  */
} fontinfo;   /* a node in list of fonts            */

/* For the parameter in MoveToTeXPage: */
typedef int TeXcounters[10];

typedef struct TeXpageinfo
{
  TeXcounters value;   /* \count0..\count9 values    */
  boolean present[10];   /* is counter relevant?       */
  char lastvalue;   /* last relevant counter      */
} TeXpageinfo;

/* DVIReader also builds a list of \special info: */

typedef struct specialinfo
{
  string special;
  int hp, vp;
  struct specialinfo *nextspecial;
} specialinfo;


/* Most of these should be treated as read-only parameters:                */
#ifndef Extern
#define Extern extern
#endif
Extern int DVImag;   /* magnification stored in DVI file        */
Extern int totalpages;   /* number of pages in DVI file             */
Extern int totalfonts;   /* number of fonts in DVI file             */
Extern int currDVIpage;   /* updated by MoveTo... calls              */
Extern TeXcounters currTeXpage;
    /* ditto                                   */
Extern int totalrules;   /* number of rules on current page         */
Extern ruleinfo *rulelist;   /* head of rule information list           */
Extern ruleinfo *ruletail;   /* tail of rule information list           */
Extern specialinfo *speciallist;
    /* head of \special information list       */
Extern fontinfo *fontlist;   /* head of font information list           */
Extern fontinfo *currfont;   /* InterpretPage's current font info       */
Extern boolean pageempty;   /* is page empty of rules and chars?       */
Extern int minhp;   /* minimum horizontal pixel coordinate     */
Extern int minvp;   /* minimum vertical pixel coordinate       */
Extern int maxhp;   /* maximum horizontal pixel coordinate     */
Extern int maxvp;   /* maximum vertical pixel coordinate       */

extern Void InitDVIReader (VOID);
extern Void OpenDVIFile __((Char *name));
extern Void SetConversionFactors __((double xres, double yres, double magnification));
extern Void MoveToDVIPage __((int n));
extern Void MoveToNextPage __((boolean ascending));
extern boolean MoveToTeXPage __((TeXpageinfo *newTeXpage));
extern int XPixelRound __((int DVIunits));
extern int YPixelRound __((int DVIunits));
extern Void InterpretPage (VOID);
extern Void SortFonts __((fontinfo **unusedlist));
extern Void CloseDVIFile (VOID);

#endif /* DVIREADER_H */

/* end dvireader.h */
