{$N-,V-,W-,G+}

{$DEFINE NewStat}

Unit wbibstat;

interface

Uses
  WObjects, WinTypes, WinProcs, Strings,
  bibvars, bibstrg, bibutil, rc_id, wbibdisp;

const
  StatusBox_Click = wm_User+1;

  Status_NBoxes = 8; Status_ActiveBoxes = 7;

  SBox_entries = 1; SBox_Linked  = 2; SBox_Sort     = 3;
  SBox_Unix    = 4; SBox_RO      = 5; SBox_Ind      = 6;
  SBox_Patt    = 7; SBox_Message = 8;
  SBox_Help    = 9;

  PattStatus_NBoxes = 2; PattStatus_ActiveBoxes = 2;
  SBox_CaseSen = 1; SBox_RegExp = 2;

  stat_EntriesClick = 1;  stat_LinkClick = 2;
  stat_SortClick    = 3;  stat_ReadOnly  = 4;
  stat_PattClick    = 5;

type

  PStatusBox = ^TStatusBox;
  TStatusBox = object(TWindow)
    Text: array[boolean] of PChar;
    Active,Centered,YesText: boolean;
    Identifier,BoxHeight,BoxWidth: integer;
    constructor init(AParent: PWindowsObject; AIdentifier: integer;
                AYesText,ANoText: PChar; ACentered: boolean);
    procedure   FontAndSize(Str1,Str2: PChar);
    function    GetClassName: PChar; virtual;
    procedure   GetWindowClass(var Class: TWndClass); virtual;
    procedure   SetupWindow; virtual;
    procedure   Paint(PaintDC: HDC; var PaintInfo: TPaintStruct); virtual;
    procedure   wmMouseMove(var Msg: TMessage); virtual wm_first+wm_MouseMove;
    procedure   wmLButtonDblClk(var Msg: TMessage);
                              virtual wm_first+wm_LButtonDblClk;
    procedure   wmRButtonDown(var Msg: TMessage);
                              virtual wm_First+wm_RButtonDown;
    procedure   SetState(Yes,IsActive: boolean);
    procedure   SetText(YesStr,NoStr: PChar);
    destructor  done; virtual;
  end;

  StatusBoxList = array[1..Status_NBoxes] of PStatusBox;

  PHelpBar = ^THelpBar;
  THelpBar = object(TWindow)
    Height,BoxHeight,HelpTextId,NBoxes,ActiveBoxes: integer;
    LastPos,LeftPos: integer;
    FirstTime: boolean;
    HelpBox: PStatusBox;
    StatusBarBoxes: StatusBoxList;
    ClientRect: TRect;
    constructor Init(AParent: PWindowsObject);
    function    GetClassName: PChar; virtual;
    procedure   GetWindowClass(var Class: TWndClass); virtual;
    procedure   SetupWindow; virtual;
    procedure   Paint(PaintDC: HDC; var PaintInfo: TPaintStruct); virtual;
    procedure   Resize;
    procedure   PutHelpText(Id: integer);
    procedure   PutHelpStr(S: string; Id: integer);
    procedure   CheckHelpPos(Redraw: boolean);
    procedure   HideHelpText(Force,Redisplay: boolean);
    procedure   MoveBarTo(W,H: integer);
    procedure   ClearHelpText; virtual;
  end;

  PPattStatusBar = ^TPattStatusBar;
  TPattStatusBar = object(THelpBar)
    constructor Init(AParent: PWindowsObject);
    procedure   Update(CaseSen,RegExp: boolean);
  end;

  PStatusBar = ^TStatusBar;
  TStatusBar = object(THelpBar)
    procedure   ClearHelpText; virtual;
    constructor Init(AParent: PWindowsObject);
    procedure   SetupWindow; virtual;
    procedure   Update;
    procedure   Clicked(var Msg: TMessage); virtual wm_first+StatusBox_Click;
    procedure   PutStatusMessage(S: string);
    procedure   ShowStatusMessage;
    procedure   HideStatusMessage;
  end;

var
  StatusBar: PStatusBar;
  CurrentHelpBar: PHelpBar;

implementation

const
  Status_TextEdgeTop  = 0; Status_TextEdgeBottom = 0;
  Status_TextEdgeSide = 2; Status_BoxEdge        = 2;
  Status_BoxDist      = 6;

  SBClicked_Right = 1; SBClicked_Double = 2;

{ TStatusBox methods }

constructor TStatusBox.init(AParent: PWindowsObject;
            Aidentifier: integer;
            AYesText,ANoText: PChar; ACentered: boolean);
begin
  TWindow.Init(AParent,Nil);
  Text[true]:=Nil; Text[false]:=Nil;
  if AYesText<>Nil then Text[true ]:=StrNew(AYesText);
  if ANoText<>Nil  then Text[false]:=StrNew(ANoText);
  Centered:=ACentered;
  YesText:=true;
  Active:=false;
  identifier:=AIdentifier;
  BoxWidth:=0; BoxHeight:=0;

  with Attr do
  begin
    X:=0; Y:=0; W:=1; H:=1;
    Style:=ws_Child or ws_ClipSiblings or ws_Visible;
  end;
  DisableAutoCreate;
end;                          { TStatusBox.init }

procedure TStatusBox.SetupWindow;
begin
  TWindow.SetupWindow;
  FontAndSize(Text[true],Text[false]);
end;

procedure TStatusBox.FontAndSize(Str1,Str2: PChar);
var
  DC: HDC;
  OldFont: HFont;
  Metrics: TTextMetric;
  Width,TextWidth: integer;
begin
  DC:=GetDC(HWindow);
  OldFont:=0;
  with Fonts^[StatusBarFont] do
  if not Initialized then
  begin
    Font:=CreateFontIndirect(Logfont);
    OldFont:=SelectObject(DC,Font);
    GetTextMetrics(DC,Metrics);
    Height:=Metrics.tmHeight+Metrics.tmExternalLeading;
    Ascent:=Metrics.tmAscent;
    Descent:=Metrics.tmDescent;
    Initialized:=true;
  end else OldFont:=SelectObject(DC,Font);
  TextWidth:=0;
  if Str1<>Nil then
  begin
    Width:=LoWord(GetTextExtent(DC,Str1,StrLen(Str1)));
    if Width>TextWidth then TextWidth:=Width;
  end;
  if Str2<>Nil then
  begin
    Width:=LoWord(GetTextExtent(DC,Str2,StrLen(Str2)));
    if Width>TextWidth then TextWidth:=Width;
  end;
  SelectObject(DC,OldFont);
  ReleaseDC(HWindow,DC);
  BoxWidth:=TextWidth+2*Status_TextEdgeSide+3;   
  BoxHeight:=Fonts^[StatusBarFont].Ascent+Fonts^[StatusBarFont].Descent
             +Status_TextEdgeTop+Status_TextEdgeBottom+2;
  SetWindowPos(HWindow,0,0,0,BoxWidth,BoxHeight,
               swp_NoMove or swp_NoZOrder);
end;

function TStatusBox.GetClassName: PChar;
begin
  GetClassName:=BibDBStatusBoxClass;
end;

procedure TStatusBox.GetWindowClass(var Class: TWndClass);
begin
  TWindow.GetWindowClass(Class);
  with Class do
  begin
    hBrBackground:=HBrush(Color_BtnFace+1);
    hcursor:=0;
    Style:=Style or cs_DblClks or cs_HRedraw or cs_VRedraw;
  end;
end;

procedure TStatusBox.Paint(PaintDC: HDC; var PaintInfo: TPaintStruct);
var
  Pen,OldPen: HPen;
  OldFont: HFont;
  Rect: TRect;
begin
  GetClientRect(HWindow,Rect);
  Pen:=CreatePen(PS_Solid,0,GetSysColor(Color_BtnShadow));
  OldPen:=SelectObject(PaintDC,Pen);
  MoveTo(PaintDC,0,0); LineTo(PaintDC,0,Rect.Bottom-1);
  MoveTo(PaintDC,0,0); LineTo(PaintDC,Rect.Right-1,0);
  SelectObject(PaintDC,GetStockObject(White_Pen));
  DeleteObject(Pen);
  MoveTo(PaintDC,Rect.Right-1,1); LineTo(PaintDC,Rect.Right-1,Rect.Bottom-1);
  MoveTo(PaintDC,1,Rect.Bottom-1); LineTo(PaintDC,Rect.Right,Rect.Bottom-1);

  if Text[YesText]<>Nil then
  with Fonts^[StatusBarFont] do
  begin
    SetBKMode(PaintDC,Transparent);
    OldFont:=SelectObject(PaintDC,Font);
{    SetTextColor(PaintDC,GetSysColor(Color_BtnText));}
    SetTextColor(PaintDC,Color);
    if Centered then
    begin
      SetTextAlign(PaintDC,ta_Center or ta_Top or ta_NoUpdateCP);
      TextOut(PaintDC,Rect.right div 2,Status_TextEdgeTop+1,
              Text[YesText],StrLen(Text[YesText]));
    end else
    begin
      SetTextAlign(PaintDC,ta_Left or ta_Top or ta_NoUpdateCP);
      TextOut(PaintDC,Status_TextEdgeSide+1,Status_TextEdgeTop+1,
              Text[YesText],StrLen(Text[YesText]));
    end;
    SelectObject(PaintDC,OldFont);
  end;

  SelectObject(PaintDC,OldPen);
end;                          { TStatusBox.Paint }

procedure TStatusBox.wmMouseMove(var Msg: TMessage);
begin
  if AmWaiting then SetCursor(CrossCursor)
  else if active then SetCursor(ArrowCursor)
  else SetCursor(CrossCursor);
end;

procedure TStatusBox.wmLButtonDblClk(var Msg: TMessage);
begin
  if Active then PostMessage(Parent^.HWindow,StatusBox_Click,
                             identifier,SBClicked_Double);
end;

procedure TStatusBox.wmRButtonDown(var Msg: TMessage);
begin
  if Active then PostMessage(Parent^.HWindow,StatusBox_Click,
                             identifier,SBClicked_Right);
end;

procedure TStatusBox.SetState(Yes,IsActive: boolean);
begin
  if Yes<>YesText then
  begin
    YesText:=Yes;
    InvalidateRect(HWindow,Nil,true);
  end;
  Active:=IsActive;
end;

procedure TStatusBox.SetText(YesStr,NoStr: PChar);
begin
  if Text[true] <>Nil then StrDispose(Text[true]);  Text[true] :=Nil;
  if Text[false]<>Nil then StrDispose(Text[false]); Text[false]:=Nil;
  if (YesStr<>Nil) then Text[true] :=StrNew(YesStr);
  if (NoStr <>Nil) then Text[false]:=StrNew(NoStr);
end;

destructor TStatusBox.Done;
begin
  if Text[false]<>Nil then StrDispose(Text[false]);
  if Text[true]<>Nil  then StrDispose(Text[true]);
  TWindow.Done;
end;

{ THelpBar methods }

constructor THelpBar.init(AParent: PWindowsObject);
var
  i: integer;
begin
  TWindow.init(AParent,'');
  HelpTextId:=0;
  LastPos:=0;
  NBoxes:=0; ActiveBoxes:=0;
  LeftPos:=0;
  for i:=1 to Status_NBoxes do StatusBarBoxes[i]:=Nil;
  New(HelpBox,Init(@Self,SBox_Help,Nil,Nil,false));
  Attr.Style:=ws_Child or ws_ClipSiblings or ws_Visible;
end;                         { THelpBar.init }

function THelpBar.GetClassName: PChar;
begin
  GetClassName:=BibDBHelpBarClass;
end;

procedure THelpBar.GetWindowClass(var Class: TWndClass);
begin
  TWindow.GetWindowClass(Class);
  with Class do
  begin
    hBrBackground:=HBrush(Color_BtnFace+1);
    hcursor:=CrossCursor;
  end;
end;

procedure THelpBar.SetupWindow;
var
  i: integer;
begin
  TWindow.SetupWindow;
  Application^.MakeWindow(HelpBox);
  BoxHeight:=HelpBox^.BoxHeight;
  Height:=BoxHeight+2*Status_BoxEdge;
  HelpBox^.Show(sw_hide);

  for i:=1 to NBoxes do
  begin
    Application^.MakeWindow(StatusBarBoxes[i]);
    StatusBarBoxes[i]^.Show(sw_Show);
  end;
  HelpBox^.Show(sw_Hide);
end;                          { THelpBar.SetupWindow }

procedure THelpBar.Paint(PaintDC: HDC; var PaintInfo: TPaintStruct);
var
  OldPen: HPen;
begin
  OldPen:=SelectObject(PaintDC,GetStockObject(White_Pen));
  with PaintInfo do
  begin
    MoveTo(PaintDC,rcPaint.Left,0);
    LineTo(PaintDC,rcPaint.right,0);
  end;
  SelectObject(PaintDC,OldPen);
end;

procedure THelpBar.Resize;
var
  i: integer;
begin
  with Fonts^[StatusBarFont] do
  if Initialized then
  begin
    DeleteObject(Font); Font:=0;
    Height:=0; Initialized:=false;
  end;
  HelpBox^.FontAndSize(Nil,Nil);
  BoxHeight:=HelpBox^.BoxHeight;
  Height:=BoxHeight+2*Status_BoxEdge;

  for i:=1 to NBoxes do
  with StatusBarBoxes[i]^ do
  begin
    FontAndSize(Text[true],Text[false]);
    Show(sw_Show);
  end;
  HelpBox^.Show(sw_Hide);
end;                       { THelpBar.Resize }

procedure THelpBar.ClearHelpText;
begin
  HideHelpText(false,true);
end;

procedure THelpBar.PutHelpText(id: integer);
var
  F: array[0..255] of char;
  i: integer;
  Rect: TRect;
begin
  if Id=HelpTextId then Exit;
  if LoadString(Hinstance,id,F,256)=0 then Exit;
  HelpTextId:=Id;
  with HelpBox^ do
  begin
    SetText(F,F); Show(sw_show);
  end;
  for i:=1 to ActiveBoxes do StatusBarBoxes[i]^.Show(sw_Hide);

  CheckHelpPos(false);
  InvalidateRect(HWindow,Nil,true); UpdateWindow(HWindow);
end;                           { THelpBar.PutHelpText }

procedure THelpBar.PutHelpStr(S: string; Id: integer);
var
  F: array[0..255] of char;
  i: integer;
  Rect: TRect;
begin
  if Id=HelpTextId then Exit;
  if S='' then
  begin
    ClearHelpText; Exit;
  end;
  StrPCopy(F,S);
  HelpTextId:=id;
  with HelpBox^ do
  begin
    SetText(F,F); Show(sw_show);
  end;
  for i:=1 to ActiveBoxes do StatusBarBoxes[i]^.Show(sw_Hide);

  CheckHelpPos(false);
  InvalidateRect(HWindow,Nil,true); UpdateWindow(HWindow);
end;                           { THelpBar.PutHelpText }

procedure THelpBar.CheckHelpPos(Redraw: boolean);
const
  Step = 32;
var
  Blen,Secleft,SecLen,X,X1: integer;
  DC: HDC;

function FindEdge(Seen,Unseen: integer): integer;
var
  middle: integer;
begin
  if seen<0 then Seen:=0; if Seen>=ClientRect.right then Seen:=ClientRect.right-1;
  if Unseen<0 then UnSeen:=0; if UnSeen>=ClientRect.right then UnSeen:=ClientRect.right-1;
  while abs(Seen-Unseen)>1 do
  begin
    middle:=(Seen+Unseen) div 2;
    if GetPixel(DC,middle,1)=-1 then Unseen:=middle
    else seen:=middle;
  end;
  FindEdge:=seen;
end;

begin
  if HelpTextID=0 then Exit;

  DC:=GetDC(HWindow);
  SecLeft:=0; SecLen:=0;
  X:=0;
  while (X<ClientRect.right-1) do
  begin
    if GetPixel(DC,X,1)=-1 then X:=X+Step { hidden }
    else begin
      if X<>0 then X:=FindEdge(X,X-Step); 
      X1:=X;
      while (X1<ClientRect.right) and (GetPixel(DC,X1,1)<>-1) do
        X1:=X1+Step;
      if X1>=ClientRect.right then X1:=ClientRect.right-1
      else X1:=FindEdge(X1-Step,X1);
      if (X1-X+1)>SecLen then
      begin
        SecLeft:=X; SecLen:=X1-X+1;
      end;
      X:=X1+1;
    end;
  end;
  ReleaseDC(HWindow,DC);
  if (Secleft<>LeftPos) then
  begin
    Blen:=(ClientRect.right-ClientRect.left-Secleft)-2*Status_BoxEdge;
    MoveWindow(HelpBox^.HWindow,Status_BoxEdge+Secleft,Status_BoxEdge,
               Blen,BoxHeight,true);
    LeftPos:=Secleft;
    if Redraw then
    begin
      InvalidateRect(HWindow,Nil,true); UpdateWindow(HWindow);
    end;
  end;
end;                              { THelpBar.CheckHelpPos }

procedure THelpBar.HideHelpText(Force,ReDisplay: Boolean);
var
  i: integer;
begin
  if force or (HelpTextId<>0) then
  begin
    HelpBox^.Show(sw_hide);
    for i:=1 to ActiveBoxes do StatusBarBoxes[i]^.Show(sw_Show);
    if ReDisplay then
    begin
      InvalidateRect(HWindow,Nil,true); UpdateWindow(HWindow);
    end;
    HelpTextId:=0;
  end;
end;                           { THelpBar.HideHelpText }

procedure THelpBar.MoveBarTo(W,H: integer);
var
  Blen,i: integer;
  Rect,BRect: TRect;
begin
  MoveWindow(HWindow,0,H-Height,W,Height,true);

  GetClientRect(HWindow,Rect);
  Blen:=(Rect.right-Rect.left)-2*Status_BoxEdge;
  MoveWindow(HelpBox^.HWindow,Status_BoxEdge,Status_BoxEdge,Blen,BoxHeight,true);

  LeftPos:=0;
  LastPos:=Status_BoxEdge;
  for i:=1 to ActiveBoxes do
  begin
    GetClientRect(StatusBarBoxes[i]^.HWindow,BRect);
    MoveWindow(StatusBarBoxes[i]^.HWindow,LastPos,Status_BoxEdge,BRect.right,
               BRect.bottom,true);
    LastPos:=LastPos+BRect.right+Status_BoxDist;
  end;
  if ActiveBoxes<NBoxes then
  begin
    GetClientRect(HWindow,Rect);
    Blen:=(Rect.right-Rect.left)-LastPos-Status_BoxEdge;
    MoveWindow(StatusBarBoxes[NBoxes]^.HWindow,LastPos,Status_BoxEdge,
          Blen,BoxHeight,true);
  end;
  if FirstTime then Show(sw_Show);
  FirstTime:=false;
  GetClientRect(HWindow,ClientRect);
  InvalidateRect(HWindow,Nil,true);
end;                              { THelpBar.MoveBarTo }

{ TPattStatusBar methods }

constructor TPattStatusBar.init(AParent: PWindowsObject);
begin
  THelpBar.init(AParent);
  NBoxes:=PattStatus_NBoxes;
  ActiveBoxes:=PattStatus_ActiveBoxes;
  New(StatusBarBoxes[SBox_CaseSen],init(@self,0,'Case on',  'Case off',  true));
  New(StatusBarBoxes[SBox_RegExp ],init(@self,0,'RegExp on','RegExp off',true));
end;

procedure TPattStatusBar.Update(CaseSen,RegExp: boolean);
begin
  StatusBarBoxes[SBox_CaseSen]^.SetState(CaseSen,false);
  StatusBarBoxes[SBox_RegExp ]^.SetState(RegExp,false);
end;                          { TPattStatusBar.Update }

{ TStatusBar methods }

constructor TStatusBar.init(AParent: PWindowsObject);
begin
  THelpBar.init(AParent);
  NBoxes:=Status_NBoxes;
  ActiveBoxes:=Status_ActiveBoxes;

  New(StatusBarBoxes[SBox_entries],
      init(@Self,stat_EntriesClick,'Strings','Entries',true));
  New(StatusBarBoxes[SBox_Linked],
      init(@Self,stat_LinkClick,   'Link',   'Unlnk',true));
  New(StatusBarBoxes[SBox_Sort],
      init(@Self,stat_SortClick,   'Sort',   'Unsrt',true));
  New(StatusBarBoxes[SBox_Unix],
      init(@Self,0,                'Unix',   'Dos',true));
  New(StatusBarBoxes[SBox_RO],
      init(@Self,stat_ReadOnly,    'R/O',    'R/W',true));
  New(StatusBarBoxes[SBox_Ind],
      init(@Self,0,                'Index',  'Unind.',true));
  New(StatusBarBoxes[SBox_Patt],
      init(@Self,stat_PattClick,   'Patt on','Patt off',true));

  New(StatusBarBoxes[SBox_Message],init(@Self,SBox_Message,Nil,Nil,false));
end;

procedure TStatusBar.SetupWindow;
begin
  THelpBar.SetupWindow;
  StatusBarBoxes[SBox_Message]^.Show(sw_hide);
end;                          { TStatusBar.SetupWindow }

procedure TStatusBar.Update;
var
  FileIsSorted: boolean;
begin
  if EditOnlyStrings then
    FileIsSorted:=(CurrentSortMode^.StringNameSort<>StrSortOff)
  else FileIsSorted:=CurrentSortMode^.SortingOn;
  if Linked then FileIsSorted:=false;

  StatusBarBoxes[SBox_entries]^.SetState(EditOnlyStrings,true);
  StatusBarBoxes[SBox_Linked ]^.SetState(Linked,true);
  StatusBarBoxes[SBox_Sort   ]^.SetState(FileIsSorted,not (Linked or BibReadOnly));
  StatusBarBoxes[SBox_Unix   ]^.SetState(UnixBib,false);
  StatusBarBoxes[SBox_RO     ]^.SetState(BibReadOnly or Linked,
                                         BibFileExists and not Linked);
  StatusBarBoxes[SBox_Patt   ]^.SetState(Pattern^.on,Pattern^.npatt<>0);
  StatusBarBoxes[SBox_Ind    ]^.SetState(MakeUseOfIndex(Pattern),false);
{  InvalidateRect(HWindow,Nil,true);}
end;                           { TStatusBar.Update }

procedure TStatusBar.Clicked(var Msg: TMessage);
begin
  SendMessage(Parent^.HWindow,bib_StatusBoxClick,Msg.wParam,0);
end;

procedure TStatusBar.PutStatusMessage(S: string);
var
  F: array[0..255] of char;
  Rect: TRect;
  TP: TPoint;
begin
  StrPCopy(F,S);
  HideHelpText(true,false);
  with StatusBarBoxes[SBox_Message]^ do
  begin
    SetText(F,Nil); Show(sw_show);
    GetWindowRect(HWindow,Rect);
  end;
  TP.X:=Rect.left; TP.Y:=Rect.top; ScreenToClient(HWindow,TP);
  rect.left:=TP.X; Rect.Top:=TP.Y;
  TP.X:=Rect.right; TP.Y:=Rect.bottom; ScreenToClient(HWindow,TP);
  rect.right:=TP.X; Rect.bottom:=TP.Y;
  InvalidateRect(HWindow,@Rect,true); UpdateWindow(HWindow);
end;                           { TStatusBar.PutStatusMessage }

procedure TStatusBar.ShowStatusMessage;
var
  Rect: TRect;
  TP: TPoint;
begin
  with StatusBarBoxes[SBox_Message]^ do
  begin
    Show(sw_show);
    GetWindowRect(HWindow,Rect);
  end;
  TP.X:=Rect.left; TP.Y:=Rect.top; ScreenToClient(HWindow,TP);
  rect.left:=TP.X; Rect.Top:=TP.Y;
  TP.X:=Rect.right; TP.Y:=Rect.bottom; ScreenToClient(HWindow,TP);
  rect.right:=TP.X; Rect.bottom:=TP.Y;
  InvalidateRect(HWindow,@Rect,true); UpdateWindow(HWindow);
end;                         { TStatusBar.ShowStatusMessage }

procedure TStatusBar.HideStatusMessage;
begin
  with StatusBarBoxes[SBox_Message]^ do
  begin
    Show(sw_hide);
    InvalidateRect(HWindow,Nil,true);
    UpdateWindow(HWindow);
  end;
end;                          { TStatusBar.HideStatusMessage }

procedure TStatusBar.ClearHelpText; 
begin
  HideStatusMessage;
  THelpBar.ClearHelpText;
end;


begin
  StatusBar:=Nil; CurrentHelpBar:=Nil;
end.
