/* wptRegistry.h - Win32 Registry headerfile
 *	Copyright (C) 2000-2005 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * as published by the Free Software Foundation; either version 2 
 * of the License, or (at your option) any later version.
 *  
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 */

#ifndef WPT_REGISTRY_H
#define WPT_REGISTRY_H

enum {
    CFG_INVALID=0,
    CFG_CACHETIME,
    CFG_WORDWRAP,
    CFG_FASTMODE,
    CFG_VIEWER,
    CFG_KEYLISTMODE,
    CFG_WIPEMODE,
    CFG_ALWAYSTRUST,
    CFG_AUTOBACKUP,
    CFG_AUTOBAKMODE,
    CFG_DISHOTKEYS,
    CFG_NOZIP_MMEDIA,
    CFG_EXPERT,
    CFG_FM_PROGRESS,
    /* end of id list */
    CFG_AUTOBAKPATH,
    CFG_KSERV_CONF,
};


struct reg_hotkey_s {
    const char * reg_entry;
    char key[2];
    int enabled;
};
typedef struct reg_hotkey_s * reg_hotkey_t;

struct winpt_reg_prefs_s {
    int no_hotkeys;	/* disable ALL hotkeys */
    int word_wrap;	/* set word wrapping (0 means to disable it) */
    int cache_time;	/* caching time for passphrase */
    int use_tmpfiles;	/* use tempfiles for gpg communication */
    int use_viewer;	/* use clipboard viewer for displaying plaintext */
    int no_zip_mmedia;  /* disable compression for multi-media files (movies, music) */
    int keylist_mode;   /* normal=0 minimal=1 or  */
    int wipe_mode;	/* simple=0, dod=1, gutmann=2 */
    int always_trust;	/* skip key validation (1 means yes) */
    int auto_backup;	/* automatic backup (1 means activated) */
    struct {
	int mode;
	char *path;
    } backup;
    char *kserv_conf;
    int expert;
    struct {
	int progress;
    } fm;
    char *homedir;     /* WinPT mobile home dir */
};

extern reg_hotkey_s reg_hotkeys[];
extern winpt_reg_prefs_s reg_prefs;

/*-- wptHotkey.cpp --*/
void hotkeys_modify (void);
void hotkey_disable (reg_hotkey_t rhk);
void hotkey_enable (reg_hotkey_t rhk, const char * key);

/*-- wptRegistry.cpp --*/
void free_reg_prefs (void);
int regist_inst_gnupg (int create_mokey);
int regist_inst_winpt (int with_ext, int *created);
int create_file_type (const char * exefile, const char * ext,
		      const char * extname, char *iconfile );
int set_reg_winpt_single (int id, int val);
int get_reg_winpt_single (int id);
int set_reg_winpt_prefs (winpt_reg_prefs_s * opt);
int get_reg_winpt_prefs (winpt_reg_prefs_s * opt);
char* get_reg_entry( HKEY root_key, const char * dir, const char * key );
int set_reg_entry( HKEY root_key, const char * dir, const char * key,
				   const char * value );
int set_reg_key( HKEY root_key, const char * dir, const char * key,
				 const char * value );
int set_reg_entry_gpg( const char * key, const char * value );
int set_reg_entry_mo( const char * value );
char* get_reg_entry_gpg( const char * key );
char* get_reg_entry_mo( void );
void get_reg_proxy_prefs( char ** host, int * port, 
			  char ** user, char ** pass );
int set_reg_proxy_prefs( const char * host, int port, 
			 const char * user, const char * pass );
int set_reg_entry_keyserver( const char * name, const char * val );
char * get_reg_entry_keyserver( const char * name );
int set_reg_winpt_flag( const char * name, int val );
int get_reg_winpt_flag( const char * name );

#endif /* WPT_REGISTRY_H */
