/* wptKeyserver.h - Keyserver headerfile
 *	Copyright (C) 2000-2005 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * as published by the Free Software Foundation; either version 2 
 * of the License, or (at your option) any later version.
 *  
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 */

#ifndef WPT_KEYSERVER_H
#define WPT_KEYSERVER_H

#define HKP_PORT     11371 /* Horowitz Keyserver Protocol */
#define FINGER_PORT	79 /* Finger Protocol */

#define DEF_HKP_KEYSERVER "http://subkeys.pgp.net"

enum {
    PROXY_USER = 0,
    PROXY_PASS = 1,
};

enum {
    KSPROTO_HTTP   = 0,
    KSPROTO_LDAP   = 1,
    KSPROTO_FINGER = 2
};

struct keyserver_ctx {
    const char *   name;
    unsigned short port;
    const char *   pattern;
};

struct keyserver {
    char *  name;
    int     port;
    int	    used;
    int	    proto;
};

struct keyserver_proxy_ctx {
    int	    port;
    char *  host;
    char *  user;
    char *  base64_user;
    char *  pass;
};

struct keyserver_node {
    keyserver_node *	next;
    keyserver		host;
    int			used;
};

struct keyserver_cfgfile {
    keyserver_node *	list;
    keyserver_proxy_ctx proxy;
    int			nlist;
};

#define MAX_KEYSERVERS 32
extern keyserver server[MAX_KEYSERVERS]; /* runtime initialized */
extern char * default_keyserver;
extern unsigned short default_keyserver_port;

struct keyserver_key {
    int	    bits;
    char    keyid[8+1];
    char    date[10+1];
    char    uid[384];
};

const char* kserver_strerror( void );

/*-- Winsock2 support --*/
int wsock_init( void );
void wsock_end( void );
const char* wsock_strerror( void );

/*-- Keyserver config --*/
int kserver_load_conf (const char *conf);
const char* kserver_check_keyid( const char *keyid );
const char* kserver_get_proxy( int *r_port );
const char* kserver_get_proxy_info( int id );

int kserver_read_config( const char *fname, keyserver_cfgfile **ret_cfg );
int kserver_write_config( const char *fname, keyserver_cfgfile *cfg );
void kserver_cfgfile_release( keyserver_cfgfile *cfg );
void kserver_change_proxy( keyserver_proxy_ctx *ctx );
void proxy_release( keyserver_proxy_ctx *ctx );
const char * kserver_get_hostname (int idx, int type, unsigned short *port);
void keyserver_set_default (const char *hostname, unsigned short port);
void set_default_kserver (void);

/*-- General --*/
int kserver_check_inet_connection (void);
int kserver_connect (const char *hostname, unsigned short port, int *conn_fd);
int kserver_sendkey (const char *hostname, unsigned short port, const char *pubkey, int len);
int kserver_recvkey (const char *hostname, unsigned short port, 
		     const char *keyid, char *key, int maxkeylen);

int kserver_search_init(const char *hostname, unsigned short port, const char *keyid, int *conn_fd);
int kserver_search_chkresp (int conn_fd);
int kserver_search (int conn_fd, keyserver_key *key);

/*-- Finger/LDAP Protocol --*/
int  ldap_recvkey (const char *hostname, const char *keyid, char *key, 
		   int maxkeylen);
int finger_recvkey (const char * host, const char * user, char * key, 
		    int maxkeylen);

/*-- Dialog support --*/
int hkp_send_key (HWND dlg, const char *kserver, unsigned short port, const char *pattern);
int hkp_recv_key (HWND dlg, const char *kserver, unsigned short port, const char *pattern, 
		  int proto, int flags);

#endif /* WPT_KEYSERVER_H_ */