/* wptClipSignDlg.cpp - WinPT clipboard sign dialog
 *	Copyright (C) 2000, 2001, 2002, 2003 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <windows.h>
#include <commctrl.h>

#include "../resource.h"
#include "wptTypes.h"
#include "wptAgent.h"
#include "wptNLS.h"
#include "wptGPG.h"
#include "wptCommonCtl.h"
#include "wptRegistry.h"
#include "wptKeylist.h"
#include "wptErrors.h"
#include "wptW32API.h"
#include "wptVersion.h"
#include "wptContext.h" /* for passphrase_s */
#include "wptDlgs.h"


/* This function is used when only one secret key is available.
 * it doesn't make sense to offer a dialog for this case.
 */
void
one_key_proc (HWND dlg)
{
    char * signer;
    gpgme_ctx_t ctx;
    gpgme_error_t err;
    passphrase_cb_s pwd;
    int rc = 0, n = reg_prefs.word_wrap;
    
    signer = get_gnupg_default_key ();
    if( !signer ) 
    {
        msg_box( dlg, _("Could not get default key."), _("Signing"), MB_ERR );
        return;
    }
    
    err = gpgme_new( &ctx );
    if( err )
	BUG( dlg );
    gpgme_enable_logging( ctx );
    set_gpg_passphrase_cb( ctx, &pwd, GPG_CMD_SIGN, dlg, _("Signing") );
    err = gpgme_op_clip_sign( ctx, GPGME_SIG_MODE_CLEAR, signer, n );
    memset( pwd.pwd, 0, sizeof pwd.pwd );
    if( err == GPGME_Bad_Passphrase )
	agent_del_cache( pwd.keyid );

    if( err )
	gpgme_show_error( dlg, err, ctx, _("Signing"), MB_ERR );
    else
	show_msg( dlg, 1500, _("GnuPG Status: Finished") );
    gpgme_release( ctx );
    free_if_alloc( signer );
} /* one_key_proc */


BOOL CALLBACK 
clip_sign_dlg_proc( HWND dlg, UINT msg, WPARAM wparam, LPARAM lparam )
{	
    static listview_ctrl_t lv = NULL;
    gpgme_keycache_t kc, sec_kc;
    gpgme_ctx_t ctx;
    gpgme_error_t err;
    passphrase_cb_s pwd;
    int lv_idx = 0;
    int rc = 0, no_signer = 0;
    char * signer = NULL;
    
    switch( msg ) {
    case WM_INITDIALOG:
#ifndef LANG_DE
        SetWindowText( dlg, _("Signing") );
#endif
        kc = keycache_get_ctx( KEYCACHE_PUB );
	if( !kc )
	    BUG( NULL );
        sec_kc = keycache_get_ctx( KEYCACHE_PRV );
	if( !sec_kc )
	    BUG( dlg );
        if( gpgme_keycache_count( sec_kc ) == 1 ) {
            one_key_proc( dlg );
            EndDialog( dlg, TRUE );
            return FALSE;
        }
        lv = keylist_load( GetDlgItem( dlg, IDC_SIGN_KEYLIST ), kc, sec_kc, 
			    KEYLIST_SIGN, GPGME_ATTR_USERID );
	center_window( dlg );
        SetForegroundWindow( dlg );
        set_active_window( dlg );
        return FALSE;	
        
    case WM_DESTROY:
        reset_active_window();
        if( lv ) {
            keylist_delete( lv );
            lv = NULL;
        }
        memset( pwd.pwd, 0, sizeof pwd.pwd );
        return FALSE;
        
    case WM_NOTIFY:
        NMHDR * notify;
        notify = (NMHDR *)lparam;
        if( notify && notify->code == NM_DBLCLK
            && notify->idFrom == IDC_SIGN_KEYLIST )
            PostMessage( dlg, WM_COMMAND, MAKEWPARAM(IDOK, 0), NULL );
        return TRUE;
        
    case WM_SYSCOMMAND:
        if( LOWORD (wparam) == SC_CLOSE )
            EndDialog(dlg, TRUE);
        return FALSE;
        
    case WM_COMMAND:
        switch ( LOWORD( wparam ) ) 
	{
        case IDOK:
            signer = get_gnupg_default_key ();
            if( !signer ) 
	    {
                msg_box( dlg, _("Could not get default key."), _("Signing"), MB_ERR );
                return FALSE;
            }
            if( listview_count_items( lv, 0 ) == 1 ) 
	    {
                listview_get_item_text( lv, 0, 1, signer, sizeof signer-1 );
                no_signer = 0;
            }
            else if( (lv_idx = listview_get_curr_pos( lv )) == -1 ) 
	    {
		rc = log_box( _("Signing"), MB_YESNO, 
		              _("No key was chosen.\nUse the GPG default key '%s'?"),
			      signer );
                if( rc == IDNO ) 
		{
		    free_if_alloc (signer);
                    return FALSE;
		}
                no_signer = 1;
            }
            if (!no_signer)
	    {
		free_if_alloc (signer);
		signer = new char[32+1];
		if (!signer)
		    BUG (NULL);
                listview_get_item_text (lv, lv_idx, 1, signer, 32);
	    }
            err = gpgme_new (&ctx);
	    if( err )
		BUG( dlg );
	    gpgme_enable_logging( ctx );
	    set_gpg_passphrase_cb( ctx, &pwd, GPG_CMD_SIGN, dlg, _("Signing") );
            err = gpgme_op_clip_sign( ctx, GPGME_SIG_MODE_CLEAR, signer,
					reg_prefs.word_wrap );
	    free_if_alloc( signer );
            memset( pwd.pwd, 0, sizeof pwd.pwd );
            if( pwd.cancel && err == GPGME_Bad_Passphrase ) { /* The user hit the cancel button */
		gpgme_release( ctx );
                EndDialog( dlg, TRUE );
                return TRUE;
            }
            if( err ) {
		gpgme_show_error( dlg, err, ctx, _("Signing"), MB_ERR );
		gpgme_release( ctx );
                return FALSE;
            }
	    else	             
		show_msg( dlg, 1500, _("GnuPG Status: Finished") );
	    gpgme_release( ctx );
            EndDialog( dlg, TRUE );
            return TRUE;
            
        case IDCANCEL:
            EndDialog( dlg, FALSE );
            return FALSE;
        }
        break;
    }
    
    return FALSE;
} /* clip_sign_dlg_proc */
