/* types.h -  Some type definitions
 *	Copyright (C) 2000 Werner Koch (dd9jn)
 *	Copyright (C) 2003, 2004 Timo Schulz
 *
 * This file is part of MyGPGME.
 *
 * MyGPGME is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MyGPGME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef TYPES_H
#define TYPES_H

#include "gpgme.h"  /* external objects and prototypes */

#ifndef HAVE_BYTE_TYPEDEF
typedef unsigned char byte;
#define HAVE_BYTE_TYPEDEF
#endif

#ifndef HAVE_ULONG_TYPEDEF
typedef unsigned long ulong;
#define HAVE_ULONG_TYPEDEF
#define SIZEOF_UNSIGNED_LONG 4
#endif


typedef enum {
    GPGME_DATA_MODE_NONE  = 0,
    GPGME_DATA_MODE_IN    = 1,
    GPGME_DATA_MODE_OUT   = 2,
    GPGME_DATA_MODE_INOUT = 3
} gpgme_data_mode_t;


/*
 * Declaration of internal objects
 */

/*-- rungpg.c --*/
struct gpg_object_s;
typedef struct gpg_object_s *_gpg_object_t;

/*-- encrypt.c --*/
typedef encrypt_result_s;
typedef struct encrypt_result_s *_encrypt_result_t;

/*-- verify.c --*/
struct verify_result_s;
typedef struct verify_result_s *_verify_result_t;

/*-- decrypt.c --*/
struct decrypt_result_s;
typedef struct decrypt_result_s *_decrypt_result_t;

/*-- sign.c --*/
struct sign_result_s;
typedef struct sign_result_s *_sign_result_t;

/*-- sign-encrypt.c --*/
struct sign_encrypt_result_s;
typedef struct sign_encrypt_result_s *_sign_encrypt_result_t;

/*-- import.c --*/
struct import_result_s;
typedef struct import_result_s *_import_result_t;

/*-- sym-encrypt.c --*/
struct symenc_result_s;
typedef struct symenc_result_s *_symenc_result_t;

/*-- editkey.c --*/
struct editkey_result_s;
typedef struct editkey_result_s * _editkey_result_t;

#endif /* TYPES_H */
