/* wptCryptdisk.h
 *	Copyright (C) 2004 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */
#ifndef WPT_CRYPTDISK_H
#define WPT_CRYPTDISK_H

#define FILE_DEVICE_FILE_DISK       0x8000
#define IOCTL_FILE_DISK_OPEN_FILE   CTL_CODE(FILE_DEVICE_FILE_DISK, 0x800, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define IOCTL_FILE_DISK_CLOSE_FILE  CTL_CODE(FILE_DEVICE_FILE_DISK, 0x801, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define IOCTL_FILE_DISK_QUERY_FILE  CTL_CODE(FILE_DEVICE_FILE_DISK, 0x802, METHOD_BUFFERED, FILE_READ_ACCESS)

#define DISK_DEFSIZE 32 /*MB*/

enum cmd_t {
    CMD_MOUNT	=0,
    CMD_NEW	=1,
    CMD_UMOUNT	=2,
    CMD_UMOUNT2 =3,
};

struct private_ofi_s {
    INT		    forced;
    INT		    cmd;
    INT		    devnum;
    CHAR	    drvlet;
    LARGE_INTEGER   filesize;
    BOOLEAN         readonly;
    USHORT          flen;
    UCHAR           fname[MAX_PATH+1];
};

typedef struct _OPEN_FILE_INFORMATION {
    LARGE_INTEGER   FileSize;
    BOOLEAN         ReadOnly;
    USHORT          FileNameLength;
    UCHAR           FileName[1];
} OPEN_FILE_INFORMATION, *POPEN_FILE_INFORMATION;

struct mount_list_s {
    struct mount_list_s * next;
    char drive[8];
    LARGE_INTEGER size;
    int rdonly;
    int devnum;
    int ttl;
};
typedef struct mount_list_s * mount_list_t;


/*-- wptCryptdisk.cpp --*/
int cryptdisk_unmount (char drivelet, int forced);
int cryptdisk_available (void);
void cryptdisk_cleanup (void);
int cryptdisk_serv_run (void);
BOOL CALLBACK cryptdisk_mount_dlg_proc (HWND dlg, UINT msg, WPARAM wparam, 
					LPARAM lparam);
BOOL CALLBACK cryptdisk_umount_dlg_proc (HWND dlg, UINT msg, WPARAM wparam, 
					 LPARAM lparam);
BOOL CALLBACK cryptdisk_new_dlg_proc (HWND dlg, UINT msg, WPARAM wparam, 
				      LPARAM lparam);

#endif /* WPT_CRYPTDISK_H */