// SPDX-FileCopyrightText: 2024 g10 Code GmbH
// SPDX-FileContributor: Carl Schwan <carl@carlschwan.eu>
//
// SPDX-License-Identifier: GPL-3.0-or-later

#pragma once

#include <KJob>

class FileEncryptJob : public KJob
{
    Q_OBJECT

public:
    enum {
        PermissionError = UserDefinedError,
        EncryptionError,
    };
    explicit FileEncryptJob(const QString &filePath, const QByteArray &content, const QList<QByteArray> &recipientsKeys, QObject *parent = nullptr);

    void start() override;

private:
    QString m_filePath;
    QByteArray m_content;
    QList<QByteArray> m_recipientsKeys;
};
