// SPDX-FileCopyrightText: 2023 g10 code Gmbh
// SPDX-Contributor: Carl Schwan <carl.schwan@gnupg.com>
// SPDX-License-Identifier: GPL-2.0-or-later

#pragma once

#include <QWebSocket>

class WebsocketClient : public QObject
{
    Q_OBJECT

public:
    static WebsocketClient &self(const QUrl &url = {}, int port = -1, const QString &clientId = {});

Q_SIGNALS:
    /// Signal emited when the connection to the broker or outlook web is lost.
    void closed(const QString &errorString);

    /// Signal emited when the native client is connected or reconnected to the broker
    /// and outlook web.
    void connected();

    /// Signal emited when an email was sent succesffully,
    void emailSentSuccessfully(const QString &id);

private Q_SLOTS:
    void slotConnected();
    void slotErrorOccurred(QAbstractSocket::SocketError error);
    void slotTextMessageReceived(QString message);

private:
    explicit WebsocketClient(const QUrl &url, int port, const QString &clientId);
    void reconnect();

    QWebSocket m_webSocket;
    QUrl m_url;
    const int m_port;
    QStringList m_emails;
    QString m_clientId;
};
