/*
CLASS:lshd_context:transport_context
*/
#ifndef GABA_DEFINE
struct lshd_context
{
  struct transport_context super;
  struct alist *keys;
  const char ** services;
};
extern struct lsh_class lshd_context_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_lshd_context_mark(struct lsh_object *o,
  void (*mark)(struct lsh_object *o))
{
  struct lshd_context *i = (struct lshd_context *) o;
  mark((struct lsh_object *) i->keys);
}
struct lsh_class lshd_context_class =
{
  STATIC_HEADER,
  &(transport_context_class),
  "lshd_context",
  sizeof(struct lshd_context),
  do_lshd_context_mark,
  NULL,
};
#endif /* !GABA_DECLARE */

/*
CLASS:lshd_port:resource
*/
#ifndef GABA_DEFINE
struct lshd_port
{
  struct resource super;
  struct lshd_context *ctx;
  int fd;
};
extern struct lsh_class lshd_port_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_lshd_port_mark(struct lsh_object *o,
  void (*mark)(struct lsh_object *o))
{
  struct lshd_port *i = (struct lshd_port *) o;
  mark((struct lsh_object *) i->ctx);
}
struct lsh_class lshd_port_class =
{
  STATIC_HEADER,
  &(resource_class),
  "lshd_port",
  sizeof(struct lshd_port),
  do_lshd_port_mark,
  NULL,
};
#endif /* !GABA_DECLARE */

/*
CLASS:pid_file_resource:resource
*/
#ifndef GABA_DEFINE
struct pid_file_resource
{
  struct resource super;
  struct lsh_string *file;
};
extern struct lsh_class pid_file_resource_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_pid_file_resource_free(struct lsh_object *o)
{
  struct pid_file_resource *i = (struct pid_file_resource *) o;
  lsh_string_free(i->file);
}
struct lsh_class pid_file_resource_class =
{
  STATIC_HEADER,
  &(resource_class),
  "pid_file_resource",
  sizeof(struct pid_file_resource),
  NULL,
  do_pid_file_resource_free,
};
#endif /* !GABA_DECLARE */

/*
CLASS:sighup_close_callback:lsh_callback
*/
#ifndef GABA_DEFINE
struct sighup_close_callback
{
  struct lsh_callback super;
  struct resource *resource;
};
extern struct lsh_class sighup_close_callback_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_sighup_close_callback_mark(struct lsh_object *o,
  void (*mark)(struct lsh_object *o))
{
  struct sighup_close_callback *i = (struct sighup_close_callback *) o;
  mark((struct lsh_object *) i->resource);
}
struct lsh_class sighup_close_callback_class =
{
  STATIC_HEADER,
  &(lsh_callback_class),
  "sighup_close_callback",
  sizeof(struct sighup_close_callback),
  do_sighup_close_callback_mark,
  NULL,
};
#endif /* !GABA_DECLARE */

/*
CLASS:lshd_config:server_config
*/
#ifndef GABA_DEFINE
struct lshd_config
{
  struct server_config super;
  struct algorithms_options *algorithms;
  struct werror_config *werror_config;
  struct lshd_context *ctx;
  struct lsh_string *port;
  struct lsh_string *hostkey;
  int daemonic;
  enum daemon_flags daemon_flags;
  int corefile;
  struct lsh_string *pid_file;
  int use_pid_file;
  struct alist *keys;
  const char ** services;
};
extern struct lsh_class lshd_config_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_lshd_config_mark(struct lsh_object *o,
  void (*mark)(struct lsh_object *o))
{
  struct lshd_config *i = (struct lshd_config *) o;
  mark((struct lsh_object *) i->algorithms);
  mark((struct lsh_object *) i->werror_config);
  mark((struct lsh_object *) i->ctx);
  mark((struct lsh_object *) i->keys);
}
static void
do_lshd_config_free(struct lsh_object *o)
{
  struct lshd_config *i = (struct lshd_config *) o;
  lsh_string_free(i->port);
  lsh_string_free(i->hostkey);
  lsh_string_free(i->pid_file);
}
struct lsh_class lshd_config_class =
{
  STATIC_HEADER,
  &(server_config_class),
  "lshd_config",
  sizeof(struct lshd_config),
  do_lshd_config_mark,
  do_lshd_config_free,
};
#endif /* !GABA_DECLARE */

