#include "testutils.h"

int
test_main(void)
{
#if WITH_PUBLIC_KEY

  struct rsa_public_key pub;
  struct rsa_private_key key;

  mpz_t expected;
  
  mpz_init(expected);
  
  rsa_private_key_init(&key);
  rsa_public_key_init(&pub);

  /* 1000-bit key, generated by
   *
   *   lsh-keygen -a rsa -l 1000 -f advanced-hex
   *
   * (private-key (rsa-pkcs1 
   *        (n #69abd505285af665 36ddc7c8f027e6f0 ed435d6748b16088
   *            4fd60842b3a8d7fb bd8a3c98f0cc50ae 4f6a9f7dd73122cc
   *            ec8afa3f77134406 f53721973115fc2d 8cfbba23b145f28d
   *            84f81d3b6ae8ce1e 2850580c026e809b cfbb52566ea3a3b3
   *            df7edf52971872a7 e35c1451b8636d22 279a8fb299368238
   *            e545fbb4cf#)
   *        (e #0db2ad57#)
   *        (d #3240a56f4cd0dcc2 4a413eb4ea545259 5c83d771a1c2ba7b
   *            ec47c5b43eb4b374 09bd2aa1e236dd86 481eb1768811412f
   *            f8d91be3545912af b55c014cb55ceac6 54216af3b85d5c4f
   *            4a32894e3b5dfcde 5b2875aa4dc8d9a8 6afd0ca92ef50d35
   *            bd09f1c47efb4c8d c631e07698d362aa 4a83fd304e66d6c5
   *            468863c307#)
   *        (p #0a66399919be4b4d e5a78c5ea5c85bf9 aba8c013cb4a8732
   *            14557a12bd67711e bb4073fd39ad9a86 f4e80253ad809e5b
   *            f2fad3bc37f6f013 273c9552c9f489#)
   *        (q #0a294f069f118625 f5eae2538db9338c 776a298eae953329
   *            9fd1eed4eba04e82 b2593bc98ba8db27 de034da7daaea795
   *            2d55b07b5f9a5875 d1ca5f6dcab897#)
   *        (a #011b6c48eb592eee e85d1bb35cfb6e07 344ea0b5e5f03a28
   *            5b405396cbc78c5c 868e961db160ba8d 4b984250930cf79a
   *            1bf8a9f28963de53 128aa7d690eb87#)
   *        (b #0409ecf3d2557c88 214f1af5e1f17853 d8b2d63782fa5628
   *            60cf579b0833b7ff 5c0529f2a97c6452 2fa1a8878a9635ab
   *            ce56debf431bdec2 70b308fa5bf387#)
   *        (c #04e103ee925cb5e6 6653949fa5e1a462 c9e65e1adcd60058
   *            e2df9607cee95fa8 daec7a389a7d9afc 8dd21fef9d83805a
   *            40d46f49676a2f6b 2926f70c572c00#)))
   */
  
  mpz_set_str(pub.n,
	      "69abd505285af665" "36ddc7c8f027e6f0" "ed435d6748b16088"
	      "4fd60842b3a8d7fb" "bd8a3c98f0cc50ae" "4f6a9f7dd73122cc"
	      "ec8afa3f77134406" "f53721973115fc2d" "8cfbba23b145f28d"
	      "84f81d3b6ae8ce1e" "2850580c026e809b" "cfbb52566ea3a3b3"
	      "df7edf52971872a7" "e35c1451b8636d22" "279a8fb299368238"
	      "e545fbb4cf", 16);
  mpz_set_str(pub.e, "0db2ad57", 16);

  if (!rsa_public_key_prepare(&pub))
    FAIL();
  
  /* d is not used */
#if 0  
  mpz_set_str(key.d,
	      "3240a56f4cd0dcc2" "4a413eb4ea545259" "5c83d771a1c2ba7b"
	      "ec47c5b43eb4b374" "09bd2aa1e236dd86" "481eb1768811412f"
	      "f8d91be3545912af" "b55c014cb55ceac6" "54216af3b85d5c4f"
	      "4a32894e3b5dfcde" "5b2875aa4dc8d9a8" "6afd0ca92ef50d35"
	      "bd09f1c47efb4c8d" "c631e07698d362aa" "4a83fd304e66d6c5"
	      "468863c307", 16);
#endif
  
  mpz_set_str(key.p,
	      "0a66399919be4b4d" "e5a78c5ea5c85bf9" "aba8c013cb4a8732"
	      "14557a12bd67711e" "bb4073fd39ad9a86" "f4e80253ad809e5b"
	      "f2fad3bc37f6f013" "273c9552c9f489", 16);

  mpz_set_str(key.q,
	      "0a294f069f118625" "f5eae2538db9338c" "776a298eae953329"
	      "9fd1eed4eba04e82" "b2593bc98ba8db27" "de034da7daaea795"
	      "2d55b07b5f9a5875" "d1ca5f6dcab897", 16);
  
  mpz_set_str(key.a,
	      "011b6c48eb592eee" "e85d1bb35cfb6e07" "344ea0b5e5f03a28"
	      "5b405396cbc78c5c" "868e961db160ba8d" "4b984250930cf79a"
	      "1bf8a9f28963de53" "128aa7d690eb87", 16);
  
  mpz_set_str(key.b,
	      "0409ecf3d2557c88" "214f1af5e1f17853" "d8b2d63782fa5628"
	      "60cf579b0833b7ff" "5c0529f2a97c6452" "2fa1a8878a9635ab"
	      "ce56debf431bdec2" "70b308fa5bf387", 16);
  
  mpz_set_str(key.c,
	      "04e103ee925cb5e6" "6653949fa5e1a462" "c9e65e1adcd60058"
	      "e2df9607cee95fa8" "daec7a389a7d9afc" "8dd21fef9d83805a"
	      "40d46f49676a2f6b" "2926f70c572c00", 16);

  if (!rsa_private_key_prepare(&key))
    FAIL();

  if (pub.size != key.size)
    FAIL();
  
  /* Test md5 signatures */
  mpz_set_str(expected,
	      "53bf517009fa956e" "3daa6adc95e8663d" "3759002f488bbbad"
	      "e49f62792d85dbcc" "293f68e2b68ef89a" "c5bd42d98f845325"
	      "3e6c1b76fc337db5" "e0053f255c55faf3" "eb6cc568ad7f5013"
	      "5b269a64acb9eaa7" "b7f09d9bd90310e6" "4c58f6dbe673ada2"
	      "67c97a9d99e19f9d" "87960d9ce3f0d5ce" "84f401fe7e10fa24"
	      "28b9bffcf9", 16);

  test_rsa_md5(&pub, &key, expected);

  /* Test sha1 signature */
  mpz_set_str(expected,
	      "129b405ed85db88c" "55d35344c4b52854" "496516b4d63d8211"
	      "80a0c24d6ced9047" "33065a564bbd33d0" "a5cdfd204b9c6d15"
	      "78337207c2f1662d" "c73906c7a0f2bf5c" "af92cef9121957b1"
	      "dcb111ff47b92389" "888e384d0cfd1b1e" "e5d7003a8feff3fd"
	      "dd6a71d242a79272" "25234d67ba369441" "c12ae555c697754e"
	      "a17f93fa92", 16);

  test_rsa_sha1(&pub, &key, expected);

  /* 777-bit key, generated by
   *
   *   lsh-keygen -a rsa -l 777 -f advanced-hex
   *
   * Interesting because the size of n doesn't equal the sum of the
   * sizes of p and q. 
   *
   * (private-key (rsa-pkcs1
   *        (n #013b04440e3eef25 d51c738d508a7fa8 b3445180c342af0f
   *            4cb5a789047300e2 cfc5c5450974cfc2 448aeaaa7f43c374
   *            c9a3b038b181f2d1 0f1a2327fd2c087b a49bf1086969fd2c
   *            d1df3fd69f81fa4b 162cc8bbb363fc95 b7b24b9c53d0c67e
   *            f52b#)
   *        (e #3f1a012d#)
   *        (d #f9bae89dacca6cca c21e0412b4df8355 6fe7c5322bbae8ad
   *            3f11494fd12bc076 d4a7da3050fe109d 2074db09cc6a93b4
   *            745479522558379e a0ddfa74f86c9e9e a22c3b0e93d51447
   *            0feb38105dd35395 63b91ee32776f40c 67b2a175690f7abb
   *            25#)
   *        (p #0b73c990eeda0a2a 2c26416052c85560 0c5c0f5ce86a8326
   *            166acea91786237a 7ff884e66dbfdd3a ab9d9801414c1506
   *            8b#)
   *        (q #1b81c19a62802a41 9c99283331b0badb 08eb0c25ffce0fbf
   *            50017850036f32f3 2132a845b91a5236 61f7b451d587383f
   *            e1#)
   *        (a #0a912fc93a6cca6b 3521725a3065b3be 3c9745e29c93303d
   *            7d29316c6cafa4a2 89945f964fcdea59 1f9d248b0b6734be
   *            c9#)
   *        (b #1658eca933251813 1eb19c77aba13d73 e0b8f4ce986d7615
   *            764c6b0b03c18146 46b7f332c43e05c5 351e09006979ca5b
   *            05#)
   *        (c #0114720dace7b27f 2bf2850c1804869f 79a0aad0ec02e6b4
   *            05e1831619db2f10 bb9b6a8fd5c95df2 eb78f303ea0c0cc8
   *            06#)))
   */
  
  mpz_set_str(pub.n,
	      "013b04440e3eef25" "d51c738d508a7fa8" "b3445180c342af0f"
	      "4cb5a789047300e2" "cfc5c5450974cfc2" "448aeaaa7f43c374"
	      "c9a3b038b181f2d1" "0f1a2327fd2c087b" "a49bf1086969fd2c"
	      "d1df3fd69f81fa4b" "162cc8bbb363fc95" "b7b24b9c53d0c67e"
	      "f52b", 16);
  
  mpz_set_str(pub.e, "3f1a012d", 16);

  if (!rsa_public_key_prepare(&pub))
    FAIL();

#if 0  
  mpz_set_str(key.d,
	      "f9bae89dacca6cca" "c21e0412b4df8355" "6fe7c5322bbae8ad"
	      "3f11494fd12bc076" "d4a7da3050fe109d" "2074db09cc6a93b4"
	      "745479522558379e" "a0ddfa74f86c9e9e" "a22c3b0e93d51447"
	      "0feb38105dd35395" "63b91ee32776f40c" "67b2a175690f7abb"
	      "25", 16);
#endif
  
  mpz_set_str(key.p,
	      "0b73c990eeda0a2a" "2c26416052c85560" "0c5c0f5ce86a8326"
	      "166acea91786237a" "7ff884e66dbfdd3a" "ab9d9801414c1506"
	      "8b", 16);
  
  mpz_set_str(key.q,
	      "1b81c19a62802a41" "9c99283331b0badb" "08eb0c25ffce0fbf"
	      "50017850036f32f3" "2132a845b91a5236" "61f7b451d587383f"
	      "e1", 16);
  
  mpz_set_str(key.a,
	      "0a912fc93a6cca6b" "3521725a3065b3be" "3c9745e29c93303d"
	      "7d29316c6cafa4a2" "89945f964fcdea59" "1f9d248b0b6734be"
	      "c9", 16);
  
  mpz_set_str(key.b,
	      "1658eca933251813" "1eb19c77aba13d73" "e0b8f4ce986d7615"
	      "764c6b0b03c18146" "46b7f332c43e05c5" "351e09006979ca5b"
	      "05", 16);
  
  mpz_set_str(key.c,
	      "0114720dace7b27f" "2bf2850c1804869f" "79a0aad0ec02e6b4"
	      "05e1831619db2f10" "bb9b6a8fd5c95df2" "eb78f303ea0c0cc8"
	      "06", 16);

  if (!rsa_private_key_prepare(&key))
    FAIL();

  if (pub.size != key.size)
    FAIL();

  /* Test md5 signatures */
  mpz_set_str(expected,
	      "011b939f6fbacf7f" "7d3217b022d07477" "e582e34d4bbddd4c"
	      "31520647417fc8a6" "18b2e196d799cedd" "d8f5c062fd796b0f"
	      "72ab46db2ac6ec74" "39d856be3f746cc4" "3e0a15429954736a"
	      "60a8b3c6ea93d2cb" "c69085c307d72517" "07d43bf97a3b51eb"
	      "9e89", 16);

  test_rsa_md5(&pub, &key, expected);

  /* Test sha1 signature */
  mpz_set_str(expected,
	      "648c49e0ed045547" "08381d0bcd03b7bd" "b0f80a0e9030525d"
	      "234327a1c96b8660" "f1c01c6f15ae76d0" "4f53a53806b7e4db"
	      "1f789e6e89b538f6" "88fcbd2caa6abef0" "5432d52f3de463a4"
	      "a9e6de94f1b7bb68" "3c07edf0924fc93f" "56e1a0dba8f7491c"
	      "5c", 16);

  test_rsa_sha1(&pub, &key, expected);

  rsa_private_key_clear(&key);
  rsa_public_key_clear(&pub);
  mpz_clear(expected);

  SUCCESS();
  
#else /* !WITH_PUBLIC_KEY */
  SKIP();
#endif /* !WITH_PUBLIC_KEY */
}
