/* passcache-2.test.c - garbage tests for PggPasscache
 *      Copyright (C) 1999 Michael Roth <mroth@gnupg.org>
 *
 * This file is part of PGG (Privacy Guard Glue).
 *
 * PGG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PGG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#include <pggtest.h>


#define check()	expect_error(OBJECT, MAGIC)


int main()
{
    PggPasscache	garbage = (PggPasscache) "This is simple garbage.";
    
    pgg_errenv_reset(errenv);
    
    pgg_passcache_clone(garbage, errenv);
    check();
    
    pgg_passcache_addref(garbage, errenv);
    check();
    
    pgg_passcache_release(garbage, errenv);
    check();
    
    pgg_passcache_set_timeout(garbage, 0, errenv);
    check();
    
    pgg_passcache_get_timeout(garbage, errenv);
    check();
    
    pgg_passcache_set_policy(garbage, -1, errenv);
    check();
    
    pgg_passcache_get_policy(garbage, errenv);
    check();
    
    pgg_passcache_clear(garbage, errenv);
    check();
    
    pgg_passcache_expire(garbage, errenv);
    check();
    
    pgg_passcache_set_passphrase(garbage, NULL, NULL, errenv);
    check();
    
    pgg_passcache_rem_passphrase(garbage, NULL, errenv);
    check();
    
    pgg_passcache_get_passphrase(garbage, NULL, errenv);
    check();
    
    pgg_passcache_set_sym_passphrase(garbage, NULL, errenv);
    check();
    
    pgg_passcache_get_sym_passphrase(garbage, errenv);
    check();
    
    return 0;
}


