/* exe-2.test.c - garbage tests for PggExe
 *      Copyright (C) 1999 Michael Roth <mroth@gnupg.org>
 *
 * This file is part of PGG (Privacy Guard Glue).
 *
 * PGG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PGG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#include <pggtest.h>


#define check()	expect_error(OBJECT, MAGIC)


int main()
{
    PggExe		garbage = (PggExe) "This is simple garbage.";
    
    pgg_errenv_reset(errenv);
    
    pgg_exe_clone(garbage, errenv);
    check();
    
    pgg_exe_addref(garbage, errenv);
    check();
    
    pgg_exe_release(garbage, errenv);
    check();
    
    pgg_exe_set_gpgpath(garbage, NULL, errenv);
    check();
    
    pgg_exe_get_gpgpath(garbage, errenv);
    check();
    
    pgg_exe_get_return_code(garbage, errenv);
    check();
    
    pgg_exe_start(garbage, errenv);
    check();
    
    pgg_exe_add_arg(garbage, NULL, errenv);
    check();
    
    pgg_exe_abort(garbage, errenv);
    check();
    
    pgg_exe_request_status(garbage, errenv);
    check();
    
    pgg_exe_get_status_code(garbage, errenv);
    check();
    
    pgg_exe_get_status_arg(garbage, errenv);
    check();
    
    pgg_exe_wait_event(garbage, errenv);
    check();
    
    pgg_exe_request_shm(garbage, errenv);
    check();
    
    pgg_exe_reply_str(garbage, NULL, errenv);
    check();
    
    pgg_exe_reply_bool(garbage, 0, errenv);
    check();
    
    pgg_exe_set_read_cb(garbage, NULL, NULL, errenv);
    check();
    
    pgg_exe_set_write_cb(garbage, NULL, NULL, errenv);
    check();
    
    return 0;
}


