/* encrypt-2.test.c - garbage tests for PggEncrypt
 *      Copyright (C) 1999 Michael Roth <mroth@gnupg.org>
 *
 * This file is part of PGG (Privacy Guard Glue).
 *
 * PGG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PGG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#include <pggtest.h>


#define check()	expect_error(OBJECT, MAGIC)


int main()
{
    PggEncrypt		garbage = (PggEncrypt) "This is simple garbage.";
    
    pgg_errenv_reset(errenv);
    
    pgg_encrypt_clone(garbage, errenv);
    check();
    
    pgg_encrypt_addref(garbage, errenv);
    check();
    
    pgg_encrypt_release(garbage, errenv);
    check();
    
    pgg_encrypt_set_sign(garbage, 0, errenv);
    check();
    
    pgg_encrypt_get_sign(garbage, errenv);
    check();
    
    pgg_encrypt_set_signer(garbage, "abc", errenv);
    check();
    
    pgg_encrypt_get_signer(garbage, errenv);
    check();
    
    pgg_encrypt_add_recipient(garbage, "abc", errenv);
    check();
    
    pgg_encrypt_get_recipient_count(garbage, errenv);
    check();
    
    pgg_encrypt_get_recipient(garbage, 0, errenv);
    check();
    
    pgg_encrypt_rem_recipient(garbage, 0, errenv);
    check();
    
    pgg_encrypt_set_noencryptto(garbage, 0, errenv);
    check();
    
    pgg_encrypt_get_noencryptto(garbage, errenv);
    check();
    
    pgg_encrypt_set_stdio(garbage, NULL, errenv);
    check();
    
    pgg_encrypt_get_stdio(garbage, errenv);
    check();
    
    pgg_encrypt_set_passcache(garbage, NULL, errenv);
    check();
    
    pgg_encrypt_get_passcache(garbage, errenv);
    check();
    
    pgg_encrypt_set_algo(garbage, NULL, errenv);
    check();
    
    pgg_encrypt_get_algo(garbage, errenv);
    check();
    
    pgg_encrypt_set_config(garbage, NULL, errenv);
    check();
    
    pgg_encrypt_get_config(garbage, errenv);
    check();
    
    pgg_encrypt_execute(garbage, errenv);
    check();
    
    return 0;
}


