/* colons-process_data-1.test.c - Checks the pgg_colons_process_data() function
 *      Copyright (C) 1999 Michael Roth <mroth@gnupg.org>
 *
 * This file is part of PGG (Privacy Guard Glue).
 *
 * PGG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PGG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#include <pggtest.h>
#include <pggcolons.h>


/*
 * Representation of the following Key:
 *
 * pub:u:1024:17:009C42DBCC5CF182:1999-02-28:2004-02-27:381:f:Michael Roth <mroth@gnupg.org>:
 * fpr:::::::::1D8EC918F4F358BCE08E4456009C42DBCC5CF182:
 * sig::::009C42DBCC5CF182:1999-09-17::::Michael Roth <mroth@gnupg.org>:13:
 * sig::::7308657FA77DDABD:1999-09-18::::Michael Roth (This is my old key) <mroth@gnupg.de>:10:
 * sig::::CA15FABA1B13AD41:1999-09-18::::Michael Roth (Used for key signatures) <mroth@gnupg.org>:10:
 * uid:u::::::::Michael Roth <mroth@nessie.de>:
 * sig::::009C42DBCC5CF182:1999-09-17::::Michael Roth <mroth@gnupg.org>:13:
 * sub:u:1792:16:0DF8BD9712CCB97E:1999-02-28::381::
 * sig::::009C42DBCC5CF182:1999-02-28::::Michael Roth <mroth@gnupg.org>:18:
 */
char * test_data[] = {
    "p",
    "ub",
    ":u:",
    "1024",
    ":17:0",
    "09C42D",
    "BCC5CF1",
    "82:1999-",
    "02-28:200",
    "4-02-27:38",
    "1:f:Michael",
    " Roth <mroth",
    "@gnupg.org>:\n",
    "fpr:::::::::1D8EC918F4F358BCE08E4456009C42DBCC5CF182:\nsig::::009C42",
    "DBCC5CF182:1999-09-17::::M",
    "ichael Roth <mroth@gnupg.org>:13:",
    "\n",
    "sig::::7308657FA77DDABD:19",
    "99-09-18::::Michael Roth",
    " (This is my old key) ",
    "<mroth@gnupg.de>:10:",
    "\nsig::::CA15FABA1",
    "B13AD41:1999-09-",
    "18::::Michael ",
    "Roth (Used f",
    "or key sig",
    "natures)",
    " <mrot",
    "h@gn",
    "up",
    "g.org>:10:\n",
    "uid", ":", "u", ":", ":", ":", ":", ":", ":", ":", ":", "Michael Roth <mroth@nessie.de>", ":", "\n",
    "sig", "::::009C42DBCC5CF182", ":1999-09-17", "::::Michael Roth <mroth@gnupg.org>", ":13", ":\n",
    "sub:", "u:", "1792:", "16:", "0DF8BD9712CCB97E:", "1999-02-28::", "381", 
    "::\nsig::::", "009C42DBCC5CF182:", "1999-02-28::::", "Michael Roth <mroth@gnupg.org>:", "18:\n",
    
    NULL		/* end marker for this test programm */
};


/*
 * The above test strings parsed must result in these events:
 */
struct { int colon; char *text; } expected_event[] = {
    { 0, "pub" },
    { 1, "u" },
    { 2, "1024" },
    { 3, "17" },
    { 4, "009C42DBCC5CF182" },
    { 5, "1999-02-28" },
    { 6, "2004-02-27" },
    { 7, "381" },
    { 8, "f" },
    { 9, "Michael Roth <mroth@gnupg.org>" },
    
    { 0, "fpr" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "" },
    { 5, "" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "1D8EC918F4F358BCE08E4456009C42DBCC5CF182" },
    
    { 0, "sig" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "009C42DBCC5CF182" },
    { 5, "1999-09-17" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "Michael Roth <mroth@gnupg.org>" },
    { 10, "13" },
    
    { 0, "sig" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "7308657FA77DDABD" },
    { 5, "1999-09-18" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "Michael Roth (This is my old key) <mroth@gnupg.de>" },
    { 10, "10" },
    
    { 0, "sig" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "CA15FABA1B13AD41" },
    { 5, "1999-09-18" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "Michael Roth (Used for key signatures) <mroth@gnupg.org>" },
    { 10, "10" },
    
    { 0, "uid" },
    { 1, "u" },
    { 2, "" },
    { 3, "" },
    { 4, "" },
    { 5, "" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "Michael Roth <mroth@nessie.de>" },
    
    { 0, "sig" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "009C42DBCC5CF182" },
    { 5, "1999-09-17" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "Michael Roth <mroth@gnupg.org>" },
    { 10, "13" },
    
    { 0, "sub" },
    { 1, "u" },
    { 2, "1792" },
    { 3, "16" },
    { 4, "0DF8BD9712CCB97E" },
    { 5, "1999-02-28" },
    { 6, "" },
    { 7, "381" },
    { 8, "" },
    
    { 0, "sig" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "009C42DBCC5CF182" },
    { 5, "1999-02-28" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "Michael Roth <mroth@gnupg.org>" },
    { 10, "18" },
    
    { -1, NULL }		/* End marker used by this test programm only */
};


int expected_event_index = 0;


/*
 * Sets up a PggColon object and feed the test strings to it.
 */
int main()
{
    PggColons			colons;
    char **			ptr;
    
    pgg_errenv_reset(errenv);
    
    colons = pgg_colons_new(errenv);
    pgg_colons_set_cb(colons, colons_test_callback, NULL, errenv);	/* Test callback from colons_test_callback.c */
    
    expect_success();
    
    for (ptr = test_data; *ptr; ++ptr)
        pgg_colons_process_data(colons, *ptr, strlen(*ptr), errenv);
    
    expect_success();
    
    if (!pgg_colons_is_line_complete(colons, errenv)  ||  expected_event[expected_event_index].colon != -1) {
        PGG_DEBUG(("Not all text consumed."));
        return 1;
    }
    
    pgg_colons_release(colons, errenv);
    
    expect_success();
    
    return 0;
}





