/* colons-exe-1.test.c - Tests the calling and parsing of GnuPG colons output
 *      Copyright (C) 1999 Michael Roth <mroth@gnupg.org>
 *
 * This file is part of PGG (Privacy Guard Glue).
 *
 * PGG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PGG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#include <string.h>
#include <stdio.h>
#include <pgg.h>
#include <pggcolons.h>
#include <pggtest.h>


struct { int colon; char *text; } expected_event[] = {
    { 0, "pub" },
    { 1, "q" },
    { 2, "1024" },
    { 3, "17" },
    { 4, "009C42DBCC5CF182" },
    { 5, "1999-02-28" },
    { 6, "2004-02-27" },
    { 7, "59" },
    { 8, "-" },
    { 9, "Michael Roth <mroth@gnupg.org>" },
    { 0, "fpr" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "" },
    { 5, "" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "1D8EC918F4F358BCE08E4456009C42DBCC5CF182" },
    { 0, "sig" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "009C42DBCC5CF182" },
    { 5, "1999-09-17" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "Michael Roth <mroth@gnupg.org>" },
    { 10, "13" },
    { 0, "sig" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "7308657FA77DDABD" },
    { 5, "1999-09-18" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "[User id not found]" },
    { 10, "10" },
    { 0, "sig" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "CA15FABA1B13AD41" },
    { 5, "1999-09-18" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "Michael Roth (Used for key signatures) <mroth@gnupg.org>" },
    { 10, "10" },
    { 0, "uid" },
    { 1, "q" },
    { 2, "" },
    { 3, "" },
    { 4, "" },
    { 5, "" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "Michael Roth <mroth@nessie.de>" },
    { 0, "sig" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "009C42DBCC5CF182" },
    { 5, "1999-09-17" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "Michael Roth <mroth@gnupg.org>" },
    { 10, "13" },
    { 0, "sub" },
    { 1, "q" },
    { 2, "1792" },
    { 3, "16" },
    { 4, "0DF8BD9712CCB97E" },
    { 5, "1999-02-28" },
    { 6, "2004-02-27" },
    { 7, "59" },
    { 8, "" },
    { 0, "sig" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "009C42DBCC5CF182" },
    { 5, "1999-02-28" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "Michael Roth <mroth@gnupg.org>" },
    { 10, "18" },
    { 0, "pub" },
    { 1, "q" },
    { 2, "1024" },
    { 3, "17" },
    { 4, "CA15FABA1B13AD41" },
    { 5, "1999-09-18" },
    { 6, "" },
    { 7, "65" },
    { 8, "-" },
    { 9, "Michael Roth (Used for key signatures) <mroth@gnupg.org>" },
    { 0, "fpr" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "" },
    { 5, "" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "235040B3E62B73D14DE65567CA15FABA1B13AD41" },
    { 0, "sig" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "CA15FABA1B13AD41" },
    { 5, "1999-09-18" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "Michael Roth (Used for key signatures) <mroth@gnupg.org>" },
    { 10, "13" },
    { 0, "sig" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "7308657FA77DDABD" },
    { 5, "1999-09-18" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "[User id not found]" },
    { 10, "10" },
    { 0, "sig" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "009C42DBCC5CF182" },
    { 5, "1999-09-18" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "Michael Roth <mroth@gnupg.org>" },
    { 10, "10" },
    { 0, "pub" },
    { 1, "q" },
    { 2, "1024" },
    { 3, "17" },
    { 4, "68B7AB8957548DCD" },
    { 5, "1998-07-07" },
    { 6, "2002-12-29" },
    { 7, "73" },
    { 8, "-" },
    { 9, "Werner Koch (gnupg sig) <dd9jn@gnu.org>" },
    { 0, "fpr" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "" },
    { 5, "" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "6BD9050FD8FC941B43412DCC68B7AB8957548DCD" },
    { 0, "sig" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "68B7AB8957548DCD" },
    { 5, "1998-11-20" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "Werner Koch (gnupg sig) <dd9jn@gnu.org>" },
    { 10, "13" },
    { 0, "sig" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "036F11B8FF3EAA0B" },
    { 5, "1998-07-07" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "Werner Koch <wk@isil.d.shuttle.de>" },
    { 10, "10" },
    { 0, "sig" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "6C7EE1B8621CC013" },
    { 5, "1998-07-07" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "Werner Koch <werner.koch@guug.de>" },
    { 10, "10" },
    { 0, "sig" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "5DE249965B0358A2" },
    { 5, "1999-03-15" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "Werner Koch <wk@gnupg.org>" },
    { 10, "10" },
    { 0, "pub" },
    { 1, "q" },
    { 2, "1024" },
    { 3, "17" },
    { 4, "6C7EE1B8621CC013" },
    { 5, "1998-07-07" },
    { 6, "2002-11-01" },
    { 7, "78" },
    { 8, "-" },
    { 9, "Werner Koch <werner.koch@guug.de>" },
    { 0, "fpr" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "" },
    { 5, "" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "ECAF7590EB3443B5C7CF3ACB6C7EE1B8621CC013" },
    { 0, "sig" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "6C7EE1B8621CC013" },
    { 5, "1998-11-20" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "Werner Koch <werner.koch@guug.de>" },
    { 10, "13" },
    { 0, "sig" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "1D19F4C10C9857A5" },
    { 5, "1998-07-08" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "[User id not found]" },
    { 10, "10" },
    { 0, "sig" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "036F11B8FF3EAA0B" },
    { 5, "1998-07-07" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "Werner Koch <wk@isil.d.shuttle.de>" },
    { 10, "10" },
    { 0, "sig" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "6C7EE1B8621CC013" },
    { 5, "1999-02-20" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "Werner Koch <werner.koch@guug.de>" },
    { 10, "13" },
    { 0, "sig" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "5DE249965B0358A2" },
    { 5, "1999-03-15" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "Werner Koch <wk@gnupg.org>" },
    { 10, "10" },
    { 0, "sub" },
    { 1, "q" },
    { 2, "1536" },
    { 3, "20" },
    { 4, "5CE086B5B5A18FF4" },
    { 5, "1998-07-07" },
    { 6, "2002-07-06" },
    { 7, "78" },
    { 8, "" },
    { 0, "sig" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "6C7EE1B8621CC013" },
    { 5, "1998-07-07" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "Werner Koch <werner.koch@guug.de>" },
    { 10, "18" },
    { 0, "sub" },
    { 1, "q" },
    { 2, "1536" },
    { 3, "16" },
    { 4, "06AD222CADF6A6E1" },
    { 5, "1999-02-20" },
    { 6, "2002-11-01" },
    { 7, "78" },
    { 8, "" },
    { 0, "sig" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "6C7EE1B8621CC013" },
    { 5, "1999-02-20" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "Werner Koch <werner.koch@guug.de>" },
    { 10, "18" },
    { 0, "pub" },
    { 1, "q" },
    { 2, "768" },
    { 3, "16" },
    { 4, "E1139763E1D81275" },
    { 5, "1998-02-09" },
    { 6, "" },
    { 7, "88" },
    { 8, "-" },
    { 9, "werner <dd9jn@amsat.org>" },
    { 0, "fpr" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "" },
    { 5, "" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "86E266816C0B6DD54C06BA6CE1139763E1D81275" },
    { 0, "sig" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "E1139763E1D81275" },
    { 5, "1998-02-09" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "werner <dd9jn@amsat.org>" },
    { 10, "13" },
    { 0, "sig" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "036F11B8FF3EAA0B" },
    { 5, "1998-02-09" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "Werner Koch <wk@isil.d.shuttle.de>" },
    { 10, "10" },
    { 0, "pub" },
    { 1, "q" },
    { 2, "1312" },
    { 3, "16" },
    { 4, "036F11B8FF3EAA0B" },
    { 5, "1998-02-09" },
    { 6, "" },
    { 7, "77" },
    { 8, "-" },
    { 9, "Werner Koch <wk@isil.d.shuttle.de>" },
    { 0, "fpr" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "" },
    { 5, "" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "84896CD018510E3345DACD67036F11B8FF3EAA0B" },
    { 0, "sig" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "036F11B8FF3EAA0B" },
    { 5, "1998-02-09" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "Werner Koch <wk@isil.d.shuttle.de>" },
    { 10, "13" },
    { 0, "sig" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "E1139763E1D81275" },
    { 5, "1998-02-09" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "werner <dd9jn@amsat.org>" },
    { 10, "10" },
    { 0, "pub" },
    { 1, "q" },
    { 2, "1024" },
    { 3, "17" },
    { 4, "5DE249965B0358A2" },
    { 5, "1999-03-15" },
    { 6, "2005-12-31" },
    { 7, "79" },
    { 8, "-" },
    { 9, "Werner Koch <wk@gnupg.org>" },
    { 0, "fpr" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "" },
    { 5, "" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "A4D94E92B0986AB5EE9DCD755DE249965B0358A2" },
    { 0, "sig" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "5DE249965B0358A2" },
    { 5, "1999-04-19" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "Werner Koch <wk@gnupg.org>" },
    { 10, "13" },
    { 0, "sig" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "6C7EE1B8621CC013" },
    { 5, "1999-04-19" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "Werner Koch <werner.koch@guug.de>" },
    { 10, "10" },
    { 0, "sig" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "1D19F4C10C9857A5" },
    { 5, "1999-04-19" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "[User id not found]" },
    { 10, "10" },
    { 0, "sig" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "68B7AB8957548DCD" },
    { 5, "1999-04-19" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "Werner Koch (gnupg sig) <dd9jn@gnu.org>" },
    { 10, "10" },
    { 0, "sig" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "F6EEDF20184BC4D9" },
    { 5, "1999-05-28" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "[User id not found]" },
    { 10, "10" },
    { 0, "sig" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "983465DB21439422" },
    { 5, "1999-08-03" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "[User id not found]" },
    { 10, "10" },
    { 0, "uid" },
    { 1, "q" },
    { 2, "" },
    { 3, "" },
    { 4, "" },
    { 5, "" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "Werner Koch" },
    { 0, "sig" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "5DE249965B0358A2" },
    { 5, "1999-03-15" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "Werner Koch <wk@gnupg.org>" },
    { 10, "13" },
    { 0, "sig" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "6C4C31A5B1D51567" },
    { 5, "1999-05-04" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "[User id not found]" },
    { 10, "10" },
    { 0, "sig" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "750F6495C89D933E" },
    { 5, "1999-05-13" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "[User id not found]" },
    { 10, "10" },
    { 0, "sig" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "F6EEDF20184BC4D9" },
    { 5, "1999-05-10" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "[User id not found]" },
    { 10, "10" },
    { 0, "sig" },
    { 1, "" },
    { 2, "" },
    { 3, "" },
    { 4, "528057447653401D" },
    { 5, "1999-05-20" },
    { 6, "" },
    { 7, "" },
    { 8, "" },
    { 9, "[User id not found]" },
    { 10, "10" },
    { -1, NULL }
};


int expected_event_index = 0;


#if 0
int colons_cb(void *opaque, int colon, const char *text)
{
    printf("    { %d, \"%s\" },\n", colon, text);
    return 0;
}
#endif



int main(int argc, char *argv[])
{
    PggExe		exe;
    PggColons		colons;
    PggConfig		config;
    Pgg_Event		event;
    
    pgg_errenv_reset(errenv);
    
    colons = pgg_colons_new(errenv);
    pgg_colons_set_cb(colons, colons_test_callback, NULL, errenv);
    
    exe = pgg_exe_new(errenv);
    pgg_exe_add_arg(exe, "--homedir", errenv);
    pgg_exe_add_arg(exe, path_to_srcdir_file("gnupg-homedir-1"), errenv);
    pgg_exe_add_arg(exe, "--list-sigs", errenv);
    pgg_exe_add_arg(exe, "--with-colons", errenv);
    pgg_exe_add_arg(exe, "--fingerprint", errenv);
    pgg_colons_setup_exe(colons, exe, errenv);
    
    config = pgg_config_new(errenv);
    pgg_config_setup_exe(config, exe, errenv);
    pgg_config_release(config, errenv);
    
    expect_success();
    
    pgg_exe_start(exe, errenv);
    event = pgg_exe_wait_event(exe, errenv);
    
    expect_success();

    if (!pgg_colons_is_line_complete(colons, errenv)  ||  expected_event[expected_event_index].colon != -1) {
        PGG_DEBUG(("Not all text consumed."));
        return 1;
    }
    
    /* FIXME: Check 'event' and return code */
    
    pgg_exe_release(exe, errenv);
    pgg_colons_release(colons, errenv);
    
    expect_success();
    
    return 0;
}





