/* pggpubkey.h - PggPubkey accesses infos about public keys
 *      Copyright (C) 1999 Michael Roth <mroth@gnupg.org>
 *
 * This file is part of PGG (Privacy Guard Glue).
 *
 * PGG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PGG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#ifndef PGG_INCLUDE_PGGPUBKEY_H_19990727113644
#define PGG_INCLUDE_PGGPUBKEY_H_19990727113644


#include <pgg.h>
#include <pggimpl.h>
#include <pgglist.h>


extern PggPubkey		pgg_pubkey_new(PggErrenv errenv);
extern void			pgg_pubkey_start(PggPubkey pubkey, PggErrenv errenv);
extern void			pgg_pubkey_process(PggPubkey pubkey, int colon, const char *data, PggErrenv errenv);
extern void			pgg_pubkey_finish(PggPubkey pubkey, PggErrenv errenv);
extern void			pgg_pubkey_set_config(PggPubkey pubkey, PggConfig config, PggErrenv errenv);


typedef struct _PggPubkeyUID PggPubkeyUID;
typedef struct _PggPubkeySig PggPubkeySig;


struct _PggPubkeyUID
{
    PggListNode		node;
    PggListHead		sigs;		/* List of PggPubkeySig nodes */
    char		name[1];	/* UID string. _Not_ parsed in Realname, Comment, Email etc. */
};


struct _PggPubkeySig
{
    PggListNode		node;		
    unsigned long	keyid[2];	/* KeyID of the signature issuer */
    unsigned long	date;		/* Signature date */
};


_mktype(PggPubkey)
{
    unsigned long	magic;
    int			refcounter;
    PggListHead		uids;		/* List of PggPubkeyUID nodes */
    PggConfig		config;		/* Configuration of public ring location */
    int			process_state;	/* State during processing data */
};


_mktypeptr(PggPubkey);


#define PggPubkeyMAGIC 0xFF0F0F99


#endif


