/* pgglist.h - Low level linked lists functions with index access
 *      Copyright (C) 1999 Michael Roth <mroth@gnupg.org>
 *
 * This file is part of PGG (Privacy Guard Glue).
 *
 * PGG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PGG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#ifndef PGG_INCLUDE_PGGLIST_H_19991111015439
#define PGG_INCLUDE_PGGLIST_H_19991111015439


struct _PggListHead;
struct _PggListNode;


typedef struct _PggListHead
{
    struct _PggListNode *	last_node;
    struct _PggListNode *	cursor_node;
    unsigned int		cursor_index;
    unsigned int		node_count;
} PggListHead;


typedef struct _PggListNode
{
    struct _PggListNode *	next;
} PggListNode;


extern void			pgg_list_init(PggListHead * head);
extern void			pgg_list_prepend(PggListHead * head, PggListNode * node);
extern void			pgg_list_append(PggListHead * head, PggListNode * node);
extern PggListNode *		pgg_list_at(PggListHead * head, unsigned int index);
extern void			pgg_list_free_nodes(PggListHead * head);


#define pgg_list_count(head)	((head)->node_count)


#endif


