/* pgg_colons_setup_exe.c - Sets up a PggExe object to deliver PggColons events
 *      Copyright (C) 1999 Michael Roth <mroth@gnupg.org>
 *
 * This file is part of PGG (Privacy Guard Glue).
 *
 * PGG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PGG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#include <includes.h>
#include <pgg.h>
#include <pggdebug.h>
#include <pggcolons.h>
#include <pggexe.h>


#define colons		((PggColonsPtr)(_colons))


static long read_cb(void * c, void * data, long amount)
{
    PggErrenv           local_errenv;
    
    if (!c || !data || amount < 0)
        return -1;
    
    pgg_errenv_reset(local_errenv);
    
    if (amount > 0)
        pgg_colons_process_data((PggColons)c, (const char *)data, amount, local_errenv);

    return pgg_errenv_is_set(local_errenv) ? -1 : amount;
}


void pgg_colons_setup_exe(PggColons _colons, PggExe exe, PggErrenv errenv)
{
    PGG_STD_ASSERT(PggColons, colons);
    PGG_ASSERT(exe, ARGUMENT, NULLPTR);
    
    pgg_exe_set_read_cb(exe, read_cb, colons, errenv);
}


