/* pgg_colons_process_data.c - Parse the data into fields and call the callback
 *      Copyright (C) 1999 Michael Roth <mroth@gnupg.org>
 *
 * This file is part of PGG (Privacy Guard Glue).
 *
 * PGG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PGG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#include <includes.h>
#include <pgg.h>
#include <pggdebug.h>
#include <pggcolons.h>


#define colons          ((PggColonsPtr)(_colons))


void pgg_colons_process_data(PggColons _colons, const char *new_text, int length, PggErrenv errenv)
{
    PggErrenv			local_errenv;
    char *			stored_text;
    long			stored_text_length;
    long			index;
    char *			cb_argument;
    
    PGG_STD_ASSERT(PggColons, colons);
    PGG_ASSERT(new_text, ARGUMENT, NULLPTR);
    PGG_ASSERT(length > 0, ARGUMENT, VALUE);
    PGG_ASSERT(colons->cb, REQUEST, STATE);
    
    pgg_errenv_reset(local_errenv);
    
    pgg_buffer_append(colons->buffer, new_text, length, local_errenv);
    
    stored_text = cb_argument = (char *) pgg_buffer_get_data(colons->buffer, local_errenv);
    stored_text_length        = pgg_buffer_get_size(colons->buffer, local_errenv);
    
    if (pgg_errenv_is_set(local_errenv)) {
        pgg_errenv_copy(errenv, local_errenv);
        return;
    }
    
    for (index = colons->check_index_resume; index < stored_text_length; ++index)
        switch (stored_text[index]) {
            case ':':
                stored_text[index] = 0;		/* Create a Null terminated C string */
                colons->cb(colons->opaque, colons->current_colon++, cb_argument);	/* FIXME: catch errors */
                cb_argument = stored_text + index + 1;
                break;
            
            case '\r':
            case '\n':
                cb_argument = stored_text + index + 1;
                colons->current_colon = 0;
                break;
        }
    
    /*
     * Delete the consumed bytes out of the buffer and adjust the 
     * check_index_resume.
     */
    pgg_buffer_delete(colons->buffer, 0, cb_argument - stored_text, NULL);		/* FIXME: errors */
    colons->check_index_resume = index - (cb_argument - stored_text);
}


