/* gpgsearch.c - demonstrate how to find the gpg binary
 *      Copyright (c) 1999 by Michael Roth <mroth@gnupg.org>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * MICHAEL ROTH BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of Michael Roth shall not be
 * used in advertising or otherwise to promote the sale, use or other dealings
 * in this Software without prior written authorization from Michael Roth.
 */


#include <stdio.h>
#include <pgg.h>


/*
 * This is a small example which show how to search the gpg binary in the
 * standard $PATH environment. You could also supply an own search
 * path to pgg_config_search_gpg() as second argument.
 * In normally usage of PGG you would not need to search the gpg binary,
 * but who knows.
 */
int main()
{
    PggConfig		cfg;
    
    /*
     * In this example we don't use a PggErrenv object to collect
     * errors. Instead we use the return value. Please note: It is
     * not allways possible to use the return code. Many functions
     * doesn't return a value. A second point is that you can't check
     * the type of an error if you don't use a PggErrenv object.
     */
    if (!( cfg = pgg_config_new(NULL) )) {
        printf("Can't create a PggConfig object!\n");
        return 1;
    }
    
    /*
     * pgg_config_search_gpg() tries to find the gpg binary in the
     * default $PATH environment, or if you wish in a supplied path
     * argument. When the binary is found, the path is stored in the
     * PggConfig object and `1' is returned. If the binary is not
     * found, the object will not be altered an `0' will be returned.
     */
    if (!pgg_config_search_gpg(cfg, NULL, NULL)) {
        printf("Searching the gpg binary failed. No gpg binary found.\n");
        return 1;
    }
    
    printf("Found gpg in: `%s'\n", pgg_config_get_gpgpath(cfg, NULL) );
    
    return 0;
}
