/* pggsign.h - data structure definition of PggSign
 *      Copyright (C) 1999 Michael Roth <mroth@gnupg.org>
 *
 * This file is part of PGG (Privacy Guard Glue).
 *
 * PGG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PGG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#ifndef PGG_INCLUDE_PGGALGO_H_19990626170105
#define PGG_INCLUDE_PGGALGO_H_19990626170105


#include <pgg.h>
#include <pggimpl.h>


_mktype(PggSign)
{
    unsigned long	magic;
    int			refcounter;
    char *		signer;
    PggSign_Escape	escape;
    PggSign_Mode	mode;
    PggStdio		stdio;
    PggPasscache	passcache;
    PggAlgo		algo;
    PggConfig		config;
};


_mktypeptr(PggSign);


#define PggSignMAGIC 0xFF0F0B99


#endif


