#
# gnupg -- gnu privacy guard
# This is a template.  The dist target uses it to create the real file.
#
%define version 1.0.2
%define name gnupg
Summary: GNU Utility for data encryption and digital signatures
Summary(it): Utility GNU per la sicurezza nelle comunicazioni e nell'archiviazione dei dati.
Summary(cs): GNU nstroj pro ifrovanou komunikaci a bezpen ukldn dat
Summary(fr): Utilitaire GNU de chiffrement et d'authentification des communications et des donnes
Vendor: GNU Privacy Guard Project
Name: %{name}
Version: %{version}
Release: 1
Copyright: GPL
Group: Applications/Cryptography
Group(cs): Aplikace/ifrovn
Group(fr): Applications/Cryptographie
Source: ftp://ftp.gnupg.org/pub/gcrypt/%{name}-%{version}.tar.gz
URL: http://www.gnupg.org
Provides: gpg openpgp
BuildRoot: /tmp/rpmbuild_%{name}

%changelog
* Mon May 01 2000 Fabio Coatti <cova@ferrara.linux.it>
- Some corrections in French description, thanks to Gal Quri
<gqueri@mail.dotcom.fr>; Some corrections to Italian descriptions.

* Tue Apr 25 2000 Fabio Coatti <cova@ferrara.linux.it>
- Removed the no longer needed patch for man page by Keith Owens

* Wed Mar 1 2000 Petr Kritof <Petr@Kristof.CZ> 
- Czech descriptions added; some fixes and updates.

* Sat Jan 15 2000 Keith Owens <kaos@ocs.com.au>
- Add missing man page as separate patch instead of updating the tar file.

* Mon Dec 27 1999 Fabio Coatti <cova@ferrara.linux.it> 
- Upgraded for 1.0.1 (added missing gpg.1 man page)

* Sat May 29 1999 Fabio Coatti <cova@ferrara.linux.it>
- Some corrections in French description, thanks to Gal Quri <gqueri@mail.dotcom.fr>  

* Mon May 17 1999 Fabio Coatti <cova@felix.unife.it>
- Added French description, provided by 
Christophe Labouisse <labouiss@cybercable.fr>

* Thu May 06 1999 Fabio Coatti <cova@felix.unife.it> 
- Upgraded for 0.9.6 (removed gpgm)

* Tue Jan 12 1999 Fabio Coatti <cova@felix.unife.it>
- LINGUAS variable is now unset in configure to ensure that all languages will be built. (Thanks to Luca Olivetti <luca@luca.ddns.org>)
 
* Sat Jan 02 1999 Fabio Coatti <cova@felix.unife.it>
- Added pl language file.
- Included g10/pubring.asc in documentation files.

* Sat Dec 19 1998 Fabio Coatti <cova@felix.unife.it>
- Modified the spec file provided by Caskey L. Dickson <caskey-at-technocage.com>
- Now it can be built also by non-root. Installation has to be done as
root, gpg is suid.
- Added some changes by  Ross Golder <rossigee@bigfoot.com>
- Updates for version 0.4.5 of GnuPG (.mo files)

%description
GnuPG (GNU Privacy Guard) is a GNU utility for encrypting data and
creating digital signatures. GnuPG has advanced key management
capabilities and is compliant with the proposed OpenPGP Internet
standard described in RFC2440. Since GnuPG doesn't use any patented
algorithm, it is not compatible with any version of PGP2 (PGP2.x uses
only IDEA, patented worldwide, and RSA, which is patented in the US
until 9/20/00).

%description -l it
GnuPG (GNU Privacy Guard)  una utility GNU per la cifratura di dati e
la creazione di firme digitali. Possiede una gestione avanzata delle
chiavi ed  conforme allo standard Internet OpenPGP, descritto nella
RFC 2440. Non utilizzando algoritmi brevettati, non  compatibile con
PGP2 (PGP2.x usa solo IDEA, coperto da brevetto mondiale, ed RSA,
brevettato negli USA con scadenza 20/09/2000). Questi algoritmi sono
utilizzabili da GnuPG tramite moduli esterni.

%description -l fr
GnuPG est un utilitaire GNU destin  chiffrer des donnes et  crer
des signatures lectroniques. Il a des capacits avances de gestion de
cls et il est conforme  la norme propose OpenPGP dcrite dans la
RFC2440. Comme GnuPG n'utilise pas d'algorithme brevet, il n'est
compatible avec aucune version de PGP2 (PGP2.x ne sait utiliser que
l'IDEA brevet dans le monde entier et RSA, brevet aux tats-Unis
jusqu'au 20 septembre 2000). 

%description -l cs
GnuPG je GNU nstroj pro bezpenou komunikaci a ukldn dat. Me bt
pouit na ifrovn dat a vytven digitlnch podpis. Obsahuje
funkce pro pokroilou sprvu kl a vyhovuje navrhovanmu OpenPGP
Internet standardu podle RFC2440. Byl vytvoen jako kompletn
nhrada za PGP. Protoe neobsahuje ifrovac algoritmy IDEA nebo RSA,
me bt pouvn bez omezen.
Protoe GnuPG nepouv dn patentovan algoritmus, neme bt pln
kompatibiln s PGP verze 2. PGP 2.x pouv algoritmy IDEA (patentovno
celosvtov) a RSA (patentovno ve Spojench sttech do 20. z
2000). Tyto algoritmy lze zavst do GnuPG pomoc externch modul.


%prep
rm -rf $RPM_BUILD_ROOT
rm -rf $RPM_BUILD_DIR/%{name}-%{version}

%setup

%build
if test -n "$LINGUAS"; then
 unset LINGUAS
fi    
CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=/usr --enable-shared
make

%install
make install-strip prefix=$RPM_BUILD_ROOT/usr

%files

%doc %attr (-,root,root) INSTALL
%doc %attr (-,root,root) AUTHORS
%doc %attr (-,root,root) COPYING
%doc %attr (-,root,root) ChangeLog
%doc %attr (-,root,root) NEWS
%doc %attr (-,root,root) README
%doc %attr (-,root,root) THANKS
%doc %attr (-,root,root) TODO   
%doc %attr (-,root,root) PROJECTS
%doc %attr (-,root,root) doc/DETAILS
%doc %attr (-,root,root) doc/FAQ
%doc %attr (-,root,root) doc/HACKING
%doc %attr (-,root,root) doc/OpenPGP
%doc %attr (-,root,root) g10/pubring.asc
%doc %attr (-,root,root) g10/OPTIONS

%attr (-,root,root) /usr/man/man1/gpg.1
%attr (4755,root,root) /usr/bin/gpg

%attr (-,root,root) /usr/share/locale/*/*/%{name}.mo

%attr (-,root,root) /usr/lib/%{name}
%attr (-,root,root) /usr/share/%{name}

%clean
rm -rf $RPM_BUILD_ROOT
rm -rf $RPM_BUILD_DIR/%{name}-%{version}
