/* file.c
 *	Copyright (C) 2005 Kurt Fitzner
 *
 * This file is part of MyGPGME.
 *
 * MyGPGME is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MyGPGME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#include <windows.h>
#pragma hdrstop

#include "gpgme.h"
#include "util.h"


gpgme_error_t
gpgme_file_get_pgptype( const char * filename, gpgme_pgptype_t * r_type )
{
    gpgme_pgptype_t type = 0;
    FILE *infile;
    char *data = NULL;

    data = malloc(16384);
    if (!data)
        return mk_error( Out_Of_Core );

    infile = my_fopen(filename, "rb");
    if (!infile)
        return mk_error( File_Error );
    while (fgets(data, 16384, infile)) {
        if( strstr( data, "BEGIN PGP MESSAGE") )
            type |= GPGME_TYPE_MESSAGE;
        if( strstr( data, "BEGIN PGP SIGNED MESSAGE" ) )
            type |= GPGME_TYPE_CLEARSIG;
        if( strstr( data, "BEGIN PGP SIGNATURE" ) )
            type |= GPGME_TYPE_SIG;
        if( strstr( data, "BEGIN PGP PUBLIC KEY BLOCK" ) )
            type |= GPGME_TYPE_PUBKEY;
        if( strstr( data, "BEGIN PGP PRIVATE KEY BLOCK" )
            || strstr( data, "BEGIN PGP SECRET KEY BLOCK" ) )
            type |= GPGME_TYPE_SECKEY;
        if( strstr( data, "- -----BEGIN" ) )
            type |= GPGME_TYPE_DASH_ESCAPED;
    }  // while (fgets(data, 16384, infile))
    fclose(infile);
    free(data);
    *r_type = type;
    return 0;
} /* gpgme_clip_parse_pgpid */



