/* mips3 mpih-mul1.S -- Multiply a limb vector with a limb and store
 *			the result in a second limb vector.
 *
 *      Copyright (C) 1992, 1994, 1995, 1998, 2000
 *                    2001 Free Software Foundation, Inc.
 *
 * This file is part of GnuPG.
 *
 * GnuPG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * GnuPG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301,
 * USA.
 */


/*******************
 * mpi_limb_t
 * mpihelp_mul_1( mpi_ptr_t res_ptr,	(r4)
 *		  mpi_ptr_t s1_ptr,	(r5)
 *		  mpi_size_t s1_size,	(r6)
 *		  mpi_limb_t s2_limb)	(r7)
 */

	.text
	.align	4
	.globl	mpihelp_mul_1
	.ent	mpihelp_mul_1
mpihelp_mul_1:
	.set	noreorder
	.set	nomacro

/* # warm up phase 0 */
	ld	$8,0($5)

/* # warm up phase 1 */
	daddiu	$5,$5,8
	dmultu	$8,$7

	daddiu	$6,$6,-1
	beq	$6,$0,$LC0
	 move	$2,$0		# zero cy2

	daddiu	$6,$6,-1
	beq	$6,$0,$LC1
	ld	$8,0($5)	# load new s1 limb as early as possible

Loop:	mflo	$10
	mfhi	$9
	daddiu	$5,$5,8
	daddu	$10,$10,$2	# add old carry limb to low product limb
	dmultu	$8,$7
	ld	$8,0($5)	# load new s1 limb as early as possible
	daddiu	$6,$6,-1	# decrement loop counter
	sltu	$2,$10,$2	# carry from previous addition -> $2
	sd	$10,0($4)
	daddiu	$4,$4,8
	bne	$6,$0,Loop
	 daddu	$2,$9,$2	# add high product limb and carry from addition

/* # cool down phase 1 */
$LC1:	mflo	$10
	mfhi	$9
	daddu	$10,$10,$2
	sltu	$2,$10,$2
	dmultu	$8,$7
	sd	$10,0($4)
	daddiu	$4,$4,8
	daddu	$2,$9,$2	# add high product limb and carry from addition

/* # cool down phase 0 */
$LC0:	mflo	$10
	mfhi	$9
	daddu	$10,$10,$2
	sltu	$2,$10,$2
	sd	$10,0($4)
	j	$31
	daddu	$2,$9,$2	# add high product limb and carry from addition

	.end	mpihelp_mul_1

