/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.gnu.crypto.jce;

import gnu.crypto.jce.GnuCrypto;
import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;

public class TestOfSignature
implements Testlet {
    public void test(TestHarness harness) {
        this.setUp();
        this.testUnknownScheme(harness);
        this.testDSSRawSignature(harness);
        this.testRSAPSSRawSignature(harness);
    }

    public void testUnknownScheme(TestHarness harness) {
        harness.checkPoint("testUnknownScheme");
        try {
            Signature.getInstance("ABC", "GNU-CRYPTO");
            harness.fail("testUnknownScheme()");
        }
        catch (Exception x) {
            harness.check(true);
        }
    }

    public void testDSSRawSignature(TestHarness harness) {
        harness.checkPoint("testDSSRawSignature");
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("DSA", "GNU-CRYPTO");
            kpg.initialize(512);
            KeyPair kp = kpg.generateKeyPair();
            Signature alice = Signature.getInstance("DSA", "GNU-CRYPTO");
            Signature bob = (Signature)alice.clone();
            byte[] message = "1 if by land, 2 if by sea...".getBytes();
            alice.initSign(kp.getPrivate());
            alice.update(message);
            byte[] signature = alice.sign();
            bob.initVerify(kp.getPublic());
            bob.update(message);
            harness.check(bob.verify(signature), "Verify own signature");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("testDSSRawSignature(): " + String.valueOf(x));
        }
    }

    public void testRSAPSSRawSignature(TestHarness harness) {
        harness.checkPoint("testRSAPSSRawSignature");
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", "GNU-CRYPTO");
            kpg.initialize(1024);
            KeyPair kp = kpg.generateKeyPair();
            Signature alice = Signature.getInstance("RSA-PSS", "GNU-CRYPTO");
            Signature bob = (Signature)alice.clone();
            byte[] message = "Que du magnifique...".getBytes();
            alice.initSign(kp.getPrivate());
            alice.update(message);
            byte[] signature = alice.sign();
            bob.initVerify(kp.getPublic());
            bob.update(message);
            harness.check(bob.verify(signature), "Verify own signature");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("testRSAPSSRawSignature(): " + String.valueOf(x));
        }
    }

    private void setUp() {
        Security.addProvider((Provider)new GnuCrypto());
    }
}

