/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.tool;

import gnu.crypto.cipher.CipherFactory;
import gnu.crypto.cipher.IBlockCipher;
import gnu.crypto.util.Util;
import java.util.HashMap;
import java.util.Iterator;

public final class CipherSpeed {
    private CipherSpeed() {
    }

    public static void main(String[] args) {
        if (args == null) {
            args = new String[]{};
        }
        switch (args.length) {
            case 0: {
                Iterator cit = CipherFactory.getNames().iterator();
                while (cit.hasNext()) {
                    CipherSpeed.speed((String)cit.next());
                }
                break;
            }
            case 1: {
                CipherSpeed.speed(args[0]);
                break;
            }
            default: {
                CipherSpeed.speed(args[0], Integer.parseInt(args[1]) / 8);
            }
        }
    }

    private static void speed(String name) {
        System.out.println("Exercising " + String.valueOf(name) + "...");
        try {
            IBlockCipher cipher = CipherFactory.getInstance(name);
            CipherSpeed.speed(cipher, cipher.defaultKeySize());
        }
        catch (InternalError x) {
            System.out.println("Failed self-test...");
        }
    }

    private static void speed(String name, int keysize) {
        System.out.println("Exercising " + String.valueOf(name) + "-" + String.valueOf(keysize) + "...");
        try {
            IBlockCipher cipher = CipherFactory.getInstance(name);
            CipherSpeed.speed(cipher, keysize);
        }
        catch (InternalError x) {
            System.out.println("Failed self-test...");
        }
    }

    private static void speed(IBlockCipher cipher, int keysize) {
        try {
            int iterations = 1000000;
            int blocksize = cipher.defaultBlockSize();
            byte[] kb = new byte[keysize];
            int i = 0;
            while (i < keysize) {
                kb[i] = (byte)i;
                ++i;
            }
            byte[] pt = new byte[blocksize];
            i = 0;
            while (i < blocksize) {
                pt[i] = (byte)i;
                ++i;
            }
            System.out.println("Running " + iterations + " iterations:");
            System.out.print("Encryption: ");
            HashMap<String, byte[]> map = new HashMap<String, byte[]>();
            map.put("gnu.crypto.cipher.key.material", kb);
            cipher.init(map);
            byte[] ct = (byte[])pt.clone();
            long elapsed = -System.currentTimeMillis();
            i = 0;
            while (i < iterations) {
                cipher.encryptBlock(ct, 0, ct, 0);
                ++i;
            }
            float secs = (elapsed += System.currentTimeMillis()) > 1L ? (float)elapsed / 1000.0f : 1.0f;
            float speed = (float)iterations * (float)blocksize / 1024.0f / secs;
            System.out.println("time = " + secs + ", speed = " + speed + " KB/s");
            System.out.print("Decryption: ");
            byte[] cpt = (byte[])ct.clone();
            elapsed = -System.currentTimeMillis();
            i = 0;
            while (i < iterations) {
                cipher.decryptBlock(cpt, 0, cpt, 0);
                ++i;
            }
            secs = (elapsed += System.currentTimeMillis()) > 1L ? (float)elapsed / 1000.0f : 1.0f;
            speed = (float)iterations * (float)blocksize / 1024.0f / secs;
            System.out.println("time = " + secs + ", speed = " + speed + " KB/s");
            if (!Util.areEqual(pt, cpt)) {
                throw new RuntimeException("Symmetric operation failed");
            }
        }
        catch (Exception x) {
            x.printStackTrace(System.err);
        }
    }
}

