/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.spec.KeySpec;
import javax.crypto.SecretKey;

public class SecretKeySpec
implements KeySpec,
SecretKey {
    private String algorithm;
    private byte[] key;

    public SecretKeySpec(byte[] key, String algorithm) {
        if (key == null) {
            throw new IllegalArgumentException("null key passed");
        }
        if (algorithm == null) {
            throw new IllegalArgumentException("null algorithm passed");
        }
        this.key = new byte[key.length];
        System.arraycopy(key, 0, this.key, 0, key.length);
        this.algorithm = algorithm;
    }

    public SecretKeySpec(byte[] key, int offset, int len, String algorithm) {
        if (key == null) {
            throw new IllegalArgumentException("Null key passed");
        }
        if (key.length - offset < len) {
            throw new IllegalArgumentException("Bad offset/len");
        }
        if (algorithm == null) {
            throw new IllegalArgumentException("Null algorithm string passed");
        }
        this.key = new byte[len];
        System.arraycopy(key, offset, this.key, 0, len);
        this.algorithm = algorithm;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getFormat() {
        return "RAW";
    }

    public byte[] getEncoded() {
        byte[] tmp = new byte[this.key.length];
        System.arraycopy(this.key, 0, tmp, 0, tmp.length);
        return tmp;
    }

    public int hashCode() {
        int code = this.algorithm.toUpperCase().hashCode();
        int i = 0;
        while (i != this.key.length) {
            code ^= this.key[i] << 8 * (i % 4);
            ++i;
        }
        return code;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof SecretKeySpec)) {
            return false;
        }
        SecretKeySpec spec = (SecretKeySpec)obj;
        if (!this.algorithm.equalsIgnoreCase(spec.algorithm)) {
            return false;
        }
        if (this.key.length != spec.key.length) {
            return false;
        }
        int i = 0;
        while (i != this.key.length) {
            if (this.key[i] != spec.key[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

