/* win32_entropy.h C header file for winseed library
 *	Copyright (C) 1999 Martin Grap
 *
 * This file is part of winseed.
 *
 * winseed is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * winseed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef __win32_entropy__
#define __win32_entropy__

#include<windows.h>

#define WIN32_SLOW_SEEDER       0
#define WIN32_FAST_SEEDER       1

#define PCP_SUCCESS				0
#define PCP_NULL_POINTER		1
#define PCP_SEEDER_FAILED		2
#define PCP_SEEDER_NO_MEM		3
#define PCP_SEEDER_TOO_SMALL	4	
#define PCP_DLL_LOAD_FAILED     5
#define PCP_UNKNOWN_PLATFORM    6
#define PCP_ERROR_VERSION       7
#define PCP_DLL_FUNC            8
#define PCP_UNKNOWN_SEEDER_TYPE 9

typedef void *WIN32_SEEDER;
typedef unsigned char SEEDER_TYPE;
typedef unsigned int  SEEDER_ERROR;

#ifdef __cplusplus
extern "C" {
#endif

WIN32_SEEDER WINAPI WS_create_instance(SEEDER_TYPE type, SEEDER_ERROR *reason);
void         WINAPI WS_delete_instance(WIN32_SEEDER that);
unsigned int WINAPI WS_get_internal_seed_size(WIN32_SEEDER that);
void         WINAPI WS_set_internal_seed_size(WIN32_SEEDER that, unsigned int new_size);
unsigned int WINAPI WS_get_expected_seed_size(WIN32_SEEDER that);
SEEDER_ERROR WINAPI WS_get_seed(WIN32_SEEDER that, unsigned char *buffer, unsigned int *desired_length);

#ifdef __cplusplus
}
#endif

#endif /* __win32_entropy__ */