/* util.cpp some commonly needed utilities
 *	Copyright (C) 1999 Martin Grap
 *
 * This file is part of winseed.
 *
 * winseed is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * winseed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include<iostream.h>
#include<stdio.h>
#include<util.h>

void pcp_util::print_hex_vector(UINT8 *vector, UINT32 vec_length, UINT32 base , 
								UINT32 column_width)
{
	UINT32 count;

	long stream_flags;
	int s_width;
	char fill_char;

	stream_flags = cout.flags();
	s_width = cout.width();
	fill_char = cout.fill();

	cout.fill('0');

	if (base == 16)
	{
		cout.setf(stream_flags | ios::hex);
	}
	else
	{
		cout.setf(stream_flags | ios::dec);
	}

	for (count = 0; count < vec_length; count++)
	{
		if ((count != 0) && ((count % column_width) == 0))
		{
			cout << '\n';
		}

		if (base == 16)
		{
			cout.width(2);
		}
		else
		{
			cout.width(3);
		}
		
		cout << (UINT16)vector[count] << ' ';
		
	}

	cout << '\n';

	cout.flags(stream_flags);
	cout.width(s_width);
	cout.fill(fill_char);
}

void pcp_util::zero_memory(UINT8 *mem, UINT32 size)
{
	UINT32 count;

	if (mem != NULL)
	{
		for (count = 0; count < size; count++)
		{
			mem[count] = 0;
		}
	}
}

void pcp_util::mem_xor(UINT8 *buffer1, UINT32 buf1_len, UINT8 *buffer2, UINT32 buf2_len)
{
	UINT32 bytes_to_xor = min(buf1_len, buf2_len);
	UINT32 count;

	if ((buffer1 != NULL) && (buffer2 != NULL))
	{
		for(count = 0; count < bytes_to_xor; count++)
		{
			buffer1[count] = (UINT8)(buffer1[count] ^ buffer2[count]);
		}
	}
}

