/* tool_help_loader.cpp implementation of the class which provides
 *                      access to the toolhelp.dll
 *	Copyright (C) 1999 Martin Grap
 *
 * This file is part of winseed.
 *
 * winseed is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * winseed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include<tool_help_loader.h>

UINT32 tool_help_loader::Init()
{
	UINT32 result = PCP_SUCCESS;
	
	do
	{
		if ((hInstance = LoadLibrary("kernel32.dll")) == NULL)
		{
			result = PCP_DLL_LOAD_FAILED;
			break;
		}
		
		ThHeap32First = (pHeap32First)GetProcAddress(hInstance, "Heap32First");
		ThHeap32Next = (pHeap32Next)GetProcAddress(hInstance, "Heap32Next"); 
		ThHeap32ListFirst = (pHeap32ListFirst)GetProcAddress(hInstance, "Heap32ListFirst"); 
		ThHeap32ListNext = (pHeap32ListNext)GetProcAddress(hInstance, "Heap32ListNext"); 
		ThModule32First = (pModule32First)GetProcAddress(hInstance, "Module32First"); 
		ThModule32Next = (pModule32Next)GetProcAddress(hInstance, "Module32Next"); 
		ThProcess32First = (pProcess32First)GetProcAddress(hInstance, "Process32First"); 
		ThProcess32Next = (pProcess32Next)GetProcAddress(hInstance, "Process32Next"); 
		ThThread32First = (pThread32First)GetProcAddress(hInstance, "Thread32First"); 
		ThThread32Next = (pThread32Next)GetProcAddress(hInstance, "Thread32Next");
		ThCreateToolhelp32Snapshot = (pCreateToolhelp32Snapshot)GetProcAddress(hInstance, "CreateToolhelp32Snapshot");
		
		if ((ThHeap32First == NULL) || (ThHeap32Next == NULL) || (ThHeap32ListFirst == NULL) || 
		    (ThHeap32ListNext == NULL) || (ThModule32First == NULL) || (ThModule32Next == NULL) ||
			(ThProcess32First == NULL) || (ThProcess32Next == NULL) || (ThThread32First == NULL) ||
			(ThThread32Next == NULL) || (ThCreateToolhelp32Snapshot == NULL))
		{
			result = PCP_DLL_FUNC;
			break;
		}
	
	} while (0);
	
	if (result != PCP_SUCCESS)
	{
		if (hInstance != NULL)
		{
			FreeLibrary(hInstance);
			hInstance = NULL;
		}
	}
	
	return result;
}

