/* tester.c winseed test program
 *    Copyright (C) 1999 Martin Grap
 *
 * This file is part of winseed.
 *
 * winseed is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * winseed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include<stdio.h>
#include<win32_entropy.h>

#define SLOW_SAMPLE_SIZE 150000
#define FAST_SAMPLE_SIZE 2048
#define TEST_RUNS 200
#define PREVIEW_SIZE 2
#define NEW_SLOW_SEEDER_INTERNAL_SEED_SIZE 150000

void
print_hex_vector(unsigned char *buffer, unsigned int buffer_length)
{

    unsigned int count;

    for (count = 0; count < buffer_length; count++) {

	if (((count % 32) == 0) && (count != 0)) {

	    printf("\n");

	}

	printf("%02x ", buffer[count]);

    }

    printf("\n");

}

unsigned int
do_test_run(WIN32_SEEDER seeder, unsigned char *sample, unsigned int sample_size, char *type)
{

    SEEDER_ERROR result;

    unsigned int help;

    help = sample_size;

    result = WS_get_seed(seeder, sample, &help);

    if (result == PCP_SUCCESS) {

	printf("%s: Preview (%d bytes): ", type, PREVIEW_SIZE);

	print_hex_vector(sample, PREVIEW_SIZE);

	printf("bytes requested: %d, bytes returned: %d\n", sample_size, help);

	printf("\n");

    }

    return result;

}

void
main()
{

    WIN32_SEEDER slow_seeder = NULL, fast_seeder = NULL;

    SEEDER_ERROR reason, error = PCP_SUCCESS;

    DWORD milliseconds;

    unsigned int count, stop = 0;

    unsigned char slow_sample[SLOW_SAMPLE_SIZE];

    unsigned char fast_sample[FAST_SAMPLE_SIZE];

    do {

	if ((slow_seeder = WS_create_instance(WIN32_SLOW_SEEDER, &reason)) == NULL) {

	    printf("construction (slow) failed! Reason: %d\n", reason);

	    break;

	}

	if ((fast_seeder = WS_create_instance(WIN32_FAST_SEEDER, &reason)) == NULL) {

	    printf("construction (fast) failed! Reason: %d\n", reason);

	    break;

	}

	printf("default fast seeder internal seed size %d\n", WS_get_expected_seed_size(fast_seeder));

	printf("current fast seeder internal seed size %d\n", WS_get_internal_seed_size(fast_seeder));

	printf("\n");

	printf("default slow seeder internal seed size %d\n", WS_get_expected_seed_size(slow_seeder));

	printf("current slow seeder internal seed size %d\n\n", WS_get_internal_seed_size(slow_seeder));

	WS_set_internal_seed_size(slow_seeder, NEW_SLOW_SEEDER_INTERNAL_SEED_SIZE);

	printf("new internal buffer size for slow seeder %d\n\n", WS_get_internal_seed_size(slow_seeder));

	for (count = 0; (count < TEST_RUNS) && (error == PCP_SUCCESS); count++) {

	    printf("-------- Test run %d ------------------ \n", count);

	    /*
	     * query slow seeder
	     */
	    if ((error = do_test_run(slow_seeder, slow_sample, SLOW_SAMPLE_SIZE, "slow")) != PCP_SUCCESS) {

		printf("Error in slow seeder call!\n");

		continue;

	    }

	    /*
	     * query fast seeder
	     */

	    if ((error = do_test_run(fast_seeder, fast_sample, FAST_SAMPLE_SIZE, "fast")) != PCP_SUCCESS) {

		printf("Error in fast seeder call!\n");

		continue;

	    }

	    milliseconds = (slow_sample[0] * fast_sample[0]) & 8191;

	    printf("Sleeping for %d milliseconds until next run\n", milliseconds);

	    printf("--------------------------------------\n\n");

	    SleepEx(milliseconds, FALSE);

	}

    } while (0);

    if (slow_seeder != NULL) {

	WS_delete_instance(slow_seeder);

    }

    if (fast_seeder != NULL) {

	WS_delete_instance(fast_seeder);

    }

    if (error != PCP_SUCCESS) {

	printf("Failure after %d test runs. error code: %d\n", count, error);

    }

    else {

	printf("All %d test runs successfull\n", count);

    }

}
