/* net_api_loader.cpp implementation for the class which provides
 *                  access to the netapi32.dll
 *	Copyright (C) 1999 Martin Grap
 *
 * This file is part of winseed.
 *
 * winseed is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * winseed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include<netapi_loader.h>

UINT32 netapi_loader::Init()
{
	UINT32 result = PCP_SUCCESS;

	do
	{
		if ((hInstance = LoadLibrary("netapi32.dll")) == NULL)
		{
			result = PCP_DLL_LOAD_FAILED;
			break;
		}
		
		NaNetApiBufferFree = (pNetApiBufferFree)GetProcAddress(hInstance, "NetApiBufferFree");
		NaNetApiBufferSize = (pNetApiBufferSize)GetProcAddress(hInstance, "NetApiBufferSize"); 
		NaNetStatisticsGet2 = (pNetStatisticsGet2)GetProcAddress(hInstance, "NetStatisticsGet"); 

		
		if ((NaNetApiBufferFree == NULL) || (NaNetApiBufferSize == NULL) || (NaNetStatisticsGet2 == NULL) )
		{
			result = PCP_DLL_FUNC;
			break;
		}
	
	} while (0);
	
	if (result != PCP_SUCCESS)
	{
		if (hInstance != NULL)
		{
			FreeLibrary(hInstance);
			hInstance = NULL;
		}
	}

	return result;
}
