/* moduli.h - Prefabricated values for the DH Group Exchange
 *      Copyright (C) 2002 Timo Schulz
 *
 * This file is part of GSTI.
 *
 * GSTI is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * GSTI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef GSTI_MODULI_H
#define GSTI_MODULI_H

#define GEX_MINSIZE 1023
#define GEX_DEFSIZE 1534
#define GEX_MAXSIZE 4094

/* Taken from /etc/ssh/moduli. The generator is always "2" */

static unsigned char mpi_array_1023[] = {
  0x44, 0x43, 0x46, 0x41, 0x43, 0x34, 0x45, 0x46, 0x45, 0x38, 0x39, 0x46,
  0x35, 0x42, 0x30, 0x38, 0x32, 0x39, 0x36, 0x32, 0x41, 0x42, 0x39, 0x41, 0x36,
  0x37, 0x45, 0x38, 0x44, 0x36, 0x33, 0x45, 0x38, 0x34, 0x46, 0x41, 0x34, 0x39,
  0x31, 0x45, 0x35, 0x44, 0x33, 0x38, 0x37, 0x34, 0x39, 0x37, 0x38, 0x38, 0x31,
  0x35, 0x38, 0x36, 0x38, 0x35, 0x39, 0x35, 0x34, 0x36, 0x39, 0x31, 0x36, 0x33,
  0x44, 0x41, 0x30, 0x36, 0x36, 0x31, 0x45, 0x36, 0x32, 0x30, 0x38, 0x41, 0x38,
  0x43, 0x32, 0x43, 0x44, 0x34, 0x46, 0x38, 0x33, 0x38, 0x39, 0x33, 0x42, 0x35,
  0x33, 0x38, 0x36, 0x34, 0x41, 0x44, 0x46, 0x44, 0x32, 0x31, 0x35, 0x34, 0x45,
  0x38, 0x44, 0x38, 0x45, 0x46, 0x41, 0x31, 0x34, 0x36, 0x42, 0x41, 0x44, 0x38,
  0x30, 0x38, 0x35, 0x36, 0x32, 0x45, 0x34, 0x42, 0x46, 0x36, 0x43, 0x39, 0x30,
  0x33, 0x34, 0x38, 0x46, 0x44, 0x37, 0x39, 0x45, 0x45, 0x42, 0x33, 0x33, 0x38,
  0x37, 0x44, 0x39, 0x33, 0x46, 0x43, 0x37, 0x39, 0x34, 0x33, 0x42, 0x43, 0x34,
  0x35, 0x30, 0x42, 0x41, 0x35, 0x35, 0x33, 0x39, 0x39, 0x42, 0x41, 0x33, 0x43,
  0x46, 0x33, 0x44, 0x46, 0x42, 0x44, 0x30, 0x44, 0x34, 0x45, 0x37, 0x31, 0x38,
  0x30, 0x30, 0x30, 0x30, 0x37, 0x42, 0x30, 0x45, 0x39, 0x44, 0x35, 0x46, 0x31,
  0x32, 0x45, 0x37, 0x41, 0x32, 0x43, 0x42, 0x37, 0x45, 0x41, 0x34, 0x45, 0x34,
  0x39, 0x38, 0x31, 0x32, 0x45, 0x37, 0x31, 0x35, 0x46, 0x38, 0x44, 0x43, 0x35,
  0x37, 0x30, 0x43, 0x34, 0x37, 0x38, 0x44, 0x43, 0x32, 0x44, 0x45, 0x42, 0x31,
  0x43, 0x34, 0x39, 0x42, 0x30, 0x41, 0x45, 0x38, 0x37, 0x41, 0x35, 0x44, 0x46,
  0x35, 0x34, 0x34, 0x39, 0x43, 0x32, 0x32, 0x31, 0x43, 0x42, 0x0A,
};

static unsigned char mpi_array_1534[] = {
  0x36, 0x44, 0x46, 0x44, 0x31, 0x36, 0x44, 0x39, 0x36, 0x36, 0x39, 0x45,
  0x44, 0x41, 0x46, 0x34, 0x32, 0x45, 0x46, 0x35, 0x44, 0x34, 0x45, 0x45, 0x44,
  0x38, 0x32, 0x41, 0x41, 0x38, 0x34, 0x42, 0x30, 0x35, 0x34, 0x31, 0x44, 0x45,
  0x43, 0x32, 0x30, 0x34, 0x35, 0x42, 0x36, 0x41, 0x46, 0x35, 0x35, 0x30, 0x32,
  0x31, 0x41, 0x31, 0x38, 0x34, 0x46, 0x33, 0x32, 0x42, 0x43, 0x41, 0x44, 0x45,
  0x36, 0x31, 0x34, 0x41, 0x31, 0x31, 0x34, 0x31, 0x33, 0x37, 0x30, 0x32, 0x32,
  0x43, 0x39, 0x41, 0x38, 0x42, 0x34, 0x31, 0x43, 0x30, 0x39, 0x41, 0x46, 0x43,
  0x33, 0x38, 0x31, 0x39, 0x39, 0x45, 0x37, 0x33, 0x30, 0x35, 0x38, 0x36, 0x34,
  0x46, 0x37, 0x30, 0x41, 0x38, 0x37, 0x30, 0x38, 0x46, 0x33, 0x37, 0x46, 0x43,
  0x32, 0x31, 0x32, 0x37, 0x32, 0x36, 0x34, 0x45, 0x43, 0x46, 0x34, 0x46, 0x41,
  0x33, 0x32, 0x33, 0x39, 0x31, 0x46, 0x32, 0x34, 0x33, 0x43, 0x43, 0x36, 0x32,
  0x42, 0x38, 0x39, 0x36, 0x30, 0x32, 0x44, 0x33, 0x38, 0x31, 0x33, 0x30, 0x38,
  0x32, 0x36, 0x37, 0x39, 0x45, 0x35, 0x42, 0x44, 0x46, 0x34, 0x39, 0x36, 0x42,
  0x41, 0x39, 0x44, 0x46, 0x41, 0x34, 0x43, 0x38, 0x31, 0x38, 0x41, 0x44, 0x32,
  0x31, 0x45, 0x43, 0x32, 0x36, 0x31, 0x42, 0x36, 0x46, 0x31, 0x31, 0x38, 0x34,
  0x31, 0x45, 0x36, 0x46, 0x32, 0x44, 0x45, 0x31, 0x35, 0x37, 0x34, 0x43, 0x45,
  0x39, 0x35, 0x30, 0x39, 0x35, 0x38, 0x34, 0x31, 0x44, 0x41, 0x46, 0x30, 0x35,
  0x32, 0x38, 0x36, 0x38, 0x43, 0x43, 0x44, 0x35, 0x45, 0x39, 0x42, 0x46, 0x43,
  0x41, 0x35, 0x34, 0x33, 0x45, 0x30, 0x39, 0x33, 0x34, 0x42, 0x35, 0x30, 0x41,
  0x37, 0x36, 0x41, 0x35, 0x39, 0x38, 0x45, 0x36, 0x39, 0x33, 0x31, 0x33, 0x36,
  0x44, 0x45, 0x32, 0x44, 0x34, 0x37, 0x39, 0x41, 0x45, 0x46, 0x33, 0x37, 0x38,
  0x35, 0x44, 0x39, 0x37, 0x42, 0x41, 0x46, 0x46, 0x34, 0x46, 0x42, 0x38, 0x35,
  0x41, 0x42, 0x38, 0x44, 0x34, 0x36, 0x44, 0x41, 0x34, 0x32, 0x34, 0x43, 0x34,
  0x43, 0x43, 0x35, 0x45, 0x31, 0x31, 0x41, 0x42, 0x43, 0x41, 0x46, 0x37, 0x31,
  0x38, 0x38, 0x33, 0x37, 0x45, 0x31, 0x36, 0x33, 0x35, 0x30, 0x39, 0x38, 0x32,
  0x42, 0x46, 0x38, 0x41, 0x32, 0x37, 0x37, 0x32, 0x38, 0x33, 0x31, 0x38, 0x45,
  0x43, 0x30, 0x32, 0x43, 0x37, 0x31, 0x45, 0x44, 0x31, 0x36, 0x34, 0x46, 0x35,
  0x37, 0x43, 0x44, 0x42, 0x31, 0x32, 0x31, 0x42, 0x37, 0x32, 0x36, 0x31, 0x34,
  0x42, 0x37, 0x42, 0x37, 0x43, 0x34, 0x30, 0x36, 0x36, 0x31, 0x33, 0x45, 0x43,
  0x33, 0x33, 0x34, 0x45, 0x44, 0x31, 0x35, 0x42, 0x0A,
};

static unsigned char mpi_array_2046[] = {
  0x37, 0x45, 0x44, 0x30, 0x38, 0x38, 0x38, 0x42, 0x36, 0x36, 0x30, 0x41,
  0x38,
  0x31, 0x38, 0x46, 0x31, 0x35, 0x45, 0x35, 0x46, 0x37, 0x36, 0x41, 0x37,
  0x46,
  0x32, 0x42, 0x46, 0x31, 0x30, 0x43, 0x39, 0x39, 0x44, 0x37, 0x34, 0x31,
  0x32,
  0x39, 0x44, 0x41, 0x30, 0x34, 0x34, 0x34, 0x36, 0x43, 0x36, 0x30, 0x31,
  0x31,
  0x36, 0x43, 0x39, 0x43, 0x38, 0x30, 0x30, 0x35, 0x30, 0x31, 0x30, 0x36,
  0x30,
  0x42, 0x38, 0x41, 0x46, 0x46, 0x30, 0x37, 0x35, 0x44, 0x43, 0x45, 0x30,
  0x43,
  0x30, 0x38, 0x43, 0x45, 0x46, 0x44, 0x46, 0x36, 0x39, 0x35, 0x34, 0x34,
  0x30,
  0x45, 0x36, 0x46, 0x31, 0x36, 0x46, 0x43, 0x43, 0x44, 0x42, 0x30, 0x36,
  0x33,
  0x35, 0x39, 0x44, 0x30, 0x38, 0x30, 0x45, 0x46, 0x36, 0x32, 0x44, 0x36,
  0x34,
  0x38, 0x35, 0x43, 0x42, 0x41, 0x45, 0x42, 0x39, 0x34, 0x42, 0x39, 0x32,
  0x42,
  0x45, 0x37, 0x37, 0x31, 0x44, 0x35, 0x33, 0x35, 0x42, 0x34, 0x45, 0x41,
  0x39,
  0x43, 0x35, 0x44, 0x31, 0x34, 0x44, 0x38, 0x34, 0x43, 0x44, 0x37, 0x36,
  0x34,
  0x39, 0x45, 0x32, 0x35, 0x43, 0x37, 0x43, 0x46, 0x45, 0x41, 0x32, 0x43,
  0x39,
  0x31, 0x34, 0x34, 0x38, 0x36, 0x43, 0x43, 0x32, 0x42, 0x46, 0x44, 0x45,
  0x37,
  0x37, 0x43, 0x34, 0x43, 0x30, 0x44, 0x46, 0x31, 0x44, 0x36, 0x44, 0x44,
  0x45,
  0x44, 0x36, 0x35, 0x46, 0x45, 0x45, 0x32, 0x46, 0x35, 0x33, 0x41, 0x37,
  0x46,
  0x41, 0x36, 0x39, 0x30, 0x41, 0x46, 0x45, 0x33, 0x38, 0x45, 0x45, 0x30,
  0x30,
  0x43, 0x31, 0x35, 0x34, 0x46, 0x42, 0x41, 0x45, 0x46, 0x46, 0x39, 0x33,
  0x35,
  0x34, 0x36, 0x36, 0x42, 0x31, 0x37, 0x36, 0x43, 0x42, 0x30, 0x41, 0x45,
  0x44,
  0x30, 0x32, 0x34, 0x35, 0x38, 0x41, 0x35, 0x35, 0x32, 0x39, 0x32, 0x39,
  0x46,
  0x34, 0x45, 0x41, 0x37, 0x46, 0x43, 0x33, 0x45, 0x36, 0x46, 0x39, 0x46,
  0x37,
  0x35, 0x38, 0x44, 0x45, 0x37, 0x46, 0x32, 0x32, 0x43, 0x43, 0x31, 0x46,
  0x34,
  0x39, 0x36, 0x34, 0x31, 0x46, 0x34, 0x39, 0x32, 0x38, 0x32, 0x30, 0x34,
  0x34,
  0x31, 0x42, 0x44, 0x43, 0x31, 0x30, 0x39, 0x46, 0x30, 0x43, 0x45, 0x31,
  0x38,
  0x46, 0x38, 0x38, 0x33, 0x46, 0x43, 0x39, 0x33, 0x45, 0x41, 0x39, 0x41,
  0x43,
  0x34, 0x43, 0x31, 0x34, 0x33, 0x32, 0x36, 0x38, 0x32, 0x42, 0x41, 0x31,
  0x43,
  0x35, 0x42, 0x36, 0x37, 0x42, 0x45, 0x44, 0x38, 0x43, 0x38, 0x36, 0x31,
  0x31,
  0x35, 0x32, 0x41, 0x35, 0x46, 0x39, 0x35, 0x32, 0x41, 0x38, 0x43, 0x44,
  0x43,
  0x46, 0x31, 0x42, 0x43, 0x45, 0x30, 0x32, 0x42, 0x38, 0x44, 0x39, 0x33,
  0x45,
  0x38, 0x30, 0x43, 0x31, 0x31, 0x33, 0x43, 0x45, 0x39, 0x46, 0x45, 0x32,
  0x45,
  0x34, 0x41, 0x43, 0x41, 0x34, 0x39, 0x42, 0x32, 0x39, 0x37, 0x38, 0x42,
  0x39,
  0x39, 0x41, 0x38, 0x43, 0x35, 0x46, 0x41, 0x32, 0x33, 0x31, 0x41, 0x37,
  0x37,
  0x46, 0x35, 0x45, 0x37, 0x43, 0x36, 0x30, 0x34, 0x44, 0x34, 0x34, 0x43,
  0x37,
  0x43, 0x36, 0x45, 0x41, 0x39, 0x38, 0x44, 0x35, 0x36, 0x31, 0x32, 0x39,
  0x34,
  0x44, 0x34, 0x46, 0x37, 0x41, 0x42, 0x30, 0x36, 0x31, 0x34, 0x33, 0x32,
  0x43,
  0x41, 0x42, 0x38, 0x42, 0x42, 0x44, 0x43, 0x45, 0x43, 0x33, 0x36, 0x35,
  0x39,
  0x44, 0x45, 0x36, 0x34, 0x46, 0x36, 0x35, 0x32, 0x36, 0x35, 0x45, 0x36,
  0x42,
  0x39, 0x46, 0x43, 0x35, 0x46, 0x34, 0x36, 0x38, 0x37, 0x39, 0x42, 0x42,
  0x31,
  0x37, 0x43, 0x43, 0x33, 0x34, 0x39, 0x39, 0x33, 0x38, 0x35, 0x33, 0x41,
  0x43,
  0x41, 0x41, 0x43, 0x41, 0x42, 0x0A,
};

static unsigned char mpi_array_3190[] = {
  0x36, 0x36, 0x39, 0x42, 0x41, 0x33, 0x45, 0x44, 0x36, 0x36, 0x31, 0x46,
  0x32,
  0x32, 0x36, 0x41, 0x30, 0x39, 0x30, 0x42, 0x45, 0x35, 0x36, 0x34, 0x34,
  0x41,
  0x32, 0x42, 0x42, 0x34, 0x32, 0x30, 0x39, 0x33, 0x37, 0x31, 0x42, 0x37,
  0x38,
  0x46, 0x43, 0x33, 0x45, 0x36, 0x38, 0x34, 0x38, 0x41, 0x30, 0x39, 0x35,
  0x38,
  0x32, 0x31, 0x39, 0x39, 0x33, 0x46, 0x35, 0x39, 0x30, 0x38, 0x34, 0x43,
  0x41,
  0x35, 0x45, 0x45, 0x31, 0x32, 0x30, 0x35, 0x32, 0x46, 0x39, 0x37, 0x37,
  0x44,
  0x30, 0x31, 0x46, 0x30, 0x36, 0x36, 0x36, 0x46, 0x30, 0x33, 0x46, 0x36,
  0x35,
  0x37, 0x33, 0x42, 0x31, 0x39, 0x39, 0x44, 0x46, 0x45, 0x43, 0x39, 0x41,
  0x42,
  0x39, 0x34, 0x35, 0x38, 0x38, 0x43, 0x32, 0x43, 0x36, 0x30, 0x44, 0x45,
  0x33,
  0x42, 0x33, 0x45, 0x37, 0x43, 0x46, 0x35, 0x30, 0x39, 0x34, 0x35, 0x38,
  0x37,
  0x39, 0x31, 0x39, 0x46, 0x43, 0x43, 0x33, 0x46, 0x42, 0x34, 0x30, 0x41,
  0x36,
  0x31, 0x43, 0x32, 0x36, 0x31, 0x45, 0x38, 0x39, 0x31, 0x41, 0x30, 0x46,
  0x39,
  0x31, 0x44, 0x39, 0x46, 0x46, 0x43, 0x38, 0x46, 0x33, 0x30, 0x43, 0x41,
  0x31,
  0x32, 0x43, 0x46, 0x38, 0x30, 0x39, 0x44, 0x44, 0x38, 0x32, 0x39, 0x30,
  0x44,
  0x44, 0x37, 0x38, 0x36, 0x46, 0x41, 0x38, 0x42, 0x30, 0x34, 0x31, 0x46,
  0x46,
  0x41, 0x43, 0x35, 0x37, 0x39, 0x33, 0x43, 0x33, 0x38, 0x46, 0x33, 0x38,
  0x37,
  0x35, 0x37, 0x45, 0x41, 0x36, 0x37, 0x39, 0x30, 0x34, 0x37, 0x32, 0x41,
  0x43,
  0x32, 0x36, 0x39, 0x32, 0x31, 0x38, 0x35, 0x42, 0x35, 0x35, 0x34, 0x42,
  0x30,
  0x30, 0x34, 0x36, 0x45, 0x38, 0x43, 0x30, 0x36, 0x35, 0x43, 0x39, 0x38,
  0x33,
  0x43, 0x30, 0x41, 0x43, 0x43, 0x38, 0x44, 0x32, 0x46, 0x38, 0x35, 0x41,
  0x42,
  0x34, 0x42, 0x45, 0x44, 0x46, 0x37, 0x43, 0x45, 0x32, 0x33, 0x33, 0x30,
  0x30,
  0x39, 0x32, 0x31, 0x38, 0x43, 0x39, 0x36, 0x39, 0x31, 0x46, 0x45, 0x34,
  0x34,
  0x32, 0x36, 0x31, 0x35, 0x38, 0x30, 0x44, 0x34, 0x31, 0x34, 0x39, 0x46,
  0x31,
  0x44, 0x34, 0x34, 0x37, 0x31, 0x42, 0x30, 0x42, 0x35, 0x44, 0x46, 0x37,
  0x39,
  0x45, 0x32, 0x32, 0x34, 0x32, 0x35, 0x32, 0x34, 0x37, 0x34, 0x45, 0x42,
  0x43,
  0x33, 0x42, 0x37, 0x42, 0x35, 0x34, 0x39, 0x30, 0x39, 0x35, 0x30, 0x42,
  0x42,
  0x34, 0x33, 0x38, 0x42, 0x46, 0x34, 0x39, 0x38, 0x45, 0x37, 0x39, 0x46,
  0x38,
  0x37, 0x39, 0x34, 0x34, 0x39, 0x38, 0x42, 0x33, 0x41, 0x33, 0x42, 0x35,
  0x46,
  0x42, 0x42, 0x34, 0x32, 0x38, 0x32, 0x39, 0x43, 0x33, 0x42, 0x42, 0x45,
  0x41,
  0x34, 0x30, 0x36, 0x37, 0x46, 0x32, 0x38, 0x43, 0x32, 0x33, 0x42, 0x45,
  0x34,
  0x30, 0x33, 0x37, 0x37, 0x42, 0x39, 0x38, 0x36, 0x42, 0x44, 0x35, 0x34,
  0x34,
  0x33, 0x43, 0x43, 0x43, 0x46, 0x30, 0x32, 0x34, 0x30, 0x35, 0x42, 0x38,
  0x43,
  0x43, 0x43, 0x41, 0x41, 0x30, 0x39, 0x45, 0x38, 0x31, 0x37, 0x39, 0x46,
  0x30,
  0x31, 0x36, 0x38, 0x44, 0x34, 0x39, 0x36, 0x39, 0x39, 0x39, 0x34, 0x31,
  0x37,
  0x31, 0x41, 0x36, 0x41, 0x44, 0x39, 0x38, 0x46, 0x38, 0x31, 0x30, 0x31,
  0x35,
  0x42, 0x43, 0x38, 0x34, 0x45, 0x31, 0x30, 0x41, 0x34, 0x34, 0x45, 0x31,
  0x45,
  0x46, 0x44, 0x32, 0x45, 0x30, 0x38, 0x36, 0x32, 0x43, 0x35, 0x44, 0x31,
  0x41,
  0x41, 0x46, 0x45, 0x39, 0x39, 0x30, 0x31, 0x34, 0x37, 0x31, 0x35, 0x41,
  0x33,
  0x36, 0x38, 0x30, 0x30, 0x44, 0x42, 0x44, 0x39, 0x41, 0x36, 0x43, 0x35,
  0x31,
  0x43, 0x30, 0x32, 0x32, 0x36, 0x43, 0x43, 0x38, 0x32, 0x41, 0x36, 0x35,
  0x31,
  0x44, 0x41, 0x45, 0x34, 0x46, 0x37, 0x33, 0x44, 0x35, 0x34, 0x43, 0x34,
  0x44,
  0x31, 0x30, 0x33, 0x43, 0x31, 0x33, 0x44, 0x31, 0x43, 0x31, 0x35, 0x43,
  0x46,
  0x38, 0x43, 0x43, 0x41, 0x36, 0x37, 0x44, 0x35, 0x43, 0x42, 0x33, 0x39,
  0x46,
  0x30, 0x33, 0x43, 0x36, 0x36, 0x46, 0x33, 0x42, 0x37, 0x34, 0x36, 0x37,
  0x46,
  0x38, 0x46, 0x46, 0x44, 0x43, 0x43, 0x35, 0x30, 0x37, 0x34, 0x43, 0x44,
  0x30,
  0x43, 0x31, 0x42, 0x32, 0x35, 0x33, 0x38, 0x46, 0x42, 0x46, 0x39, 0x35,
  0x36,
  0x39, 0x37, 0x31, 0x42, 0x46, 0x33, 0x39, 0x33, 0x31, 0x34, 0x43, 0x45,
  0x44,
  0x44, 0x32, 0x30, 0x45, 0x31, 0x42, 0x31, 0x30, 0x44, 0x45, 0x31, 0x36,
  0x44,
  0x38, 0x36, 0x45, 0x31, 0x30, 0x42, 0x45, 0x37, 0x46, 0x41, 0x35, 0x42,
  0x31,
  0x41, 0x37, 0x30, 0x36, 0x41, 0x45, 0x42, 0x34, 0x43, 0x33, 0x35, 0x36,
  0x46,
  0x34, 0x39, 0x38, 0x30, 0x37, 0x41, 0x32, 0x32, 0x30, 0x37, 0x32, 0x43,
  0x44,
  0x30, 0x30, 0x35, 0x35, 0x39, 0x41, 0x46, 0x30, 0x41, 0x38, 0x36, 0x33,
  0x37,
  0x38, 0x38, 0x39, 0x35, 0x36, 0x36, 0x35, 0x31, 0x39, 0x31, 0x39, 0x45,
  0x32,
  0x36, 0x41, 0x33, 0x31, 0x35, 0x45, 0x41, 0x44, 0x31, 0x44, 0x32, 0x36,
  0x45,
  0x37, 0x43, 0x39, 0x38, 0x46, 0x43, 0x34, 0x43, 0x46, 0x41, 0x33, 0x35,
  0x41,
  0x30, 0x46, 0x30, 0x34, 0x44, 0x44, 0x34, 0x30, 0x30, 0x41, 0x32, 0x39,
  0x39,
  0x31, 0x41, 0x31, 0x46, 0x46, 0x45, 0x35, 0x42, 0x32, 0x37, 0x31, 0x46,
  0x45,
  0x44, 0x45, 0x35, 0x34, 0x33, 0x37, 0x35, 0x38, 0x39, 0x36, 0x41, 0x32,
  0x39,
  0x46, 0x39, 0x36, 0x38, 0x42, 0x45, 0x31, 0x44, 0x35, 0x31, 0x31, 0x42,
  0x41,
  0x34, 0x36, 0x36, 0x41, 0x39, 0x32, 0x41, 0x43, 0x33, 0x45, 0x33, 0x37,
  0x37,
  0x32, 0x37, 0x30, 0x39, 0x46, 0x43, 0x38, 0x31, 0x35, 0x42, 0x30, 0x44,
  0x30,
  0x37, 0x37, 0x39, 0x34, 0x42, 0x0A,
};

static unsigned char mpi_array_4094[] = {
  0x36, 0x35, 0x42, 0x35, 0x42, 0x39, 0x46, 0x35, 0x45, 0x43, 0x46, 0x41,
  0x44,
  0x42, 0x34, 0x43, 0x43, 0x42, 0x33, 0x38, 0x44, 0x31, 0x42, 0x43, 0x38,
  0x39,
  0x34, 0x33, 0x30, 0x32, 0x45, 0x39, 0x35, 0x42, 0x34, 0x38, 0x34, 0x33,
  0x32,
  0x39, 0x30, 0x46, 0x31, 0x41, 0x37, 0x41, 0x34, 0x30, 0x35, 0x37, 0x39,
  0x44,
  0x46, 0x33, 0x45, 0x32, 0x46, 0x46, 0x39, 0x38, 0x43, 0x31, 0x44, 0x33,
  0x44,
  0x41, 0x39, 0x46, 0x32, 0x31, 0x30, 0x38, 0x35, 0x37, 0x43, 0x37, 0x38,
  0x34,
  0x34, 0x33, 0x33, 0x44, 0x46, 0x33, 0x32, 0x41, 0x44, 0x46, 0x39, 0x45,
  0x30,
  0x43, 0x38, 0x30, 0x31, 0x32, 0x31, 0x32, 0x31, 0x31, 0x36, 0x39, 0x30,
  0x45,
  0x31, 0x46, 0x46, 0x42, 0x34, 0x31, 0x42, 0x38, 0x44, 0x42, 0x34, 0x45,
  0x38,
  0x36, 0x41, 0x46, 0x45, 0x33, 0x38, 0x38, 0x41, 0x30, 0x39, 0x43, 0x39,
  0x42,
  0x42, 0x32, 0x43, 0x39, 0x38, 0x45, 0x44, 0x43, 0x35, 0x38, 0x31, 0x43,
  0x32,
  0x45, 0x36, 0x35, 0x44, 0x35, 0x37, 0x46, 0x36, 0x31, 0x42, 0x42, 0x39,
  0x32,
  0x30, 0x43, 0x33, 0x44, 0x31, 0x42, 0x37, 0x42, 0x30, 0x35, 0x38, 0x42,
  0x35,
  0x46, 0x41, 0x44, 0x46, 0x46, 0x36, 0x35, 0x44, 0x36, 0x30, 0x37, 0x44,
  0x41,
  0x46, 0x46, 0x34, 0x34, 0x33, 0x42, 0x38, 0x42, 0x41, 0x31, 0x41, 0x43,
  0x45,
  0x31, 0x41, 0x33, 0x41, 0x37, 0x42, 0x31, 0x36, 0x45, 0x41, 0x30, 0x37,
  0x31,
  0x33, 0x46, 0x36, 0x32, 0x35, 0x33, 0x37, 0x43, 0x36, 0x36, 0x38, 0x39,
  0x45,
  0x33, 0x43, 0x34, 0x41, 0x30, 0x46, 0x36, 0x31, 0x31, 0x39, 0x38, 0x46,
  0x33,
  0x42, 0x30, 0x35, 0x34, 0x46, 0x43, 0x46, 0x31, 0x34, 0x30, 0x43, 0x46,
  0x41,
  0x44, 0x44, 0x38, 0x36, 0x32, 0x32, 0x43, 0x30, 0x45, 0x37, 0x36, 0x32,
  0x31,
  0x39, 0x39, 0x38, 0x33, 0x33, 0x31, 0x45, 0x35, 0x39, 0x44, 0x41, 0x36,
  0x46,
  0x37, 0x32, 0x45, 0x39, 0x44, 0x36, 0x30, 0x38, 0x44, 0x30, 0x45, 0x35,
  0x38,
  0x46, 0x35, 0x32, 0x36, 0x45, 0x39, 0x35, 0x46, 0x34, 0x38, 0x35, 0x43,
  0x37,
  0x43, 0x41, 0x33, 0x30, 0x41, 0x34, 0x31, 0x36, 0x36, 0x31, 0x37, 0x44,
  0x41,
  0x33, 0x43, 0x43, 0x46, 0x46, 0x37, 0x32, 0x32, 0x42, 0x42, 0x38, 0x32,
  0x33,
  0x36, 0x32, 0x36, 0x30, 0x36, 0x32, 0x38, 0x33, 0x44, 0x30, 0x35, 0x34,
  0x42,
  0x33, 0x34, 0x42, 0x38, 0x33, 0x45, 0x43, 0x44, 0x42, 0x34, 0x43, 0x39,
  0x31,
  0x42, 0x41, 0x42, 0x38, 0x33, 0x35, 0x39, 0x34, 0x34, 0x30, 0x31, 0x30,
  0x45,
  0x42, 0x45, 0x35, 0x45, 0x39, 0x46, 0x41, 0x37, 0x42, 0x30, 0x31, 0x36,
  0x45,
  0x44, 0x38, 0x39, 0x38, 0x39, 0x31, 0x44, 0x44, 0x35, 0x35, 0x33, 0x43,
  0x43,
  0x37, 0x31, 0x42, 0x35, 0x43, 0x46, 0x37, 0x36, 0x45, 0x44, 0x42, 0x32,
  0x41,
  0x31, 0x38, 0x34, 0x42, 0x33, 0x37, 0x37, 0x46, 0x36, 0x37, 0x30, 0x44,
  0x36,
  0x41, 0x46, 0x31, 0x39, 0x31, 0x37, 0x36, 0x33, 0x45, 0x45, 0x46, 0x44,
  0x31,
  0x37, 0x35, 0x45, 0x34, 0x38, 0x45, 0x41, 0x33, 0x37, 0x45, 0x45, 0x31,
  0x38,
  0x42, 0x39, 0x45, 0x34, 0x34, 0x45, 0x32, 0x44, 0x30, 0x31, 0x37, 0x44,
  0x38,
  0x34, 0x35, 0x43, 0x34, 0x34, 0x34, 0x43, 0x38, 0x31, 0x31, 0x31, 0x38,
  0x31,
  0x36, 0x38, 0x31, 0x39, 0x38, 0x36, 0x36, 0x45, 0x34, 0x39, 0x30, 0x42,
  0x35,
  0x32, 0x46, 0x37, 0x46, 0x38, 0x37, 0x39, 0x41, 0x30, 0x43, 0x36, 0x46,
  0x34,
  0x30, 0x31, 0x43, 0x46, 0x37, 0x38, 0x35, 0x39, 0x36, 0x37, 0x34, 0x46,
  0x39,
  0x33, 0x45, 0x33, 0x30, 0x34, 0x33, 0x36, 0x35, 0x46, 0x34, 0x45, 0x38,
  0x43,
  0x42, 0x38, 0x43, 0x33, 0x31, 0x32, 0x45, 0x46, 0x42, 0x37, 0x32, 0x35,
  0x37,
  0x33, 0x32, 0x41, 0x34, 0x36, 0x44, 0x37, 0x43, 0x46, 0x30, 0x43, 0x39,
  0x44,
  0x32, 0x39, 0x33, 0x39, 0x41, 0x45, 0x45, 0x32, 0x35, 0x46, 0x34, 0x32,
  0x38,
  0x43, 0x45, 0x46, 0x43, 0x39, 0x30, 0x39, 0x35, 0x39, 0x44, 0x42, 0x46,
  0x38,
  0x41, 0x44, 0x44, 0x36, 0x31, 0x32, 0x46, 0x33, 0x34, 0x33, 0x45, 0x46,
  0x39,
  0x42, 0x46, 0x43, 0x41, 0x32, 0x46, 0x42, 0x41, 0x36, 0x31, 0x42, 0x44,
  0x34,
  0x42, 0x46, 0x39, 0x33, 0x45, 0x31, 0x45, 0x35, 0x34, 0x36, 0x32, 0x36,
  0x44,
  0x32, 0x32, 0x37, 0x46, 0x44, 0x41, 0x38, 0x31, 0x32, 0x45, 0x31, 0x38,
  0x44,
  0x30, 0x37, 0x31, 0x35, 0x37, 0x39, 0x41, 0x42, 0x34, 0x45, 0x45, 0x41,
  0x43,
  0x39, 0x39, 0x30, 0x31, 0x44, 0x41, 0x42, 0x31, 0x38, 0x33, 0x42, 0x43,
  0x42,
  0x30, 0x44, 0x39, 0x46, 0x34, 0x38, 0x37, 0x33, 0x32, 0x44, 0x39, 0x32,
  0x43,
  0x45, 0x36, 0x36, 0x42, 0x33, 0x38, 0x36, 0x45, 0x41, 0x45, 0x35, 0x44,
  0x38,
  0x32, 0x31, 0x32, 0x43, 0x39, 0x46, 0x44, 0x31, 0x35, 0x36, 0x44, 0x43,
  0x33,
  0x46, 0x30, 0x39, 0x42, 0x31, 0x37, 0x31, 0x42, 0x35, 0x36, 0x30, 0x33,
  0x45,
  0x31, 0x37, 0x41, 0x34, 0x36, 0x38, 0x44, 0x32, 0x34, 0x34, 0x46, 0x33,
  0x42,
  0x36, 0x38, 0x38, 0x30, 0x45, 0x42, 0x43, 0x44, 0x41, 0x31, 0x38, 0x39,
  0x42,
  0x41, 0x39, 0x45, 0x32, 0x33, 0x45, 0x34, 0x41, 0x34, 0x43, 0x36, 0x43,
  0x32,
  0x39, 0x39, 0x35, 0x41, 0x43, 0x46, 0x32, 0x36, 0x34, 0x46, 0x38, 0x43,
  0x45,
  0x39, 0x44, 0x35, 0x34, 0x42, 0x32, 0x37, 0x33, 0x31, 0x36, 0x33, 0x34,
  0x33,
  0x43, 0x30, 0x42, 0x43, 0x31, 0x39, 0x32, 0x32, 0x31, 0x46, 0x37, 0x35,
  0x45,
  0x36, 0x41, 0x32, 0x41, 0x43, 0x36, 0x38, 0x30, 0x31, 0x31, 0x37, 0x34,
  0x31,
  0x36, 0x39, 0x35, 0x45, 0x35, 0x39, 0x39, 0x46, 0x37, 0x33, 0x34, 0x36,
  0x30,
  0x42, 0x37, 0x41, 0x30, 0x34, 0x32, 0x45, 0x30, 0x34, 0x36, 0x31, 0x44,
  0x42,
  0x31, 0x38, 0x39, 0x43, 0x44, 0x43, 0x45, 0x32, 0x32, 0x33, 0x42, 0x34,
  0x30,
  0x33, 0x33, 0x36, 0x42, 0x46, 0x32, 0x32, 0x35, 0x31, 0x41, 0x45, 0x33,
  0x42,
  0x33, 0x36, 0x33, 0x31, 0x35, 0x39, 0x39, 0x36, 0x30, 0x43, 0x39, 0x46,
  0x36,
  0x33, 0x42, 0x34, 0x37, 0x45, 0x46, 0x43, 0x34, 0x33, 0x37, 0x39, 0x30,
  0x44,
  0x34, 0x37, 0x34, 0x44, 0x41, 0x42, 0x42, 0x39, 0x41, 0x36, 0x38, 0x36,
  0x44,
  0x41, 0x46, 0x32, 0x31, 0x45, 0x30, 0x44, 0x44, 0x37, 0x36, 0x35, 0x33,
  0x33,
  0x37, 0x34, 0x39, 0x46, 0x43, 0x41, 0x39, 0x46, 0x31, 0x34, 0x34, 0x46,
  0x41,
  0x39, 0x43, 0x32, 0x34, 0x33, 0x43, 0x45, 0x46, 0x31, 0x33, 0x36, 0x34,
  0x43,
  0x37, 0x39, 0x44, 0x39, 0x38, 0x31, 0x45, 0x44, 0x38, 0x31, 0x44, 0x43,
  0x34,
  0x36, 0x33, 0x35, 0x43, 0x37, 0x33, 0x42, 0x37, 0x46, 0x38, 0x39, 0x30,
  0x38,
  0x42, 0x41, 0x31, 0x39, 0x30, 0x41, 0x41, 0x39, 0x32, 0x30, 0x45, 0x44,
  0x33,
  0x37, 0x30, 0x46, 0x38, 0x31, 0x35, 0x42, 0x43, 0x32, 0x46, 0x39, 0x42,
  0x33,
  0x44, 0x32, 0x38, 0x45, 0x44, 0x38, 0x37, 0x42, 0x45, 0x33, 0x34, 0x41,
  0x30,
  0x31, 0x34, 0x39, 0x38, 0x38, 0x33, 0x36, 0x32, 0x32, 0x32, 0x43, 0x31,
  0x37,
  0x42, 0x37, 0x30, 0x43, 0x32, 0x34, 0x36, 0x43, 0x30, 0x33, 0x43, 0x41,
  0x31,
  0x43, 0x31, 0x30, 0x43, 0x31, 0x45, 0x30, 0x38, 0x46, 0x33, 0x0A,
};


#endif /*GSTI_MODULI_H */
