/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.gnupg;

import com.freiheit.gnupg.GnuPGContext;
import com.freiheit.gnupg.GnuPGPeer;
import com.freiheit.gnupg.GnuPGSignature;
import java.util.ArrayList;
import java.util.Iterator;

public class GnuPGKey
extends GnuPGPeer {
    protected GnuPGKey(int ptr) {
        this.setInternalRepresentation(ptr);
    }

    protected GnuPGKey(GnuPGContext context, String fingerprint) {
        this.setInternalRepresentation(this.gpgmeGetKey(context.getInternalRepresentation(), fingerprint));
    }

    public String getName() {
        return this.gpgmeGetName(this.getInternalRepresentation());
    }

    public String getEmail() {
        return this.gpgmeGetEmail(this.getInternalRepresentation());
    }

    public String getKeyID() {
        return this.gpgmeGetKeyID(this.getInternalRepresentation());
    }

    public String getFingerprint() {
        return this.gpgmeGetFingerprint(this.getInternalRepresentation());
    }

    public String getComment() {
        return this.gpgmeGetComment(this.getInternalRepresentation());
    }

    public String getUserID() {
        return this.gpgmeGetUserID(this.getInternalRepresentation());
    }

    public Iterator getSignatures() {
        ArrayList<GnuPGSignature> siglist = null;
        for (GnuPGSignature sig = this.getSignature(); sig != null; sig = sig.getNextSignature()) {
            if (siglist == null) {
                siglist = new ArrayList<GnuPGSignature>();
            }
            siglist.add(sig);
        }
        return siglist.listIterator();
    }

    private String listSignatures() {
        Iterator iter = this.getSignatures();
        StringBuffer buf = new StringBuffer();
        while (iter != null && iter.hasNext()) {
            GnuPGSignature sig = (GnuPGSignature)iter.next();
            buf.append("\t").append(sig).append("\n");
        }
        return buf.toString();
    }

    private GnuPGSignature getSignature() {
        GnuPGSignature result = null;
        int ptr = this.gpgmeGetSignature(this.getInternalRepresentation());
        if (ptr != 0) {
            result = new GnuPGSignature(ptr);
        }
        return result;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getKeyID()).append(": ").append(this.getName()).append(", ").append(this.getComment()).append(", ").append(this.getEmail()).append(", ").append("[").append(this.getFingerprint()).append("]").append("\n").append(this.listSignatures());
        return buf.toString();
    }

    public void destroy() {
        if (this.getInternalRepresentation() != 0) {
            this.gpgmeKeyUnref(this.getInternalRepresentation());
            this.setInternalRepresentation(0);
        }
    }

    protected void finalize() {
        this.destroy();
    }

    private native int gpgmeGetKey(int var1, String var2);

    private native int gpgmeKeyUnref(int var1);

    private native String gpgmeGetName(int var1);

    private native String gpgmeGetEmail(int var1);

    private native String gpgmeGetKeyID(int var1);

    private native String gpgmeGetFingerprint(int var1);

    private native String gpgmeGetComment(int var1);

    private native String gpgmeGetUserID(int var1);

    private native int gpgmeGetSignature(int var1);
}

