/* Xymon Client V1.2 for VSE/ESA and z/VSE
    Copyright (C) 2003-2010 Richard Smrcina
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.
 
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU General Public License for more details.
 
    http://www.gnu.org/licenses/old-licenses/gpl-2.0.html            */
/*  This program performs the partition GETVIS test for z/VSE.
    It relies on HOBVARS to tell it which partitions for which
    to check GETVIS.
    It only uses SERVER configuration mode.
 
   Rich Smrcina: Original V1.2 release 09/07/2008
   Rich Smrcina: Changed project name to Xymon 02/10/2009
                                                                      */
parse arg lib cfgmode .
/*  Retrieve options member from PRD2.CONFIG                     */
'execio * diskr 'lib'.hobvars.z (stem hobvars. finis'
/*  Go through options table to fill values to run the client    */
do i=1 to hobvars.0
  if left(hobvars.i,1)='#' then iterate   /* Ignore comment */
  parse var hobvars.i kw value
  value=strip(value,'B')
  select
    when kw='GETVIS' then do
      if words(value) > 0 then do
        getvis_test='1'
        ptn=0
        do w=1 to words(value)
          ptn=ptn+1
          pid.ptn = word(value,w)
          end
        pid.0=ptn
        end
      end
    otherwise
      nop
    end
  end
call do_getvis
return
 
do_getvis:
queue '[getvis]'
queue 'Partition    Used/24  Free/24  Used/Any  Free/Any'
do i=1 to pid.0
  rtn=hobvsgvs(pid.i)
  parse var rtn jnm +8 blctl +4 blhwm +4 blfree +4 blused +4 blfcon +4 ,
                alctl +4 alhwm +4 alfree +4 alused +4 alfcon +4
  if jnm='INVALID ' then
    row.i=pid.i'-Nojob' cr
  else do
    blfree=x2d(c2x(blfree))/1024
    blused=x2d(c2x(blused))/1024
    alfree=x2d(c2x(alfree))/1024
    alused=x2d(c2x(alused))/1024
    blfree=right(blfree,7)  /* Make fields fixed length  */
    blused=right(blused,7)
    alfree=right(alfree,7)
    alused=right(alused,7)
/*  Concatenate jobname to partid, if there is a jobname.  */
    if jnm='        ' then
      col=pid.i
    else
      col=pid.i'-'jnm
    col=left(col,12)  /* Make field 12 bytes long  */
    queue col blused'  'blfree'   'alused'   'alfree
    end
  end
queue ''
'execio * diskw' lib'.hobvsegv.data (finis'
return
